/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.j2ee.core;

import java.util.Comparator;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.NbBundle;

public final class Profile {
    public static final Comparator<Profile> UI_COMPARATOR = new Comparator<Profile>(){

        @Override
        public int compare(Profile o1, Profile o2) {
            return -(o1.order - o2.order);
        }
    };
    public static final Profile J2EE_13 = new Profile(1, "1.3", null, "J2EE13.displayName");
    public static final Profile J2EE_14 = new Profile(2, "1.4", null, "J2EE14.displayName");
    public static final Profile JAVA_EE_5 = new Profile(3, "1.5", null, "JavaEE5.displayName");
    public static final Profile JAVA_EE_6_FULL = new Profile(4, "1.6", null, "JavaEE6Full.displayName");
    public static final Profile JAVA_EE_6_WEB = new Profile(5, "1.6", "web", "JavaEE6Web.displayName");
    public static final Profile JAVA_EE_7_FULL = new Profile(6, "1.7", null, "JavaEE7Full.displayName");
    public static final Profile JAVA_EE_7_WEB = new Profile(7, "1.7", "web", "JavaEE7Web.displayName");
    public static final Profile JAVA_EE_8_FULL = new Profile(8, "1.8", null, "JavaEE8Full.displayName");
    public static final Profile JAVA_EE_8_WEB = new Profile(9, "1.8", "web", "JavaEE8Web.displayName");
    public static final Profile JAKARTA_EE_8_FULL = new Profile(10, "8.0", null, "JakartaEE8Full.displayName");
    public static final Profile JAKARTA_EE_8_WEB = new Profile(11, "8.0", "web", "JakartaEE8Web.displayName");
    public static final Profile JAKARTA_EE_9_WEB = new Profile(12, "9.0", "web", "JakartaEE9Web.displayName");
    public static final Profile JAKARTA_EE_9_FULL = new Profile(13, "9.0", null, "JakartaEE9Full.displayName");
    private final int order;
    private final String propertiesString;
    private final String bundleKey;

    private Profile(int order, String canonicalName, String profile, String bundleKey) {
        this.order = order;
        this.bundleKey = bundleKey;
        StringBuilder builder = new StringBuilder(canonicalName);
        if (profile != null) {
            builder.append("-").append(profile);
        }
        this.propertiesString = builder.toString();
    }

    @NonNull
    public String getDisplayName() {
        return NbBundle.getMessage(Profile.class, (String)this.bundleKey);
    }

    @NonNull
    public String toPropertiesString() {
        return this.propertiesString;
    }

    public boolean isAtLeast(@NonNull Profile profile) {
        return Profile.isVersionEqualOrHigher(this, profile);
    }

    public String toString() {
        return this.toPropertiesString();
    }

    @CheckForNull
    public static Profile fromPropertiesString(@NullAllowed String value) {
        String valueMinusQuotes = value;
        if (value != null && value.contains("\"")) {
            valueMinusQuotes = value.replace("\"", "");
        }
        if (J2EE_13.toPropertiesString().equals(valueMinusQuotes)) {
            return J2EE_13;
        }
        if (J2EE_14.toPropertiesString().equals(valueMinusQuotes)) {
            return J2EE_14;
        }
        if (JAVA_EE_5.toPropertiesString().equals(valueMinusQuotes)) {
            return JAVA_EE_5;
        }
        if (JAVA_EE_6_FULL.toPropertiesString().equals(valueMinusQuotes) || "EE_6_FULL".equals(value)) {
            return JAVA_EE_6_FULL;
        }
        if (JAVA_EE_6_WEB.toPropertiesString().equals(valueMinusQuotes) || "EE_6_WEB".equals(value)) {
            return JAVA_EE_6_WEB;
        }
        if (JAVA_EE_7_FULL.toPropertiesString().equals(valueMinusQuotes) || "EE_7_FULL".equals(value)) {
            return JAVA_EE_7_FULL;
        }
        if (JAVA_EE_7_WEB.toPropertiesString().equals(valueMinusQuotes) || "EE_7_WEB".equals(value)) {
            return JAVA_EE_7_WEB;
        }
        if (JAVA_EE_8_FULL.toPropertiesString().equals(valueMinusQuotes) || "EE_8_FULL".equals(value)) {
            return JAVA_EE_8_FULL;
        }
        if (JAVA_EE_8_WEB.toPropertiesString().equals(valueMinusQuotes) || "EE_8_WEB".equals(value)) {
            return JAVA_EE_8_WEB;
        }
        if (JAKARTA_EE_8_FULL.toPropertiesString().equals(valueMinusQuotes) || "JAKARTA_EE_8_FULL".equals(value)) {
            return JAKARTA_EE_8_FULL;
        }
        if (JAKARTA_EE_8_WEB.toPropertiesString().equals(valueMinusQuotes) || "JAKARTA_EE_8_WEB".equals(value)) {
            return JAKARTA_EE_8_WEB;
        }
        if (JAKARTA_EE_9_FULL.toPropertiesString().equals(valueMinusQuotes) || "JAKARTA_EE_9_FULL".equals(value)) {
            return JAKARTA_EE_9_FULL;
        }
        if (JAKARTA_EE_9_WEB.toPropertiesString().equals(valueMinusQuotes) || "JAKARTA_EE_9_WEB".equals(value)) {
            return JAKARTA_EE_9_WEB;
        }
        return null;
    }

    private static String getProfileVersion(@NonNull Profile profile) {
        String profileDetails = profile.toPropertiesString();
        int indexOfDash = profileDetails.indexOf("-");
        if (indexOfDash != -1) {
            return profileDetails.substring(0, indexOfDash);
        }
        return profileDetails;
    }

    private static boolean compareWebAndFull(@NonNull Profile profileToCompare, @NonNull Profile comparingVersion) {
        boolean isThisFullProfile = Profile.isFullProfile(profileToCompare);
        boolean isParamFullProfile = Profile.isFullProfile(comparingVersion);
        if (isThisFullProfile && isParamFullProfile) {
            return true;
        }
        if (!isThisFullProfile && !isParamFullProfile) {
            return true;
        }
        return isThisFullProfile && !isParamFullProfile;
    }

    private static boolean isFullProfile(@NonNull Profile profile) {
        String profileDetails = profile.toPropertiesString();
        return profileDetails.indexOf("-") == -1;
    }

    private static boolean isVersionEqualOrHigher(@NonNull Profile profileToCompare, @NonNull Profile comparingVersion) {
        String comparingProfileVersion;
        int comparisonResult = UI_COMPARATOR.compare(profileToCompare, comparingVersion);
        if (comparisonResult == 0) {
            return true;
        }
        String profileToCompareVersion = Profile.getProfileVersion(profileToCompare);
        if (profileToCompareVersion.equals(comparingProfileVersion = Profile.getProfileVersion(comparingVersion))) {
            return Profile.compareWebAndFull(profileToCompare, comparingVersion);
        }
        return comparisonResult <= 0;
    }
}

