/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper;

import java.util.List;

public enum Platform {
    GENERIC(null, null, null, null, "Generic"),
    UNIX("unix", null, null, null, "Unix"),
    WINDOWS("windows", null, null, null, "Windows"),
    WINDOWS_X86("windows", "x86", null, null, "Windows X86"),
    WINDOWS_X64("windows", "x64", null, null, "Windows X64"),
    WINDOWS_IA64("windows", "ia64", null, null, "Windows Itanium"),
    LINUX("linux", null, null, null, "Linux"),
    LINUX_X86("linux", "x86", null, null, "Linux X86"),
    LINUX_X64("linux", "x64", null, null, "Linux X64"),
    LINUX_PPC("linux", "ppc", null, null, "Linux PowerPC"),
    LINUX_PPC64("linux", "ppc64", null, null, "Linux PowerPC X64"),
    LINUX_SPARC("linux", "sparc", null, null, "Linux SPARC"),
    LINUX_IA64("linux", "ia64", null, null, "Linux Itanium"),
    SOLARIS("solaris", null, null, null, "Solaris"),
    SOLARIS_X86("solaris", "x86", null, null, "Solaris X86"),
    SOLARIS_SPARC("solaris", "sparc", null, null, "Solaris SPARC"),
    MACOSX("macosx", null, null, null, "MacOS X"),
    MACOSX_X86("macosx", "x86", null, null, "Mac OS X Intel"),
    MACOSX_X64("macosx", "x64", null, null, "Mac OS X Intel X64"),
    MACOSX_PPC("macosx", "ppc", null, null, "Mac OS X PowerPC"),
    MACOSX_PPC64("macosx", "ppc64", null, null, "Mac OS X PowerPC X64"),
    BSD("bsd", null, null, null, "BSD"),
    BSD_X86("bsd", "x86", null, null, "BSD X86"),
    BSD_X64("bsd", "x64", null, null, "BSD X64"),
    BSD_PPC("bsd", "ppc", null, null, "BSD PowerPC"),
    BSD_PPC64("bsd", "ppc64", null, null, "BSD PowerPC X64"),
    BSD_SPARC("bsd", "sparc", null, null, "BSD SPARC"),
    FREEBSD("freebsd", null, null, null, "FreeBSD"),
    FREEBSD_X86("freebsd", "x86", null, null, "FreeBSD X86"),
    FREEBSD_X64("freebsd", "x64", null, null, "FreeBSD X64"),
    FREEBSD_PPC("freebsd", "ppc", null, null, "FreeBSD PowerPC"),
    FREEBSD_PPC64("freebsd", "ppc64", null, null, "FreeBSD PowerPC X64"),
    FREEBSD_SPARC("freebsd", "sparc", null, null, "FreeBSD SPARC"),
    OPENBSD("openbsd", null, null, null, "OpenBSD"),
    OPENBSD_X86("openbsd", "x86", null, null, "OpenBSD X86"),
    OPENBSD_X64("openbsd", "x64", null, null, "OpenBSD X64"),
    OPENBSD_PPC("openbsd", "ppc", null, null, "OpenBSD PowerPC"),
    OPENBSD_PPC64("openbsd", "ppc64", null, null, "OpenBSD PowerPC X64"),
    OPENBSD_SPARC("openbsd", "sparc", null, null, "OpenBSD SPARC"),
    AIX("aix", null, null, null, "AIX"),
    AIX_PPC("aix", "ppc", null, null, "AIX PowerPC"),
    AIX_PPC64("aix", "ppc64", null, null, "AIX PowerPC X64"),
    HPUX("hpux", null, null, null, "HP-UX"),
    HPUX_IA64("hpux", "ia64", null, null, "HP-UX Itanium"),
    HPUX_PA_RISC("hpux", "pa_risc", null, null, "HP-UX PA-RISC"),
    HPUX_PA_RISC20("hpux", "pa_risc2.0", null, null, "HP-UX PA-RISC2.0");

    private String osFamily;
    private String hardwareArch;
    private String osVersion;
    private String osFlavor;
    private String codeName;
    private String displayName;
    public static final String SEPARATOR = "-";

    private Platform(String osFamily, String hardwareArch, String osVersion, String osFlavor, String displayName) {
        this.osFamily = osFamily;
        this.hardwareArch = hardwareArch;
        this.osVersion = osVersion;
        this.osFlavor = osFlavor;
        if (osFamily != null) {
            this.codeName = osFamily;
            if (hardwareArch != null) {
                this.codeName = this.codeName + SEPARATOR + hardwareArch;
                if (osVersion != null) {
                    this.codeName = this.codeName + SEPARATOR + osVersion;
                    if (osFlavor != null) {
                        this.codeName = this.codeName + SEPARATOR + osFlavor;
                    }
                }
            }
        } else {
            this.codeName = "generic";
        }
        this.displayName = displayName;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public String getHardwareArch() {
        return this.hardwareArch;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsFlavor() {
        return this.osFlavor;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isCompatibleWith(Platform platform) {
        if (platform.osFamily != null && !platform.osFamily.equals(this.osFamily)) {
            if (platform.osFamily.equals("unix") && !"windows".equals(this.osFamily)) {
                return true;
            }
            if (platform.osFamily.equals("bsd")) {
                boolean osFamilyMatches = "freebsd".equals(this.osFamily) || "openbsd".equals(this.osFamily) || "macosx".equals(this.osFamily);
                return osFamilyMatches && (platform.hardwareArch == null || platform.hardwareArch.equals(this.hardwareArch));
            }
            return false;
        }
        if (platform.hardwareArch != null && !platform.hardwareArch.equals(this.hardwareArch)) {
            return false;
        }
        if (platform.osVersion != null && !platform.osVersion.equals(this.osVersion)) {
            return false;
        }
        return platform.osFlavor == null || platform.osFlavor.equals(this.osFlavor);
    }

    public boolean isCompatibleWith(List<Platform> platforms) {
        for (Platform candidate : platforms) {
            if (!this.isCompatibleWith(candidate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.codeName;
    }
}

