/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project.ui;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.fish.payara.micro.plugin.Constants;
import org.netbeans.modules.fish.payara.micro.plugin.MicroPluginWizardDescriptor;
import org.netbeans.modules.fish.payara.micro.project.ui.BaseWizardIterator;
import org.netbeans.modules.fish.payara.micro.project.ui.PayaraMicroDescriptor;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class MicroProjectWizardIterator
extends BaseWizardIterator {
    public static MicroProjectWizardIterator createWebAppIterator() {
        return new MicroProjectWizardIterator();
    }

    public Set<FileObject> instantiate() throws IOException {
        ProjectInfo projectInfo = new ProjectInfo((String)this.descriptor.getProperty("groupId"), (String)this.descriptor.getProperty("artifactId"), (String)this.descriptor.getProperty("version"), (String)this.descriptor.getProperty("package"));
        String payaraMicroVersion = (String)this.descriptor.getProperty("payaraMicroVersion");
        String autoBindHttp = (String)this.descriptor.getProperty("autoBindHttp");
        String contextRoot = (String)this.descriptor.getProperty("contextRoot");
        Archetype archetype = this.createMojoArchetype();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("payaraMicroVersion", payaraMicroVersion);
        properties.put("autoBindHttp", autoBindHttp);
        properties.put("contextRoot", contextRoot);
        ArchetypeWizards.logUsage((String)archetype.getGroupId(), (String)archetype.getArtifactId(), (String)archetype.getVersion());
        File rootFile = FileUtil.normalizeFile((File)((File)this.descriptor.getProperty("projdir")));
        ArchetypeWizards.createFromArchetype((File)rootFile, (ProjectInfo)projectInfo, (Archetype)archetype, properties, (boolean)true);
        Set projects = ArchetypeWizards.openProjects((File)rootFile, (File)rootFile);
        for (FileObject projectFile : projects) {
            Project project = ProjectManager.getDefault().findProject(projectFile);
            if (project == null) continue;
            MavenProjectSupport.changeServer((Project)project, (boolean)true);
            MicroPluginWizardDescriptor.updateMicroMavenPlugin(project, payaraMicroVersion, autoBindHttp, contextRoot);
        }
        return projects;
    }

    private Archetype createMojoArchetype() {
        Archetype archetype = new Archetype();
        archetype.setGroupId("fish.payara.maven.archetypes");
        archetype.setArtifactId("payara-micro-maven-archetype");
        return archetype;
    }

    @Override
    public void initialize(WizardDescriptor wiz) {
        super.initialize(wiz);
        wiz.putProperty("NewProjectWizard_Title", (Object)NbBundle.getMessage(MicroProjectWizardIterator.class, (String)"TTL_NewProjectWizard"));
    }

    @Override
    protected WizardDescriptor.Panel[] createPanels(ValidationGroup vg) {
        return new WizardDescriptor.Panel[]{ArchetypeWizards.basicWizardPanel((ValidationGroup)vg, (boolean)false, null), new PayaraMicroDescriptor(Constants.PROJECT_TYPE)};
    }
}

