
[//000000001]: # (struct::map \- )
[//000000002]: # (Generated from file 'struct\_map\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (struct::map\(n\) 1 tcllib "")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

struct::map \- Manage key/value maps

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [API](#section2)

  - [Bugs, Ideas, Feedback](#section3)

# <a name='synopsis'></a>SYNOPSIS

package require struct::map ?1?  

[__::struct::map__ *mapName*](#1)  
[__mapName__ __method__ ?*arg arg \.\.\.*?](#2)  
[*mapName* __get__](#3)  
[*mapName* __names__](#4)  
[*mapName* __set__ *name* ?*value*?](#5)  
[*mapName* __unset__ ?*pattern*\.\.\.?](#6)  

# <a name='description'></a>DESCRIPTION

Provides a snit class whose instances manage a key/value map\. In other words, an
object wrapper around Tcl arrays\.

# <a name='section2'></a>API

The main command provides construction of maps:

  - <a name='1'></a>__::struct::map__ *mapName*

    Creates a new, empty map with an associated global Tcl command whose name is
    *mapName*\. It may be used to invoke various operations on the map\. It has
    the following general form:

      * <a name='2'></a>__mapName__ __method__ ?*arg arg \.\.\.*?

        __method__ and *arg*uments determine the exact behavior of the
        command\.

    If *mapName* is specified as __%AUTO%__ a unique name will be
    generated by the package itself\. The result of the command is the
    fully\-qualified name of the instance command\.

The following commands are possible for map objects:

  - <a name='3'></a>*mapName* __get__

    Returns the entire map as a Tcl dictionary\.

  - <a name='4'></a>*mapName* __names__

    Returns the list of all keys known to the map, in arbitrary order\.

  - <a name='5'></a>*mapName* __set__ *name* ?*value*?

    Sets key *name* to the specified *value*, if the value specified\.
    Returns the value for the key\. Throws an error if the key is not known\.

  - <a name='6'></a>*mapName* __unset__ ?*pattern*\.\.\.?

    Removes all keys matching at least one of the glob *pattern*s from the
    map\. If no pattern is specified all keys are removed\. In other words, the
    default pattern is __\*__\. The result of the command is the empty string\.

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *struct :: list* of the
[Tcllib Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report
any ideas for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.
