/*
 * Copyright (c) 2000-2007 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 * 
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

#define kProgressBarHeight   (18)
#define kProgressBarCapWidth (9)
#define kProgressBarWidth    (300 + 2 * kProgressBarCapWidth)

static const unsigned char 
progressmeter_leftcap1x[2][kProgressBarCapWidth * kProgressBarHeight] = {
{
    0xff,0xff,0xff,0xff,0xff,0xe8,0xcc,0xbb,0xaa,
    0xff,0xff,0xff,0xf3,0xbf,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xeb,0xb0,0xa9,0xad,0xd4,0xec,0xfe,
    0xff,0xf3,0xb0,0xa9,0xbf,0xf4,0xff,0xff,0xff,
    0xff,0xbf,0xa9,0xc4,0xff,0xff,0xff,0xff,0xff,
    0xe8,0xa9,0xb0,0xfb,0xff,0xff,0xff,0xff,0xff,
    0xcc,0xa9,0xd5,0xff,0xff,0xff,0xff,0xff,0xff,
    0xb5,0xa9,0xef,0xff,0xff,0xff,0xff,0xff,0xff,
    0xac,0xa9,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,
    0xae,0xa9,0xfa,0xff,0xff,0xff,0xff,0xff,0xff,
    0xb8,0xa9,0xef,0xff,0xff,0xff,0xff,0xff,0xff,
    0xcc,0xa9,0xd5,0xff,0xff,0xff,0xff,0xff,0xff,
    0xe8,0xa9,0xb0,0xfb,0xff,0xff,0xff,0xff,0xff,
    0xff,0xbf,0xa9,0xc5,0xff,0xff,0xff,0xff,0xff,
    0xff,0xf3,0xae,0xa9,0xc0,0xf4,0xff,0xff,0xff,
    0xff,0xff,0xeb,0xb0,0xa9,0xad,0xd4,0xec,0xff,
    0xff,0xff,0xff,0xf3,0xbd,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xe8,0xcc,0xbb,0xa9,
},
{
    0xff,0xff,0xff,0xff,0xff,0xe8,0xcc,0xbb,0xaa,
    0xff,0xff,0xff,0xf3,0xbf,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xeb,0xb0,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xf3,0xb0,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xbf,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xe8,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xcc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xb5,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xac,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xae,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xb8,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xcc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xe8,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xbf,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xf3,0xae,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xeb,0xb0,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xf3,0xbd,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xe8,0xcc,0xbb,0xa9,
}
};

static const unsigned char 
progressmeter_leftcap2x[2][4 * kProgressBarCapWidth * kProgressBarHeight] = {
{
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xe0,0xcc,0xbc,0xbb,0xaa,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe4,0xc0,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0xbc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xcf,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xfa,0xc1,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb8,0xd4,0xeb,0xee,0xfe,
    0xff,0xff,0xff,0xff,0xfa,0xb8,0xa9,0xa9,0xa9,0xa9,0xa9,0xc4,0xf2,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xfe,0xc1,0xa9,0xa9,0xa9,0xa9,0xb4,0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xcf,0xa9,0xa9,0xa9,0xa9,0xbf,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xeb,0xa9,0xa9,0xa9,0xa9,0xbf,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xbd,0xa9,0xa9,0xa9,0xb4,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xe4,0xa9,0xa9,0xa9,0xa9,0xeb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xbc,0xa9,0xa9,0xa9,0xc5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xf4,0xa9,0xa9,0xa9,0xa9,0xf2,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xdc,0xa9,0xa9,0xa9,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xc8,0xa9,0xa9,0xa9,0xd7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xb9,0xa9,0xa9,0xa9,0xea,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xb0,0xa9,0xa9,0xa9,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xac,0xa9,0xa9,0xa9,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xac,0xa9,0xa9,0xa9,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xb0,0xa9,0xa9,0xa9,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xb9,0xa9,0xa9,0xa9,0xea,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xc7,0xa9,0xa9,0xa9,0xd7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xdc,0xa9,0xa9,0xa9,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xf4,0xa9,0xa9,0xa9,0xa9,0xf2,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xbc,0xa9,0xa9,0xa9,0xc5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xe4,0xa9,0xa9,0xa9,0xa9,0xeb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xbd,0xa9,0xa9,0xa9,0xb5,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xeb,0xa9,0xa9,0xa9,0xa9,0xbf,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xcd,0xa9,0xa9,0xa9,0xa9,0xbf,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xfe,0xc0,0xa9,0xa9,0xa9,0xa9,0xb4,0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xfa,0xb7,0xa9,0xa9,0xa9,0xa9,0xa9,0xc5,0xf3,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xf8,0xc0,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbb,0xd4,0xec,0xef,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xcd,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xeb,0xbc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe3,0xbc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf4,0xdb,0xcb,0xbb,0xb9,0xa9,
},
{
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xe0,0xcc,0xbc,0xbb,0xaa,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe4,0xc0,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0xbc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xcf,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xfa,0xc1,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xfa,0xb8,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xfe,0xc1,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xcf,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xeb,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xbd,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xe4,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xbc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xf4,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xdc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xc8,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xb9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xb0,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xac,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xac,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xb0,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xb9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xc7,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xdc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xf4,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xbc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xe4,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xbd,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xeb,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xcd,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xfe,0xc0,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xfa,0xb7,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xf8,0xc0,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xcd,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xeb,0xbc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe3,0xbc,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf4,0xdb,0xcb,0xbb,0xb9,0xa9,
}
};




static const unsigned char 
progressmeter_middle1x[2][1 * kProgressBarHeight] = {
{
    0xaa,
    0xa9,
    0xf6,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xf6,
    0xa9,
    0xa9,
},
{
    0xaa,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
}};


static const unsigned char 
progressmeter_middle2x[2][2 * 1 * kProgressBarHeight] = {
{
    0xaa,
    0xa9,
    0xa9,
    0xa9,
    0xfe,
    0xff,
    0xff,
    0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
	0xff,
    0xff,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
},
{
    0xaa,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
    0xa9,
}};

static const unsigned char 
progressmeter_rightcap1x[2][kProgressBarCapWidth * kProgressBarHeight] = {
{
    0xa9,0xbb,0xcc,0xe8,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xbf,0xf3,0xff,0xff,0xff,
    0xfe,0xec,0xd4,0xad,0xa9,0xb0,0xeb,0xff,0xff,
    0xff,0xff,0xff,0xf4,0xbf,0xa9,0xb0,0xf3,0xff,
    0xff,0xff,0xff,0xff,0xff,0xc4,0xa9,0xbf,0xff,
    0xff,0xff,0xff,0xff,0xff,0xfb,0xb0,0xa9,0xe8,
    0xff,0xff,0xff,0xff,0xff,0xff,0xd5,0xa9,0xcc,
    0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xa9,0xb5,
    0xff,0xff,0xff,0xff,0xff,0xff,0xfa,0xa9,0xac,
    0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xa9,0xac,
    0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xa9,0xb5,
    0xff,0xff,0xff,0xff,0xff,0xff,0xd5,0xa9,0xcc,
    0xff,0xff,0xff,0xff,0xff,0xfb,0xb0,0xa9,0xe8,
    0xff,0xff,0xff,0xff,0xff,0xc5,0xa9,0xbf,0xff,
    0xff,0xff,0xff,0xf4,0xc1,0xa9,0xae,0xf3,0xff,
    0xff,0xec,0xd4,0xad,0xa9,0xb0,0xea,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xbd,0xf3,0xff,0xff,0xff,
    0xa9,0xbb,0xcc,0xe8,0xff,0xff,0xff,0xff,0xff,
},
{
    0xa9,0xbb,0xcc,0xe8,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xbf,0xf3,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xb0,0xeb,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb0,0xf3,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbf,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xe8,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xcc,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb5,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xac,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xac,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb5,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xcc,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xe8,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbf,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xae,0xf3,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xb0,0xea,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xbd,0xf3,0xff,0xff,0xff,
    0xa9,0xbb,0xcc,0xe8,0xff,0xff,0xff,0xff,0xff,
}};


static const unsigned char 
progressmeter_rightcap2x[2][4 * kProgressBarCapWidth * kProgressBarHeight] = {
{
    0xaa,0xbb,0xbc,0xcc,0xe0,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc0,0xe4,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xcf,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,
    0xfe,0xee,0xeb,0xd4,0xb8,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc1,0xfb,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xf2,0xc5,0xa9,0xa9,0xa9,0xa9,0xa9,0xb8,0xfa,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0xb4,0xa9,0xa9,0xa9,0xa9,0xc1,0xfe,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xbf,0xa9,0xa9,0xa9,0xa9,0xcf,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfc,0xbf,0xa9,0xa9,0xa9,0xa9,0xeb,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xb4,0xa9,0xa9,0xa9,0xbd,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xeb,0xa9,0xa9,0xa9,0xa9,0xe4,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xc5,0xa9,0xa9,0xa9,0xbc,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf2,0xa9,0xa9,0xa9,0xa9,0xf4,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xa9,0xa9,0xa9,0xdc,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xd7,0xa9,0xa9,0xa9,0xc8,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xea,0xa9,0xa9,0xa9,0xb9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xa9,0xa9,0xa9,0xb0,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfc,0xa9,0xa9,0xa9,0xac,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfc,0xa9,0xa9,0xa9,0xac,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xa9,0xa9,0xa9,0xb0,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xea,0xa9,0xa9,0xa9,0xb9,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xd7,0xa9,0xa9,0xa9,0xc8,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xc0,0xa9,0xa9,0xa9,0xdc,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf2,0xa9,0xa9,0xa9,0xa9,0xf4,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xc5,0xa9,0xa9,0xa9,0xbc,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0xa9,0xa9,0xa9,0xa9,0xe4,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xb5,0xa9,0xa9,0xa9,0xbc,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfc,0xbf,0xa9,0xa9,0xa9,0xa9,0xeb,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xbf,0xa9,0xa9,0xa9,0xa9,0xcd,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0xb4,0xa9,0xa9,0xa9,0xa9,0xc0,0xfe,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xf3,0xc5,0xa9,0xa9,0xa9,0xa9,0xa9,0xb7,0xfa,0xff,0xff,0xff,0xff,
    0xff,0xef,0xec,0xd4,0xbb,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc0,0xf8,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xcd,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xeb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xe3,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xb9,0xbb,0xcb,0xdb,0xf4,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
},
{
    0xaa,0xbb,0xbc,0xcc,0xe0,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc0,0xe4,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xcf,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc1,0xfb,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb8,0xfa,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc1,0xfe,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xcf,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xeb,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbd,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xe4,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xf4,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xdc,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc8,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb0,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xac,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xac,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb0,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc8,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xdc,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xf4,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xe4,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xeb,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xcd,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc0,0xfe,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xb7,0xfa,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xc0,0xf8,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xcd,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xeb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xbc,0xe3,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xa9,0xb9,0xbb,0xcb,0xdb,0xf4,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
} };

static const unsigned char *
progressmeter_leftcap[2][2] = { 
	{ &progressmeter_leftcap1x[0][0], &progressmeter_leftcap1x[1][0] },
	{ &progressmeter_leftcap2x[0][0], &progressmeter_leftcap2x[1][0] } };

static const unsigned char *
progressmeter_middle[2][2] = { 
	{ &progressmeter_middle1x[0][0], &progressmeter_middle1x[1][0] },
	{ &progressmeter_middle2x[0][0], &progressmeter_middle2x[1][0] } };

static const unsigned char *
progressmeter_rightcap[2][2] = { 
	{ &progressmeter_rightcap1x[0][0], &progressmeter_rightcap1x[1][0] },
	{ &progressmeter_rightcap2x[0][0], &progressmeter_rightcap2x[1][0] } };
	
