/******************************************************************************
* Copyright (C) 2019-2022 Xilinx, Inc. All rights reserved.
* Copyright (C) 2022-2023 Advanced Micro Devices, Inc. All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


/*****************************************************************************/
/**
*
* @file xaiegbl_params.h
* @{
*
* This file contains the macro definitions for the AIE registers, generated from
* regdb headers.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who     Date     Changes
* ----- ------  -------- -----------------------------------------------------
* 1.0  Naresh  03/14/2018  Initial creation
* 1.1  Naresh  07/11/2018  Updated copyright info
* 1.2  Nishad  12/05/2018  Renamed ME attributes to AIE
* 1.3  Wendy   09/15/2019  Remove Private Registers
* 1.4  Tejus   10/22/2019  Copy file for aienginev2
* </pre>
*
******************************************************************************/
#ifndef XAIEGBL_PARAMS_H
#define XAIEGBL_PARAMS_H

/* XAIEGBL mem module register definitions */

/**
 * @name Mem Module register definitions
 * This registers contains mem module information
 * @{
 */
/**
 * Register:XAIEGBL_MEM_MODULE
 */
#define XAIEGBL_MEM_DATMEM		0x00000000
#define XAIEGBL_MEM_DATMEMWID		128
#define XAIEGBL_MEM_DATMEMMSK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_MEM_DATMEM_DAT_LSB		0
#define XAIEGBL_MEM_DATMEM_DAT_WIDTH		128
#define XAIEGBL_MEM_DATMEM_DAT_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_MEM_DATMEM_DAT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DATMEM(Data)		((Data&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_MEM_PERCTRL0		0x00011000
#define XAIEGBL_MEM_PERCTRL0WID		32
#define XAIEGBL_MEM_PERCTRL0MSK		0x7F7F7F7F
#define XAIEGBL_MEM_PERCTRL0_CNT1STOPEVT_LSB		24
#define XAIEGBL_MEM_PERCTRL0_CNT1STOPEVT_WIDTH		7
#define XAIEGBL_MEM_PERCTRL0_CNT1STOPEVT_MASK		0x7F000000
#define XAIEGBL_MEM_PERCTRL0_CNT1STOPEVT_DEFVAL		0x0
#define XAIEGBL_MEM_PERCTRL0_CNT1STAEVT_LSB		16
#define XAIEGBL_MEM_PERCTRL0_CNT1STAEVT_WIDTH		7
#define XAIEGBL_MEM_PERCTRL0_CNT1STAEVT_MASK		0x007F0000
#define XAIEGBL_MEM_PERCTRL0_CNT1STAEVT_DEFVAL		0x0
#define XAIEGBL_MEM_PERCTRL0_CNT0STOPEVT_LSB		8
#define XAIEGBL_MEM_PERCTRL0_CNT0STOPEVT_WIDTH		7
#define XAIEGBL_MEM_PERCTRL0_CNT0STOPEVT_MASK		0x00007F00
#define XAIEGBL_MEM_PERCTRL0_CNT0STOPEVT_DEFVAL		0x0
#define XAIEGBL_MEM_PERCTRL0_CNT0STAEVT_LSB		0
#define XAIEGBL_MEM_PERCTRL0_CNT0STAEVT_WIDTH		7
#define XAIEGBL_MEM_PERCTRL0_CNT0STAEVT_MASK		0x0000007F
#define XAIEGBL_MEM_PERCTRL0_CNT0STAEVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_PERCTRL0(Cnt1_Stop_Event,Cnt1_Start_Event,Cnt0_Stop_Event,Cnt0_Start_Event)		(((Cnt1_Stop_Event&0x0000007f)<<24)+((Cnt1_Start_Event&0x0000007f)<<16)+((Cnt0_Stop_Event&0x0000007f)<<8)+(Cnt0_Start_Event&0x0000007f))

#define XAIEGBL_MEM_PERCTRL1		0x00011008
#define XAIEGBL_MEM_PERCTRL1WID		32
#define XAIEGBL_MEM_PERCTRL1MSK		0x00007F7F
#define XAIEGBL_MEM_PERCTRL1_CNT1RSTEVT_LSB		8
#define XAIEGBL_MEM_PERCTRL1_CNT1RSTEVT_WIDTH		7
#define XAIEGBL_MEM_PERCTRL1_CNT1RSTEVT_MASK		0x00007F00
#define XAIEGBL_MEM_PERCTRL1_CNT1RSTEVT_DEFVAL		0x0
#define XAIEGBL_MEM_PERCTRL1_CNT0RSTEVT_LSB		0
#define XAIEGBL_MEM_PERCTRL1_CNT0RSTEVT_WIDTH		7
#define XAIEGBL_MEM_PERCTRL1_CNT0RSTEVT_MASK		0x0000007F
#define XAIEGBL_MEM_PERCTRL1_CNT0RSTEVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_PERCTRL1(Cnt1_Reset_Event,Cnt0_Reset_Event)		(((Cnt1_Reset_Event&0x0000007f)<<8)+(Cnt0_Reset_Event&0x0000007f))

#define XAIEGBL_MEM_PERCOU0		0x00011020
#define XAIEGBL_MEM_PERCOU0WID		32
#define XAIEGBL_MEM_PERCOU0MSK		0xFFFFFFFF
#define XAIEGBL_MEM_PERCOU0_COU0VAL_LSB		0
#define XAIEGBL_MEM_PERCOU0_COU0VAL_WIDTH		32
#define XAIEGBL_MEM_PERCOU0_COU0VAL_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_PERCOU0_COU0VAL_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_PERCOU0(Counter0_Value)		((Counter0_Value&0xffffffff))

#define XAIEGBL_MEM_PERCOU1		0x00011024
#define XAIEGBL_MEM_PERCOU1WID		32
#define XAIEGBL_MEM_PERCOU1MSK		0xFFFFFFFF
#define XAIEGBL_MEM_PERCOU1_COU0VAL_LSB		0
#define XAIEGBL_MEM_PERCOU1_COU0VAL_WIDTH		32
#define XAIEGBL_MEM_PERCOU1_COU0VAL_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_PERCOU1_COU0VAL_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_PERCOU1(Counter0_Value)		((Counter0_Value&0xffffffff))

#define XAIEGBL_MEM_PERCOU0EVTVAL		0x00011080
#define XAIEGBL_MEM_PERCOU0EVTVALWID		32
#define XAIEGBL_MEM_PERCOU0EVTVALMSK		0xFFFFFFFF
#define XAIEGBL_MEM_PERCOU0EVTVAL_COU0EVTVAL_LSB		0
#define XAIEGBL_MEM_PERCOU0EVTVAL_COU0EVTVAL_WIDTH		32
#define XAIEGBL_MEM_PERCOU0EVTVAL_COU0EVTVAL_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_PERCOU0EVTVAL_COU0EVTVAL_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_PERCOU0EVTVAL(Counter0_Event_Value)		((Counter0_Event_Value&0xffffffff))

#define XAIEGBL_MEM_PERCOU1EVTVAL		0x00011084
#define XAIEGBL_MEM_PERCOU1EVTVALWID		32
#define XAIEGBL_MEM_PERCOU1EVTVALMSK		0xFFFFFFFF
#define XAIEGBL_MEM_PERCOU1EVTVAL_COU1EVTVAL_LSB		0
#define XAIEGBL_MEM_PERCOU1EVTVAL_COU1EVTVAL_WIDTH		32
#define XAIEGBL_MEM_PERCOU1EVTVAL_COU1EVTVAL_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_PERCOU1EVTVAL_COU1EVTVAL_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_PERCOU1EVTVAL(Counter1_Event_Value)		((Counter1_Event_Value&0xffffffff))

#define XAIEGBL_MEM_TIMCTRL		0x00014000
#define XAIEGBL_MEM_TIMCTRLWID		32
#define XAIEGBL_MEM_TIMCTRLMSK		0x80007F00
#define XAIEGBL_MEM_TIMCTRL_RST_LSB		31
#define XAIEGBL_MEM_TIMCTRL_RST_WIDTH		1
#define XAIEGBL_MEM_TIMCTRL_RST_MASK		0x80000000
#define XAIEGBL_MEM_TIMCTRL_RST_DEFVAL		0x0
#define XAIEGBL_MEM_TIMCTRL_RSTEVT_LSB		8
#define XAIEGBL_MEM_TIMCTRL_RSTEVT_WIDTH		7
#define XAIEGBL_MEM_TIMCTRL_RSTEVT_MASK		0x00007F00
#define XAIEGBL_MEM_TIMCTRL_RSTEVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_TIMCTRL(Reset,Reset_Event)		(((Reset&0x00000001)<<31)+((Reset_Event&0x0000007f)<<8))

#define XAIEGBL_MEM_EVTGEN		0x00014008
#define XAIEGBL_MEM_EVTGENWID		32
#define XAIEGBL_MEM_EVTGENMSK		0x0000007F
#define XAIEGBL_MEM_EVTGEN_EVT_LSB		0
#define XAIEGBL_MEM_EVTGEN_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTGEN_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTGEN_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTGEN(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST0		0x00014010
#define XAIEGBL_MEM_EVTBRDCAST0WID		32
#define XAIEGBL_MEM_EVTBRDCAST0MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST0_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST0_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST0_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST0_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST0(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST1		0x00014014
#define XAIEGBL_MEM_EVTBRDCAST1WID		32
#define XAIEGBL_MEM_EVTBRDCAST1MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST1_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST1_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST1_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST1_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST1(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST2		0x00014018
#define XAIEGBL_MEM_EVTBRDCAST2WID		32
#define XAIEGBL_MEM_EVTBRDCAST2MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST2_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST2_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST2_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST2_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST2(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST3		0x0001401C
#define XAIEGBL_MEM_EVTBRDCAST3WID		32
#define XAIEGBL_MEM_EVTBRDCAST3MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST3_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST3_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST3_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST3_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST3(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST4		0x00014020
#define XAIEGBL_MEM_EVTBRDCAST4WID		32
#define XAIEGBL_MEM_EVTBRDCAST4MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST4_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST4_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST4_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST4_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST4(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST5		0x00014024
#define XAIEGBL_MEM_EVTBRDCAST5WID		32
#define XAIEGBL_MEM_EVTBRDCAST5MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST5_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST5_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST5_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST5_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST5(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST6		0x00014028
#define XAIEGBL_MEM_EVTBRDCAST6WID		32
#define XAIEGBL_MEM_EVTBRDCAST6MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST6_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST6_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST6_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST6_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST6(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST7		0x0001402C
#define XAIEGBL_MEM_EVTBRDCAST7WID		32
#define XAIEGBL_MEM_EVTBRDCAST7MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST7_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST7_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST7_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST7_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST7(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST8		0x00014030
#define XAIEGBL_MEM_EVTBRDCAST8WID		32
#define XAIEGBL_MEM_EVTBRDCAST8MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST8_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST8_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST8_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST8_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST8(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST9		0x00014034
#define XAIEGBL_MEM_EVTBRDCAST9WID		32
#define XAIEGBL_MEM_EVTBRDCAST9MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST9_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST9_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST9_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST9_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST9(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST10		0x00014038
#define XAIEGBL_MEM_EVTBRDCAST10WID		32
#define XAIEGBL_MEM_EVTBRDCAST10MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST10_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST10_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST10_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST10_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST10(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST11		0x0001403C
#define XAIEGBL_MEM_EVTBRDCAST11WID		32
#define XAIEGBL_MEM_EVTBRDCAST11MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST11_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST11_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST11_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST11_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST11(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST12		0x00014040
#define XAIEGBL_MEM_EVTBRDCAST12WID		32
#define XAIEGBL_MEM_EVTBRDCAST12MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST12_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST12_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST12_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST12_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST12(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST13		0x00014044
#define XAIEGBL_MEM_EVTBRDCAST13WID		32
#define XAIEGBL_MEM_EVTBRDCAST13MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST13_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST13_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST13_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST13_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST13(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST14		0x00014048
#define XAIEGBL_MEM_EVTBRDCAST14WID		32
#define XAIEGBL_MEM_EVTBRDCAST14MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST14_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST14_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST14_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST14_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST14(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCAST15		0x0001404C
#define XAIEGBL_MEM_EVTBRDCAST15WID		32
#define XAIEGBL_MEM_EVTBRDCAST15MSK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST15_EVT_LSB		0
#define XAIEGBL_MEM_EVTBRDCAST15_EVT_WIDTH		7
#define XAIEGBL_MEM_EVTBRDCAST15_EVT_MASK		0x0000007F
#define XAIEGBL_MEM_EVTBRDCAST15_EVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCAST15(Event)		((Event&0x0000007f))

#define XAIEGBL_MEM_EVTBRDCASTBLKSOUSET		0x00014050
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUSETWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUSETMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUSET_SET_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUSET_SET_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUSET_SET_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUSET_SET_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKSOUSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKSOUCLR		0x00014054
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUCLRWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUCLRMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUCLR_CLR_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUCLR_CLR_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUCLR_CLR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKSOUCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKSOUVAL		0x00014058
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUVALWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUVALMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUVAL_VAL_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUVAL_VAL_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKSOUVAL_VAL_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKSOUVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKWESSET		0x00014060
#define XAIEGBL_MEM_EVTBRDCASTBLKWESSETWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKWESSETMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKWESSET_SET_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKWESSET_SET_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKWESSET_SET_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKWESSET_SET_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKWESSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKWESCLR		0x00014064
#define XAIEGBL_MEM_EVTBRDCASTBLKWESCLRWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKWESCLRMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKWESCLR_CLR_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKWESCLR_CLR_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKWESCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKWESCLR_CLR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKWESCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKWESVAL		0x00014068
#define XAIEGBL_MEM_EVTBRDCASTBLKWESVALWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKWESVALMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKWESVAL_VAL_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKWESVAL_VAL_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKWESVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKWESVAL_VAL_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKWESVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKNORSET		0x00014070
#define XAIEGBL_MEM_EVTBRDCASTBLKNORSETWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKNORSETMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKNORSET_SET_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKNORSET_SET_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKNORSET_SET_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKNORSET_SET_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKNORSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKNORCLR		0x00014074
#define XAIEGBL_MEM_EVTBRDCASTBLKNORCLRWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKNORCLRMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKNORCLR_CLR_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKNORCLR_CLR_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKNORCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKNORCLR_CLR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKNORCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKNORVAL		0x00014078
#define XAIEGBL_MEM_EVTBRDCASTBLKNORVALWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKNORVALMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKNORVAL_VAL_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKNORVAL_VAL_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKNORVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKNORVAL_VAL_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKNORVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKEASSET		0x00014080
#define XAIEGBL_MEM_EVTBRDCASTBLKEASSETWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKEASSETMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKEASSET_SET_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKEASSET_SET_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKEASSET_SET_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKEASSET_SET_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKEASSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKEASCLR		0x00014084
#define XAIEGBL_MEM_EVTBRDCASTBLKEASCLRWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKEASCLRMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKEASCLR_CLR_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKEASCLR_CLR_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKEASCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKEASCLR_CLR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKEASCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_MEM_EVTBRDCASTBLKEASVAL		0x00014088
#define XAIEGBL_MEM_EVTBRDCASTBLKEASVALWID		32
#define XAIEGBL_MEM_EVTBRDCASTBLKEASVALMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKEASVAL_VAL_LSB		0
#define XAIEGBL_MEM_EVTBRDCASTBLKEASVAL_VAL_WIDTH		16
#define XAIEGBL_MEM_EVTBRDCASTBLKEASVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_MEM_EVTBRDCASTBLKEASVAL_VAL_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTBRDCASTBLKEASVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_MEM_TRACTRL0		0x000140D0
#define XAIEGBL_MEM_TRACTRL0WID		32
#define XAIEGBL_MEM_TRACTRL0MSK		0x7F7F0000
#define XAIEGBL_MEM_TRACTRL0_TRASTOPEVT_LSB		24
#define XAIEGBL_MEM_TRACTRL0_TRASTOPEVT_WIDTH		7
#define XAIEGBL_MEM_TRACTRL0_TRASTOPEVT_MASK		0x7F000000
#define XAIEGBL_MEM_TRACTRL0_TRASTOPEVT_DEFVAL		0x0
#define XAIEGBL_MEM_TRACTRL0_TRASTAEVT_LSB		16
#define XAIEGBL_MEM_TRACTRL0_TRASTAEVT_WIDTH		7
#define XAIEGBL_MEM_TRACTRL0_TRASTAEVT_MASK		0x007F0000
#define XAIEGBL_MEM_TRACTRL0_TRASTAEVT_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_TRACTRL0(Trace_Stop_Event,Trace_Start_Event)		(((Trace_Stop_Event&0x0000007f)<<24)+((Trace_Start_Event&0x0000007f)<<16))

#define XAIEGBL_MEM_TRACTRL1		0x000140D4
#define XAIEGBL_MEM_TRACTRL1WID		32
#define XAIEGBL_MEM_TRACTRL1MSK		0x0000701F
#define XAIEGBL_MEM_TRACTRL1_PKTTYP_LSB		12
#define XAIEGBL_MEM_TRACTRL1_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_TRACTRL1_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_TRACTRL1_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_TRACTRL1_ID_LSB		0
#define XAIEGBL_MEM_TRACTRL1_ID_WIDTH		5
#define XAIEGBL_MEM_TRACTRL1_ID_MASK		0x0000001F
#define XAIEGBL_MEM_TRACTRL1_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_TRACTRL1(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_TRASTA		0x000140D8
#define XAIEGBL_MEM_TRASTAWID		32
#define XAIEGBL_MEM_TRASTAMSK		0x00000307
#define XAIEGBL_MEM_TRASTA_STA_LSB		8
#define XAIEGBL_MEM_TRASTA_STA_WIDTH		2
#define XAIEGBL_MEM_TRASTA_STA_MASK		0x00000300
#define XAIEGBL_MEM_TRASTA_STA_DEFVAL		0x0
#define XAIEGBL_MEM_TRASTA_MOD_LSB		0
#define XAIEGBL_MEM_TRASTA_MOD_WIDTH		3
#define XAIEGBL_MEM_TRASTA_MOD_MASK		0x00000007
#define XAIEGBL_MEM_TRASTA_MOD_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_TRASTA(State,Mode)		(((State&0x00000003)<<8)+(Mode&0x00000007))

#define XAIEGBL_MEM_TRAEVT0		0x000140E0
#define XAIEGBL_MEM_TRAEVT0WID		32
#define XAIEGBL_MEM_TRAEVT0MSK		0x7F7F7F7F
#define XAIEGBL_MEM_TRAEVT0_TRAEVT3_LSB		24
#define XAIEGBL_MEM_TRAEVT0_TRAEVT3_WIDTH		7
#define XAIEGBL_MEM_TRAEVT0_TRAEVT3_MASK		0x7F000000
#define XAIEGBL_MEM_TRAEVT0_TRAEVT3_DEFVAL		0x0
#define XAIEGBL_MEM_TRAEVT0_TRAEVT2_LSB		16
#define XAIEGBL_MEM_TRAEVT0_TRAEVT2_WIDTH		7
#define XAIEGBL_MEM_TRAEVT0_TRAEVT2_MASK		0x007F0000
#define XAIEGBL_MEM_TRAEVT0_TRAEVT2_DEFVAL		0x0
#define XAIEGBL_MEM_TRAEVT0_TRAEVT1_LSB		8
#define XAIEGBL_MEM_TRAEVT0_TRAEVT1_WIDTH		7
#define XAIEGBL_MEM_TRAEVT0_TRAEVT1_MASK		0x00007F00
#define XAIEGBL_MEM_TRAEVT0_TRAEVT1_DEFVAL		0x0
#define XAIEGBL_MEM_TRAEVT0_TRAEVT0_LSB		0
#define XAIEGBL_MEM_TRAEVT0_TRAEVT0_WIDTH		7
#define XAIEGBL_MEM_TRAEVT0_TRAEVT0_MASK		0x0000007F
#define XAIEGBL_MEM_TRAEVT0_TRAEVT0_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_TRAEVT0(Trace_Event3,Trace_Event2,Trace_Event1,Trace_Event0)		(((Trace_Event3&0x0000007f)<<24)+((Trace_Event2&0x0000007f)<<16)+((Trace_Event1&0x0000007f)<<8)+(Trace_Event0&0x0000007f))

#define XAIEGBL_MEM_TRAEVT1		0x000140E4
#define XAIEGBL_MEM_TRAEVT1WID		32
#define XAIEGBL_MEM_TRAEVT1MSK		0x7F7F7F7F
#define XAIEGBL_MEM_TRAEVT1_TRAEVT7_LSB		24
#define XAIEGBL_MEM_TRAEVT1_TRAEVT7_WIDTH		7
#define XAIEGBL_MEM_TRAEVT1_TRAEVT7_MASK		0x7F000000
#define XAIEGBL_MEM_TRAEVT1_TRAEVT7_DEFVAL		0x0
#define XAIEGBL_MEM_TRAEVT1_TRAEVT6_LSB		16
#define XAIEGBL_MEM_TRAEVT1_TRAEVT6_WIDTH		7
#define XAIEGBL_MEM_TRAEVT1_TRAEVT6_MASK		0x007F0000
#define XAIEGBL_MEM_TRAEVT1_TRAEVT6_DEFVAL		0x0
#define XAIEGBL_MEM_TRAEVT1_TRAEVT5_LSB		8
#define XAIEGBL_MEM_TRAEVT1_TRAEVT5_WIDTH		7
#define XAIEGBL_MEM_TRAEVT1_TRAEVT5_MASK		0x00007F00
#define XAIEGBL_MEM_TRAEVT1_TRAEVT5_DEFVAL		0x0
#define XAIEGBL_MEM_TRAEVT1_TRAEVT4_LSB		0
#define XAIEGBL_MEM_TRAEVT1_TRAEVT4_WIDTH		7
#define XAIEGBL_MEM_TRAEVT1_TRAEVT4_MASK		0x0000007F
#define XAIEGBL_MEM_TRAEVT1_TRAEVT4_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_TRAEVT1(Trace_Event7,Trace_Event6,Trace_Event5,Trace_Event4)		(((Trace_Event7&0x0000007f)<<24)+((Trace_Event6&0x0000007f)<<16)+((Trace_Event5&0x0000007f)<<8)+(Trace_Event4&0x0000007f))

#define XAIEGBL_MEM_TIMTRIEVTLOWVAL		0x000140F0
#define XAIEGBL_MEM_TIMTRIEVTLOWVALWID		32
#define XAIEGBL_MEM_TIMTRIEVTLOWVALMSK		0xFFFFFFFF
#define XAIEGBL_MEM_TIMTRIEVTLOWVAL_TIM_LSB		0
#define XAIEGBL_MEM_TIMTRIEVTLOWVAL_TIM_WIDTH		32
#define XAIEGBL_MEM_TIMTRIEVTLOWVAL_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_TIMTRIEVTLOWVAL_TIM_DEFVAL		0xFFFFFFFF
#define XAIEGBL_MEM_VALUE_TIMTRIEVTLOWVAL(TimerTrigLow)		((TimerTrigLow&0xffffffff))

#define XAIEGBL_MEM_TIMTRIEVTHIGVAL		0x000140F4
#define XAIEGBL_MEM_TIMTRIEVTHIGVALWID		32
#define XAIEGBL_MEM_TIMTRIEVTHIGVALMSK		0xFFFFFFFF
#define XAIEGBL_MEM_TIMTRIEVTHIGVAL_TIM_LSB		0
#define XAIEGBL_MEM_TIMTRIEVTHIGVAL_TIM_WIDTH		32
#define XAIEGBL_MEM_TIMTRIEVTHIGVAL_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_TIMTRIEVTHIGVAL_TIM_DEFVAL		0xFFFFFFFF
#define XAIEGBL_MEM_VALUE_TIMTRIEVTHIGVAL(TimerTrigHigh)		((TimerTrigHigh&0xffffffff))

#define XAIEGBL_MEM_TIMLOW		0x000140F8
#define XAIEGBL_MEM_TIMLOWWID		32
#define XAIEGBL_MEM_TIMLOWMSK		0xFFFFFFFF
#define XAIEGBL_MEM_TIMLOW_TIM_LSB		0
#define XAIEGBL_MEM_TIMLOW_TIM_WIDTH		32
#define XAIEGBL_MEM_TIMLOW_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_TIMLOW_TIM_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_TIMLOW(TimerLow)		((TimerLow&0xffffffff))

#define XAIEGBL_MEM_TIMHIG		0x000140FC
#define XAIEGBL_MEM_TIMHIGWID		32
#define XAIEGBL_MEM_TIMHIGMSK		0xFFFFFFFF
#define XAIEGBL_MEM_TIMHIG_TIM_LSB		0
#define XAIEGBL_MEM_TIMHIG_TIM_WIDTH		32
#define XAIEGBL_MEM_TIMHIG_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_TIMHIG_TIM_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_TIMHIG(TimerHigh)		((TimerHigh&0xffffffff))

#define XAIEGBL_MEM_WTCHPT0		0x00014100
#define XAIEGBL_MEM_WTCHPT0WID		32
#define XAIEGBL_MEM_WTCHPT0MSK		0xFFFFFFE0
#define XAIEGBL_MEM_WTCHPT0_REAACC_LSB		31
#define XAIEGBL_MEM_WTCHPT0_REAACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT0_REAACC_MASK		0x80000000
#define XAIEGBL_MEM_WTCHPT0_REAACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_WRIACC_LSB		30
#define XAIEGBL_MEM_WTCHPT0_WRIACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT0_WRIACC_MASK		0x40000000
#define XAIEGBL_MEM_WTCHPT0_WRIACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_AXIACC_LSB		29
#define XAIEGBL_MEM_WTCHPT0_AXIACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT0_AXIACC_MASK		0x20000000
#define XAIEGBL_MEM_WTCHPT0_AXIACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_DMAACC_LSB		28
#define XAIEGBL_MEM_WTCHPT0_DMAACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT0_DMAACC_MASK		0x10000000
#define XAIEGBL_MEM_WTCHPT0_DMAACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_EASACC_LSB		27
#define XAIEGBL_MEM_WTCHPT0_EASACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT0_EASACC_MASK		0x08000000
#define XAIEGBL_MEM_WTCHPT0_EASACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_NORACC_LSB		26
#define XAIEGBL_MEM_WTCHPT0_NORACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT0_NORACC_MASK		0x04000000
#define XAIEGBL_MEM_WTCHPT0_NORACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_WESACC_LSB		25
#define XAIEGBL_MEM_WTCHPT0_WESACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT0_WESACC_MASK		0x02000000
#define XAIEGBL_MEM_WTCHPT0_WESACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_SOUACC_LSB		24
#define XAIEGBL_MEM_WTCHPT0_SOUACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT0_SOUACC_MASK		0x01000000
#define XAIEGBL_MEM_WTCHPT0_SOUACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_WRI_LSB		20
#define XAIEGBL_MEM_WTCHPT0_WRI_WIDTH		4
#define XAIEGBL_MEM_WTCHPT0_WRI_MASK		0x00F00000
#define XAIEGBL_MEM_WTCHPT0_WRI_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT0_ADD_LSB		5
#define XAIEGBL_MEM_WTCHPT0_ADD_WIDTH		15
#define XAIEGBL_MEM_WTCHPT0_ADD_MASK		0x000FFFE0
#define XAIEGBL_MEM_WTCHPT0_ADD_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_WTCHPT0(Read_Access,Write_Access,AXI_Access,DMA_Access,East_Access,North_Access,West_Access,South_Access,WriteStrobes,Address)		(((Read_Access&0x00000001)<<31)+((Write_Access&0x00000001)<<30)+((AXI_Access&0x00000001)<<29)+((DMA_Access&0x00000001)<<28)+((East_Access&0x00000001)<<27)+((North_Access&0x00000001)<<26)+((West_Access&0x00000001)<<25)+((South_Access&0x00000001)<<24)+((WriteStrobes&0x0000000f)<<20)+((Address&0x00007fff)<<5))

#define XAIEGBL_MEM_WTCHPT1		0x00014104
#define XAIEGBL_MEM_WTCHPT1WID		32
#define XAIEGBL_MEM_WTCHPT1MSK		0xFFFFFFE0
#define XAIEGBL_MEM_WTCHPT1_REAACC_LSB		31
#define XAIEGBL_MEM_WTCHPT1_REAACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT1_REAACC_MASK		0x80000000
#define XAIEGBL_MEM_WTCHPT1_REAACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_WRIACC_LSB		30
#define XAIEGBL_MEM_WTCHPT1_WRIACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT1_WRIACC_MASK		0x40000000
#define XAIEGBL_MEM_WTCHPT1_WRIACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_AXIACC_LSB		29
#define XAIEGBL_MEM_WTCHPT1_AXIACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT1_AXIACC_MASK		0x20000000
#define XAIEGBL_MEM_WTCHPT1_AXIACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_DMAACC_LSB		28
#define XAIEGBL_MEM_WTCHPT1_DMAACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT1_DMAACC_MASK		0x10000000
#define XAIEGBL_MEM_WTCHPT1_DMAACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_EASACC_LSB		27
#define XAIEGBL_MEM_WTCHPT1_EASACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT1_EASACC_MASK		0x08000000
#define XAIEGBL_MEM_WTCHPT1_EASACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_NORACC_LSB		26
#define XAIEGBL_MEM_WTCHPT1_NORACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT1_NORACC_MASK		0x04000000
#define XAIEGBL_MEM_WTCHPT1_NORACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_WESACC_LSB		25
#define XAIEGBL_MEM_WTCHPT1_WESACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT1_WESACC_MASK		0x02000000
#define XAIEGBL_MEM_WTCHPT1_WESACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_SOUACC_LSB		24
#define XAIEGBL_MEM_WTCHPT1_SOUACC_WIDTH		1
#define XAIEGBL_MEM_WTCHPT1_SOUACC_MASK		0x01000000
#define XAIEGBL_MEM_WTCHPT1_SOUACC_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_WRI_LSB		20
#define XAIEGBL_MEM_WTCHPT1_WRI_WIDTH		4
#define XAIEGBL_MEM_WTCHPT1_WRI_MASK		0x00F00000
#define XAIEGBL_MEM_WTCHPT1_WRI_DEFVAL		0x0
#define XAIEGBL_MEM_WTCHPT1_ADD_LSB		5
#define XAIEGBL_MEM_WTCHPT1_ADD_WIDTH		15
#define XAIEGBL_MEM_WTCHPT1_ADD_MASK		0x000FFFE0
#define XAIEGBL_MEM_WTCHPT1_ADD_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_WTCHPT1(Read_Access,Write_Access,AXI_Access,DMA_Access,East_Access,North_Access,West_Access,South_Access,WriteStrobes,Address)		(((Read_Access&0x00000001)<<31)+((Write_Access&0x00000001)<<30)+((AXI_Access&0x00000001)<<29)+((DMA_Access&0x00000001)<<28)+((East_Access&0x00000001)<<27)+((North_Access&0x00000001)<<26)+((West_Access&0x00000001)<<25)+((South_Access&0x00000001)<<24)+((WriteStrobes&0x0000000f)<<20)+((Address&0x00007fff)<<5))

#define XAIEGBL_MEM_EVTSTA0		0x00014200
#define XAIEGBL_MEM_EVTSTA0WID		32
#define XAIEGBL_MEM_EVTSTA0MSK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTSTA0_EVT310STA_LSB		0
#define XAIEGBL_MEM_EVTSTA0_EVT310STA_WIDTH		32
#define XAIEGBL_MEM_EVTSTA0_EVT310STA_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTSTA0_EVT310STA_DEFVAL		0x2
#define XAIEGBL_MEM_VALUE_EVTSTA0(Event_31_0_Status)		((Event_31_0_Status&0xffffffff))

#define XAIEGBL_MEM_EVTSTA1		0x00014204
#define XAIEGBL_MEM_EVTSTA1WID		32
#define XAIEGBL_MEM_EVTSTA1MSK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTSTA1_EVT6332STA_LSB		0
#define XAIEGBL_MEM_EVTSTA1_EVT6332STA_WIDTH		32
#define XAIEGBL_MEM_EVTSTA1_EVT6332STA_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTSTA1_EVT6332STA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTSTA1(Event_63_32_Status)		((Event_63_32_Status&0xffffffff))

#define XAIEGBL_MEM_EVTSTA2		0x00014208
#define XAIEGBL_MEM_EVTSTA2WID		32
#define XAIEGBL_MEM_EVTSTA2MSK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTSTA2_EVT9564STA_LSB		0
#define XAIEGBL_MEM_EVTSTA2_EVT9564STA_WIDTH		32
#define XAIEGBL_MEM_EVTSTA2_EVT9564STA_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTSTA2_EVT9564STA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTSTA2(Event_95_64_Status)		((Event_95_64_Status&0xffffffff))

#define XAIEGBL_MEM_EVTSTA3		0x0001420C
#define XAIEGBL_MEM_EVTSTA3WID		32
#define XAIEGBL_MEM_EVTSTA3MSK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTSTA3_EVT12796STA_LSB		0
#define XAIEGBL_MEM_EVTSTA3_EVT12796STA_WIDTH		32
#define XAIEGBL_MEM_EVTSTA3_EVT12796STA_MASK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTSTA3_EVT12796STA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_EVTSTA3(Event_127_96_Status)		((Event_127_96_Status&0xffffffff))

#define XAIEGBL_MEM_COMEVTINP		0x00014400
#define XAIEGBL_MEM_COMEVTINPWID		32
#define XAIEGBL_MEM_COMEVTINPMSK		0x7F7F7F7F
#define XAIEGBL_MEM_COMEVTINP_EVTD_LSB		24
#define XAIEGBL_MEM_COMEVTINP_EVTD_WIDTH		7
#define XAIEGBL_MEM_COMEVTINP_EVTD_MASK		0x7F000000
#define XAIEGBL_MEM_COMEVTINP_EVTD_DEFVAL		0x0
#define XAIEGBL_MEM_COMEVTINP_EVTC_LSB		16
#define XAIEGBL_MEM_COMEVTINP_EVTC_WIDTH		7
#define XAIEGBL_MEM_COMEVTINP_EVTC_MASK		0x007F0000
#define XAIEGBL_MEM_COMEVTINP_EVTC_DEFVAL		0x0
#define XAIEGBL_MEM_COMEVTINP_EVTB_LSB		8
#define XAIEGBL_MEM_COMEVTINP_EVTB_WIDTH		7
#define XAIEGBL_MEM_COMEVTINP_EVTB_MASK		0x00007F00
#define XAIEGBL_MEM_COMEVTINP_EVTB_DEFVAL		0x0
#define XAIEGBL_MEM_COMEVTINP_EVTA_LSB		0
#define XAIEGBL_MEM_COMEVTINP_EVTA_WIDTH		7
#define XAIEGBL_MEM_COMEVTINP_EVTA_MASK		0x0000007F
#define XAIEGBL_MEM_COMEVTINP_EVTA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_COMEVTINP(eventD,eventC,eventB,eventA)		(((eventD&0x0000007f)<<24)+((eventC&0x0000007f)<<16)+((eventB&0x0000007f)<<8)+(eventA&0x0000007f))

#define XAIEGBL_MEM_COMEVTCTRL		0x00014404
#define XAIEGBL_MEM_COMEVTCTRLWID		32
#define XAIEGBL_MEM_COMEVTCTRLMSK		0x00030303
#define XAIEGBL_MEM_COMEVTCTRL_COM2_LSB		16
#define XAIEGBL_MEM_COMEVTCTRL_COM2_WIDTH		2
#define XAIEGBL_MEM_COMEVTCTRL_COM2_MASK		0x00030000
#define XAIEGBL_MEM_COMEVTCTRL_COM2_DEFVAL		0x0
#define XAIEGBL_MEM_COMEVTCTRL_COM1_LSB		8
#define XAIEGBL_MEM_COMEVTCTRL_COM1_WIDTH		2
#define XAIEGBL_MEM_COMEVTCTRL_COM1_MASK		0x00000300
#define XAIEGBL_MEM_COMEVTCTRL_COM1_DEFVAL		0x0
#define XAIEGBL_MEM_COMEVTCTRL_COM0_LSB		0
#define XAIEGBL_MEM_COMEVTCTRL_COM0_WIDTH		2
#define XAIEGBL_MEM_COMEVTCTRL_COM0_MASK		0x00000003
#define XAIEGBL_MEM_COMEVTCTRL_COM0_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_COMEVTCTRL(combo2,combo1,combo0)		(((combo2&0x00000003)<<16)+((combo1&0x00000003)<<8)+(combo0&0x00000003))

#define XAIEGBL_MEM_EVTGRP0ENA		0x00014500
#define XAIEGBL_MEM_EVTGRP0ENAWID		32
#define XAIEGBL_MEM_EVTGRP0ENAMSK		0x000000FF
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT3_LSB		7
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT3_WIDTH		1
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT3_MASK		0x00000080
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT3_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT2_LSB		6
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT2_WIDTH		1
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT2_MASK		0x00000040
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT2_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT1_LSB		5
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT1_WIDTH		1
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT1_MASK		0x00000020
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT1_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT0_LSB		4
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT0_WIDTH		1
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT0_MASK		0x00000010
#define XAIEGBL_MEM_EVTGRP0ENA_COMEVT0_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRP0ENA_PERCNT1EVT_LSB		3
#define XAIEGBL_MEM_EVTGRP0ENA_PERCNT1EVT_WIDTH		1
#define XAIEGBL_MEM_EVTGRP0ENA_PERCNT1EVT_MASK		0x00000008
#define XAIEGBL_MEM_EVTGRP0ENA_PERCNT1EVT_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRP0ENA_PERCNT0EVT_LSB		2
#define XAIEGBL_MEM_EVTGRP0ENA_PERCNT0EVT_WIDTH		1
#define XAIEGBL_MEM_EVTGRP0ENA_PERCNT0EVT_MASK		0x00000004
#define XAIEGBL_MEM_EVTGRP0ENA_PERCNT0EVT_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRP0ENA_TIMVALREA_LSB		1
#define XAIEGBL_MEM_EVTGRP0ENA_TIMVALREA_WIDTH		1
#define XAIEGBL_MEM_EVTGRP0ENA_TIMVALREA_MASK		0x00000002
#define XAIEGBL_MEM_EVTGRP0ENA_TIMVALREA_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRP0ENA_TIMSYN_LSB		0
#define XAIEGBL_MEM_EVTGRP0ENA_TIMSYN_WIDTH		1
#define XAIEGBL_MEM_EVTGRP0ENA_TIMSYN_MASK		0x00000001
#define XAIEGBL_MEM_EVTGRP0ENA_TIMSYN_DEFVAL		0x1
#define XAIEGBL_MEM_VALUE_EVTGRP0ENA(Combo_Event_3,Combo_Event_2,Combo_Event_1,Combo_Event_0,Perf_Cnt1_Event,Perf_Cnt0_Event,Timer_Value_Reached,Timer_Sync)		(((Combo_Event_3&0x00000001)<<7)+((Combo_Event_2&0x00000001)<<6)+((Combo_Event_1&0x00000001)<<5)+((Combo_Event_0&0x00000001)<<4)+((Perf_Cnt1_Event&0x00000001)<<3)+((Perf_Cnt0_Event&0x00000001)<<2)+((Timer_Value_Reached&0x00000001)<<1)+(Timer_Sync&0x00000001))

#define XAIEGBL_MEM_EVTGRPWTCHPTENA		0x00014504
#define XAIEGBL_MEM_EVTGRPWTCHPTENAWID		32
#define XAIEGBL_MEM_EVTGRPWTCHPTENAMSK		0x00000003
#define XAIEGBL_MEM_EVTGRPWTCHPTENA_WTCHPT1_LSB		1
#define XAIEGBL_MEM_EVTGRPWTCHPTENA_WTCHPT1_WIDTH		1
#define XAIEGBL_MEM_EVTGRPWTCHPTENA_WTCHPT1_MASK		0x00000002
#define XAIEGBL_MEM_EVTGRPWTCHPTENA_WTCHPT1_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPWTCHPTENA_WTCHPT0_LSB		0
#define XAIEGBL_MEM_EVTGRPWTCHPTENA_WTCHPT0_WIDTH		1
#define XAIEGBL_MEM_EVTGRPWTCHPTENA_WTCHPT0_MASK		0x00000001
#define XAIEGBL_MEM_EVTGRPWTCHPTENA_WTCHPT0_DEFVAL		0x1
#define XAIEGBL_MEM_VALUE_EVTGRPWTCHPTENA(Watchpoint_1,Watchpoint_0)		(((Watchpoint_1&0x00000001)<<1)+(Watchpoint_0&0x00000001))

#define XAIEGBL_MEM_EVTGRPDMAENA		0x00014508
#define XAIEGBL_MEM_EVTGRPDMAENAWID		32
#define XAIEGBL_MEM_EVTGRPDMAENAMSK		0x000FFFFF
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1MEMCON_LSB		19
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1MEMCON_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1MEMCON_MASK		0x00080000
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1MEMCON_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0MEMCON_LSB		18
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0MEMCON_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0MEMCON_MASK		0x00040000
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0MEMCON_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1MEMCON_LSB		17
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1MEMCON_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1MEMCON_MASK		0x00020000
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1MEMCON_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0MEMCON_LSB		16
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0MEMCON_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0MEMCON_MASK		0x00010000
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0MEMCON_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1STALLOCKACQ_LSB		15
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1STALLOCKACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1STALLOCKACQ_MASK		0x00008000
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1STALLOCKACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0STALLOCKACQ_LSB		14
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0STALLOCKACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0STALLOCKACQ_MASK		0x00004000
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0STALLOCKACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1STALLOCKACQ_LSB		13
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1STALLOCKACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1STALLOCKACQ_MASK		0x00002000
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1STALLOCKACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0STALLOCKACQ_LSB		12
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0STALLOCKACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0STALLOCKACQ_MASK		0x00001000
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0STALLOCKACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1GOTOIDL_LSB		11
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1GOTOIDL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1GOTOIDL_MASK		0x00000800
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1GOTOIDL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0GOTOIDL_LSB		10
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0GOTOIDL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0GOTOIDL_MASK		0x00000400
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0GOTOIDL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1GOTOIDL_LSB		9
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1GOTOIDL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1GOTOIDL_MASK		0x00000200
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1GOTOIDL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0GOTOIDL_LSB		8
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0GOTOIDL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0GOTOIDL_MASK		0x00000100
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0GOTOIDL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1FINBD_LSB		7
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1FINBD_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1FINBD_MASK		0x00000080
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1FINBD_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0FINBD_LSB		6
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0FINBD_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0FINBD_MASK		0x00000040
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0FINBD_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1FINBD_LSB		5
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1FINBD_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1FINBD_MASK		0x00000020
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1FINBD_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0FINBD_LSB		4
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0FINBD_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0FINBD_MASK		0x00000010
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0FINBD_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1STABD_LSB		3
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1STABD_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1STABD_MASK		0x00000008
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S1STABD_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0STABD_LSB		2
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0STABD_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0STABD_MASK		0x00000004
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAMM2S0STABD_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1STABD_LSB		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1STABD_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1STABD_MASK		0x00000002
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM1STABD_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0STABD_LSB		0
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0STABD_WIDTH		1
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0STABD_MASK		0x00000001
#define XAIEGBL_MEM_EVTGRPDMAENA_DMAS2MM0STABD_DEFVAL		0x1
#define XAIEGBL_MEM_VALUE_EVTGRPDMAENA(DMA_MM2S_1_memory_conflict,DMA_MM2S_0_memory_conflict,DMA_S2MM_1_memory_conflict,DMA_S2MM_0_memory_conflict,DMA_MM2S_1_stalled_lock_acquire,DMA_MM2S_0_stalled_lock_acquire,DMA_S2MM_1_stalled_lock_acquire,DMA_S2MM_0_stalled_lock_acquire,DMA_MM2S_1_go_to_idle,DMA_MM2S_0_go_to_idle,DMA_S2MM_1_go_to_idle,DMA_S2MM_0_go_to_idle,DMA_MM2S_1_finished_BD,DMA_MM2S_0_finished_BD,DMA_S2MM_1_finished_BD,DMA_S2MM_0_finished_BD,DMA_MM2S_1_start_BD,DMA_MM2S_0_start_BD,DMA_S2MM_1_start_BD,DMA_S2MM_0_start_BD)		(((DMA_MM2S_1_memory_conflict&0x00000001)<<19)+((DMA_MM2S_0_memory_conflict&0x00000001)<<18)+((DMA_S2MM_1_memory_conflict&0x00000001)<<17)+((DMA_S2MM_0_memory_conflict&0x00000001)<<16)+((DMA_MM2S_1_stalled_lock_acquire&0x00000001)<<15)+((DMA_MM2S_0_stalled_lock_acquire&0x00000001)<<14)+((DMA_S2MM_1_stalled_lock_acquire&0x00000001)<<13)+((DMA_S2MM_0_stalled_lock_acquire&0x00000001)<<12)+((DMA_MM2S_1_go_to_idle&0x00000001)<<11)+((DMA_MM2S_0_go_to_idle&0x00000001)<<10)+((DMA_S2MM_1_go_to_idle&0x00000001)<<9)+((DMA_S2MM_0_go_to_idle&0x00000001)<<8)+((DMA_MM2S_1_finished_BD&0x00000001)<<7)+((DMA_MM2S_0_finished_BD&0x00000001)<<6)+((DMA_S2MM_1_finished_BD&0x00000001)<<5)+((DMA_S2MM_0_finished_BD&0x00000001)<<4)+((DMA_MM2S_1_start_BD&0x00000001)<<3)+((DMA_MM2S_0_start_BD&0x00000001)<<2)+((DMA_S2MM_1_start_BD&0x00000001)<<1)+(DMA_S2MM_0_start_BD&0x00000001))

#define XAIEGBL_MEM_EVTGRPLOCKENA		0x0001450C
#define XAIEGBL_MEM_EVTGRPLOCKENAWID		32
#define XAIEGBL_MEM_EVTGRPLOCKENAMSK		0xFFFFFFFF
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK15REL_LSB		31
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK15REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK15REL_MASK		0x80000000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK15REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK15ACQ_LSB		30
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK15ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK15ACQ_MASK		0x40000000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK15ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK14REL_LSB		29
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK14REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK14REL_MASK		0x20000000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK14REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK14ACQ_LSB		28
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK14ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK14ACQ_MASK		0x10000000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK14ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK13REL_LSB		27
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK13REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK13REL_MASK		0x08000000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK13REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK13ACQ_LSB		26
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK13ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK13ACQ_MASK		0x04000000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK13ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK12REL_LSB		25
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK12REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK12REL_MASK		0x02000000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK12REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK12ACQ_LSB		24
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK12ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK12ACQ_MASK		0x01000000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK12ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK11REL_LSB		23
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK11REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK11REL_MASK		0x00800000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK11REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK11ACQ_LSB		22
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK11ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK11ACQ_MASK		0x00400000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK11ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK10REL_LSB		21
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK10REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK10REL_MASK		0x00200000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK10REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK10ACQ_LSB		20
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK10ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK10ACQ_MASK		0x00100000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK10ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK9REL_LSB		19
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK9REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK9REL_MASK		0x00080000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK9REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK9ACQ_LSB		18
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK9ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK9ACQ_MASK		0x00040000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK9ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK8REL_LSB		17
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK8REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK8REL_MASK		0x00020000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK8REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK8ACQ_LSB		16
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK8ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK8ACQ_MASK		0x00010000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK8ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK7REL_LSB		15
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK7REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK7REL_MASK		0x00008000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK7REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK7ACQ_LSB		14
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK7ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK7ACQ_MASK		0x00004000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK7ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK6REL_LSB		13
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK6REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK6REL_MASK		0x00002000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK6REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK6ACQ_LSB		12
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK6ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK6ACQ_MASK		0x00001000
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK6ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK5REL_LSB		11
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK5REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK5REL_MASK		0x00000800
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK5REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK5ACQ_LSB		10
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK5ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK5ACQ_MASK		0x00000400
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK5ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK4REL_LSB		9
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK4REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK4REL_MASK		0x00000200
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK4REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK4ACQ_LSB		8
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK4ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK4ACQ_MASK		0x00000100
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK4ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK3REL_LSB		7
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK3REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK3REL_MASK		0x00000080
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK3REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK3ACQ_LSB		6
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK3ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK3ACQ_MASK		0x00000040
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK3ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK2REL_LSB		5
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK2REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK2REL_MASK		0x00000020
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK2REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK2ACQ_LSB		4
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK2ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK2ACQ_MASK		0x00000010
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK2ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK1REL_LSB		3
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK1REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK1REL_MASK		0x00000008
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK1REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK1ACQ_LSB		2
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK1ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK1ACQ_MASK		0x00000004
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK1ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK0REL_LSB		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK0REL_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK0REL_MASK		0x00000002
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK0REL_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK0ACQ_LSB		0
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK0ACQ_WIDTH		1
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK0ACQ_MASK		0x00000001
#define XAIEGBL_MEM_EVTGRPLOCKENA_LOCK0ACQ_DEFVAL		0x1
#define XAIEGBL_MEM_VALUE_EVTGRPLOCKENA(Lock_15_Release,Lock_15_Acquired,Lock_14_Release,Lock_14_Acquired,Lock_13_Release,Lock_13_Acquired,Lock_12_Release,Lock_12_Acquired,Lock_11_Release,Lock_11_Acquired,Lock_10_Release,Lock_10_Acquired,Lock_9_Release,Lock_9_Acquired,Lock_8_Release,Lock_8_Acquired,Lock_7_Release,Lock_7_Acquired,Lock_6_Release,Lock_6_Acquired,Lock_5_Release,Lock_5_Acquired,Lock_4_Release,Lock_4_Acquired,Lock_3_Release,Lock_3_Acquired,Lock_2_Release,Lock_2_Acquired,Lock_1_Release,Lock_1_Acquired,Lock_0_Release,Lock_0_Acquired)		(((Lock_15_Release&0x00000001)<<31)+((Lock_15_Acquired&0x00000001)<<30)+((Lock_14_Release&0x00000001)<<29)+((Lock_14_Acquired&0x00000001)<<28)+((Lock_13_Release&0x00000001)<<27)+((Lock_13_Acquired&0x00000001)<<26)+((Lock_12_Release&0x00000001)<<25)+((Lock_12_Acquired&0x00000001)<<24)+((Lock_11_Release&0x00000001)<<23)+((Lock_11_Acquired&0x00000001)<<22)+((Lock_10_Release&0x00000001)<<21)+((Lock_10_Acquired&0x00000001)<<20)+((Lock_9_Release&0x00000001)<<19)+((Lock_9_Acquired&0x00000001)<<18)+((Lock_8_Release&0x00000001)<<17)+((Lock_8_Acquired&0x00000001)<<16)+((Lock_7_Release&0x00000001)<<15)+((Lock_7_Acquired&0x00000001)<<14)+((Lock_6_Release&0x00000001)<<13)+((Lock_6_Acquired&0x00000001)<<12)+((Lock_5_Release&0x00000001)<<11)+((Lock_5_Acquired&0x00000001)<<10)+((Lock_4_Release&0x00000001)<<9)+((Lock_4_Acquired&0x00000001)<<8)+((Lock_3_Release&0x00000001)<<7)+((Lock_3_Acquired&0x00000001)<<6)+((Lock_2_Release&0x00000001)<<5)+((Lock_2_Acquired&0x00000001)<<4)+((Lock_1_Release&0x00000001)<<3)+((Lock_1_Acquired&0x00000001)<<2)+((Lock_0_Release&0x00000001)<<1)+(Lock_0_Acquired&0x00000001))

#define XAIEGBL_MEM_EVTGRPMEMCONENA		0x00014510
#define XAIEGBL_MEM_EVTGRPMEMCONENAWID		32
#define XAIEGBL_MEM_EVTGRPMEMCONENAMSK		0x000000FF
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN7_LSB		7
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN7_WIDTH		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN7_MASK		0x00000080
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN7_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN6_LSB		6
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN6_WIDTH		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN6_MASK		0x00000040
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN6_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN5_LSB		5
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN5_WIDTH		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN5_MASK		0x00000020
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN5_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN4_LSB		4
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN4_WIDTH		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN4_MASK		0x00000010
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN4_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN3_LSB		3
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN3_WIDTH		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN3_MASK		0x00000008
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN3_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN2_LSB		2
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN2_WIDTH		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN2_MASK		0x00000004
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN2_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN1_LSB		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN1_WIDTH		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN1_MASK		0x00000002
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN1_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN0_LSB		0
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN0_WIDTH		1
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN0_MASK		0x00000001
#define XAIEGBL_MEM_EVTGRPMEMCONENA_CONDMBAN0_DEFVAL		0x1
#define XAIEGBL_MEM_VALUE_EVTGRPMEMCONENA(Conflict_DM_Bank_7,Conflict_DM_Bank_6,Conflict_DM_Bank_5,Conflict_DM_Bank_4,Conflict_DM_Bank_3,Conflict_DM_Bank_2,Conflict_DM_Bank_1,Conflict_DM_Bank_0)		(((Conflict_DM_Bank_7&0x00000001)<<7)+((Conflict_DM_Bank_6&0x00000001)<<6)+((Conflict_DM_Bank_5&0x00000001)<<5)+((Conflict_DM_Bank_4&0x00000001)<<4)+((Conflict_DM_Bank_3&0x00000001)<<3)+((Conflict_DM_Bank_2&0x00000001)<<2)+((Conflict_DM_Bank_1&0x00000001)<<1)+(Conflict_DM_Bank_0&0x00000001))

#define XAIEGBL_MEM_EVTGRPERRENA		0x00014514
#define XAIEGBL_MEM_EVTGRPERRENAWID		32
#define XAIEGBL_MEM_EVTGRPERRENAMSK		0x00003FFF
#define XAIEGBL_MEM_EVTGRPERRENA_DMAMM2S1ERR_LSB		13
#define XAIEGBL_MEM_EVTGRPERRENA_DMAMM2S1ERR_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMAMM2S1ERR_MASK		0x00002000
#define XAIEGBL_MEM_EVTGRPERRENA_DMAMM2S1ERR_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMAMM2S0ERR_LSB		12
#define XAIEGBL_MEM_EVTGRPERRENA_DMAMM2S0ERR_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMAMM2S0ERR_MASK		0x00001000
#define XAIEGBL_MEM_EVTGRPERRENA_DMAMM2S0ERR_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMAS2MM1ERR_LSB		11
#define XAIEGBL_MEM_EVTGRPERRENA_DMAS2MM1ERR_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMAS2MM1ERR_MASK		0x00000800
#define XAIEGBL_MEM_EVTGRPERRENA_DMAS2MM1ERR_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMAS2MM0ERR_LSB		10
#define XAIEGBL_MEM_EVTGRPERRENA_DMAS2MM0ERR_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMAS2MM0ERR_MASK		0x00000400
#define XAIEGBL_MEM_EVTGRPERRENA_DMAS2MM0ERR_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN7_LSB		9
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN7_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN7_MASK		0x00000200
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN7_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN6_LSB		8
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN6_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN6_MASK		0x00000100
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN6_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN5_LSB		7
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN5_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN5_MASK		0x00000080
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN5_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN4_LSB		6
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN4_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN4_MASK		0x00000040
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN4_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN3_LSB		5
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN3_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN3_MASK		0x00000020
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN3_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN2_LSB		4
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN2_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN2_MASK		0x00000010
#define XAIEGBL_MEM_EVTGRPERRENA_DMPARERRBAN2_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERR2BIT_LSB		3
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERR2BIT_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERR2BIT_MASK		0x00000008
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERR2BIT_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERR1BIT_LSB		2
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERR1BIT_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERR1BIT_MASK		0x00000004
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERR1BIT_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERRSCR2BIT_LSB		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERRSCR2BIT_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERRSCR2BIT_MASK		0x00000002
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERRSCR2BIT_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERRSCRCOR_LSB		0
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERRSCRCOR_WIDTH		1
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERRSCRCOR_MASK		0x00000001
#define XAIEGBL_MEM_EVTGRPERRENA_DMECCERRSCRCOR_DEFVAL		0x1
#define XAIEGBL_MEM_VALUE_EVTGRPERRENA(DMA_MM2S_1_Error,DMA_MM2S_0_Error,DMA_S2MM_1_Error,DMA_S2MM_0_Error,DM_Parity_Error_Bank_7,DM_Parity_Error_Bank_6,DM_Parity_Error_Bank_5,DM_Parity_Error_Bank_4,DM_Parity_Error_Bank_3,DM_Parity_Error_Bank_2,DM_ECC_Error_2bit,DM_ECC_Error_1bit,DM_ECC_Error_Scrub_2bit,DM_ECC_Error_Scrub_Corrected)		(((DMA_MM2S_1_Error&0x00000001)<<13)+((DMA_MM2S_0_Error&0x00000001)<<12)+((DMA_S2MM_1_Error&0x00000001)<<11)+((DMA_S2MM_0_Error&0x00000001)<<10)+((DM_Parity_Error_Bank_7&0x00000001)<<9)+((DM_Parity_Error_Bank_6&0x00000001)<<8)+((DM_Parity_Error_Bank_5&0x00000001)<<7)+((DM_Parity_Error_Bank_4&0x00000001)<<6)+((DM_Parity_Error_Bank_3&0x00000001)<<5)+((DM_Parity_Error_Bank_2&0x00000001)<<4)+((DM_ECC_Error_2bit&0x00000001)<<3)+((DM_ECC_Error_1bit&0x00000001)<<2)+((DM_ECC_Error_Scrub_2bit&0x00000001)<<1)+(DM_ECC_Error_Scrub_Corrected&0x00000001))

#define XAIEGBL_MEM_EVTGRPBRDCASTENA		0x00014518
#define XAIEGBL_MEM_EVTGRPBRDCASTENAWID		32
#define XAIEGBL_MEM_EVTGRPBRDCASTENAMSK		0x0000FFFF
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST15_LSB		15
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST15_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST15_MASK		0x00008000
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST15_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST14_LSB		14
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST14_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST14_MASK		0x00004000
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST14_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST13_LSB		13
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST13_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST13_MASK		0x00002000
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST13_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST12_LSB		12
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST12_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST12_MASK		0x00001000
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST12_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST11_LSB		11
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST11_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST11_MASK		0x00000800
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST11_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST10_LSB		10
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST10_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST10_MASK		0x00000400
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST10_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST9_LSB		9
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST9_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST9_MASK		0x00000200
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST9_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST8_LSB		8
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST8_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST8_MASK		0x00000100
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST8_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST7_LSB		7
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST7_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST7_MASK		0x00000080
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST7_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST6_LSB		6
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST6_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST6_MASK		0x00000040
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST6_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST5_LSB		5
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST5_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST5_MASK		0x00000020
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST5_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST4_LSB		4
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST4_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST4_MASK		0x00000010
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST4_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST3_LSB		3
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST3_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST3_MASK		0x00000008
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST3_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST2_LSB		2
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST2_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST2_MASK		0x00000004
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST2_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST1_LSB		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST1_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST1_MASK		0x00000002
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST1_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST0_LSB		0
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST0_WIDTH		1
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST0_MASK		0x00000001
#define XAIEGBL_MEM_EVTGRPBRDCASTENA_BRDCAST0_DEFVAL		0x1
#define XAIEGBL_MEM_VALUE_EVTGRPBRDCASTENA(Broadcast_15,Broadcast_14,Broadcast_13,Broadcast_12,Broadcast_11,Broadcast_10,Broadcast_9,Broadcast_8,Broadcast_7,Broadcast_6,Broadcast_5,Broadcast_4,Broadcast_3,Broadcast_2,Broadcast_1,Broadcast_0)		(((Broadcast_15&0x00000001)<<15)+((Broadcast_14&0x00000001)<<14)+((Broadcast_13&0x00000001)<<13)+((Broadcast_12&0x00000001)<<12)+((Broadcast_11&0x00000001)<<11)+((Broadcast_10&0x00000001)<<10)+((Broadcast_9&0x00000001)<<9)+((Broadcast_8&0x00000001)<<8)+((Broadcast_7&0x00000001)<<7)+((Broadcast_6&0x00000001)<<6)+((Broadcast_5&0x00000001)<<5)+((Broadcast_4&0x00000001)<<4)+((Broadcast_3&0x00000001)<<3)+((Broadcast_2&0x00000001)<<2)+((Broadcast_1&0x00000001)<<1)+(Broadcast_0&0x00000001))

#define XAIEGBL_MEM_EVTGRPUSREVTENA		0x0001451C
#define XAIEGBL_MEM_EVTGRPUSREVTENAWID		32
#define XAIEGBL_MEM_EVTGRPUSREVTENAMSK		0x0000000F
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT3_LSB		3
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT3_WIDTH		1
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT3_MASK		0x00000008
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT3_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT2_LSB		2
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT2_WIDTH		1
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT2_MASK		0x00000004
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT2_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT1_LSB		1
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT1_WIDTH		1
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT1_MASK		0x00000002
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT1_DEFVAL		0x1
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT0_LSB		0
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT0_WIDTH		1
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT0_MASK		0x00000001
#define XAIEGBL_MEM_EVTGRPUSREVTENA_USREVT0_DEFVAL		0x1
#define XAIEGBL_MEM_VALUE_EVTGRPUSREVTENA(User_Event_3,User_Event_2,User_Event_1,User_Event_0)		(((User_Event_3&0x00000001)<<3)+((User_Event_2&0x00000001)<<2)+((User_Event_1&0x00000001)<<1)+(User_Event_0&0x00000001))

#define XAIEGBL_MEM_DMABD0ADDA		0x0001D000
#define XAIEGBL_MEM_DMABD0ADDAWID		32
#define XAIEGBL_MEM_DMABD0ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD0ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD0ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD0ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD0ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD0ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD0ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD0ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD0ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD0ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD0ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD0ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD0ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD0ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD0ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD0ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD0ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD0ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD0ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD0ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD0ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD0ADDB		0x0001D004
#define XAIEGBL_MEM_DMABD0ADDBWID		32
#define XAIEGBL_MEM_DMABD0ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD0ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD0ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD0ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD0ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD0ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD0ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD0ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD0ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD0ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD0ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD0ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD0ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD0ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD0ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD0ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD0ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD0ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD0ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD0ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD0ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD0ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD02DX		0x0001D008
#define XAIEGBL_MEM_DMABD02DXWID		32
#define XAIEGBL_MEM_DMABD02DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD02DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD02DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD02DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD02DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD02DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD02DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD02DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD02DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD02DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD02DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD02DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD02DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD02DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD02DY		0x0001D00C
#define XAIEGBL_MEM_DMABD02DYWID		32
#define XAIEGBL_MEM_DMABD02DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD02DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD02DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD02DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD02DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD02DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD02DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD02DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD02DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD02DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD02DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD02DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD02DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD02DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD0PKT		0x0001D010
#define XAIEGBL_MEM_DMABD0PKTWID		32
#define XAIEGBL_MEM_DMABD0PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD0PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD0PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD0PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD0PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD0PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD0PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD0PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD0PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD0INTSTA		0x0001D014
#define XAIEGBL_MEM_DMABD0INTSTAWID		32
#define XAIEGBL_MEM_DMABD0INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD0INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD0INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD0INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD0INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD0INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD0INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD0INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD0INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD0CTRL		0x0001D018
#define XAIEGBL_MEM_DMABD0CTRLWID		32
#define XAIEGBL_MEM_DMABD0CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD0CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD0CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD0CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD0CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD0CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD0CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD0CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD0CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD0CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD0CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD0CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD0CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD0CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD0CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD0CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD0CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD0CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD0CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD0CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD0CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD0CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD0CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD0CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD0CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD0CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD0CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD0CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD0CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD0CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD0CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD1ADDA		0x0001D020
#define XAIEGBL_MEM_DMABD1ADDAWID		32
#define XAIEGBL_MEM_DMABD1ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD1ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD1ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD1ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD1ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD1ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD1ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD1ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD1ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD1ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD1ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD1ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD1ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD1ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD1ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD1ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD1ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD1ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD1ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD1ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD1ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD1ADDB		0x0001D024
#define XAIEGBL_MEM_DMABD1ADDBWID		32
#define XAIEGBL_MEM_DMABD1ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD1ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD1ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD1ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD1ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD1ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD1ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD1ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD1ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD1ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD1ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD1ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD1ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD1ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD1ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD1ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD1ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD1ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD1ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD1ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD1ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD1ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD12DX		0x0001D028
#define XAIEGBL_MEM_DMABD12DXWID		32
#define XAIEGBL_MEM_DMABD12DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD12DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD12DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD12DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD12DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD12DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD12DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD12DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD12DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD12DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD12DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD12DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD12DY		0x0001D02C
#define XAIEGBL_MEM_DMABD12DYWID		32
#define XAIEGBL_MEM_DMABD12DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD12DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD12DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD12DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD12DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD12DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD12DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD12DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD12DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD12DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD12DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD12DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD1PKT		0x0001D030
#define XAIEGBL_MEM_DMABD1PKTWID		32
#define XAIEGBL_MEM_DMABD1PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD1PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD1PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD1PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD1PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD1PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD1PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD1PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD1PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD1INTSTA		0x0001D034
#define XAIEGBL_MEM_DMABD1INTSTAWID		32
#define XAIEGBL_MEM_DMABD1INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD1INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD1INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD1INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD1INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD1INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD1INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD1INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD1INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD1CTRL		0x0001D038
#define XAIEGBL_MEM_DMABD1CTRLWID		32
#define XAIEGBL_MEM_DMABD1CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD1CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD1CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD1CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD1CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD1CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD1CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD1CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD1CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD1CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD1CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD1CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD1CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD1CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD1CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD1CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD1CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD1CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD1CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD1CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD1CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD1CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD1CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD1CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD1CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD1CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD1CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD1CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD1CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD1CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD1CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD2ADDA		0x0001D040
#define XAIEGBL_MEM_DMABD2ADDAWID		32
#define XAIEGBL_MEM_DMABD2ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD2ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD2ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD2ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD2ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD2ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD2ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD2ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD2ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD2ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD2ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD2ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD2ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD2ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD2ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD2ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD2ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD2ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD2ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD2ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD2ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD2ADDB		0x0001D044
#define XAIEGBL_MEM_DMABD2ADDBWID		32
#define XAIEGBL_MEM_DMABD2ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD2ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD2ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD2ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD2ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD2ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD2ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD2ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD2ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD2ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD2ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD2ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD2ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD2ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD2ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD2ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD2ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD2ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD2ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD2ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD2ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD2ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD22DX		0x0001D048
#define XAIEGBL_MEM_DMABD22DXWID		32
#define XAIEGBL_MEM_DMABD22DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD22DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD22DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD22DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD22DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD22DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD22DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD22DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD22DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD22DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD22DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD22DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD22DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD22DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD22DY		0x0001D04C
#define XAIEGBL_MEM_DMABD22DYWID		32
#define XAIEGBL_MEM_DMABD22DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD22DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD22DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD22DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD22DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD22DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD22DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD22DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD22DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD22DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD22DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD22DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD22DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD22DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD2PKT		0x0001D050
#define XAIEGBL_MEM_DMABD2PKTWID		32
#define XAIEGBL_MEM_DMABD2PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD2PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD2PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD2PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD2PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD2PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD2PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD2PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD2PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD2INTSTA		0x0001D054
#define XAIEGBL_MEM_DMABD2INTSTAWID		32
#define XAIEGBL_MEM_DMABD2INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD2INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD2INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD2INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD2INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD2INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD2INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD2INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD2INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD2CTRL		0x0001D058
#define XAIEGBL_MEM_DMABD2CTRLWID		32
#define XAIEGBL_MEM_DMABD2CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD2CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD2CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD2CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD2CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD2CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD2CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD2CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD2CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD2CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD2CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD2CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD2CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD2CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD2CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD2CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD2CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD2CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD2CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD2CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD2CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD2CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD2CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD2CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD2CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD2CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD2CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD2CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD2CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD2CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD2CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD3ADDA		0x0001D060
#define XAIEGBL_MEM_DMABD3ADDAWID		32
#define XAIEGBL_MEM_DMABD3ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD3ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD3ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD3ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD3ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD3ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD3ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD3ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD3ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD3ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD3ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD3ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD3ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD3ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD3ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD3ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD3ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD3ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD3ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD3ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD3ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD3ADDB		0x0001D064
#define XAIEGBL_MEM_DMABD3ADDBWID		32
#define XAIEGBL_MEM_DMABD3ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD3ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD3ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD3ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD3ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD3ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD3ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD3ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD3ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD3ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD3ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD3ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD3ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD3ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD3ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD3ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD3ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD3ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD3ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD3ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD3ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD3ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD32DX		0x0001D068
#define XAIEGBL_MEM_DMABD32DXWID		32
#define XAIEGBL_MEM_DMABD32DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD32DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD32DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD32DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD32DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD32DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD32DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD32DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD32DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD32DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD32DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD32DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD32DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD32DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD32DY		0x0001D06C
#define XAIEGBL_MEM_DMABD32DYWID		32
#define XAIEGBL_MEM_DMABD32DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD32DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD32DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD32DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD32DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD32DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD32DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD32DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD32DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD32DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD32DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD32DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD32DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD32DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD3PKT		0x0001D070
#define XAIEGBL_MEM_DMABD3PKTWID		32
#define XAIEGBL_MEM_DMABD3PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD3PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD3PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD3PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD3PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD3PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD3PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD3PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD3PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD3INTSTA		0x0001D074
#define XAIEGBL_MEM_DMABD3INTSTAWID		32
#define XAIEGBL_MEM_DMABD3INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD3INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD3INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD3INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD3INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD3INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD3INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD3INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD3INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD3CTRL		0x0001D078
#define XAIEGBL_MEM_DMABD3CTRLWID		32
#define XAIEGBL_MEM_DMABD3CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD3CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD3CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD3CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD3CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD3CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD3CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD3CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD3CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD3CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD3CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD3CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD3CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD3CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD3CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD3CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD3CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD3CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD3CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD3CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD3CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD3CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD3CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD3CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD3CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD3CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD3CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD3CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD3CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD3CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD3CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD4ADDA		0x0001D080
#define XAIEGBL_MEM_DMABD4ADDAWID		32
#define XAIEGBL_MEM_DMABD4ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD4ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD4ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD4ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD4ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD4ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD4ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD4ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD4ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD4ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD4ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD4ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD4ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD4ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD4ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD4ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD4ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD4ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD4ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD4ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD4ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD4ADDB		0x0001D084
#define XAIEGBL_MEM_DMABD4ADDBWID		32
#define XAIEGBL_MEM_DMABD4ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD4ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD4ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD4ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD4ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD4ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD4ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD4ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD4ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD4ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD4ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD4ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD4ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD4ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD4ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD4ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD4ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD4ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD4ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD4ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD4ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD4ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD42DX		0x0001D088
#define XAIEGBL_MEM_DMABD42DXWID		32
#define XAIEGBL_MEM_DMABD42DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD42DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD42DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD42DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD42DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD42DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD42DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD42DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD42DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD42DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD42DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD42DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD42DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD42DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD42DY		0x0001D08C
#define XAIEGBL_MEM_DMABD42DYWID		32
#define XAIEGBL_MEM_DMABD42DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD42DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD42DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD42DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD42DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD42DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD42DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD42DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD42DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD42DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD42DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD42DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD42DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD42DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD4PKT		0x0001D090
#define XAIEGBL_MEM_DMABD4PKTWID		32
#define XAIEGBL_MEM_DMABD4PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD4PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD4PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD4PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD4PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD4PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD4PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD4PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD4PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD4INTSTA		0x0001D094
#define XAIEGBL_MEM_DMABD4INTSTAWID		32
#define XAIEGBL_MEM_DMABD4INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD4INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD4INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD4INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD4INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD4INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD4INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD4INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD4INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD4CTRL		0x0001D098
#define XAIEGBL_MEM_DMABD4CTRLWID		32
#define XAIEGBL_MEM_DMABD4CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD4CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD4CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD4CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD4CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD4CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD4CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD4CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD4CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD4CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD4CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD4CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD4CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD4CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD4CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD4CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD4CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD4CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD4CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD4CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD4CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD4CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD4CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD4CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD4CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD4CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD4CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD4CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD4CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD4CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD4CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD5ADDA		0x0001D0A0
#define XAIEGBL_MEM_DMABD5ADDAWID		32
#define XAIEGBL_MEM_DMABD5ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD5ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD5ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD5ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD5ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD5ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD5ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD5ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD5ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD5ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD5ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD5ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD5ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD5ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD5ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD5ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD5ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD5ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD5ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD5ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD5ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD5ADDB		0x0001D0A4
#define XAIEGBL_MEM_DMABD5ADDBWID		32
#define XAIEGBL_MEM_DMABD5ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD5ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD5ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD5ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD5ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD5ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD5ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD5ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD5ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD5ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD5ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD5ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD5ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD5ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD5ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD5ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD5ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD5ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD5ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD5ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD5ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD5ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD52DX		0x0001D0A8
#define XAIEGBL_MEM_DMABD52DXWID		32
#define XAIEGBL_MEM_DMABD52DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD52DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD52DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD52DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD52DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD52DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD52DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD52DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD52DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD52DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD52DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD52DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD52DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD52DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD52DY		0x0001D0AC
#define XAIEGBL_MEM_DMABD52DYWID		32
#define XAIEGBL_MEM_DMABD52DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD52DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD52DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD52DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD52DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD52DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD52DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD52DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD52DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD52DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD52DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD52DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD52DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD52DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD5PKT		0x0001D0B0
#define XAIEGBL_MEM_DMABD5PKTWID		32
#define XAIEGBL_MEM_DMABD5PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD5PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD5PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD5PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD5PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD5PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD5PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD5PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD5PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD5INTSTA		0x0001D0B4
#define XAIEGBL_MEM_DMABD5INTSTAWID		32
#define XAIEGBL_MEM_DMABD5INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD5INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD5INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD5INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD5INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD5INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD5INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD5INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD5INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD5CTRL		0x0001D0B8
#define XAIEGBL_MEM_DMABD5CTRLWID		32
#define XAIEGBL_MEM_DMABD5CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD5CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD5CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD5CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD5CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD5CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD5CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD5CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD5CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD5CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD5CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD5CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD5CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD5CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD5CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD5CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD5CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD5CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD5CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD5CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD5CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD5CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD5CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD5CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD5CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD5CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD5CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD5CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD5CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD5CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD5CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD6ADDA		0x0001D0C0
#define XAIEGBL_MEM_DMABD6ADDAWID		32
#define XAIEGBL_MEM_DMABD6ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD6ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD6ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD6ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD6ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD6ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD6ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD6ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD6ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD6ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD6ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD6ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD6ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD6ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD6ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD6ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD6ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD6ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD6ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD6ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD6ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD6ADDB		0x0001D0C4
#define XAIEGBL_MEM_DMABD6ADDBWID		32
#define XAIEGBL_MEM_DMABD6ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD6ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD6ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD6ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD6ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD6ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD6ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD6ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD6ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD6ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD6ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD6ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD6ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD6ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD6ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD6ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD6ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD6ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD6ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD6ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD6ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD6ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD62DX		0x0001D0C8
#define XAIEGBL_MEM_DMABD62DXWID		32
#define XAIEGBL_MEM_DMABD62DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD62DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD62DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD62DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD62DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD62DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD62DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD62DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD62DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD62DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD62DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD62DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD62DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD62DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD62DY		0x0001D0CC
#define XAIEGBL_MEM_DMABD62DYWID		32
#define XAIEGBL_MEM_DMABD62DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD62DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD62DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD62DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD62DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD62DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD62DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD62DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD62DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD62DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD62DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD62DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD62DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD62DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD6PKT		0x0001D0D0
#define XAIEGBL_MEM_DMABD6PKTWID		32
#define XAIEGBL_MEM_DMABD6PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD6PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD6PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD6PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD6PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD6PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD6PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD6PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD6PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD6INTSTA		0x0001D0D4
#define XAIEGBL_MEM_DMABD6INTSTAWID		32
#define XAIEGBL_MEM_DMABD6INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD6INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD6INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD6INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD6INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD6INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD6INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD6INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD6INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD6CTRL		0x0001D0D8
#define XAIEGBL_MEM_DMABD6CTRLWID		32
#define XAIEGBL_MEM_DMABD6CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD6CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD6CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD6CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD6CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD6CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD6CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD6CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD6CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD6CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD6CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD6CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD6CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD6CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD6CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD6CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD6CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD6CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD6CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD6CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD6CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD6CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD6CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD6CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD6CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD6CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD6CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD6CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD6CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD6CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD6CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD7ADDA		0x0001D0E0
#define XAIEGBL_MEM_DMABD7ADDAWID		32
#define XAIEGBL_MEM_DMABD7ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD7ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD7ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD7ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD7ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD7ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD7ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD7ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD7ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD7ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD7ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD7ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD7ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD7ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD7ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD7ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD7ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD7ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD7ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD7ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD7ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD7ADDB		0x0001D0E4
#define XAIEGBL_MEM_DMABD7ADDBWID		32
#define XAIEGBL_MEM_DMABD7ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD7ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD7ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD7ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD7ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD7ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD7ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD7ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD7ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD7ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD7ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD7ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD7ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD7ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD7ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD7ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD7ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD7ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD7ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD7ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD7ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD7ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD72DX		0x0001D0E8
#define XAIEGBL_MEM_DMABD72DXWID		32
#define XAIEGBL_MEM_DMABD72DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD72DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD72DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD72DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD72DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD72DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD72DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD72DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD72DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD72DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD72DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD72DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD72DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD72DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD72DY		0x0001D0EC
#define XAIEGBL_MEM_DMABD72DYWID		32
#define XAIEGBL_MEM_DMABD72DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD72DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD72DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD72DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD72DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD72DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD72DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD72DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD72DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD72DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD72DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD72DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD72DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD72DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD7PKT		0x0001D0F0
#define XAIEGBL_MEM_DMABD7PKTWID		32
#define XAIEGBL_MEM_DMABD7PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD7PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD7PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD7PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD7PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD7PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD7PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD7PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD7PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD7INTSTA		0x0001D0F4
#define XAIEGBL_MEM_DMABD7INTSTAWID		32
#define XAIEGBL_MEM_DMABD7INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD7INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD7INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD7INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD7INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD7INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD7INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD7INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD7INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD7CTRL		0x0001D0F8
#define XAIEGBL_MEM_DMABD7CTRLWID		32
#define XAIEGBL_MEM_DMABD7CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD7CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD7CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD7CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD7CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD7CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD7CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD7CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD7CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD7CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD7CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD7CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD7CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD7CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD7CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD7CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD7CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD7CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD7CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD7CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD7CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD7CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD7CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD7CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD7CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD7CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD7CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD7CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD7CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD7CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD7CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD8ADDA		0x0001D100
#define XAIEGBL_MEM_DMABD8ADDAWID		32
#define XAIEGBL_MEM_DMABD8ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD8ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD8ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD8ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD8ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD8ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD8ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD8ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD8ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD8ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD8ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD8ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD8ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD8ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD8ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD8ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD8ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD8ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD8ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD8ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD8ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD8ADDB		0x0001D104
#define XAIEGBL_MEM_DMABD8ADDBWID		32
#define XAIEGBL_MEM_DMABD8ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD8ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD8ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD8ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD8ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD8ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD8ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD8ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD8ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD8ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD8ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD8ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD8ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD8ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD8ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD8ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD8ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD8ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD8ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD8ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD8ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD8ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD82DX		0x0001D108
#define XAIEGBL_MEM_DMABD82DXWID		32
#define XAIEGBL_MEM_DMABD82DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD82DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD82DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD82DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD82DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD82DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD82DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD82DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD82DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD82DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD82DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD82DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD82DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD82DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD82DY		0x0001D10C
#define XAIEGBL_MEM_DMABD82DYWID		32
#define XAIEGBL_MEM_DMABD82DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD82DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD82DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD82DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD82DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD82DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD82DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD82DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD82DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD82DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD82DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD82DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD82DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD82DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD8PKT		0x0001D110
#define XAIEGBL_MEM_DMABD8PKTWID		32
#define XAIEGBL_MEM_DMABD8PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD8PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD8PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD8PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD8PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD8PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD8PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD8PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD8PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD8INTSTA		0x0001D114
#define XAIEGBL_MEM_DMABD8INTSTAWID		32
#define XAIEGBL_MEM_DMABD8INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD8INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD8INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD8INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD8INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD8INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD8INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD8INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD8INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD8CTRL		0x0001D118
#define XAIEGBL_MEM_DMABD8CTRLWID		32
#define XAIEGBL_MEM_DMABD8CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD8CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD8CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD8CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD8CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD8CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD8CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD8CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD8CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD8CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD8CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD8CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD8CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD8CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD8CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD8CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD8CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD8CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD8CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD8CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD8CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD8CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD8CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD8CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD8CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD8CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD8CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD8CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD8CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD8CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD8CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD9ADDA		0x0001D120
#define XAIEGBL_MEM_DMABD9ADDAWID		32
#define XAIEGBL_MEM_DMABD9ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD9ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD9ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD9ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD9ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD9ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD9ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD9ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD9ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD9ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD9ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD9ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD9ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD9ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD9ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD9ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD9ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD9ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD9ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD9ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD9ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD9ADDB		0x0001D124
#define XAIEGBL_MEM_DMABD9ADDBWID		32
#define XAIEGBL_MEM_DMABD9ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD9ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD9ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD9ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD9ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD9ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD9ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD9ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD9ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD9ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD9ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD9ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD9ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD9ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD9ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD9ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD9ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD9ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD9ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD9ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD9ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD9ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD92DX		0x0001D128
#define XAIEGBL_MEM_DMABD92DXWID		32
#define XAIEGBL_MEM_DMABD92DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD92DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD92DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD92DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD92DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD92DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD92DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD92DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD92DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD92DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD92DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD92DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD92DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD92DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD92DY		0x0001D12C
#define XAIEGBL_MEM_DMABD92DYWID		32
#define XAIEGBL_MEM_DMABD92DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD92DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD92DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD92DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD92DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD92DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD92DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD92DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD92DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD92DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD92DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD92DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD92DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD92DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD9PKT		0x0001D130
#define XAIEGBL_MEM_DMABD9PKTWID		32
#define XAIEGBL_MEM_DMABD9PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD9PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD9PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD9PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD9PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD9PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD9PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD9PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD9PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD9INTSTA		0x0001D134
#define XAIEGBL_MEM_DMABD9INTSTAWID		32
#define XAIEGBL_MEM_DMABD9INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD9INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD9INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD9INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD9INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD9INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD9INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD9INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD9INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD9CTRL		0x0001D138
#define XAIEGBL_MEM_DMABD9CTRLWID		32
#define XAIEGBL_MEM_DMABD9CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD9CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD9CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD9CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD9CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD9CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD9CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD9CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD9CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD9CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD9CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD9CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD9CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD9CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD9CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD9CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD9CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD9CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD9CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD9CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD9CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD9CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD9CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD9CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD9CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD9CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD9CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD9CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD9CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD9CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD9CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD10ADDA		0x0001D140
#define XAIEGBL_MEM_DMABD10ADDAWID		32
#define XAIEGBL_MEM_DMABD10ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD10ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD10ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD10ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD10ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD10ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD10ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD10ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD10ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD10ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD10ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD10ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD10ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD10ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD10ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD10ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD10ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD10ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD10ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD10ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD10ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD10ADDB		0x0001D144
#define XAIEGBL_MEM_DMABD10ADDBWID		32
#define XAIEGBL_MEM_DMABD10ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD10ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD10ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD10ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD10ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD10ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD10ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD10ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD10ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD10ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD10ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD10ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD10ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD10ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD10ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD10ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD10ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD10ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD10ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD10ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD10ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD10ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD102DX		0x0001D148
#define XAIEGBL_MEM_DMABD102DXWID		32
#define XAIEGBL_MEM_DMABD102DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD102DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD102DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD102DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD102DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD102DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD102DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD102DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD102DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD102DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD102DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD102DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD102DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD102DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD102DY		0x0001D14C
#define XAIEGBL_MEM_DMABD102DYWID		32
#define XAIEGBL_MEM_DMABD102DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD102DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD102DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD102DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD102DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD102DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD102DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD102DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD102DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD102DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD102DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD102DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD102DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD102DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD10PKT		0x0001D150
#define XAIEGBL_MEM_DMABD10PKTWID		32
#define XAIEGBL_MEM_DMABD10PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD10PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD10PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD10PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD10PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD10PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD10PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD10PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD10PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD10INTSTA		0x0001D154
#define XAIEGBL_MEM_DMABD10INTSTAWID		32
#define XAIEGBL_MEM_DMABD10INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD10INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD10INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD10INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD10INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD10INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD10INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD10INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD10INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD10CTRL		0x0001D158
#define XAIEGBL_MEM_DMABD10CTRLWID		32
#define XAIEGBL_MEM_DMABD10CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD10CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD10CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD10CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD10CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD10CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD10CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD10CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD10CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD10CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD10CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD10CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD10CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD10CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD10CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD10CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD10CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD10CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD10CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD10CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD10CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD10CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD10CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD10CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD10CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD10CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD10CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD10CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD10CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD10CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD10CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD11ADDA		0x0001D160
#define XAIEGBL_MEM_DMABD11ADDAWID		32
#define XAIEGBL_MEM_DMABD11ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD11ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD11ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD11ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD11ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD11ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD11ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD11ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD11ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD11ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD11ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD11ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD11ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD11ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD11ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD11ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD11ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD11ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD11ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD11ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD11ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD11ADDB		0x0001D164
#define XAIEGBL_MEM_DMABD11ADDBWID		32
#define XAIEGBL_MEM_DMABD11ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD11ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD11ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD11ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD11ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD11ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD11ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD11ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD11ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD11ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD11ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD11ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD11ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD11ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD11ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD11ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD11ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD11ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD11ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD11ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD11ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD11ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD112DX		0x0001D168
#define XAIEGBL_MEM_DMABD112DXWID		32
#define XAIEGBL_MEM_DMABD112DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD112DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD112DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD112DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD112DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD112DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD112DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD112DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD112DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD112DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD112DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD112DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD112DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD112DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD112DY		0x0001D16C
#define XAIEGBL_MEM_DMABD112DYWID		32
#define XAIEGBL_MEM_DMABD112DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD112DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD112DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD112DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD112DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD112DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD112DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD112DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD112DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD112DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD112DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD112DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD112DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD112DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD11PKT		0x0001D170
#define XAIEGBL_MEM_DMABD11PKTWID		32
#define XAIEGBL_MEM_DMABD11PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD11PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD11PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD11PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD11PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD11PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD11PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD11PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD11PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD11INTSTA		0x0001D174
#define XAIEGBL_MEM_DMABD11INTSTAWID		32
#define XAIEGBL_MEM_DMABD11INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD11INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD11INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD11INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD11INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD11INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD11INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD11INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD11INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD11CTRL		0x0001D178
#define XAIEGBL_MEM_DMABD11CTRLWID		32
#define XAIEGBL_MEM_DMABD11CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD11CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD11CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD11CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD11CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD11CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD11CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD11CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD11CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD11CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD11CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD11CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD11CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD11CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD11CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD11CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD11CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD11CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD11CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD11CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD11CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD11CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD11CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD11CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD11CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD11CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD11CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD11CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD11CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD11CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD11CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD12ADDA		0x0001D180
#define XAIEGBL_MEM_DMABD12ADDAWID		32
#define XAIEGBL_MEM_DMABD12ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD12ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD12ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD12ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD12ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD12ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD12ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD12ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD12ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD12ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD12ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD12ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD12ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD12ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD12ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD12ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD12ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD12ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD12ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD12ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD12ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD12ADDB		0x0001D184
#define XAIEGBL_MEM_DMABD12ADDBWID		32
#define XAIEGBL_MEM_DMABD12ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD12ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD12ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD12ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD12ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD12ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD12ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD12ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD12ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD12ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD12ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD12ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD12ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD12ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD12ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD12ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD12ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD12ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD12ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD12ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD12ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD12ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD122DX		0x0001D188
#define XAIEGBL_MEM_DMABD122DXWID		32
#define XAIEGBL_MEM_DMABD122DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD122DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD122DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD122DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD122DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD122DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD122DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD122DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD122DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD122DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD122DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD122DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD122DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD122DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD122DY		0x0001D18C
#define XAIEGBL_MEM_DMABD122DYWID		32
#define XAIEGBL_MEM_DMABD122DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD122DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD122DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD122DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD122DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD122DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD122DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD122DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD122DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD122DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD122DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD122DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD122DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD122DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD12PKT		0x0001D190
#define XAIEGBL_MEM_DMABD12PKTWID		32
#define XAIEGBL_MEM_DMABD12PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD12PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD12PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD12PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD12PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD12PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD12PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD12PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD12PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD12INTSTA		0x0001D194
#define XAIEGBL_MEM_DMABD12INTSTAWID		32
#define XAIEGBL_MEM_DMABD12INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD12INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD12INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD12INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD12INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD12INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD12INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD12INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD12INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD12CTRL		0x0001D198
#define XAIEGBL_MEM_DMABD12CTRLWID		32
#define XAIEGBL_MEM_DMABD12CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD12CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD12CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD12CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD12CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD12CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD12CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD12CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD12CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD12CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD12CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD12CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD12CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD12CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD12CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD12CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD12CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD12CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD12CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD12CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD12CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD12CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD12CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD12CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD12CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD12CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD12CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD12CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD12CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD12CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD12CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD13ADDA		0x0001D1A0
#define XAIEGBL_MEM_DMABD13ADDAWID		32
#define XAIEGBL_MEM_DMABD13ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD13ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD13ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD13ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD13ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD13ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD13ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD13ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD13ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD13ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD13ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD13ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD13ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD13ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD13ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD13ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD13ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD13ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD13ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD13ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD13ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD13ADDB		0x0001D1A4
#define XAIEGBL_MEM_DMABD13ADDBWID		32
#define XAIEGBL_MEM_DMABD13ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD13ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD13ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD13ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD13ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD13ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD13ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD13ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD13ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD13ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD13ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD13ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD13ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD13ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD13ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD13ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD13ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD13ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD13ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD13ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD13ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD13ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD132DX		0x0001D1A8
#define XAIEGBL_MEM_DMABD132DXWID		32
#define XAIEGBL_MEM_DMABD132DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD132DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD132DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD132DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD132DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD132DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD132DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD132DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD132DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD132DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD132DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD132DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD132DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD132DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD132DY		0x0001D1AC
#define XAIEGBL_MEM_DMABD132DYWID		32
#define XAIEGBL_MEM_DMABD132DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD132DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD132DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD132DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD132DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD132DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD132DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD132DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD132DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD132DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD132DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD132DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD132DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD132DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD13PKT		0x0001D1B0
#define XAIEGBL_MEM_DMABD13PKTWID		32
#define XAIEGBL_MEM_DMABD13PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD13PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD13PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD13PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD13PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD13PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD13PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD13PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD13PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD13INTSTA		0x0001D1B4
#define XAIEGBL_MEM_DMABD13INTSTAWID		32
#define XAIEGBL_MEM_DMABD13INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD13INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD13INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD13INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD13INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD13INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD13INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD13INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD13INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD13CTRL		0x0001D1B8
#define XAIEGBL_MEM_DMABD13CTRLWID		32
#define XAIEGBL_MEM_DMABD13CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD13CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD13CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD13CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD13CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD13CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD13CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD13CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD13CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD13CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD13CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD13CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD13CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD13CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD13CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD13CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD13CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD13CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD13CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD13CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD13CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD13CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD13CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD13CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD13CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD13CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD13CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD13CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD13CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD13CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD13CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD14ADDA		0x0001D1C0
#define XAIEGBL_MEM_DMABD14ADDAWID		32
#define XAIEGBL_MEM_DMABD14ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD14ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD14ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD14ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD14ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD14ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD14ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD14ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD14ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD14ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD14ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD14ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD14ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD14ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD14ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD14ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD14ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD14ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD14ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD14ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD14ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD14ADDB		0x0001D1C4
#define XAIEGBL_MEM_DMABD14ADDBWID		32
#define XAIEGBL_MEM_DMABD14ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD14ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD14ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD14ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD14ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD14ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD14ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD14ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD14ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD14ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD14ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD14ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD14ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD14ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD14ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD14ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD14ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD14ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD14ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD14ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD14ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD14ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD142DX		0x0001D1C8
#define XAIEGBL_MEM_DMABD142DXWID		32
#define XAIEGBL_MEM_DMABD142DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD142DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD142DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD142DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD142DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD142DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD142DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD142DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD142DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD142DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD142DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD142DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD142DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD142DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD142DY		0x0001D1CC
#define XAIEGBL_MEM_DMABD142DYWID		32
#define XAIEGBL_MEM_DMABD142DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD142DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD142DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD142DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD142DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD142DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD142DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD142DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD142DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD142DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD142DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD142DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD142DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD142DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD14PKT		0x0001D1D0
#define XAIEGBL_MEM_DMABD14PKTWID		32
#define XAIEGBL_MEM_DMABD14PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD14PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD14PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD14PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD14PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD14PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD14PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD14PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD14PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD14INTSTA		0x0001D1D4
#define XAIEGBL_MEM_DMABD14INTSTAWID		32
#define XAIEGBL_MEM_DMABD14INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD14INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD14INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD14INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD14INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD14INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD14INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD14INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD14INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD14CTRL		0x0001D1D8
#define XAIEGBL_MEM_DMABD14CTRLWID		32
#define XAIEGBL_MEM_DMABD14CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD14CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD14CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD14CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD14CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD14CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD14CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD14CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD14CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD14CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD14CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD14CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD14CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD14CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD14CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD14CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD14CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD14CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD14CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD14CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD14CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD14CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD14CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD14CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD14CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD14CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD14CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD14CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD14CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD14CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD14CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMABD15ADDA		0x0001D1E0
#define XAIEGBL_MEM_DMABD15ADDAWID		32
#define XAIEGBL_MEM_DMABD15ADDAMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD15ADDA_LOCKIDA_LSB		22
#define XAIEGBL_MEM_DMABD15ADDA_LOCKIDA_WIDTH		4
#define XAIEGBL_MEM_DMABD15ADDA_LOCKIDA_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD15ADDA_LOCKIDA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDA_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD15ADDA_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDA_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD15ADDA_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDA_RELVALA_LSB		20
#define XAIEGBL_MEM_DMABD15ADDA_RELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDA_RELVALA_MASK		0x00100000
#define XAIEGBL_MEM_DMABD15ADDA_RELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDA_USERELVALA_LSB		19
#define XAIEGBL_MEM_DMABD15ADDA_USERELVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDA_USERELVALA_MASK		0x00080000
#define XAIEGBL_MEM_DMABD15ADDA_USERELVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDA_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD15ADDA_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDA_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD15ADDA_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDA_ACQVALA_LSB		17
#define XAIEGBL_MEM_DMABD15ADDA_ACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDA_ACQVALA_MASK		0x00020000
#define XAIEGBL_MEM_DMABD15ADDA_ACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDA_USEACQVALA_LSB		16
#define XAIEGBL_MEM_DMABD15ADDA_USEACQVALA_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDA_USEACQVALA_MASK		0x00010000
#define XAIEGBL_MEM_DMABD15ADDA_USEACQVALA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDA_BASADDA_LSB		0
#define XAIEGBL_MEM_DMABD15ADDA_BASADDA_WIDTH		13
#define XAIEGBL_MEM_DMABD15ADDA_BASADDA_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD15ADDA_BASADDA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD15ADDA(Lock_ID_A,Enable_Release,Release_Value_A,Use_Release_Value_A,Enable_Acquire,Acquire_Value_A,Use_Acquire_Value_A,Base_Address_A)		(((Lock_ID_A&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_A&0x00000001)<<20)+((Use_Release_Value_A&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_A&0x00000001)<<17)+((Use_Acquire_Value_A&0x00000001)<<16)+(Base_Address_A&0x00001fff))

#define XAIEGBL_MEM_DMABD15ADDB		0x0001D1E4
#define XAIEGBL_MEM_DMABD15ADDBWID		32
#define XAIEGBL_MEM_DMABD15ADDBMSK		0x03FF1FFF
#define XAIEGBL_MEM_DMABD15ADDB_LOCKIDB_LSB		22
#define XAIEGBL_MEM_DMABD15ADDB_LOCKIDB_WIDTH		4
#define XAIEGBL_MEM_DMABD15ADDB_LOCKIDB_MASK		0x03C00000
#define XAIEGBL_MEM_DMABD15ADDB_LOCKIDB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDB_ENAREL_LSB		21
#define XAIEGBL_MEM_DMABD15ADDB_ENAREL_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDB_ENAREL_MASK		0x00200000
#define XAIEGBL_MEM_DMABD15ADDB_ENAREL_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDB_RELVALB_LSB		20
#define XAIEGBL_MEM_DMABD15ADDB_RELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDB_RELVALB_MASK		0x00100000
#define XAIEGBL_MEM_DMABD15ADDB_RELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDB_USERELVALB_LSB		19
#define XAIEGBL_MEM_DMABD15ADDB_USERELVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDB_USERELVALB_MASK		0x00080000
#define XAIEGBL_MEM_DMABD15ADDB_USERELVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDB_ENAACQ_LSB		18
#define XAIEGBL_MEM_DMABD15ADDB_ENAACQ_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDB_ENAACQ_MASK		0x00040000
#define XAIEGBL_MEM_DMABD15ADDB_ENAACQ_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDB_ACQVALB_LSB		17
#define XAIEGBL_MEM_DMABD15ADDB_ACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDB_ACQVALB_MASK		0x00020000
#define XAIEGBL_MEM_DMABD15ADDB_ACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDB_USEACQVALB_LSB		16
#define XAIEGBL_MEM_DMABD15ADDB_USEACQVALB_WIDTH		1
#define XAIEGBL_MEM_DMABD15ADDB_USEACQVALB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD15ADDB_USEACQVALB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15ADDB_BASADDB_LSB		0
#define XAIEGBL_MEM_DMABD15ADDB_BASADDB_WIDTH		13
#define XAIEGBL_MEM_DMABD15ADDB_BASADDB_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD15ADDB_BASADDB_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD15ADDB(Lock_ID_B,Enable_Release,Release_Value_B,Use_Release_Value_B,Enable_Acquire,Acquire_Value_B,Use_Acquire_Value_B,Base_Address_B)		(((Lock_ID_B&0x0000000f)<<22)+((Enable_Release&0x00000001)<<21)+((Release_Value_B&0x00000001)<<20)+((Use_Release_Value_B&0x00000001)<<19)+((Enable_Acquire&0x00000001)<<18)+((Acquire_Value_B&0x00000001)<<17)+((Use_Acquire_Value_B&0x00000001)<<16)+(Base_Address_B&0x00001fff))

#define XAIEGBL_MEM_DMABD152DX		0x0001D1E8
#define XAIEGBL_MEM_DMABD152DXWID		32
#define XAIEGBL_MEM_DMABD152DXMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD152DX_XINC_LSB		24
#define XAIEGBL_MEM_DMABD152DX_XINC_WIDTH		8
#define XAIEGBL_MEM_DMABD152DX_XINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD152DX_XINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD152DX_XWRA_LSB		16
#define XAIEGBL_MEM_DMABD152DX_XWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD152DX_XWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD152DX_XWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD152DX_XOFF_LSB		0
#define XAIEGBL_MEM_DMABD152DX_XOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD152DX_XOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD152DX_XOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD152DX(X_Increment,X_Wrap,X_Offset)		(((X_Increment&0x000000ff)<<24)+((X_Wrap&0x000000ff)<<16)+(X_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD152DY		0x0001D1EC
#define XAIEGBL_MEM_DMABD152DYWID		32
#define XAIEGBL_MEM_DMABD152DYMSK		0xFFFF1FFF
#define XAIEGBL_MEM_DMABD152DY_YINC_LSB		24
#define XAIEGBL_MEM_DMABD152DY_YINC_WIDTH		8
#define XAIEGBL_MEM_DMABD152DY_YINC_MASK		0xFF000000
#define XAIEGBL_MEM_DMABD152DY_YINC_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD152DY_YWRA_LSB		16
#define XAIEGBL_MEM_DMABD152DY_YWRA_WIDTH		8
#define XAIEGBL_MEM_DMABD152DY_YWRA_MASK		0x00FF0000
#define XAIEGBL_MEM_DMABD152DY_YWRA_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD152DY_YOFF_LSB		0
#define XAIEGBL_MEM_DMABD152DY_YOFF_WIDTH		13
#define XAIEGBL_MEM_DMABD152DY_YOFF_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD152DY_YOFF_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD152DY(Y_Increment,Y_Wrap,Y_Offset)		(((Y_Increment&0x000000ff)<<24)+((Y_Wrap&0x000000ff)<<16)+(Y_Offset&0x00001fff))

#define XAIEGBL_MEM_DMABD15PKT		0x0001D1F0
#define XAIEGBL_MEM_DMABD15PKTWID		32
#define XAIEGBL_MEM_DMABD15PKTMSK		0x0000701F
#define XAIEGBL_MEM_DMABD15PKT_PKTTYP_LSB		12
#define XAIEGBL_MEM_DMABD15PKT_PKTTYP_WIDTH		3
#define XAIEGBL_MEM_DMABD15PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_MEM_DMABD15PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15PKT_ID_LSB		0
#define XAIEGBL_MEM_DMABD15PKT_ID_WIDTH		5
#define XAIEGBL_MEM_DMABD15PKT_ID_MASK		0x0000001F
#define XAIEGBL_MEM_DMABD15PKT_ID_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD15PKT(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_MEM_DMABD15INTSTA		0x0001D1F4
#define XAIEGBL_MEM_DMABD15INTSTAWID		32
#define XAIEGBL_MEM_DMABD15INTSTAMSK		0x00011FFF
#define XAIEGBL_MEM_DMABD15INTSTA_AB_LSB		16
#define XAIEGBL_MEM_DMABD15INTSTA_AB_WIDTH		1
#define XAIEGBL_MEM_DMABD15INTSTA_AB_MASK		0x00010000
#define XAIEGBL_MEM_DMABD15INTSTA_AB_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15INTSTA_CURPTR_LSB		0
#define XAIEGBL_MEM_DMABD15INTSTA_CURPTR_WIDTH		13
#define XAIEGBL_MEM_DMABD15INTSTA_CURPTR_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD15INTSTA_CURPTR_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD15INTSTA(A_B,Current_Pointer)		(((A_B&0x00000001)<<16)+(Current_Pointer&0x00001fff))

#define XAIEGBL_MEM_DMABD15CTRL		0x0001D1F8
#define XAIEGBL_MEM_DMABD15CTRLWID		32
#define XAIEGBL_MEM_DMABD15CTRLMSK		0xFFFFFFFF
#define XAIEGBL_MEM_DMABD15CTRL_VALBD_LSB		31
#define XAIEGBL_MEM_DMABD15CTRL_VALBD_WIDTH		1
#define XAIEGBL_MEM_DMABD15CTRL_VALBD_MASK		0x80000000
#define XAIEGBL_MEM_DMABD15CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15CTRL_ENAABMOD_LSB		30
#define XAIEGBL_MEM_DMABD15CTRL_ENAABMOD_WIDTH		1
#define XAIEGBL_MEM_DMABD15CTRL_ENAABMOD_MASK		0x40000000
#define XAIEGBL_MEM_DMABD15CTRL_ENAABMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15CTRL_ENAFIFMOD_LSB		28
#define XAIEGBL_MEM_DMABD15CTRL_ENAFIFMOD_WIDTH		2
#define XAIEGBL_MEM_DMABD15CTRL_ENAFIFMOD_MASK		0x30000000
#define XAIEGBL_MEM_DMABD15CTRL_ENAFIFMOD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15CTRL_ENAPKT_LSB		27
#define XAIEGBL_MEM_DMABD15CTRL_ENAPKT_WIDTH		1
#define XAIEGBL_MEM_DMABD15CTRL_ENAPKT_MASK		0x08000000
#define XAIEGBL_MEM_DMABD15CTRL_ENAPKT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15CTRL_ENAINT_LSB		26
#define XAIEGBL_MEM_DMABD15CTRL_ENAINT_WIDTH		1
#define XAIEGBL_MEM_DMABD15CTRL_ENAINT_MASK		0x04000000
#define XAIEGBL_MEM_DMABD15CTRL_ENAINT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15CTRL_INTCNT_LSB		18
#define XAIEGBL_MEM_DMABD15CTRL_INTCNT_WIDTH		8
#define XAIEGBL_MEM_DMABD15CTRL_INTCNT_MASK		0x03FC0000
#define XAIEGBL_MEM_DMABD15CTRL_INTCNT_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15CTRL_USENEXBD_LSB		17
#define XAIEGBL_MEM_DMABD15CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_MEM_DMABD15CTRL_USENEXBD_MASK		0x00020000
#define XAIEGBL_MEM_DMABD15CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15CTRL_NEXBD_LSB		13
#define XAIEGBL_MEM_DMABD15CTRL_NEXBD_WIDTH		4
#define XAIEGBL_MEM_DMABD15CTRL_NEXBD_MASK		0x0001E000
#define XAIEGBL_MEM_DMABD15CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_MEM_DMABD15CTRL_LEN_LSB		0
#define XAIEGBL_MEM_DMABD15CTRL_LEN_WIDTH		13
#define XAIEGBL_MEM_DMABD15CTRL_LEN_MASK		0x00001FFF
#define XAIEGBL_MEM_DMABD15CTRL_LEN_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMABD15CTRL(Valid_BD,Enable_AB_Mode,Enable_FIFO_Mode,Enable_Packet,Enabled_Interleaved,Interleaved_Count,Use_Next_BD,Next_BD,Length)		(((Valid_BD&0x00000001)<<31)+((Enable_AB_Mode&0x00000001)<<30)+((Enable_FIFO_Mode&0x00000003)<<28)+((Enable_Packet&0x00000001)<<27)+((Enabled_Interleaved&0x00000001)<<26)+((Interleaved_Count&0x000000ff)<<18)+((Use_Next_BD&0x00000001)<<17)+((Next_BD&0x0000000f)<<13)+(Length&0x00001fff))

#define XAIEGBL_MEM_DMAS2MM0CTR		0x0001DE00
#define XAIEGBL_MEM_DMAS2MM0CTRWID		32
#define XAIEGBL_MEM_DMAS2MM0CTRMSK		0x00000003
#define XAIEGBL_MEM_DMAS2MM0CTR_RST_LSB		1
#define XAIEGBL_MEM_DMAS2MM0CTR_RST_WIDTH		1
#define XAIEGBL_MEM_DMAS2MM0CTR_RST_MASK		0x00000002
#define XAIEGBL_MEM_DMAS2MM0CTR_RST_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MM0CTR_ENA_LSB		0
#define XAIEGBL_MEM_DMAS2MM0CTR_ENA_WIDTH		1
#define XAIEGBL_MEM_DMAS2MM0CTR_ENA_MASK		0x00000001
#define XAIEGBL_MEM_DMAS2MM0CTR_ENA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAS2MM0CTR(Reset,Enable)		(((Reset&0x00000001)<<1)+(Enable&0x00000001))

#define XAIEGBL_MEM_DMAS2MM0STAQUE		0x0001DE04
#define XAIEGBL_MEM_DMAS2MM0STAQUEWID		32
#define XAIEGBL_MEM_DMAS2MM0STAQUEMSK		0x0000000F
#define XAIEGBL_MEM_DMAS2MM0STAQUE_STABD_LSB		0
#define XAIEGBL_MEM_DMAS2MM0STAQUE_STABD_WIDTH		4
#define XAIEGBL_MEM_DMAS2MM0STAQUE_STABD_MASK		0x0000000F
#define XAIEGBL_MEM_DMAS2MM0STAQUE_STABD_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAS2MM0STAQUE(Start_BD)		((Start_BD&0x0000000f))

#define XAIEGBL_MEM_DMAS2MM1CTR		0x0001DE08
#define XAIEGBL_MEM_DMAS2MM1CTRWID		32
#define XAIEGBL_MEM_DMAS2MM1CTRMSK		0x00000003
#define XAIEGBL_MEM_DMAS2MM1CTR_RST_LSB		1
#define XAIEGBL_MEM_DMAS2MM1CTR_RST_WIDTH		1
#define XAIEGBL_MEM_DMAS2MM1CTR_RST_MASK		0x00000002
#define XAIEGBL_MEM_DMAS2MM1CTR_RST_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MM1CTR_ENA_LSB		0
#define XAIEGBL_MEM_DMAS2MM1CTR_ENA_WIDTH		1
#define XAIEGBL_MEM_DMAS2MM1CTR_ENA_MASK		0x00000001
#define XAIEGBL_MEM_DMAS2MM1CTR_ENA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAS2MM1CTR(Reset,Enable)		(((Reset&0x00000001)<<1)+(Enable&0x00000001))

#define XAIEGBL_MEM_DMAS2MM1STAQUE		0x0001DE0C
#define XAIEGBL_MEM_DMAS2MM1STAQUEWID		32
#define XAIEGBL_MEM_DMAS2MM1STAQUEMSK		0x0000000F
#define XAIEGBL_MEM_DMAS2MM1STAQUE_STABD_LSB		0
#define XAIEGBL_MEM_DMAS2MM1STAQUE_STABD_WIDTH		4
#define XAIEGBL_MEM_DMAS2MM1STAQUE_STABD_MASK		0x0000000F
#define XAIEGBL_MEM_DMAS2MM1STAQUE_STABD_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAS2MM1STAQUE(Start_BD)		((Start_BD&0x0000000f))

#define XAIEGBL_MEM_DMAMM2S0CTR		0x0001DE10
#define XAIEGBL_MEM_DMAMM2S0CTRWID		32
#define XAIEGBL_MEM_DMAMM2S0CTRMSK		0x00000003
#define XAIEGBL_MEM_DMAMM2S0CTR_RST_LSB		1
#define XAIEGBL_MEM_DMAMM2S0CTR_RST_WIDTH		1
#define XAIEGBL_MEM_DMAMM2S0CTR_RST_MASK		0x00000002
#define XAIEGBL_MEM_DMAMM2S0CTR_RST_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2S0CTR_ENA_LSB		0
#define XAIEGBL_MEM_DMAMM2S0CTR_ENA_WIDTH		1
#define XAIEGBL_MEM_DMAMM2S0CTR_ENA_MASK		0x00000001
#define XAIEGBL_MEM_DMAMM2S0CTR_ENA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAMM2S0CTR(Reset,Enable)		(((Reset&0x00000001)<<1)+(Enable&0x00000001))

#define XAIEGBL_MEM_DMAMM2S0STAQUE		0x0001DE14
#define XAIEGBL_MEM_DMAMM2S0STAQUEWID		32
#define XAIEGBL_MEM_DMAMM2S0STAQUEMSK		0x0000000F
#define XAIEGBL_MEM_DMAMM2S0STAQUE_STABD_LSB		0
#define XAIEGBL_MEM_DMAMM2S0STAQUE_STABD_WIDTH		4
#define XAIEGBL_MEM_DMAMM2S0STAQUE_STABD_MASK		0x0000000F
#define XAIEGBL_MEM_DMAMM2S0STAQUE_STABD_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAMM2S0STAQUE(Start_BD)		((Start_BD&0x0000000f))

#define XAIEGBL_MEM_DMAMM2S1CTR		0x0001DE18
#define XAIEGBL_MEM_DMAMM2S1CTRWID		32
#define XAIEGBL_MEM_DMAMM2S1CTRMSK		0x00000003
#define XAIEGBL_MEM_DMAMM2S1CTR_RST_LSB		1
#define XAIEGBL_MEM_DMAMM2S1CTR_RST_WIDTH		1
#define XAIEGBL_MEM_DMAMM2S1CTR_RST_MASK		0x00000002
#define XAIEGBL_MEM_DMAMM2S1CTR_RST_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2S1CTR_ENA_LSB		0
#define XAIEGBL_MEM_DMAMM2S1CTR_ENA_WIDTH		1
#define XAIEGBL_MEM_DMAMM2S1CTR_ENA_MASK		0x00000001
#define XAIEGBL_MEM_DMAMM2S1CTR_ENA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAMM2S1CTR(Reset,Enable)		(((Reset&0x00000001)<<1)+(Enable&0x00000001))

#define XAIEGBL_MEM_DMAMM2S1STAQUE		0x0001DE1C
#define XAIEGBL_MEM_DMAMM2S1STAQUEWID		32
#define XAIEGBL_MEM_DMAMM2S1STAQUEMSK		0x0000000F
#define XAIEGBL_MEM_DMAMM2S1STAQUE_STABD_LSB		0
#define XAIEGBL_MEM_DMAMM2S1STAQUE_STABD_WIDTH		4
#define XAIEGBL_MEM_DMAMM2S1STAQUE_STABD_MASK		0x0000000F
#define XAIEGBL_MEM_DMAMM2S1STAQUE_STABD_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAMM2S1STAQUE(Start_BD)		((Start_BD&0x0000000f))

#define XAIEGBL_MEM_DMAS2MMSTA		0x0001DF00
#define XAIEGBL_MEM_DMAS2MMSTAWID		32
#define XAIEGBL_MEM_DMAS2MMSTAMSK		0x30FF0FFF
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE1_LSB		29
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE1_WIDTH		1
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE1_MASK		0x20000000
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE0_LSB		28
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE0_WIDTH		1
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE0_MASK		0x10000000
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUEOVE0_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_CURBD1_LSB		20
#define XAIEGBL_MEM_DMAS2MMSTA_CURBD1_WIDTH		4
#define XAIEGBL_MEM_DMAS2MMSTA_CURBD1_MASK		0x00F00000
#define XAIEGBL_MEM_DMAS2MMSTA_CURBD1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_CURBD0_LSB		16
#define XAIEGBL_MEM_DMAS2MMSTA_CURBD0_WIDTH		4
#define XAIEGBL_MEM_DMAS2MMSTA_CURBD0_MASK		0x000F0000
#define XAIEGBL_MEM_DMAS2MMSTA_CURBD0_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ1_LSB		9
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ1_WIDTH		3
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ1_MASK		0x00000E00
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ0_LSB		6
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ0_WIDTH		3
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ0_MASK		0x000001C0
#define XAIEGBL_MEM_DMAS2MMSTA_STAQUESIZ0_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL1_LSB		5
#define XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL1_WIDTH		1
#define XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL1_MASK		0x00000020
#define XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL0_LSB		4
#define XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL0_WIDTH		1
#define XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL0_MASK		0x00000010
#define XAIEGBL_MEM_DMAS2MMSTA_LOCKSTAL0_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_STA1_LSB		2
#define XAIEGBL_MEM_DMAS2MMSTA_STA1_WIDTH		2
#define XAIEGBL_MEM_DMAS2MMSTA_STA1_MASK		0x0000000C
#define XAIEGBL_MEM_DMAS2MMSTA_STA1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAS2MMSTA_STA0_LSB		0
#define XAIEGBL_MEM_DMAS2MMSTA_STA0_WIDTH		2
#define XAIEGBL_MEM_DMAS2MMSTA_STA0_MASK		0x00000003
#define XAIEGBL_MEM_DMAS2MMSTA_STA0_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAS2MMSTA(Start_Queue_Overflow_1,Start_Queue_Overflow_0,Cur_BD_1,Cur_BD_0,Start_Queue_Size_1,Start_Queue_Size_0,Lock_stalled1,Lock_stalled0,Stat1,Stat0)		(((Start_Queue_Overflow_1&0x00000001)<<29)+((Start_Queue_Overflow_0&0x00000001)<<28)+((Cur_BD_1&0x0000000f)<<20)+((Cur_BD_0&0x0000000f)<<16)+((Start_Queue_Size_1&0x00000007)<<9)+((Start_Queue_Size_0&0x00000007)<<6)+((Lock_stalled1&0x00000001)<<5)+((Lock_stalled0&0x00000001)<<4)+((Stat1&0x00000003)<<2)+(Stat0&0x00000003))

#define XAIEGBL_MEM_DMAMM2SSTA		0x0001DF10
#define XAIEGBL_MEM_DMAMM2SSTAWID		32
#define XAIEGBL_MEM_DMAMM2SSTAMSK		0x30FF0FFF
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE1_LSB		29
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE1_WIDTH		1
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE1_MASK		0x20000000
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE0_LSB		28
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE0_WIDTH		1
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE0_MASK		0x10000000
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUEOVE0_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_CURBD1_LSB		20
#define XAIEGBL_MEM_DMAMM2SSTA_CURBD1_WIDTH		4
#define XAIEGBL_MEM_DMAMM2SSTA_CURBD1_MASK		0x00F00000
#define XAIEGBL_MEM_DMAMM2SSTA_CURBD1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_CURBD0_LSB		16
#define XAIEGBL_MEM_DMAMM2SSTA_CURBD0_WIDTH		4
#define XAIEGBL_MEM_DMAMM2SSTA_CURBD0_MASK		0x000F0000
#define XAIEGBL_MEM_DMAMM2SSTA_CURBD0_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ1_LSB		9
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ1_WIDTH		3
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ1_MASK		0x00000E00
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ0_LSB		6
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ0_WIDTH		3
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ0_MASK		0x000001C0
#define XAIEGBL_MEM_DMAMM2SSTA_STAQUESIZ0_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL1_LSB		5
#define XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL1_WIDTH		1
#define XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL1_MASK		0x00000020
#define XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL0_LSB		4
#define XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL0_WIDTH		1
#define XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL0_MASK		0x00000010
#define XAIEGBL_MEM_DMAMM2SSTA_LOCKSTAL0_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_STA1_LSB		2
#define XAIEGBL_MEM_DMAMM2SSTA_STA1_WIDTH		2
#define XAIEGBL_MEM_DMAMM2SSTA_STA1_MASK		0x0000000C
#define XAIEGBL_MEM_DMAMM2SSTA_STA1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAMM2SSTA_STA0_LSB		0
#define XAIEGBL_MEM_DMAMM2SSTA_STA0_WIDTH		2
#define XAIEGBL_MEM_DMAMM2SSTA_STA0_MASK		0x00000003
#define XAIEGBL_MEM_DMAMM2SSTA_STA0_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAMM2SSTA(Start_Queue_Overflow_1,Start_Queue_Overflow_0,Cur_BD_1,Cur_BD_0,Start_Queue_Size_1,Start_Queue_Size_0,Lock_stalled1,Lock_stalled0,Stat1,Stat0)		(((Start_Queue_Overflow_1&0x00000001)<<29)+((Start_Queue_Overflow_0&0x00000001)<<28)+((Cur_BD_1&0x0000000f)<<20)+((Cur_BD_0&0x0000000f)<<16)+((Start_Queue_Size_1&0x00000007)<<9)+((Start_Queue_Size_0&0x00000007)<<6)+((Lock_stalled1&0x00000001)<<5)+((Lock_stalled0&0x00000001)<<4)+((Stat1&0x00000003)<<2)+(Stat0&0x00000003))

#define XAIEGBL_MEM_DMAFIFCOU		0x0001DF20
#define XAIEGBL_MEM_DMAFIFCOUWID		32
#define XAIEGBL_MEM_DMAFIFCOUMSK		0x0FFF0FFF
#define XAIEGBL_MEM_DMAFIFCOU_COU1_LSB		16
#define XAIEGBL_MEM_DMAFIFCOU_COU1_WIDTH		12
#define XAIEGBL_MEM_DMAFIFCOU_COU1_MASK		0x0FFF0000
#define XAIEGBL_MEM_DMAFIFCOU_COU1_DEFVAL		0x0
#define XAIEGBL_MEM_DMAFIFCOU_COU0_LSB		0
#define XAIEGBL_MEM_DMAFIFCOU_COU0_WIDTH		12
#define XAIEGBL_MEM_DMAFIFCOU_COU0_MASK		0x00000FFF
#define XAIEGBL_MEM_DMAFIFCOU_COU0_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_DMAFIFCOU(Counter1,Counter0)		(((Counter1&0x00000fff)<<16)+(Counter0&0x00000fff))

#define XAIEGBL_MEM_LOCK0RELNV		0x0001E000
#define XAIEGBL_MEM_LOCK0RELNVWID		32
#define XAIEGBL_MEM_LOCK0RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK0RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK0RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK0RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK0RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK0RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK0RELV0		0x0001E020
#define XAIEGBL_MEM_LOCK0RELV0WID		32
#define XAIEGBL_MEM_LOCK0RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK0RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK0RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK0RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK0RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK0RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK0RELV1		0x0001E030
#define XAIEGBL_MEM_LOCK0RELV1WID		32
#define XAIEGBL_MEM_LOCK0RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK0RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK0RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK0RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK0RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK0RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK0ACQNV		0x0001E040
#define XAIEGBL_MEM_LOCK0ACQNVWID		32
#define XAIEGBL_MEM_LOCK0ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK0ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK0ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK0ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK0ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK0ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK0ACQV0		0x0001E060
#define XAIEGBL_MEM_LOCK0ACQV0WID		32
#define XAIEGBL_MEM_LOCK0ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK0ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK0ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK0ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK0ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK0ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK0ACQV1		0x0001E070
#define XAIEGBL_MEM_LOCK0ACQV1WID		32
#define XAIEGBL_MEM_LOCK0ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK0ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK0ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK0ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK0ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK0ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK1RELNV		0x0001E080
#define XAIEGBL_MEM_LOCK1RELNVWID		32
#define XAIEGBL_MEM_LOCK1RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK1RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK1RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK1RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK1RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK1RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK1RELV0		0x0001E0A0
#define XAIEGBL_MEM_LOCK1RELV0WID		32
#define XAIEGBL_MEM_LOCK1RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK1RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK1RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK1RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK1RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK1RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK1RELV1		0x0001E0B0
#define XAIEGBL_MEM_LOCK1RELV1WID		32
#define XAIEGBL_MEM_LOCK1RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK1RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK1RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK1RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK1RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK1RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK1ACQNV		0x0001E0C0
#define XAIEGBL_MEM_LOCK1ACQNVWID		32
#define XAIEGBL_MEM_LOCK1ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK1ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK1ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK1ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK1ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK1ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK1ACQV0		0x0001E0E0
#define XAIEGBL_MEM_LOCK1ACQV0WID		32
#define XAIEGBL_MEM_LOCK1ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK1ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK1ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK1ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK1ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK1ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK1ACQV1		0x0001E0F0
#define XAIEGBL_MEM_LOCK1ACQV1WID		32
#define XAIEGBL_MEM_LOCK1ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK1ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK1ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK1ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK1ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK1ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK2RELNV		0x0001E100
#define XAIEGBL_MEM_LOCK2RELNVWID		32
#define XAIEGBL_MEM_LOCK2RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK2RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK2RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK2RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK2RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK2RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK2RELV0		0x0001E120
#define XAIEGBL_MEM_LOCK2RELV0WID		32
#define XAIEGBL_MEM_LOCK2RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK2RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK2RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK2RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK2RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK2RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK2RELV1		0x0001E130
#define XAIEGBL_MEM_LOCK2RELV1WID		32
#define XAIEGBL_MEM_LOCK2RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK2RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK2RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK2RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK2RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK2RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK2ACQNV		0x0001E140
#define XAIEGBL_MEM_LOCK2ACQNVWID		32
#define XAIEGBL_MEM_LOCK2ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK2ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK2ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK2ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK2ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK2ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK2ACQV0		0x0001E160
#define XAIEGBL_MEM_LOCK2ACQV0WID		32
#define XAIEGBL_MEM_LOCK2ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK2ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK2ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK2ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK2ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK2ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK2ACQV1		0x0001E170
#define XAIEGBL_MEM_LOCK2ACQV1WID		32
#define XAIEGBL_MEM_LOCK2ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK2ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK2ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK2ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK2ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK2ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK3RELNV		0x0001E180
#define XAIEGBL_MEM_LOCK3RELNVWID		32
#define XAIEGBL_MEM_LOCK3RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK3RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK3RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK3RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK3RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK3RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK3RELV0		0x0001E1A0
#define XAIEGBL_MEM_LOCK3RELV0WID		32
#define XAIEGBL_MEM_LOCK3RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK3RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK3RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK3RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK3RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK3RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK3RELV1		0x0001E1B0
#define XAIEGBL_MEM_LOCK3RELV1WID		32
#define XAIEGBL_MEM_LOCK3RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK3RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK3RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK3RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK3RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK3RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK3ACQNV		0x0001E1C0
#define XAIEGBL_MEM_LOCK3ACQNVWID		32
#define XAIEGBL_MEM_LOCK3ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK3ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK3ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK3ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK3ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK3ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK3ACQV0		0x0001E1E0
#define XAIEGBL_MEM_LOCK3ACQV0WID		32
#define XAIEGBL_MEM_LOCK3ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK3ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK3ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK3ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK3ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK3ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK3ACQV1		0x0001E1F0
#define XAIEGBL_MEM_LOCK3ACQV1WID		32
#define XAIEGBL_MEM_LOCK3ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK3ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK3ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK3ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK3ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK3ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK4RELNV		0x0001E200
#define XAIEGBL_MEM_LOCK4RELNVWID		32
#define XAIEGBL_MEM_LOCK4RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK4RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK4RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK4RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK4RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK4RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK4RELV0		0x0001E220
#define XAIEGBL_MEM_LOCK4RELV0WID		32
#define XAIEGBL_MEM_LOCK4RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK4RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK4RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK4RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK4RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK4RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK4RELV1		0x0001E230
#define XAIEGBL_MEM_LOCK4RELV1WID		32
#define XAIEGBL_MEM_LOCK4RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK4RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK4RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK4RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK4RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK4RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK4ACQNV		0x0001E240
#define XAIEGBL_MEM_LOCK4ACQNVWID		32
#define XAIEGBL_MEM_LOCK4ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK4ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK4ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK4ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK4ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK4ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK4ACQV0		0x0001E260
#define XAIEGBL_MEM_LOCK4ACQV0WID		32
#define XAIEGBL_MEM_LOCK4ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK4ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK4ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK4ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK4ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK4ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK4ACQV1		0x0001E270
#define XAIEGBL_MEM_LOCK4ACQV1WID		32
#define XAIEGBL_MEM_LOCK4ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK4ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK4ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK4ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK4ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK4ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK5RELNV		0x0001E280
#define XAIEGBL_MEM_LOCK5RELNVWID		32
#define XAIEGBL_MEM_LOCK5RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK5RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK5RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK5RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK5RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK5RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK5RELV0		0x0001E2A0
#define XAIEGBL_MEM_LOCK5RELV0WID		32
#define XAIEGBL_MEM_LOCK5RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK5RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK5RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK5RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK5RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK5RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK5RELV1		0x0001E2B0
#define XAIEGBL_MEM_LOCK5RELV1WID		32
#define XAIEGBL_MEM_LOCK5RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK5RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK5RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK5RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK5RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK5RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK5ACQNV		0x0001E2C0
#define XAIEGBL_MEM_LOCK5ACQNVWID		32
#define XAIEGBL_MEM_LOCK5ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK5ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK5ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK5ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK5ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK5ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK5ACQV0		0x0001E2E0
#define XAIEGBL_MEM_LOCK5ACQV0WID		32
#define XAIEGBL_MEM_LOCK5ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK5ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK5ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK5ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK5ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK5ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK5ACQV1		0x0001E2F0
#define XAIEGBL_MEM_LOCK5ACQV1WID		32
#define XAIEGBL_MEM_LOCK5ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK5ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK5ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK5ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK5ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK5ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK6RELNV		0x0001E300
#define XAIEGBL_MEM_LOCK6RELNVWID		32
#define XAIEGBL_MEM_LOCK6RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK6RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK6RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK6RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK6RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK6RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK6RELV0		0x0001E320
#define XAIEGBL_MEM_LOCK6RELV0WID		32
#define XAIEGBL_MEM_LOCK6RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK6RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK6RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK6RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK6RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK6RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK6RELV1		0x0001E330
#define XAIEGBL_MEM_LOCK6RELV1WID		32
#define XAIEGBL_MEM_LOCK6RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK6RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK6RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK6RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK6RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK6RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK6ACQNV		0x0001E340
#define XAIEGBL_MEM_LOCK6ACQNVWID		32
#define XAIEGBL_MEM_LOCK6ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK6ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK6ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK6ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK6ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK6ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK6ACQV0		0x0001E360
#define XAIEGBL_MEM_LOCK6ACQV0WID		32
#define XAIEGBL_MEM_LOCK6ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK6ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK6ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK6ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK6ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK6ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK6ACQV1		0x0001E370
#define XAIEGBL_MEM_LOCK6ACQV1WID		32
#define XAIEGBL_MEM_LOCK6ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK6ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK6ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK6ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK6ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK6ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK7RELNV		0x0001E380
#define XAIEGBL_MEM_LOCK7RELNVWID		32
#define XAIEGBL_MEM_LOCK7RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK7RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK7RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK7RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK7RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK7RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK7RELV0		0x0001E3A0
#define XAIEGBL_MEM_LOCK7RELV0WID		32
#define XAIEGBL_MEM_LOCK7RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK7RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK7RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK7RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK7RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK7RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK7RELV1		0x0001E3B0
#define XAIEGBL_MEM_LOCK7RELV1WID		32
#define XAIEGBL_MEM_LOCK7RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK7RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK7RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK7RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK7RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK7RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK7ACQNV		0x0001E3C0
#define XAIEGBL_MEM_LOCK7ACQNVWID		32
#define XAIEGBL_MEM_LOCK7ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK7ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK7ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK7ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK7ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK7ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK7ACQV0		0x0001E3E0
#define XAIEGBL_MEM_LOCK7ACQV0WID		32
#define XAIEGBL_MEM_LOCK7ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK7ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK7ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK7ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK7ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK7ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK7ACQV1		0x0001E3F0
#define XAIEGBL_MEM_LOCK7ACQV1WID		32
#define XAIEGBL_MEM_LOCK7ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK7ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK7ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK7ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK7ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK7ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK8RELNV		0x0001E400
#define XAIEGBL_MEM_LOCK8RELNVWID		32
#define XAIEGBL_MEM_LOCK8RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK8RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK8RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK8RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK8RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK8RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK8RELV0		0x0001E420
#define XAIEGBL_MEM_LOCK8RELV0WID		32
#define XAIEGBL_MEM_LOCK8RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK8RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK8RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK8RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK8RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK8RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK8RELV1		0x0001E430
#define XAIEGBL_MEM_LOCK8RELV1WID		32
#define XAIEGBL_MEM_LOCK8RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK8RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK8RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK8RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK8RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK8RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK8ACQNV		0x0001E440
#define XAIEGBL_MEM_LOCK8ACQNVWID		32
#define XAIEGBL_MEM_LOCK8ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK8ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK8ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK8ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK8ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK8ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK8ACQV0		0x0001E460
#define XAIEGBL_MEM_LOCK8ACQV0WID		32
#define XAIEGBL_MEM_LOCK8ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK8ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK8ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK8ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK8ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK8ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK8ACQV1		0x0001E470
#define XAIEGBL_MEM_LOCK8ACQV1WID		32
#define XAIEGBL_MEM_LOCK8ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK8ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK8ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK8ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK8ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK8ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK9RELNV		0x0001E480
#define XAIEGBL_MEM_LOCK9RELNVWID		32
#define XAIEGBL_MEM_LOCK9RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK9RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK9RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK9RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK9RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK9RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK9RELV0		0x0001E4A0
#define XAIEGBL_MEM_LOCK9RELV0WID		32
#define XAIEGBL_MEM_LOCK9RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK9RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK9RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK9RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK9RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK9RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK9RELV1		0x0001E4B0
#define XAIEGBL_MEM_LOCK9RELV1WID		32
#define XAIEGBL_MEM_LOCK9RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK9RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK9RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK9RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK9RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK9RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK9ACQNV		0x0001E4C0
#define XAIEGBL_MEM_LOCK9ACQNVWID		32
#define XAIEGBL_MEM_LOCK9ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK9ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK9ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK9ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK9ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK9ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK9ACQV0		0x0001E4E0
#define XAIEGBL_MEM_LOCK9ACQV0WID		32
#define XAIEGBL_MEM_LOCK9ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK9ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK9ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK9ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK9ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK9ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK9ACQV1		0x0001E4F0
#define XAIEGBL_MEM_LOCK9ACQV1WID		32
#define XAIEGBL_MEM_LOCK9ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK9ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK9ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK9ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK9ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK9ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK10RELNV		0x0001E500
#define XAIEGBL_MEM_LOCK10RELNVWID		32
#define XAIEGBL_MEM_LOCK10RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK10RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK10RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK10RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK10RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK10RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK10RELV0		0x0001E520
#define XAIEGBL_MEM_LOCK10RELV0WID		32
#define XAIEGBL_MEM_LOCK10RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK10RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK10RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK10RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK10RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK10RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK10RELV1		0x0001E530
#define XAIEGBL_MEM_LOCK10RELV1WID		32
#define XAIEGBL_MEM_LOCK10RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK10RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK10RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK10RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK10RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK10RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK10ACQNV		0x0001E540
#define XAIEGBL_MEM_LOCK10ACQNVWID		32
#define XAIEGBL_MEM_LOCK10ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK10ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK10ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK10ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK10ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK10ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK10ACQV0		0x0001E560
#define XAIEGBL_MEM_LOCK10ACQV0WID		32
#define XAIEGBL_MEM_LOCK10ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK10ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK10ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK10ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK10ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK10ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK10ACQV1		0x0001E570
#define XAIEGBL_MEM_LOCK10ACQV1WID		32
#define XAIEGBL_MEM_LOCK10ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK10ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK10ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK10ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK10ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK10ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK11RELNV		0x0001E580
#define XAIEGBL_MEM_LOCK11RELNVWID		32
#define XAIEGBL_MEM_LOCK11RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK11RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK11RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK11RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK11RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK11RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK11RELV0		0x0001E5A0
#define XAIEGBL_MEM_LOCK11RELV0WID		32
#define XAIEGBL_MEM_LOCK11RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK11RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK11RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK11RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK11RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK11RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK11RELV1		0x0001E5B0
#define XAIEGBL_MEM_LOCK11RELV1WID		32
#define XAIEGBL_MEM_LOCK11RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK11RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK11RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK11RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK11RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK11RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK11ACQNV		0x0001E5C0
#define XAIEGBL_MEM_LOCK11ACQNVWID		32
#define XAIEGBL_MEM_LOCK11ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK11ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK11ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK11ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK11ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK11ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK11ACQV0		0x0001E5E0
#define XAIEGBL_MEM_LOCK11ACQV0WID		32
#define XAIEGBL_MEM_LOCK11ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK11ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK11ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK11ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK11ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK11ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK11ACQV1		0x0001E5F0
#define XAIEGBL_MEM_LOCK11ACQV1WID		32
#define XAIEGBL_MEM_LOCK11ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK11ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK11ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK11ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK11ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK11ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK12RELNV		0x0001E600
#define XAIEGBL_MEM_LOCK12RELNVWID		32
#define XAIEGBL_MEM_LOCK12RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK12RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK12RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK12RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK12RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK12RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK12RELV0		0x0001E620
#define XAIEGBL_MEM_LOCK12RELV0WID		32
#define XAIEGBL_MEM_LOCK12RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK12RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK12RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK12RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK12RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK12RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK12RELV1		0x0001E630
#define XAIEGBL_MEM_LOCK12RELV1WID		32
#define XAIEGBL_MEM_LOCK12RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK12RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK12RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK12RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK12RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK12RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK12ACQNV		0x0001E640
#define XAIEGBL_MEM_LOCK12ACQNVWID		32
#define XAIEGBL_MEM_LOCK12ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK12ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK12ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK12ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK12ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK12ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK12ACQV0		0x0001E660
#define XAIEGBL_MEM_LOCK12ACQV0WID		32
#define XAIEGBL_MEM_LOCK12ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK12ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK12ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK12ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK12ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK12ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK12ACQV1		0x0001E670
#define XAIEGBL_MEM_LOCK12ACQV1WID		32
#define XAIEGBL_MEM_LOCK12ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK12ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK12ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK12ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK12ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK12ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK13RELNV		0x0001E680
#define XAIEGBL_MEM_LOCK13RELNVWID		32
#define XAIEGBL_MEM_LOCK13RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK13RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK13RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK13RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK13RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK13RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK13RELV0		0x0001E6A0
#define XAIEGBL_MEM_LOCK13RELV0WID		32
#define XAIEGBL_MEM_LOCK13RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK13RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK13RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK13RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK13RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK13RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK13RELV1		0x0001E6B0
#define XAIEGBL_MEM_LOCK13RELV1WID		32
#define XAIEGBL_MEM_LOCK13RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK13RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK13RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK13RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK13RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK13RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK13ACQNV		0x0001E6C0
#define XAIEGBL_MEM_LOCK13ACQNVWID		32
#define XAIEGBL_MEM_LOCK13ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK13ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK13ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK13ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK13ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK13ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK13ACQV0		0x0001E6E0
#define XAIEGBL_MEM_LOCK13ACQV0WID		32
#define XAIEGBL_MEM_LOCK13ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK13ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK13ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK13ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK13ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK13ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK13ACQV1		0x0001E6F0
#define XAIEGBL_MEM_LOCK13ACQV1WID		32
#define XAIEGBL_MEM_LOCK13ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK13ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK13ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK13ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK13ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK13ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK14RELNV		0x0001E700
#define XAIEGBL_MEM_LOCK14RELNVWID		32
#define XAIEGBL_MEM_LOCK14RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK14RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK14RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK14RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK14RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK14RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK14RELV0		0x0001E720
#define XAIEGBL_MEM_LOCK14RELV0WID		32
#define XAIEGBL_MEM_LOCK14RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK14RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK14RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK14RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK14RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK14RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK14RELV1		0x0001E730
#define XAIEGBL_MEM_LOCK14RELV1WID		32
#define XAIEGBL_MEM_LOCK14RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK14RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK14RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK14RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK14RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK14RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK14ACQNV		0x0001E740
#define XAIEGBL_MEM_LOCK14ACQNVWID		32
#define XAIEGBL_MEM_LOCK14ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK14ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK14ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK14ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK14ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK14ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK14ACQV0		0x0001E760
#define XAIEGBL_MEM_LOCK14ACQV0WID		32
#define XAIEGBL_MEM_LOCK14ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK14ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK14ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK14ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK14ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK14ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK14ACQV1		0x0001E770
#define XAIEGBL_MEM_LOCK14ACQV1WID		32
#define XAIEGBL_MEM_LOCK14ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK14ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK14ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK14ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK14ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK14ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK15RELNV		0x0001E780
#define XAIEGBL_MEM_LOCK15RELNVWID		32
#define XAIEGBL_MEM_LOCK15RELNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK15RELNV_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK15RELNV_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK15RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK15RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK15RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK15RELV0		0x0001E7A0
#define XAIEGBL_MEM_LOCK15RELV0WID		32
#define XAIEGBL_MEM_LOCK15RELV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK15RELV0_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK15RELV0_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK15RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK15RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK15RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK15RELV1		0x0001E7B0
#define XAIEGBL_MEM_LOCK15RELV1WID		32
#define XAIEGBL_MEM_LOCK15RELV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK15RELV1_RELDON_LSB		0
#define XAIEGBL_MEM_LOCK15RELV1_RELDON_WIDTH		1
#define XAIEGBL_MEM_LOCK15RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK15RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK15RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_MEM_LOCK15ACQNV		0x0001E7C0
#define XAIEGBL_MEM_LOCK15ACQNVWID		32
#define XAIEGBL_MEM_LOCK15ACQNVMSK		0x00000001
#define XAIEGBL_MEM_LOCK15ACQNV_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK15ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK15ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK15ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK15ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK15ACQV0		0x0001E7E0
#define XAIEGBL_MEM_LOCK15ACQV0WID		32
#define XAIEGBL_MEM_LOCK15ACQV0MSK		0x00000001
#define XAIEGBL_MEM_LOCK15ACQV0_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK15ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK15ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK15ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK15ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_LOCK15ACQV1		0x0001E7F0
#define XAIEGBL_MEM_LOCK15ACQV1WID		32
#define XAIEGBL_MEM_LOCK15ACQV1MSK		0x00000001
#define XAIEGBL_MEM_LOCK15ACQV1_ACQDON_LSB		0
#define XAIEGBL_MEM_LOCK15ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_MEM_LOCK15ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_MEM_LOCK15ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCK15ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_MEM_ALLLOCKSTAVAL		0x0001EF00
#define XAIEGBL_MEM_ALLLOCKSTAVALWID		32
#define XAIEGBL_MEM_ALLLOCKSTAVALMSK		0xFFFFFFFF
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK15VAL_LSB		31
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK15VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK15VAL_MASK		0x80000000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK15VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK15STA_LSB		30
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK15STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK15STA_MASK		0x40000000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK15STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK14VAL_LSB		29
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK14VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK14VAL_MASK		0x20000000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK14VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK14STA_LSB		28
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK14STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK14STA_MASK		0x10000000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK14STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK13VAL_LSB		27
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK13VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK13VAL_MASK		0x08000000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK13VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK13STA_LSB		26
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK13STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK13STA_MASK		0x04000000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK13STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK12VAL_LSB		25
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK12VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK12VAL_MASK		0x02000000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK12VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK12STA_LSB		24
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK12STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK12STA_MASK		0x01000000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK12STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK11VAL_LSB		23
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK11VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK11VAL_MASK		0x00800000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK11VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK11STA_LSB		22
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK11STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK11STA_MASK		0x00400000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK11STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK10VAL_LSB		21
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK10VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK10VAL_MASK		0x00200000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK10VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK10STA_LSB		20
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK10STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK10STA_MASK		0x00100000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK10STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK9VAL_LSB		19
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK9VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK9VAL_MASK		0x00080000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK9VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK9STA_LSB		18
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK9STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK9STA_MASK		0x00040000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK9STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK8VAL_LSB		17
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK8VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK8VAL_MASK		0x00020000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK8VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK8STA_LSB		16
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK8STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK8STA_MASK		0x00010000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK8STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK7VAL_LSB		15
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK7VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK7VAL_MASK		0x00008000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK7VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK7STA_LSB		14
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK7STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK7STA_MASK		0x00004000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK7STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK6VAL_LSB		13
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK6VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK6VAL_MASK		0x00002000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK6VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK6STA_LSB		12
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK6STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK6STA_MASK		0x00001000
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK6STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK5VAL_LSB		11
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK5VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK5VAL_MASK		0x00000800
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK5VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK5STA_LSB		10
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK5STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK5STA_MASK		0x00000400
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK5STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK4VAL_LSB		9
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK4VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK4VAL_MASK		0x00000200
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK4VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK4STA_LSB		8
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK4STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK4STA_MASK		0x00000100
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK4STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK3VAL_LSB		7
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK3VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK3VAL_MASK		0x00000080
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK3VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK3STA_LSB		6
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK3STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK3STA_MASK		0x00000040
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK3STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK2VAL_LSB		5
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK2VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK2VAL_MASK		0x00000020
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK2VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK2STA_LSB		4
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK2STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK2STA_MASK		0x00000010
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK2STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK1VAL_LSB		3
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK1VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK1VAL_MASK		0x00000008
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK1VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK1STA_LSB		2
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK1STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK1STA_MASK		0x00000004
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK1STA_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK0VAL_LSB		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK0VAL_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK0VAL_MASK		0x00000002
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK0VAL_DEFVAL		0x0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK0STA_LSB		0
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK0STA_WIDTH		1
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK0STA_MASK		0x00000001
#define XAIEGBL_MEM_ALLLOCKSTAVAL_LOCK0STA_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_ALLLOCKSTAVAL(Lock15_Value,Lock15_State,Lock14_Value,Lock14_State,Lock13_Value,Lock13_State,Lock12_Value,Lock12_State,Lock11_Value,Lock11_State,Lock10_Value,Lock10_State,Lock9_Value,Lock9_State,Lock8_Value,Lock8_State,Lock7_Value,Lock7_State,Lock6_Value,Lock6_State,Lock5_Value,Lock5_State,Lock4_Value,Lock4_State,Lock3_Value,Lock3_State,Lock2_Value,Lock2_State,Lock1_Value,Lock1_State,Lock0_Value,Lock0_State)		(((Lock15_Value&0x00000001)<<31)+((Lock15_State&0x00000001)<<30)+((Lock14_Value&0x00000001)<<29)+((Lock14_State&0x00000001)<<28)+((Lock13_Value&0x00000001)<<27)+((Lock13_State&0x00000001)<<26)+((Lock12_Value&0x00000001)<<25)+((Lock12_State&0x00000001)<<24)+((Lock11_Value&0x00000001)<<23)+((Lock11_State&0x00000001)<<22)+((Lock10_Value&0x00000001)<<21)+((Lock10_State&0x00000001)<<20)+((Lock9_Value&0x00000001)<<19)+((Lock9_State&0x00000001)<<18)+((Lock8_Value&0x00000001)<<17)+((Lock8_State&0x00000001)<<16)+((Lock7_Value&0x00000001)<<15)+((Lock7_State&0x00000001)<<14)+((Lock6_Value&0x00000001)<<13)+((Lock6_State&0x00000001)<<12)+((Lock5_Value&0x00000001)<<11)+((Lock5_State&0x00000001)<<10)+((Lock4_Value&0x00000001)<<9)+((Lock4_State&0x00000001)<<8)+((Lock3_Value&0x00000001)<<7)+((Lock3_State&0x00000001)<<6)+((Lock2_Value&0x00000001)<<5)+((Lock2_State&0x00000001)<<4)+((Lock1_Value&0x00000001)<<3)+((Lock1_State&0x00000001)<<2)+((Lock0_Value&0x00000001)<<1)+(Lock0_State&0x00000001))

#define XAIEGBL_MEM_LOCKEVTVALCTRL0		0x0001EF20
#define XAIEGBL_MEM_LOCKEVTVALCTRL0WID		32
#define XAIEGBL_MEM_LOCKEVTVALCTRL0MSK		0xFFFFFFFF
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK7REL_LSB		30
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK7REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK7REL_MASK		0xC0000000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK7REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK7ACQ_LSB		28
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK7ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK7ACQ_MASK		0x30000000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK7ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK6REL_LSB		26
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK6REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK6REL_MASK		0x0C000000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK6REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK6ACQ_LSB		24
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK6ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK6ACQ_MASK		0x03000000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK6ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK5REL_LSB		22
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK5REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK5REL_MASK		0x00C00000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK5REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK5ACQ_LSB		20
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK5ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK5ACQ_MASK		0x00300000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK5ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK4REL_LSB		18
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK4REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK4REL_MASK		0x000C0000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK4REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK4ACQ_LSB		16
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK4ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK4ACQ_MASK		0x00030000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK4ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK3REL_LSB		14
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK3REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK3REL_MASK		0x0000C000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK3REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK3ACQ_LSB		12
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK3ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK3ACQ_MASK		0x00003000
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK3ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK2REL_LSB		10
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK2REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK2REL_MASK		0x00000C00
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK2REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK2ACQ_LSB		8
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK2ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK2ACQ_MASK		0x00000300
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK2ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK1REL_LSB		6
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK1REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK1REL_MASK		0x000000C0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK1REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK1ACQ_LSB		4
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK1ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK1ACQ_MASK		0x00000030
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK1ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK0REL_LSB		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK0REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK0REL_MASK		0x0000000C
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK0REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK0ACQ_LSB		0
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK0ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK0ACQ_MASK		0x00000003
#define XAIEGBL_MEM_LOCKEVTVALCTRL0_LOCK0ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCKEVTVALCTRL0(Lock_7_Release,Lock_7_Acquired,Lock_6_Release,Lock_6_Acquired,Lock_5_Release,Lock_5_Acquired,Lock_4_Release,Lock_4_Acquired,Lock_3_Release,Lock_3_Acquired,Lock_2_Release,Lock_2_Acquired,Lock_1_Release,Lock_1_Acquired,Lock_0_Release,Lock_0_Acquired)		(((Lock_7_Release&0x00000003)<<30)+((Lock_7_Acquired&0x00000003)<<28)+((Lock_6_Release&0x00000003)<<26)+((Lock_6_Acquired&0x00000003)<<24)+((Lock_5_Release&0x00000003)<<22)+((Lock_5_Acquired&0x00000003)<<20)+((Lock_4_Release&0x00000003)<<18)+((Lock_4_Acquired&0x00000003)<<16)+((Lock_3_Release&0x00000003)<<14)+((Lock_3_Acquired&0x00000003)<<12)+((Lock_2_Release&0x00000003)<<10)+((Lock_2_Acquired&0x00000003)<<8)+((Lock_1_Release&0x00000003)<<6)+((Lock_1_Acquired&0x00000003)<<4)+((Lock_0_Release&0x00000003)<<2)+(Lock_0_Acquired&0x00000003))

#define XAIEGBL_MEM_LOCKEVTVALCTRL1		0x0001EF24
#define XAIEGBL_MEM_LOCKEVTVALCTRL1WID		32
#define XAIEGBL_MEM_LOCKEVTVALCTRL1MSK		0xFFFFFFFF
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK15REL_LSB		30
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK15REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK15REL_MASK		0xC0000000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK15REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK15ACQ_LSB		28
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK15ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK15ACQ_MASK		0x30000000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK15ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK14REL_LSB		26
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK14REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK14REL_MASK		0x0C000000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK14REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK14ACQ_LSB		24
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK14ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK14ACQ_MASK		0x03000000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK14ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK13REL_LSB		22
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK13REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK13REL_MASK		0x00C00000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK13REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK13ACQ_LSB		20
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK13ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK13ACQ_MASK		0x00300000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK13ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK12REL_LSB		18
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK12REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK12REL_MASK		0x000C0000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK12REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK12ACQ_LSB		16
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK12ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK12ACQ_MASK		0x00030000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK12ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK11REL_LSB		14
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK11REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK11REL_MASK		0x0000C000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK11REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK11ACQ_LSB		12
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK11ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK11ACQ_MASK		0x00003000
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK11ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK10REL_LSB		10
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK10REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK10REL_MASK		0x00000C00
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK10REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK10ACQ_LSB		8
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK10ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK10ACQ_MASK		0x00000300
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK10ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK9REL_LSB		6
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK9REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK9REL_MASK		0x000000C0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK9REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK9ACQ_LSB		4
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK9ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK9ACQ_MASK		0x00000030
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK9ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK8REL_LSB		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK8REL_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK8REL_MASK		0x0000000C
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK8REL_DEFVAL		0x0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK8ACQ_LSB		0
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK8ACQ_WIDTH		2
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK8ACQ_MASK		0x00000003
#define XAIEGBL_MEM_LOCKEVTVALCTRL1_LOCK8ACQ_DEFVAL		0x0
#define XAIEGBL_MEM_VALUE_LOCKEVTVALCTRL1(Lock_15_Release,Lock_15_Acquired,Lock_14_Release,Lock_14_Acquired,Lock_13_Release,Lock_13_Acquired,Lock_12_Release,Lock_12_Acquired,Lock_11_Release,Lock_11_Acquired,Lock_10_Release,Lock_10_Acquired,Lock_9_Release,Lock_9_Acquired,Lock_8_Release,Lock_8_Acquired)		(((Lock_15_Release&0x00000003)<<30)+((Lock_15_Acquired&0x00000003)<<28)+((Lock_14_Release&0x00000003)<<26)+((Lock_14_Acquired&0x00000003)<<24)+((Lock_13_Release&0x00000003)<<22)+((Lock_13_Acquired&0x00000003)<<20)+((Lock_12_Release&0x00000003)<<18)+((Lock_12_Acquired&0x00000003)<<16)+((Lock_11_Release&0x00000003)<<14)+((Lock_11_Acquired&0x00000003)<<12)+((Lock_10_Release&0x00000003)<<10)+((Lock_10_Acquired&0x00000003)<<8)+((Lock_9_Release&0x00000003)<<6)+((Lock_9_Acquired&0x00000003)<<4)+((Lock_8_Release&0x00000003)<<2)+(Lock_8_Acquired&0x00000003))
/** @} */

/* Append new macros here */

/**
 * @name Core Module register definitions
 * This registers contains core module information
 * @{
 */
/**
 * Register:XAIEGBL_CORE_MODULE
 */
#define XAIEGBL_CORE_PRGMEM		0x00020000
#define XAIEGBL_CORE_PRGMEMWID		128
#define XAIEGBL_CORE_PRGMEM_A_LSB		0
#define XAIEGBL_CORE_PRGMEM_A_WIDTH		128
#define XAIEGBL_CORE_PRGMEM_A_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_PRGMEM_A_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PRGMEM(a)		((a&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_CORER0		0x00030000
#define XAIEGBL_CORE_CORER0WID		32
#define XAIEGBL_CORE_CORER0_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER0_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER0_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER0(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER1		0x00030010
#define XAIEGBL_CORE_CORER1WID		32
#define XAIEGBL_CORE_CORER1_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER1_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER1_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER1(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER2		0x00030020
#define XAIEGBL_CORE_CORER2WID		32
#define XAIEGBL_CORE_CORER2_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER2_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER2_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER2(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER3		0x00030030
#define XAIEGBL_CORE_CORER3WID		32
#define XAIEGBL_CORE_CORER3_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER3_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER3_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER3(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER4		0x00030040
#define XAIEGBL_CORE_CORER4WID		32
#define XAIEGBL_CORE_CORER4_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER4_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER4_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER4_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER4(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER5		0x00030050
#define XAIEGBL_CORE_CORER5WID		32
#define XAIEGBL_CORE_CORER5_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER5_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER5_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER5_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER5(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER6		0x00030060
#define XAIEGBL_CORE_CORER6WID		32
#define XAIEGBL_CORE_CORER6_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER6_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER6_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER6_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER6(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER7		0x00030070
#define XAIEGBL_CORE_CORER7WID		32
#define XAIEGBL_CORE_CORER7_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER7_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER7_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER7_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER7(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER8		0x00030080
#define XAIEGBL_CORE_CORER8WID		32
#define XAIEGBL_CORE_CORER8_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER8_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER8_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER8_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER8(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER9		0x00030090
#define XAIEGBL_CORE_CORER9WID		32
#define XAIEGBL_CORE_CORER9_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER9_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER9_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER9_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER9(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER10		0x000300A0
#define XAIEGBL_CORE_CORER10WID		32
#define XAIEGBL_CORE_CORER10_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER10_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER10_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER10_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER10(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER11		0x000300B0
#define XAIEGBL_CORE_CORER11WID		32
#define XAIEGBL_CORE_CORER11_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER11_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER11_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER11_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER11(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER12		0x000300C0
#define XAIEGBL_CORE_CORER12WID		32
#define XAIEGBL_CORE_CORER12_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER12_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER12_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER12_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER12(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER13		0x000300D0
#define XAIEGBL_CORE_CORER13WID		32
#define XAIEGBL_CORE_CORER13_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER13_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER13_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER13_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER13(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER14		0x000300E0
#define XAIEGBL_CORE_CORER14WID		32
#define XAIEGBL_CORE_CORER14_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER14_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER14_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER14_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER14(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORER15		0x000300F0
#define XAIEGBL_CORE_CORER15WID		32
#define XAIEGBL_CORE_CORER15_REGVAL_LSB		0
#define XAIEGBL_CORE_CORER15_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORER15_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORER15_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORER15(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_COREP0		0x00030100
#define XAIEGBL_CORE_COREP0WID		20
#define XAIEGBL_CORE_COREP0_REGVAL_LSB		0
#define XAIEGBL_CORE_COREP0_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREP0_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREP0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREP0(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREP1		0x00030110
#define XAIEGBL_CORE_COREP1WID		20
#define XAIEGBL_CORE_COREP1_REGVAL_LSB		0
#define XAIEGBL_CORE_COREP1_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREP1_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREP1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREP1(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREP2		0x00030120
#define XAIEGBL_CORE_COREP2WID		20
#define XAIEGBL_CORE_COREP2_REGVAL_LSB		0
#define XAIEGBL_CORE_COREP2_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREP2_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREP2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREP2(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREP3		0x00030130
#define XAIEGBL_CORE_COREP3WID		20
#define XAIEGBL_CORE_COREP3_REGVAL_LSB		0
#define XAIEGBL_CORE_COREP3_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREP3_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREP3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREP3(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREP4		0x00030140
#define XAIEGBL_CORE_COREP4WID		20
#define XAIEGBL_CORE_COREP4_REGVAL_LSB		0
#define XAIEGBL_CORE_COREP4_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREP4_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREP4_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREP4(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREP5		0x00030150
#define XAIEGBL_CORE_COREP5WID		20
#define XAIEGBL_CORE_COREP5_REGVAL_LSB		0
#define XAIEGBL_CORE_COREP5_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREP5_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREP5_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREP5(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREP6		0x00030160
#define XAIEGBL_CORE_COREP6WID		20
#define XAIEGBL_CORE_COREP6_REGVAL_LSB		0
#define XAIEGBL_CORE_COREP6_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREP6_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREP6_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREP6(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREP7		0x00030170
#define XAIEGBL_CORE_COREP7WID		20
#define XAIEGBL_CORE_COREP7_REGVAL_LSB		0
#define XAIEGBL_CORE_COREP7_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREP7_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREP7_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREP7(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECL0		0x00030180
#define XAIEGBL_CORE_CORECL0WID		32
#define XAIEGBL_CORE_CORECL0_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECL0_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECL0_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECL0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECL0(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECH0		0x00030190
#define XAIEGBL_CORE_CORECH0WID		32
#define XAIEGBL_CORE_CORECH0_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECH0_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECH0_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECH0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECH0(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECL1		0x000301A0
#define XAIEGBL_CORE_CORECL1WID		32
#define XAIEGBL_CORE_CORECL1_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECL1_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECL1_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECL1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECL1(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECH1		0x000301B0
#define XAIEGBL_CORE_CORECH1WID		32
#define XAIEGBL_CORE_CORECH1_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECH1_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECH1_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECH1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECH1(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECL2		0x000301C0
#define XAIEGBL_CORE_CORECL2WID		32
#define XAIEGBL_CORE_CORECL2_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECL2_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECL2_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECL2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECL2(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECH2		0x000301D0
#define XAIEGBL_CORE_CORECH2WID		32
#define XAIEGBL_CORE_CORECH2_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECH2_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECH2_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECH2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECH2(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECL3		0x000301E0
#define XAIEGBL_CORE_CORECL3WID		32
#define XAIEGBL_CORE_CORECL3_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECL3_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECL3_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECL3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECL3(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECH3		0x000301F0
#define XAIEGBL_CORE_CORECH3WID		32
#define XAIEGBL_CORE_CORECH3_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECH3_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECH3_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECH3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECH3(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECL4		0x00030200
#define XAIEGBL_CORE_CORECL4WID		32
#define XAIEGBL_CORE_CORECL4_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECL4_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECL4_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECL4_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECL4(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECH4		0x00030210
#define XAIEGBL_CORE_CORECH4WID		32
#define XAIEGBL_CORE_CORECH4_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECH4_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECH4_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECH4_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECH4(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECL5		0x00030220
#define XAIEGBL_CORE_CORECL5WID		32
#define XAIEGBL_CORE_CORECL5_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECL5_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECL5_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECL5_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECL5(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECH5		0x00030230
#define XAIEGBL_CORE_CORECH5WID		32
#define XAIEGBL_CORE_CORECH5_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECH5_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECH5_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECH5_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECH5(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECL6		0x00030240
#define XAIEGBL_CORE_CORECL6WID		32
#define XAIEGBL_CORE_CORECL6_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECL6_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECL6_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECL6_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECL6(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECH6		0x00030250
#define XAIEGBL_CORE_CORECH6WID		32
#define XAIEGBL_CORE_CORECH6_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECH6_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECH6_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECH6_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECH6(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECL7		0x00030260
#define XAIEGBL_CORE_CORECL7WID		32
#define XAIEGBL_CORE_CORECL7_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECL7_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECL7_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECL7_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECL7(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_CORECH7		0x00030270
#define XAIEGBL_CORE_CORECH7WID		32
#define XAIEGBL_CORE_CORECH7_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECH7_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORECH7_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORECH7_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECH7(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_COREPC		0x00030280
#define XAIEGBL_CORE_COREPCWID		20
#define XAIEGBL_CORE_COREPC_REGVAL_LSB		0
#define XAIEGBL_CORE_COREPC_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREPC_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREPC_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREPC(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREFC		0x00030290
#define XAIEGBL_CORE_COREFCWID		20
#define XAIEGBL_CORE_COREFC_REGVAL_LSB		0
#define XAIEGBL_CORE_COREFC_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREFC_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREFC_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREFC(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORESP		0x000302A0
#define XAIEGBL_CORE_CORESPWID		20
#define XAIEGBL_CORE_CORESP_REGVAL_LSB		0
#define XAIEGBL_CORE_CORESP_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORESP_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORESP_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORESP(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORELR		0x000302B0
#define XAIEGBL_CORE_CORELRWID		20
#define XAIEGBL_CORE_CORELR_REGVAL_LSB		0
#define XAIEGBL_CORE_CORELR_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORELR_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORELR_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORELR(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREM0		0x000302C0
#define XAIEGBL_CORE_COREM0WID		20
#define XAIEGBL_CORE_COREM0_REGVAL_LSB		0
#define XAIEGBL_CORE_COREM0_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREM0_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREM0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREM0(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREM1		0x000302D0
#define XAIEGBL_CORE_COREM1WID		20
#define XAIEGBL_CORE_COREM1_REGVAL_LSB		0
#define XAIEGBL_CORE_COREM1_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREM1_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREM1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREM1(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREM2		0x000302E0
#define XAIEGBL_CORE_COREM2WID		20
#define XAIEGBL_CORE_COREM2_REGVAL_LSB		0
#define XAIEGBL_CORE_COREM2_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREM2_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREM2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREM2(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREM3		0x000302F0
#define XAIEGBL_CORE_COREM3WID		20
#define XAIEGBL_CORE_COREM3_REGVAL_LSB		0
#define XAIEGBL_CORE_COREM3_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREM3_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREM3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREM3(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREM4		0x00030300
#define XAIEGBL_CORE_COREM4WID		20
#define XAIEGBL_CORE_COREM4_REGVAL_LSB		0
#define XAIEGBL_CORE_COREM4_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREM4_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREM4_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREM4(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREM5		0x00030310
#define XAIEGBL_CORE_COREM5WID		20
#define XAIEGBL_CORE_COREM5_REGVAL_LSB		0
#define XAIEGBL_CORE_COREM5_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREM5_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREM5_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREM5(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREM6		0x00030320
#define XAIEGBL_CORE_COREM6WID		20
#define XAIEGBL_CORE_COREM6_REGVAL_LSB		0
#define XAIEGBL_CORE_COREM6_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREM6_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREM6_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREM6(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREM7		0x00030330
#define XAIEGBL_CORE_COREM7WID		20
#define XAIEGBL_CORE_COREM7_REGVAL_LSB		0
#define XAIEGBL_CORE_COREM7_REGVAL_WIDTH		20
#define XAIEGBL_CORE_COREM7_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_COREM7_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREM7(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECB0		0x00030340
#define XAIEGBL_CORE_CORECB0WID		20
#define XAIEGBL_CORE_CORECB0_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECB0_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECB0_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECB0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECB0(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECB1		0x00030350
#define XAIEGBL_CORE_CORECB1WID		20
#define XAIEGBL_CORE_CORECB1_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECB1_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECB1_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECB1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECB1(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECB2		0x00030360
#define XAIEGBL_CORE_CORECB2WID		20
#define XAIEGBL_CORE_CORECB2_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECB2_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECB2_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECB2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECB2(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECB3		0x00030370
#define XAIEGBL_CORE_CORECB3WID		20
#define XAIEGBL_CORE_CORECB3_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECB3_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECB3_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECB3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECB3(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECB4		0x00030380
#define XAIEGBL_CORE_CORECB4WID		20
#define XAIEGBL_CORE_CORECB4_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECB4_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECB4_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECB4_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECB4(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECB5		0x00030390
#define XAIEGBL_CORE_CORECB5WID		20
#define XAIEGBL_CORE_CORECB5_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECB5_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECB5_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECB5_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECB5(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECB6		0x000303A0
#define XAIEGBL_CORE_CORECB6WID		20
#define XAIEGBL_CORE_CORECB6_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECB6_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECB6_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECB6_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECB6(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECB7		0x000303B0
#define XAIEGBL_CORE_CORECB7WID		20
#define XAIEGBL_CORE_CORECB7_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECB7_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECB7_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECB7_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECB7(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECS0		0x000303C0
#define XAIEGBL_CORE_CORECS0WID		20
#define XAIEGBL_CORE_CORECS0_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECS0_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECS0_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECS0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECS0(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECS1		0x000303D0
#define XAIEGBL_CORE_CORECS1WID		20
#define XAIEGBL_CORE_CORECS1_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECS1_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECS1_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECS1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECS1(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECS2		0x000303E0
#define XAIEGBL_CORE_CORECS2WID		20
#define XAIEGBL_CORE_CORECS2_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECS2_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECS2_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECS2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECS2(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECS3		0x000303F0
#define XAIEGBL_CORE_CORECS3WID		20
#define XAIEGBL_CORE_CORECS3_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECS3_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECS3_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECS3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECS3(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECS4		0x00030400
#define XAIEGBL_CORE_CORECS4WID		20
#define XAIEGBL_CORE_CORECS4_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECS4_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECS4_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECS4_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECS4(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECS5		0x00030410
#define XAIEGBL_CORE_CORECS5WID		20
#define XAIEGBL_CORE_CORECS5_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECS5_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECS5_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECS5_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECS5(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECS6		0x00030420
#define XAIEGBL_CORE_CORECS6WID		20
#define XAIEGBL_CORE_CORECS6_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECS6_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECS6_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECS6_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECS6(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORECS7		0x00030430
#define XAIEGBL_CORE_CORECS7WID		20
#define XAIEGBL_CORE_CORECS7_REGVAL_LSB		0
#define XAIEGBL_CORE_CORECS7_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORECS7_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORECS7_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECS7(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_COREMD0		0x00030440
#define XAIEGBL_CORE_COREMD0WID		32
#define XAIEGBL_CORE_COREMD0_FLOMULMSK_LSB		24
#define XAIEGBL_CORE_COREMD0_FLOMULMSK_WIDTH		8
#define XAIEGBL_CORE_COREMD0_FLOMULMSK_MASK		0xFF000000
#define XAIEGBL_CORE_COREMD0_FLOMULMSK_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD0_FLOADDMSK_LSB		16
#define XAIEGBL_CORE_COREMD0_FLOADDMSK_WIDTH		8
#define XAIEGBL_CORE_COREMD0_FLOADDMSK_MASK		0x00FF0000
#define XAIEGBL_CORE_COREMD0_FLOADDMSK_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD0_MDM_LSB		10
#define XAIEGBL_CORE_COREMD0_MDM_WIDTH		2
#define XAIEGBL_CORE_COREMD0_MDM_MASK		0x00000C00
#define XAIEGBL_CORE_COREMD0_MDM_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD0_MDS_LSB		8
#define XAIEGBL_CORE_COREMD0_MDS_WIDTH		2
#define XAIEGBL_CORE_COREMD0_MDS_MASK		0x00000300
#define XAIEGBL_CORE_COREMD0_MDS_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD0_SYMSATSEL_LSB		7
#define XAIEGBL_CORE_COREMD0_SYMSATSEL_WIDTH		1
#define XAIEGBL_CORE_COREMD0_SYMSATSEL_MASK		0x00000080
#define XAIEGBL_CORE_COREMD0_SYMSATSEL_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD0_RADSEL_LSB		4
#define XAIEGBL_CORE_COREMD0_RADSEL_WIDTH		3
#define XAIEGBL_CORE_COREMD0_RADSEL_MASK		0x00000070
#define XAIEGBL_CORE_COREMD0_RADSEL_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD0_ROUMODSEL_LSB		1
#define XAIEGBL_CORE_COREMD0_ROUMODSEL_WIDTH		3
#define XAIEGBL_CORE_COREMD0_ROUMODSEL_MASK		0x0000000E
#define XAIEGBL_CORE_COREMD0_ROUMODSEL_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD0_SATSEL_LSB		0
#define XAIEGBL_CORE_COREMD0_SATSEL_WIDTH		1
#define XAIEGBL_CORE_COREMD0_SATSEL_MASK		0x00000001
#define XAIEGBL_CORE_COREMD0_SATSEL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREMD0(Floating_Mul_Mask,Floating_Add_Mask,mdMS,mdSS,Symmetric_Saturation_Select,Radix_select,Round_Mode_Select,Saturation_Select)		(((Floating_Mul_Mask&0x000000ff)<<24)+((Floating_Add_Mask&0x000000ff)<<16)+((mdMS&0x00000003)<<10)+((mdSS&0x00000003)<<8)+((Symmetric_Saturation_Select&0x00000001)<<7)+((Radix_select&0x00000007)<<4)+((Round_Mode_Select&0x00000007)<<1)+(Saturation_Select&0x00000001))

#define XAIEGBL_CORE_COREMD1		0x00030450
#define XAIEGBL_CORE_COREMD1WID		32
#define XAIEGBL_CORE_COREMD1_FLOFLOTOFIXMSK_LSB		16
#define XAIEGBL_CORE_COREMD1_FLOFLOTOFIXMSK_WIDTH		8
#define XAIEGBL_CORE_COREMD1_FLOFLOTOFIXMSK_MASK		0x00FF0000
#define XAIEGBL_CORE_COREMD1_FLOFLOTOFIXMSK_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD1_FLOFIXTOFLOMSK_LSB		8
#define XAIEGBL_CORE_COREMD1_FLOFIXTOFLOMSK_WIDTH		8
#define XAIEGBL_CORE_COREMD1_FLOFIXTOFLOMSK_MASK		0x0000FF00
#define XAIEGBL_CORE_COREMD1_FLOFIXTOFLOMSK_DEFVAL		0x0
#define XAIEGBL_CORE_COREMD1_FLONONLINMSK_LSB		0
#define XAIEGBL_CORE_COREMD1_FLONONLINMSK_WIDTH		8
#define XAIEGBL_CORE_COREMD1_FLONONLINMSK_MASK		0x000000FF
#define XAIEGBL_CORE_COREMD1_FLONONLINMSK_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREMD1(Floating_Float_to_Fixed_Mask,Floating_Fixed_to_Float_Mask,Floating_Non_Linear_Mask)		(((Floating_Float_to_Fixed_Mask&0x000000ff)<<16)+((Floating_Fixed_to_Float_Mask&0x000000ff)<<8)+(Floating_Non_Linear_Mask&0x000000ff))

#define XAIEGBL_CORE_COREMC0		0x00030460
#define XAIEGBL_CORE_COREMC0WID		32
#define XAIEGBL_CORE_COREMC0_FLOMULEXC_LSB		24
#define XAIEGBL_CORE_COREMC0_FLOMULEXC_WIDTH		8
#define XAIEGBL_CORE_COREMC0_FLOMULEXC_MASK		0xFF000000
#define XAIEGBL_CORE_COREMC0_FLOMULEXC_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_FLOADDEXC_LSB		16
#define XAIEGBL_CORE_COREMC0_FLOADDEXC_WIDTH		8
#define XAIEGBL_CORE_COREMC0_FLOADDEXC_MASK		0x00FF0000
#define XAIEGBL_CORE_COREMC0_FLOADDEXC_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_UPSSAT_LSB		10
#define XAIEGBL_CORE_COREMC0_UPSSAT_WIDTH		1
#define XAIEGBL_CORE_COREMC0_UPSSAT_MASK		0x00000400
#define XAIEGBL_CORE_COREMC0_UPSSAT_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_SRSSAT_LSB		9
#define XAIEGBL_CORE_COREMC0_SRSSAT_WIDTH		1
#define XAIEGBL_CORE_COREMC0_SRSSAT_MASK		0x00000200
#define XAIEGBL_CORE_COREMC0_SRSSAT_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_MS1NBSC_LSB		8
#define XAIEGBL_CORE_COREMC0_MS1NBSC_WIDTH		1
#define XAIEGBL_CORE_COREMC0_MS1NBSC_MASK		0x00000100
#define XAIEGBL_CORE_COREMC0_MS1NBSC_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_MS0NBSC_LSB		7
#define XAIEGBL_CORE_COREMC0_MS0NBSC_WIDTH		1
#define XAIEGBL_CORE_COREMC0_MS0NBSC_MASK		0x00000080
#define XAIEGBL_CORE_COREMC0_MS0NBSC_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_SS1NBSC_LSB		6
#define XAIEGBL_CORE_COREMC0_SS1NBSC_WIDTH		1
#define XAIEGBL_CORE_COREMC0_SS1NBSC_MASK		0x00000040
#define XAIEGBL_CORE_COREMC0_SS1NBSC_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_SS0NBSC_LSB		5
#define XAIEGBL_CORE_COREMC0_SS0NBSC_WIDTH		1
#define XAIEGBL_CORE_COREMC0_SS0NBSC_MASK		0x00000020
#define XAIEGBL_CORE_COREMC0_SS0NBSC_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_WSS1TLA_LSB		4
#define XAIEGBL_CORE_COREMC0_WSS1TLA_WIDTH		1
#define XAIEGBL_CORE_COREMC0_WSS1TLA_MASK		0x00000010
#define XAIEGBL_CORE_COREMC0_WSS1TLA_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_WSS0TLA_LSB		3
#define XAIEGBL_CORE_COREMC0_WSS0TLA_WIDTH		1
#define XAIEGBL_CORE_COREMC0_WSS0TLA_MASK		0x00000008
#define XAIEGBL_CORE_COREMC0_WSS0TLA_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_SS1TLA_LSB		2
#define XAIEGBL_CORE_COREMC0_SS1TLA_WIDTH		1
#define XAIEGBL_CORE_COREMC0_SS1TLA_MASK		0x00000004
#define XAIEGBL_CORE_COREMC0_SS1TLA_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_SS0TLA_LSB		1
#define XAIEGBL_CORE_COREMC0_SS0TLA_WIDTH		1
#define XAIEGBL_CORE_COREMC0_SS0TLA_MASK		0x00000002
#define XAIEGBL_CORE_COREMC0_SS0TLA_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC0_CAR_LSB		0
#define XAIEGBL_CORE_COREMC0_CAR_WIDTH		1
#define XAIEGBL_CORE_COREMC0_CAR_MASK		0x00000001
#define XAIEGBL_CORE_COREMC0_CAR_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREMC0(Floating_Mul_exceptions,Floating_Add_exceptions,UPS_sat,SRS_sat,MS1_nb_sc,MS0_nb_sc,SS1_nb_sc,SS0_nb_sc,WSS1_tlast,WSS0_tlast,SS1_tlast,SS0_tlast,Carry)		(((Floating_Mul_exceptions&0x000000ff)<<24)+((Floating_Add_exceptions&0x000000ff)<<16)+((UPS_sat&0x00000001)<<10)+((SRS_sat&0x00000001)<<9)+((MS1_nb_sc&0x00000001)<<8)+((MS0_nb_sc&0x00000001)<<7)+((SS1_nb_sc&0x00000001)<<6)+((SS0_nb_sc&0x00000001)<<5)+((WSS1_tlast&0x00000001)<<4)+((WSS0_tlast&0x00000001)<<3)+((SS1_tlast&0x00000001)<<2)+((SS0_tlast&0x00000001)<<1)+(Carry&0x00000001))

#define XAIEGBL_CORE_COREMC1		0x00030470
#define XAIEGBL_CORE_COREMC1WID		32
#define XAIEGBL_CORE_COREMC1_FL2FXCNVEXC_LSB		16
#define XAIEGBL_CORE_COREMC1_FL2FXCNVEXC_WIDTH		8
#define XAIEGBL_CORE_COREMC1_FL2FXCNVEXC_MASK		0x00FF0000
#define XAIEGBL_CORE_COREMC1_FL2FXCNVEXC_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC1_FX2FLCNVEXC_LSB		8
#define XAIEGBL_CORE_COREMC1_FX2FLCNVEXC_WIDTH		8
#define XAIEGBL_CORE_COREMC1_FX2FLCNVEXC_MASK		0x0000FF00
#define XAIEGBL_CORE_COREMC1_FX2FLCNVEXC_DEFVAL		0x0
#define XAIEGBL_CORE_COREMC1_NLFEXC_LSB		0
#define XAIEGBL_CORE_COREMC1_NLFEXC_WIDTH		8
#define XAIEGBL_CORE_COREMC1_NLFEXC_MASK		0x000000FF
#define XAIEGBL_CORE_COREMC1_NLFEXC_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREMC1(Fl2Fx_Cnv_exceptions,Fx2fl_Cnv_exceptions,Nlf_exceptions)		(((Fl2Fx_Cnv_exceptions&0x000000ff)<<16)+((Fx2fl_Cnv_exceptions&0x000000ff)<<8)+(Nlf_exceptions&0x000000ff))

#define XAIEGBL_CORE_CORES0		0x00030480
#define XAIEGBL_CORE_CORES0WID		8
#define XAIEGBL_CORE_CORES0_REGVAL_LSB		0
#define XAIEGBL_CORE_CORES0_REGVAL_WIDTH		8
#define XAIEGBL_CORE_CORES0_REGVAL_MASK		0x000000FF
#define XAIEGBL_CORE_CORES0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORES0(Register_Value)		((Register_Value&0x000000ff))

#define XAIEGBL_CORE_CORES1		0x00030490
#define XAIEGBL_CORE_CORES1WID		8
#define XAIEGBL_CORE_CORES1_REGVAL_LSB		0
#define XAIEGBL_CORE_CORES1_REGVAL_WIDTH		8
#define XAIEGBL_CORE_CORES1_REGVAL_MASK		0x000000FF
#define XAIEGBL_CORE_CORES1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORES1(Register_Value)		((Register_Value&0x000000ff))

#define XAIEGBL_CORE_CORES2		0x000304A0
#define XAIEGBL_CORE_CORES2WID		8
#define XAIEGBL_CORE_CORES2_REGVAL_LSB		0
#define XAIEGBL_CORE_CORES2_REGVAL_WIDTH		8
#define XAIEGBL_CORE_CORES2_REGVAL_MASK		0x000000FF
#define XAIEGBL_CORE_CORES2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORES2(Register_Value)		((Register_Value&0x000000ff))

#define XAIEGBL_CORE_CORES3		0x000304B0
#define XAIEGBL_CORE_CORES3WID		8
#define XAIEGBL_CORE_CORES3_REGVAL_LSB		0
#define XAIEGBL_CORE_CORES3_REGVAL_WIDTH		8
#define XAIEGBL_CORE_CORES3_REGVAL_MASK		0x000000FF
#define XAIEGBL_CORE_CORES3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORES3(Register_Value)		((Register_Value&0x000000ff))

#define XAIEGBL_CORE_CORES4		0x000304C0
#define XAIEGBL_CORE_CORES4WID		8
#define XAIEGBL_CORE_CORES4_REGVAL_LSB		0
#define XAIEGBL_CORE_CORES4_REGVAL_WIDTH		8
#define XAIEGBL_CORE_CORES4_REGVAL_MASK		0x000000FF
#define XAIEGBL_CORE_CORES4_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORES4(Register_Value)		((Register_Value&0x000000ff))

#define XAIEGBL_CORE_CORES5		0x000304D0
#define XAIEGBL_CORE_CORES5WID		8
#define XAIEGBL_CORE_CORES5_REGVAL_LSB		0
#define XAIEGBL_CORE_CORES5_REGVAL_WIDTH		8
#define XAIEGBL_CORE_CORES5_REGVAL_MASK		0x000000FF
#define XAIEGBL_CORE_CORES5_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORES5(Register_Value)		((Register_Value&0x000000ff))

#define XAIEGBL_CORE_CORES6		0x000304E0
#define XAIEGBL_CORE_CORES6WID		8
#define XAIEGBL_CORE_CORES6_REGVAL_LSB		0
#define XAIEGBL_CORE_CORES6_REGVAL_WIDTH		8
#define XAIEGBL_CORE_CORES6_REGVAL_MASK		0x000000FF
#define XAIEGBL_CORE_CORES6_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORES6(Register_Value)		((Register_Value&0x000000ff))

#define XAIEGBL_CORE_CORES7		0x000304F0
#define XAIEGBL_CORE_CORES7WID		8
#define XAIEGBL_CORE_CORES7_REGVAL_LSB		0
#define XAIEGBL_CORE_CORES7_REGVAL_WIDTH		8
#define XAIEGBL_CORE_CORES7_REGVAL_MASK		0x000000FF
#define XAIEGBL_CORE_CORES7_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORES7(Register_Value)		((Register_Value&0x000000ff))

#define XAIEGBL_CORE_CORELS		0x00030500
#define XAIEGBL_CORE_CORELSWID		20
#define XAIEGBL_CORE_CORELS_REGVAL_LSB		0
#define XAIEGBL_CORE_CORELS_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORELS_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORELS_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORELS(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORELE		0x00030510
#define XAIEGBL_CORE_CORELEWID		20
#define XAIEGBL_CORE_CORELE_REGVAL_LSB		0
#define XAIEGBL_CORE_CORELE_REGVAL_WIDTH		20
#define XAIEGBL_CORE_CORELE_REGVAL_MASK		0x000FFFFF
#define XAIEGBL_CORE_CORELE_REGVAL_DEFVAL		0xFFFFF
#define XAIEGBL_CORE_VALUE_CORELE(Register_Value)		((Register_Value&0x000fffff))

#define XAIEGBL_CORE_CORELC		0x00030520
#define XAIEGBL_CORE_CORELCWID		32
#define XAIEGBL_CORE_CORELC_REGVAL_LSB		0
#define XAIEGBL_CORE_CORELC_REGVAL_WIDTH		32
#define XAIEGBL_CORE_CORELC_REGVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_CORELC_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORELC(Register_Value)		((Register_Value&0xffffffff))

#define XAIEGBL_CORE_COREVRL0		0x00030530
#define XAIEGBL_CORE_COREVRL0WID		128
#define XAIEGBL_CORE_COREVRL0_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVRL0_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVRL0_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVRL0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVRL0(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVRH0		0x00030540
#define XAIEGBL_CORE_COREVRH0WID		128
#define XAIEGBL_CORE_COREVRH0_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVRH0_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVRH0_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVRH0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVRH0(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVRL1		0x00030550
#define XAIEGBL_CORE_COREVRL1WID		128
#define XAIEGBL_CORE_COREVRL1_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVRL1_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVRL1_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVRL1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVRL1(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVRH1		0x00030560
#define XAIEGBL_CORE_COREVRH1WID		128
#define XAIEGBL_CORE_COREVRH1_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVRH1_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVRH1_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVRH1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVRH1(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVRL2		0x00030570
#define XAIEGBL_CORE_COREVRL2WID		128
#define XAIEGBL_CORE_COREVRL2_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVRL2_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVRL2_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVRL2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVRL2(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVRH2		0x00030580
#define XAIEGBL_CORE_COREVRH2WID		128
#define XAIEGBL_CORE_COREVRH2_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVRH2_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVRH2_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVRH2_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVRH2(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVRL3		0x00030590
#define XAIEGBL_CORE_COREVRL3WID		128
#define XAIEGBL_CORE_COREVRL3_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVRL3_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVRL3_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVRL3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVRL3(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVRH3		0x000305A0
#define XAIEGBL_CORE_COREVRH3WID		128
#define XAIEGBL_CORE_COREVRH3_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVRH3_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVRH3_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVRH3_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVRH3(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVCL0		0x000305B0
#define XAIEGBL_CORE_COREVCL0WID		128
#define XAIEGBL_CORE_COREVCL0_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVCL0_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVCL0_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVCL0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVCL0(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVCH0		0x000305C0
#define XAIEGBL_CORE_COREVCH0WID		128
#define XAIEGBL_CORE_COREVCH0_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVCH0_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVCH0_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVCH0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVCH0(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVCL1		0x000305D0
#define XAIEGBL_CORE_COREVCL1WID		128
#define XAIEGBL_CORE_COREVCL1_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVCL1_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVCL1_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVCL1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVCL1(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVCH1		0x000305E0
#define XAIEGBL_CORE_COREVCH1WID		128
#define XAIEGBL_CORE_COREVCH1_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVCH1_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVCH1_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVCH1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVCH1(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVDL0		0x000305F0
#define XAIEGBL_CORE_COREVDL0WID		128
#define XAIEGBL_CORE_COREVDL0_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVDL0_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVDL0_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVDL0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVDL0(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVDH0		0x00030600
#define XAIEGBL_CORE_COREVDH0WID		128
#define XAIEGBL_CORE_COREVDH0_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVDH0_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVDH0_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVDH0_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVDH0(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVDL1		0x00030610
#define XAIEGBL_CORE_COREVDL1WID		128
#define XAIEGBL_CORE_COREVDL1_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVDL1_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVDL1_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVDL1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVDL1(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREVDH1		0x00030620
#define XAIEGBL_CORE_COREVDH1WID		128
#define XAIEGBL_CORE_COREVDH1_REGVAL_LSB		0
#define XAIEGBL_CORE_COREVDH1_REGVAL_WIDTH		128
#define XAIEGBL_CORE_COREVDH1_REGVAL_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREVDH1_REGVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREVDH1(Register_Value)		((Register_Value&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML0PAR1		0x00030630
#define XAIEGBL_CORE_COREAML0PAR1WID		128
#define XAIEGBL_CORE_COREAML0PAR1_BIT1270_LSB		0
#define XAIEGBL_CORE_COREAML0PAR1_BIT1270_WIDTH		128
#define XAIEGBL_CORE_COREAML0PAR1_BIT1270_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML0PAR1_BIT1270_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML0PAR1(Bits127_0)		((Bits127_0&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML0PAR2		0x00030640
#define XAIEGBL_CORE_COREAML0PAR2WID		128
#define XAIEGBL_CORE_COREAML0PAR2_BIT255128_LSB		0
#define XAIEGBL_CORE_COREAML0PAR2_BIT255128_WIDTH		128
#define XAIEGBL_CORE_COREAML0PAR2_BIT255128_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML0PAR2_BIT255128_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML0PAR2(Bits255_128)		((Bits255_128&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML0PAR3		0x00030650
#define XAIEGBL_CORE_COREAML0PAR3WID		128
#define XAIEGBL_CORE_COREAML0PAR3_BIT383256_LSB		0
#define XAIEGBL_CORE_COREAML0PAR3_BIT383256_WIDTH		128
#define XAIEGBL_CORE_COREAML0PAR3_BIT383256_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML0PAR3_BIT383256_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML0PAR3(Bits383_256)		((Bits383_256&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH0PAR1		0x00030660
#define XAIEGBL_CORE_COREAMH0PAR1WID		128
#define XAIEGBL_CORE_COREAMH0PAR1_BIT1270_LSB		0
#define XAIEGBL_CORE_COREAMH0PAR1_BIT1270_WIDTH		128
#define XAIEGBL_CORE_COREAMH0PAR1_BIT1270_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH0PAR1_BIT1270_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH0PAR1(Bits127_0)		((Bits127_0&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH0PAR2		0x00030670
#define XAIEGBL_CORE_COREAMH0PAR2WID		128
#define XAIEGBL_CORE_COREAMH0PAR2_BIT255128_LSB		0
#define XAIEGBL_CORE_COREAMH0PAR2_BIT255128_WIDTH		128
#define XAIEGBL_CORE_COREAMH0PAR2_BIT255128_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH0PAR2_BIT255128_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH0PAR2(Bits255_128)		((Bits255_128&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH0PAR3		0x00030680
#define XAIEGBL_CORE_COREAMH0PAR3WID		128
#define XAIEGBL_CORE_COREAMH0PAR3_BIT383256_LSB		0
#define XAIEGBL_CORE_COREAMH0PAR3_BIT383256_WIDTH		128
#define XAIEGBL_CORE_COREAMH0PAR3_BIT383256_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH0PAR3_BIT383256_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH0PAR3(Bits383_256)		((Bits383_256&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML1PAR1		0x00030690
#define XAIEGBL_CORE_COREAML1PAR1WID		128
#define XAIEGBL_CORE_COREAML1PAR1_BIT1270_LSB		0
#define XAIEGBL_CORE_COREAML1PAR1_BIT1270_WIDTH		128
#define XAIEGBL_CORE_COREAML1PAR1_BIT1270_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML1PAR1_BIT1270_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML1PAR1(Bits127_0)		((Bits127_0&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML1PAR2		0x000306A0
#define XAIEGBL_CORE_COREAML1PAR2WID		128
#define XAIEGBL_CORE_COREAML1PAR2_BIT255128_LSB		0
#define XAIEGBL_CORE_COREAML1PAR2_BIT255128_WIDTH		128
#define XAIEGBL_CORE_COREAML1PAR2_BIT255128_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML1PAR2_BIT255128_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML1PAR2(Bits255_128)		((Bits255_128&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML1PAR3		0x000306B0
#define XAIEGBL_CORE_COREAML1PAR3WID		128
#define XAIEGBL_CORE_COREAML1PAR3_BIT383256_LSB		0
#define XAIEGBL_CORE_COREAML1PAR3_BIT383256_WIDTH		128
#define XAIEGBL_CORE_COREAML1PAR3_BIT383256_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML1PAR3_BIT383256_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML1PAR3(Bits383_256)		((Bits383_256&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH1PAR1		0x000306C0
#define XAIEGBL_CORE_COREAMH1PAR1WID		128
#define XAIEGBL_CORE_COREAMH1PAR1_BIT1270_LSB		0
#define XAIEGBL_CORE_COREAMH1PAR1_BIT1270_WIDTH		128
#define XAIEGBL_CORE_COREAMH1PAR1_BIT1270_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH1PAR1_BIT1270_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH1PAR1(Bits127_0)		((Bits127_0&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH1PAR2		0x000306D0
#define XAIEGBL_CORE_COREAMH1PAR2WID		128
#define XAIEGBL_CORE_COREAMH1PAR2_BIT255128_LSB		0
#define XAIEGBL_CORE_COREAMH1PAR2_BIT255128_WIDTH		128
#define XAIEGBL_CORE_COREAMH1PAR2_BIT255128_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH1PAR2_BIT255128_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH1PAR2(Bits255_128)		((Bits255_128&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH1PAR3		0x000306E0
#define XAIEGBL_CORE_COREAMH1PAR3WID		128
#define XAIEGBL_CORE_COREAMH1PAR3_BIT383256_LSB		0
#define XAIEGBL_CORE_COREAMH1PAR3_BIT383256_WIDTH		128
#define XAIEGBL_CORE_COREAMH1PAR3_BIT383256_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH1PAR3_BIT383256_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH1PAR3(Bits383_256)		((Bits383_256&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML2PAR1		0x000306F0
#define XAIEGBL_CORE_COREAML2PAR1WID		128
#define XAIEGBL_CORE_COREAML2PAR1_BIT1270_LSB		0
#define XAIEGBL_CORE_COREAML2PAR1_BIT1270_WIDTH		128
#define XAIEGBL_CORE_COREAML2PAR1_BIT1270_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML2PAR1_BIT1270_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML2PAR1(Bits127_0)		((Bits127_0&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML2PAR2		0x00030700
#define XAIEGBL_CORE_COREAML2PAR2WID		128
#define XAIEGBL_CORE_COREAML2PAR2_BIT255128_LSB		0
#define XAIEGBL_CORE_COREAML2PAR2_BIT255128_WIDTH		128
#define XAIEGBL_CORE_COREAML2PAR2_BIT255128_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML2PAR2_BIT255128_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML2PAR2(Bits255_128)		((Bits255_128&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML2PAR3		0x00030710
#define XAIEGBL_CORE_COREAML2PAR3WID		128
#define XAIEGBL_CORE_COREAML2PAR3_BIT383256_LSB		0
#define XAIEGBL_CORE_COREAML2PAR3_BIT383256_WIDTH		128
#define XAIEGBL_CORE_COREAML2PAR3_BIT383256_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML2PAR3_BIT383256_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML2PAR3(Bits383_256)		((Bits383_256&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH2PAR1		0x00030720
#define XAIEGBL_CORE_COREAMH2PAR1WID		128
#define XAIEGBL_CORE_COREAMH2PAR1_BIT1270_LSB		0
#define XAIEGBL_CORE_COREAMH2PAR1_BIT1270_WIDTH		128
#define XAIEGBL_CORE_COREAMH2PAR1_BIT1270_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH2PAR1_BIT1270_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH2PAR1(Bits127_0)		((Bits127_0&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH2PAR2		0x00030730
#define XAIEGBL_CORE_COREAMH2PAR2WID		128
#define XAIEGBL_CORE_COREAMH2PAR2_BIT255128_LSB		0
#define XAIEGBL_CORE_COREAMH2PAR2_BIT255128_WIDTH		128
#define XAIEGBL_CORE_COREAMH2PAR2_BIT255128_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH2PAR2_BIT255128_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH2PAR2(Bits255_128)		((Bits255_128&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH2PAR3		0x00030740
#define XAIEGBL_CORE_COREAMH2PAR3WID		128
#define XAIEGBL_CORE_COREAMH2PAR3_BIT383256_LSB		0
#define XAIEGBL_CORE_COREAMH2PAR3_BIT383256_WIDTH		128
#define XAIEGBL_CORE_COREAMH2PAR3_BIT383256_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH2PAR3_BIT383256_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH2PAR3(Bits383_256)		((Bits383_256&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML3PAR1		0x00030750
#define XAIEGBL_CORE_COREAML3PAR1WID		128
#define XAIEGBL_CORE_COREAML3PAR1_BIT1270_LSB		0
#define XAIEGBL_CORE_COREAML3PAR1_BIT1270_WIDTH		128
#define XAIEGBL_CORE_COREAML3PAR1_BIT1270_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML3PAR1_BIT1270_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML3PAR1(Bits127_0)		((Bits127_0&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML3PAR2		0x00030760
#define XAIEGBL_CORE_COREAML3PAR2WID		128
#define XAIEGBL_CORE_COREAML3PAR2_BIT255128_LSB		0
#define XAIEGBL_CORE_COREAML3PAR2_BIT255128_WIDTH		128
#define XAIEGBL_CORE_COREAML3PAR2_BIT255128_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML3PAR2_BIT255128_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML3PAR2(Bits255_128)		((Bits255_128&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAML3PAR3		0x00030770
#define XAIEGBL_CORE_COREAML3PAR3WID		128
#define XAIEGBL_CORE_COREAML3PAR3_BIT383256_LSB		0
#define XAIEGBL_CORE_COREAML3PAR3_BIT383256_WIDTH		128
#define XAIEGBL_CORE_COREAML3PAR3_BIT383256_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAML3PAR3_BIT383256_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAML3PAR3(Bits383_256)		((Bits383_256&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH3PAR1		0x00030780
#define XAIEGBL_CORE_COREAMH3PAR1WID		128
#define XAIEGBL_CORE_COREAMH3PAR1_BIT1270_LSB		0
#define XAIEGBL_CORE_COREAMH3PAR1_BIT1270_WIDTH		128
#define XAIEGBL_CORE_COREAMH3PAR1_BIT1270_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH3PAR1_BIT1270_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH3PAR1(Bits127_0)		((Bits127_0&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH3PAR2		0x00030790
#define XAIEGBL_CORE_COREAMH3PAR2WID		128
#define XAIEGBL_CORE_COREAMH3PAR2_BIT255128_LSB		0
#define XAIEGBL_CORE_COREAMH3PAR2_BIT255128_WIDTH		128
#define XAIEGBL_CORE_COREAMH3PAR2_BIT255128_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH3PAR2_BIT255128_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH3PAR2(Bits255_128)		((Bits255_128&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_COREAMH3PAR3		0x000307A0
#define XAIEGBL_CORE_COREAMH3PAR3WID		128
#define XAIEGBL_CORE_COREAMH3PAR3_BIT383256_LSB		0
#define XAIEGBL_CORE_COREAMH3PAR3_BIT383256_WIDTH		128
#define XAIEGBL_CORE_COREAMH3PAR3_BIT383256_MASK		0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIEGBL_CORE_COREAMH3PAR3_BIT383256_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COREAMH3PAR3(Bits383_256)		((Bits383_256&0xffffffffffffffffffffffffffffffff))

#define XAIEGBL_CORE_PERCTR0		0x00031000
#define XAIEGBL_CORE_PERCTR0WID		32
#define XAIEGBL_CORE_PERCTR0_CNT1STOPEVT_LSB		24
#define XAIEGBL_CORE_PERCTR0_CNT1STOPEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR0_CNT1STOPEVT_MASK		0x7F000000
#define XAIEGBL_CORE_PERCTR0_CNT1STOPEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR0_CNT1STAEVT_LSB		16
#define XAIEGBL_CORE_PERCTR0_CNT1STAEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR0_CNT1STAEVT_MASK		0x007F0000
#define XAIEGBL_CORE_PERCTR0_CNT1STAEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR0_CNT0STOPEVT_LSB		8
#define XAIEGBL_CORE_PERCTR0_CNT0STOPEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR0_CNT0STOPEVT_MASK		0x00007F00
#define XAIEGBL_CORE_PERCTR0_CNT0STOPEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR0_CNT0STAEVT_LSB		0
#define XAIEGBL_CORE_PERCTR0_CNT0STAEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR0_CNT0STAEVT_MASK		0x0000007F
#define XAIEGBL_CORE_PERCTR0_CNT0STAEVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCTR0(Cnt1_Stop_Event,Cnt1_Start_Event,Cnt0_Stop_Event,Cnt0_Start_Event)		(((Cnt1_Stop_Event&0x0000007f)<<24)+((Cnt1_Start_Event&0x0000007f)<<16)+((Cnt0_Stop_Event&0x0000007f)<<8)+(Cnt0_Start_Event&0x0000007f))

#define XAIEGBL_CORE_PERCTR1		0x00031004
#define XAIEGBL_CORE_PERCTR1WID		32
#define XAIEGBL_CORE_PERCTR1_CNT3STOPEVT_LSB		24
#define XAIEGBL_CORE_PERCTR1_CNT3STOPEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR1_CNT3STOPEVT_MASK		0x7F000000
#define XAIEGBL_CORE_PERCTR1_CNT3STOPEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR1_CNT3STAEVT_LSB		16
#define XAIEGBL_CORE_PERCTR1_CNT3STAEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR1_CNT3STAEVT_MASK		0x007F0000
#define XAIEGBL_CORE_PERCTR1_CNT3STAEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR1_CNT2STOPEVT_LSB		8
#define XAIEGBL_CORE_PERCTR1_CNT2STOPEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR1_CNT2STOPEVT_MASK		0x00007F00
#define XAIEGBL_CORE_PERCTR1_CNT2STOPEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR1_CNT2STAEVT_LSB		0
#define XAIEGBL_CORE_PERCTR1_CNT2STAEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR1_CNT2STAEVT_MASK		0x0000007F
#define XAIEGBL_CORE_PERCTR1_CNT2STAEVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCTR1(Cnt3_Stop_Event,Cnt3_Start_Event,Cnt2_Stop_Event,Cnt2_Start_Event)		(((Cnt3_Stop_Event&0x0000007f)<<24)+((Cnt3_Start_Event&0x0000007f)<<16)+((Cnt2_Stop_Event&0x0000007f)<<8)+(Cnt2_Start_Event&0x0000007f))

#define XAIEGBL_CORE_PERCTR2		0x00031008
#define XAIEGBL_CORE_PERCTR2WID		32
#define XAIEGBL_CORE_PERCTR2_CNT3RSTEVT_LSB		24
#define XAIEGBL_CORE_PERCTR2_CNT3RSTEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR2_CNT3RSTEVT_MASK		0x7F000000
#define XAIEGBL_CORE_PERCTR2_CNT3RSTEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR2_CNT2RSTEVT_LSB		16
#define XAIEGBL_CORE_PERCTR2_CNT2RSTEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR2_CNT2RSTEVT_MASK		0x007F0000
#define XAIEGBL_CORE_PERCTR2_CNT2RSTEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR2_CNT1RSTEVT_LSB		8
#define XAIEGBL_CORE_PERCTR2_CNT1RSTEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR2_CNT1RSTEVT_MASK		0x00007F00
#define XAIEGBL_CORE_PERCTR2_CNT1RSTEVT_DEFVAL		0x0
#define XAIEGBL_CORE_PERCTR2_CNT0RSTEVT_LSB		0
#define XAIEGBL_CORE_PERCTR2_CNT0RSTEVT_WIDTH		7
#define XAIEGBL_CORE_PERCTR2_CNT0RSTEVT_MASK		0x0000007F
#define XAIEGBL_CORE_PERCTR2_CNT0RSTEVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCTR2(Cnt3_Reset_Event,Cnt2_Reset_Event,Cnt1_Reset_Event,Cnt0_Reset_Event)		(((Cnt3_Reset_Event&0x0000007f)<<24)+((Cnt2_Reset_Event&0x0000007f)<<16)+((Cnt1_Reset_Event&0x0000007f)<<8)+(Cnt0_Reset_Event&0x0000007f))

#define XAIEGBL_CORE_PERCOU0		0x00031020
#define XAIEGBL_CORE_PERCOU0WID		32
#define XAIEGBL_CORE_PERCOU0_COU0VAL_LSB		0
#define XAIEGBL_CORE_PERCOU0_COU0VAL_WIDTH		32
#define XAIEGBL_CORE_PERCOU0_COU0VAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_PERCOU0_COU0VAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCOU0(Counter0_Value)		((Counter0_Value&0xffffffff))

#define XAIEGBL_CORE_PERCOU1		0x00031024
#define XAIEGBL_CORE_PERCOU1WID		32
#define XAIEGBL_CORE_PERCOU1_COU0VAL_LSB		0
#define XAIEGBL_CORE_PERCOU1_COU0VAL_WIDTH		32
#define XAIEGBL_CORE_PERCOU1_COU0VAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_PERCOU1_COU0VAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCOU1(Counter0_Value)		((Counter0_Value&0xffffffff))

#define XAIEGBL_CORE_PERCOU2		0x00031028
#define XAIEGBL_CORE_PERCOU2WID		32
#define XAIEGBL_CORE_PERCOU2_COU0VAL_LSB		0
#define XAIEGBL_CORE_PERCOU2_COU0VAL_WIDTH		32
#define XAIEGBL_CORE_PERCOU2_COU0VAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_PERCOU2_COU0VAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCOU2(Counter0_Value)		((Counter0_Value&0xffffffff))

#define XAIEGBL_CORE_PERCOU3		0x0003102C
#define XAIEGBL_CORE_PERCOU3WID		32
#define XAIEGBL_CORE_PERCOU3_COU0VAL_LSB		0
#define XAIEGBL_CORE_PERCOU3_COU0VAL_WIDTH		32
#define XAIEGBL_CORE_PERCOU3_COU0VAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_PERCOU3_COU0VAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCOU3(Counter0_Value)		((Counter0_Value&0xffffffff))

#define XAIEGBL_CORE_PERCOU0EVTVAL		0x00031080
#define XAIEGBL_CORE_PERCOU0EVTVALWID		32
#define XAIEGBL_CORE_PERCOU0EVTVAL_COUEVTVAL_LSB		0
#define XAIEGBL_CORE_PERCOU0EVTVAL_COUEVTVAL_WIDTH		32
#define XAIEGBL_CORE_PERCOU0EVTVAL_COUEVTVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_PERCOU0EVTVAL_COUEVTVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCOU0EVTVAL(Counter_Event_Value)		((Counter_Event_Value&0xffffffff))

#define XAIEGBL_CORE_PERCOU1EVTVAL		0x00031084
#define XAIEGBL_CORE_PERCOU1EVTVALWID		32
#define XAIEGBL_CORE_PERCOU1EVTVAL_COUEVTVAL_LSB		0
#define XAIEGBL_CORE_PERCOU1EVTVAL_COUEVTVAL_WIDTH		32
#define XAIEGBL_CORE_PERCOU1EVTVAL_COUEVTVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_PERCOU1EVTVAL_COUEVTVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCOU1EVTVAL(Counter_Event_Value)		((Counter_Event_Value&0xffffffff))

#define XAIEGBL_CORE_PERCOU2EVTVAL		0x00031088
#define XAIEGBL_CORE_PERCOU2EVTVALWID		32
#define XAIEGBL_CORE_PERCOU2EVTVAL_COUEVTVAL_LSB		0
#define XAIEGBL_CORE_PERCOU2EVTVAL_COUEVTVAL_WIDTH		32
#define XAIEGBL_CORE_PERCOU2EVTVAL_COUEVTVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_PERCOU2EVTVAL_COUEVTVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCOU2EVTVAL(Counter_Event_Value)		((Counter_Event_Value&0xffffffff))

#define XAIEGBL_CORE_PERCOU3EVTVAL		0x0003108C
#define XAIEGBL_CORE_PERCOU3EVTVALWID		32
#define XAIEGBL_CORE_PERCOU3EVTVAL_COUEVTVAL_LSB		0
#define XAIEGBL_CORE_PERCOU3EVTVAL_COUEVTVAL_WIDTH		32
#define XAIEGBL_CORE_PERCOU3EVTVAL_COUEVTVAL_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_PERCOU3EVTVAL_COUEVTVAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PERCOU3EVTVAL(Counter_Event_Value)		((Counter_Event_Value&0xffffffff))

#define XAIEGBL_CORE_CORECTRL		0x00032000
#define XAIEGBL_CORE_CORECTRLWID		32
#define XAIEGBL_CORE_CORECTRL_RST_LSB		1
#define XAIEGBL_CORE_CORECTRL_RST_WIDTH		1
#define XAIEGBL_CORE_CORECTRL_RST_MASK		0x00000002
#define XAIEGBL_CORE_CORECTRL_RST_DEFVAL		0x1
#define XAIEGBL_CORE_CORECTRL_ENA_LSB		0
#define XAIEGBL_CORE_CORECTRL_ENA_WIDTH		1
#define XAIEGBL_CORE_CORECTRL_ENA_MASK		0x00000001
#define XAIEGBL_CORE_CORECTRL_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORECTRL(Reset,Enable)		(((Reset&0x00000001)<<1)+(Enable&0x00000001))

#define XAIEGBL_CORE_CORESTA		0x00032004
#define XAIEGBL_CORE_CORESTAWID		32
#define XAIEGBL_CORE_CORESTA_COREDON_LSB		20
#define XAIEGBL_CORE_CORESTA_COREDON_WIDTH		1
#define XAIEGBL_CORE_CORESTA_COREDON_MASK		0x00100000
#define XAIEGBL_CORE_CORESTA_COREDON_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_ERRHLT_LSB		19
#define XAIEGBL_CORE_CORESTA_ERRHLT_WIDTH		1
#define XAIEGBL_CORE_CORESTA_ERRHLT_MASK		0x00080000
#define XAIEGBL_CORE_CORESTA_ERRHLT_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_ECCSCRSTAL_LSB		18
#define XAIEGBL_CORE_CORESTA_ECCSCRSTAL_WIDTH		1
#define XAIEGBL_CORE_CORESTA_ECCSCRSTAL_MASK		0x00040000
#define XAIEGBL_CORE_CORESTA_ECCSCRSTAL_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_ECCERRSTAL_LSB		17
#define XAIEGBL_CORE_CORESTA_ECCERRSTAL_WIDTH		1
#define XAIEGBL_CORE_CORESTA_ECCERRSTAL_MASK		0x00020000
#define XAIEGBL_CORE_CORESTA_ECCERRSTAL_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_DBGHLT_LSB		16
#define XAIEGBL_CORE_CORESTA_DBGHLT_WIDTH		1
#define XAIEGBL_CORE_CORESTA_DBGHLT_MASK		0x00010000
#define XAIEGBL_CORE_CORESTA_DBGHLT_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_CASSTALMCD_LSB		15
#define XAIEGBL_CORE_CORESTA_CASSTALMCD_WIDTH		1
#define XAIEGBL_CORE_CORESTA_CASSTALMCD_MASK		0x00008000
#define XAIEGBL_CORE_CORESTA_CASSTALMCD_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_CASSTALSCD_LSB		14
#define XAIEGBL_CORE_CORESTA_CASSTALSCD_WIDTH		1
#define XAIEGBL_CORE_CORESTA_CASSTALSCD_MASK		0x00004000
#define XAIEGBL_CORE_CORESTA_CASSTALSCD_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_STRSTALMS1_LSB		13
#define XAIEGBL_CORE_CORESTA_STRSTALMS1_WIDTH		1
#define XAIEGBL_CORE_CORESTA_STRSTALMS1_MASK		0x00002000
#define XAIEGBL_CORE_CORESTA_STRSTALMS1_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_STRSTALMS0_LSB		12
#define XAIEGBL_CORE_CORESTA_STRSTALMS0_WIDTH		1
#define XAIEGBL_CORE_CORESTA_STRSTALMS0_MASK		0x00001000
#define XAIEGBL_CORE_CORESTA_STRSTALMS0_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_STRSTALSS1_LSB		11
#define XAIEGBL_CORE_CORESTA_STRSTALSS1_WIDTH		1
#define XAIEGBL_CORE_CORESTA_STRSTALSS1_MASK		0x00000800
#define XAIEGBL_CORE_CORESTA_STRSTALSS1_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_STRSTALSS0_LSB		10
#define XAIEGBL_CORE_CORESTA_STRSTALSS0_WIDTH		1
#define XAIEGBL_CORE_CORESTA_STRSTALSS0_MASK		0x00000400
#define XAIEGBL_CORE_CORESTA_STRSTALSS0_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_LOCKSTALE_LSB		9
#define XAIEGBL_CORE_CORESTA_LOCKSTALE_WIDTH		1
#define XAIEGBL_CORE_CORESTA_LOCKSTALE_MASK		0x00000200
#define XAIEGBL_CORE_CORESTA_LOCKSTALE_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_LOCKSTALN_LSB		8
#define XAIEGBL_CORE_CORESTA_LOCKSTALN_WIDTH		1
#define XAIEGBL_CORE_CORESTA_LOCKSTALN_MASK		0x00000100
#define XAIEGBL_CORE_CORESTA_LOCKSTALN_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_LOCKSTALW_LSB		7
#define XAIEGBL_CORE_CORESTA_LOCKSTALW_WIDTH		1
#define XAIEGBL_CORE_CORESTA_LOCKSTALW_MASK		0x00000080
#define XAIEGBL_CORE_CORESTA_LOCKSTALW_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_LOCKSTALS_LSB		6
#define XAIEGBL_CORE_CORESTA_LOCKSTALS_WIDTH		1
#define XAIEGBL_CORE_CORESTA_LOCKSTALS_MASK		0x00000040
#define XAIEGBL_CORE_CORESTA_LOCKSTALS_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_MEMSTALE_LSB		5
#define XAIEGBL_CORE_CORESTA_MEMSTALE_WIDTH		1
#define XAIEGBL_CORE_CORESTA_MEMSTALE_MASK		0x00000020
#define XAIEGBL_CORE_CORESTA_MEMSTALE_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_MEMSTALN_LSB		4
#define XAIEGBL_CORE_CORESTA_MEMSTALN_WIDTH		1
#define XAIEGBL_CORE_CORESTA_MEMSTALN_MASK		0x00000010
#define XAIEGBL_CORE_CORESTA_MEMSTALN_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_MEMSTALW_LSB		3
#define XAIEGBL_CORE_CORESTA_MEMSTALW_WIDTH		1
#define XAIEGBL_CORE_CORESTA_MEMSTALW_MASK		0x00000008
#define XAIEGBL_CORE_CORESTA_MEMSTALW_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_MEMSTALS_LSB		2
#define XAIEGBL_CORE_CORESTA_MEMSTALS_WIDTH		1
#define XAIEGBL_CORE_CORESTA_MEMSTALS_MASK		0x00000004
#define XAIEGBL_CORE_CORESTA_MEMSTALS_DEFVAL		0x0
#define XAIEGBL_CORE_CORESTA_RST_LSB		1
#define XAIEGBL_CORE_CORESTA_RST_WIDTH		1
#define XAIEGBL_CORE_CORESTA_RST_MASK		0x00000002
#define XAIEGBL_CORE_CORESTA_RST_DEFVAL		0x1
#define XAIEGBL_CORE_CORESTA_ENA_LSB		0
#define XAIEGBL_CORE_CORESTA_ENA_WIDTH		1
#define XAIEGBL_CORE_CORESTA_ENA_MASK		0x00000001
#define XAIEGBL_CORE_CORESTA_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_CORESTA(Core_Done,Error_Halt,ECC_Scrubbing_Stall,ECC_Error_Stall,Debug_Halt,Cascade_Stall_MCD,Cascade_Stall_SCD,Stream_Stall_MS1,Stream_Stall_MS0,Stream_Stall_SS1,Stream_Stall_SS0,Lock_Stall_E,Lock_Stall_N,Lock_Stall_W,Lock_Stall_S,Memory_Stall_E,Memory_Stall_N,Memory_Stall_W,Memory_Stall_S,Reset,Enable)		(((Core_Done&0x00000001)<<20)+((Error_Halt&0x00000001)<<19)+((ECC_Scrubbing_Stall&0x00000001)<<18)+((ECC_Error_Stall&0x00000001)<<17)+((Debug_Halt&0x00000001)<<16)+((Cascade_Stall_MCD&0x00000001)<<15)+((Cascade_Stall_SCD&0x00000001)<<14)+((Stream_Stall_MS1&0x00000001)<<13)+((Stream_Stall_MS0&0x00000001)<<12)+((Stream_Stall_SS1&0x00000001)<<11)+((Stream_Stall_SS0&0x00000001)<<10)+((Lock_Stall_E&0x00000001)<<9)+((Lock_Stall_N&0x00000001)<<8)+((Lock_Stall_W&0x00000001)<<7)+((Lock_Stall_S&0x00000001)<<6)+((Memory_Stall_E&0x00000001)<<5)+((Memory_Stall_N&0x00000001)<<4)+((Memory_Stall_W&0x00000001)<<3)+((Memory_Stall_S&0x00000001)<<2)+((Reset&0x00000001)<<1)+(Enable&0x00000001))

#define XAIEGBL_CORE_ENAEVE		0x00032008
#define XAIEGBL_CORE_ENAEVEWID		32
#define XAIEGBL_CORE_ENAEVE_DISEVTOCC_LSB		15
#define XAIEGBL_CORE_ENAEVE_DISEVTOCC_WIDTH		1
#define XAIEGBL_CORE_ENAEVE_DISEVTOCC_MASK		0x00008000
#define XAIEGBL_CORE_ENAEVE_DISEVTOCC_DEFVAL		0x0
#define XAIEGBL_CORE_ENAEVE_DISEVT_LSB		8
#define XAIEGBL_CORE_ENAEVE_DISEVT_WIDTH		7
#define XAIEGBL_CORE_ENAEVE_DISEVT_MASK		0x00007F00
#define XAIEGBL_CORE_ENAEVE_DISEVT_DEFVAL		0x0
#define XAIEGBL_CORE_ENAEVE_ENAEVTOCC_LSB		7
#define XAIEGBL_CORE_ENAEVE_ENAEVTOCC_WIDTH		1
#define XAIEGBL_CORE_ENAEVE_ENAEVTOCC_MASK		0x00000080
#define XAIEGBL_CORE_ENAEVE_ENAEVTOCC_DEFVAL		0x0
#define XAIEGBL_CORE_ENAEVE_ENAEVT_LSB		0
#define XAIEGBL_CORE_ENAEVE_ENAEVT_WIDTH		7
#define XAIEGBL_CORE_ENAEVE_ENAEVT_MASK		0x0000007F
#define XAIEGBL_CORE_ENAEVE_ENAEVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_ENAEVE(Disable_Event_occurred,Disable_Event,Enable_Event_occurred,Enable_Event)		(((Disable_Event_occurred&0x00000001)<<15)+((Disable_Event&0x0000007f)<<8)+((Enable_Event_occurred&0x00000001)<<7)+(Enable_Event&0x0000007f))

#define XAIEGBL_CORE_RSTEVT		0x0003200C
#define XAIEGBL_CORE_RSTEVTWID		32
#define XAIEGBL_CORE_RSTEVT_RSTEVT_LSB		0
#define XAIEGBL_CORE_RSTEVT_RSTEVT_WIDTH		7
#define XAIEGBL_CORE_RSTEVT_RSTEVT_MASK		0x0000007F
#define XAIEGBL_CORE_RSTEVT_RSTEVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_RSTEVT(Reset_Event)		((Reset_Event&0x0000007f))

#define XAIEGBL_CORE_DBGCTRL0		0x00032010
#define XAIEGBL_CORE_DBGCTRL0WID		32
#define XAIEGBL_CORE_DBGCTRL0_SINSTECNT_LSB		2
#define XAIEGBL_CORE_DBGCTRL0_SINSTECNT_WIDTH		4
#define XAIEGBL_CORE_DBGCTRL0_SINSTECNT_MASK		0x0000003C
#define XAIEGBL_CORE_DBGCTRL0_SINSTECNT_DEFVAL		0x0
#define XAIEGBL_CORE_DBGCTRL0_DBGHLTBIT_LSB		0
#define XAIEGBL_CORE_DBGCTRL0_DBGHLTBIT_WIDTH		1
#define XAIEGBL_CORE_DBGCTRL0_DBGHLTBIT_MASK		0x00000001
#define XAIEGBL_CORE_DBGCTRL0_DBGHLTBIT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_DBGCTRL0(Single_Step_Count,Debug_Halt_Bit)		(((Single_Step_Count&0x0000000f)<<2)+(Debug_Halt_Bit&0x00000001))

#define XAIEGBL_CORE_DBGCTRL1		0x00032014
#define XAIEGBL_CORE_DBGCTRL1WID		32
#define XAIEGBL_CORE_DBGCTRL1_DBGHLTCOREEVT1_LSB		24
#define XAIEGBL_CORE_DBGCTRL1_DBGHLTCOREEVT1_WIDTH		7
#define XAIEGBL_CORE_DBGCTRL1_DBGHLTCOREEVT1_MASK		0x7F000000
#define XAIEGBL_CORE_DBGCTRL1_DBGHLTCOREEVT1_DEFVAL		0x0
#define XAIEGBL_CORE_DBGCTRL1_DBGHLTCOREEVT0_LSB		16
#define XAIEGBL_CORE_DBGCTRL1_DBGHLTCOREEVT0_WIDTH		7
#define XAIEGBL_CORE_DBGCTRL1_DBGHLTCOREEVT0_MASK		0x007F0000
#define XAIEGBL_CORE_DBGCTRL1_DBGHLTCOREEVT0_DEFVAL		0x0
#define XAIEGBL_CORE_DBGCTRL1_DBGSINCOREEVT_LSB		8
#define XAIEGBL_CORE_DBGCTRL1_DBGSINCOREEVT_WIDTH		7
#define XAIEGBL_CORE_DBGCTRL1_DBGSINCOREEVT_MASK		0x00007F00
#define XAIEGBL_CORE_DBGCTRL1_DBGSINCOREEVT_DEFVAL		0x0
#define XAIEGBL_CORE_DBGCTRL1_DBGRESCOREEVT_LSB		0
#define XAIEGBL_CORE_DBGCTRL1_DBGRESCOREEVT_WIDTH		7
#define XAIEGBL_CORE_DBGCTRL1_DBGRESCOREEVT_MASK		0x0000007F
#define XAIEGBL_CORE_DBGCTRL1_DBGRESCOREEVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_DBGCTRL1(Debug_Halt_Core_Event1,Debug_Halt_Core_Event0,Debug_SingleStep_Core_Event,Debug_Resume_Core_Event)		(((Debug_Halt_Core_Event1&0x0000007f)<<24)+((Debug_Halt_Core_Event0&0x0000007f)<<16)+((Debug_SingleStep_Core_Event&0x0000007f)<<8)+(Debug_Resume_Core_Event&0x0000007f))

#define XAIEGBL_CORE_DBGCTRL2		0x00032018
#define XAIEGBL_CORE_DBGCTRL2WID		32
#define XAIEGBL_CORE_DBGCTRL2_STRSTALHLT_LSB		3
#define XAIEGBL_CORE_DBGCTRL2_STRSTALHLT_WIDTH		1
#define XAIEGBL_CORE_DBGCTRL2_STRSTALHLT_MASK		0x00000008
#define XAIEGBL_CORE_DBGCTRL2_STRSTALHLT_DEFVAL		0x0
#define XAIEGBL_CORE_DBGCTRL2_LOCKSTALHLT_LSB		2
#define XAIEGBL_CORE_DBGCTRL2_LOCKSTALHLT_WIDTH		1
#define XAIEGBL_CORE_DBGCTRL2_LOCKSTALHLT_MASK		0x00000004
#define XAIEGBL_CORE_DBGCTRL2_LOCKSTALHLT_DEFVAL		0x0
#define XAIEGBL_CORE_DBGCTRL2_MEMSTALHLT_LSB		1
#define XAIEGBL_CORE_DBGCTRL2_MEMSTALHLT_WIDTH		1
#define XAIEGBL_CORE_DBGCTRL2_MEMSTALHLT_MASK		0x00000002
#define XAIEGBL_CORE_DBGCTRL2_MEMSTALHLT_DEFVAL		0x0
#define XAIEGBL_CORE_DBGCTRL2_PCEVTHLT_LSB		0
#define XAIEGBL_CORE_DBGCTRL2_PCEVTHLT_WIDTH		1
#define XAIEGBL_CORE_DBGCTRL2_PCEVTHLT_MASK		0x00000001
#define XAIEGBL_CORE_DBGCTRL2_PCEVTHLT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_DBGCTRL2(Stream_Stall_Halt,Lock_Stall_Halt,Memory_Stall_Halt,PC_Event_Halt)		(((Stream_Stall_Halt&0x00000001)<<3)+((Lock_Stall_Halt&0x00000001)<<2)+((Memory_Stall_Halt&0x00000001)<<1)+(PC_Event_Halt&0x00000001))

#define XAIEGBL_CORE_DBGSTA		0x0003201C
#define XAIEGBL_CORE_DBGSTAWID		32
#define XAIEGBL_CORE_DBGSTA_DBGEVT1HAL_LSB		6
#define XAIEGBL_CORE_DBGSTA_DBGEVT1HAL_WIDTH		1
#define XAIEGBL_CORE_DBGSTA_DBGEVT1HAL_MASK		0x00000040
#define XAIEGBL_CORE_DBGSTA_DBGEVT1HAL_DEFVAL		0x0
#define XAIEGBL_CORE_DBGSTA_DBGEVT0HAL_LSB		5
#define XAIEGBL_CORE_DBGSTA_DBGEVT0HAL_WIDTH		1
#define XAIEGBL_CORE_DBGSTA_DBGEVT0HAL_MASK		0x00000020
#define XAIEGBL_CORE_DBGSTA_DBGEVT0HAL_DEFVAL		0x0
#define XAIEGBL_CORE_DBGSTA_STRSTALHAL_LSB		4
#define XAIEGBL_CORE_DBGSTA_STRSTALHAL_WIDTH		1
#define XAIEGBL_CORE_DBGSTA_STRSTALHAL_MASK		0x00000010
#define XAIEGBL_CORE_DBGSTA_STRSTALHAL_DEFVAL		0x0
#define XAIEGBL_CORE_DBGSTA_LOCKSTALHAL_LSB		3
#define XAIEGBL_CORE_DBGSTA_LOCKSTALHAL_WIDTH		1
#define XAIEGBL_CORE_DBGSTA_LOCKSTALHAL_MASK		0x00000008
#define XAIEGBL_CORE_DBGSTA_LOCKSTALHAL_DEFVAL		0x0
#define XAIEGBL_CORE_DBGSTA_MEMSTALHAL_LSB		2
#define XAIEGBL_CORE_DBGSTA_MEMSTALHAL_WIDTH		1
#define XAIEGBL_CORE_DBGSTA_MEMSTALHAL_MASK		0x00000004
#define XAIEGBL_CORE_DBGSTA_MEMSTALHAL_DEFVAL		0x0
#define XAIEGBL_CORE_DBGSTA_PCEVTHAL_LSB		1
#define XAIEGBL_CORE_DBGSTA_PCEVTHAL_WIDTH		1
#define XAIEGBL_CORE_DBGSTA_PCEVTHAL_MASK		0x00000002
#define XAIEGBL_CORE_DBGSTA_PCEVTHAL_DEFVAL		0x0
#define XAIEGBL_CORE_DBGSTA_DBGHAL_LSB		0
#define XAIEGBL_CORE_DBGSTA_DBGHAL_WIDTH		1
#define XAIEGBL_CORE_DBGSTA_DBGHAL_MASK		0x00000001
#define XAIEGBL_CORE_DBGSTA_DBGHAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_DBGSTA(Debug_Event1_Halted,Debug_Event0_Halted,Stream_stall_Halted,Lock_Stall_Halted,Memory_Stall_Halted,PC_Event_halted,Debug_halted)		(((Debug_Event1_Halted&0x00000001)<<6)+((Debug_Event0_Halted&0x00000001)<<5)+((Stream_stall_Halted&0x00000001)<<4)+((Lock_Stall_Halted&0x00000001)<<3)+((Memory_Stall_Halted&0x00000001)<<2)+((PC_Event_halted&0x00000001)<<1)+(Debug_halted&0x00000001))

#define XAIEGBL_CORE_PCEVT0		0x00032020
#define XAIEGBL_CORE_PCEVT0WID		32
#define XAIEGBL_CORE_PCEVT0_VAL_LSB		31
#define XAIEGBL_CORE_PCEVT0_VAL_WIDTH		1
#define XAIEGBL_CORE_PCEVT0_VAL_MASK		0x80000000
#define XAIEGBL_CORE_PCEVT0_VAL_DEFVAL		0x0
#define XAIEGBL_CORE_PCEVT0_PCADD_LSB		0
#define XAIEGBL_CORE_PCEVT0_PCADD_WIDTH		14
#define XAIEGBL_CORE_PCEVT0_PCADD_MASK		0x00003FFF
#define XAIEGBL_CORE_PCEVT0_PCADD_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PCEVT0(Valid,PC_Address)		(((Valid&0x00000001)<<31)+(PC_Address&0x00003fff))

#define XAIEGBL_CORE_PCEVT1		0x00032024
#define XAIEGBL_CORE_PCEVT1WID		32
#define XAIEGBL_CORE_PCEVT1_VAL_LSB		31
#define XAIEGBL_CORE_PCEVT1_VAL_WIDTH		1
#define XAIEGBL_CORE_PCEVT1_VAL_MASK		0x80000000
#define XAIEGBL_CORE_PCEVT1_VAL_DEFVAL		0x0
#define XAIEGBL_CORE_PCEVT1_PCADD_LSB		0
#define XAIEGBL_CORE_PCEVT1_PCADD_WIDTH		14
#define XAIEGBL_CORE_PCEVT1_PCADD_MASK		0x00003FFF
#define XAIEGBL_CORE_PCEVT1_PCADD_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PCEVT1(Valid,PC_Address)		(((Valid&0x00000001)<<31)+(PC_Address&0x00003fff))

#define XAIEGBL_CORE_PCEVT2		0x00032028
#define XAIEGBL_CORE_PCEVT2WID		32
#define XAIEGBL_CORE_PCEVT2_VAL_LSB		31
#define XAIEGBL_CORE_PCEVT2_VAL_WIDTH		1
#define XAIEGBL_CORE_PCEVT2_VAL_MASK		0x80000000
#define XAIEGBL_CORE_PCEVT2_VAL_DEFVAL		0x0
#define XAIEGBL_CORE_PCEVT2_PCADD_LSB		0
#define XAIEGBL_CORE_PCEVT2_PCADD_WIDTH		14
#define XAIEGBL_CORE_PCEVT2_PCADD_MASK		0x00003FFF
#define XAIEGBL_CORE_PCEVT2_PCADD_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PCEVT2(Valid,PC_Address)		(((Valid&0x00000001)<<31)+(PC_Address&0x00003fff))

#define XAIEGBL_CORE_PCEVT3		0x0003202C
#define XAIEGBL_CORE_PCEVT3WID		32
#define XAIEGBL_CORE_PCEVT3_VAL_LSB		31
#define XAIEGBL_CORE_PCEVT3_VAL_WIDTH		1
#define XAIEGBL_CORE_PCEVT3_VAL_MASK		0x80000000
#define XAIEGBL_CORE_PCEVT3_VAL_DEFVAL		0x0
#define XAIEGBL_CORE_PCEVT3_PCADD_LSB		0
#define XAIEGBL_CORE_PCEVT3_PCADD_WIDTH		14
#define XAIEGBL_CORE_PCEVT3_PCADD_MASK		0x00003FFF
#define XAIEGBL_CORE_PCEVT3_PCADD_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_PCEVT3(Valid,PC_Address)		(((Valid&0x00000001)<<31)+(PC_Address&0x00003fff))

#define XAIEGBL_CORE_TIMCTRL		0x00034000
#define XAIEGBL_CORE_TIMCTRLWID		32
#define XAIEGBL_CORE_TIMCTRL_RST_LSB		31
#define XAIEGBL_CORE_TIMCTRL_RST_WIDTH		1
#define XAIEGBL_CORE_TIMCTRL_RST_MASK		0x80000000
#define XAIEGBL_CORE_TIMCTRL_RST_DEFVAL		0x0
#define XAIEGBL_CORE_TIMCTRL_RSTEVT_LSB		8
#define XAIEGBL_CORE_TIMCTRL_RSTEVT_WIDTH		7
#define XAIEGBL_CORE_TIMCTRL_RSTEVT_MASK		0x00007F00
#define XAIEGBL_CORE_TIMCTRL_RSTEVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TIMCTRL(Reset,Reset_Event)		(((Reset&0x00000001)<<31)+((Reset_Event&0x0000007f)<<8))

#define XAIEGBL_CORE_EVTGEN		0x00034008
#define XAIEGBL_CORE_EVTGENWID		32
#define XAIEGBL_CORE_EVTGEN_EVT_LSB		0
#define XAIEGBL_CORE_EVTGEN_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTGEN_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTGEN_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTGEN(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST0		0x00034010
#define XAIEGBL_CORE_EVTBRDCAST0WID		32
#define XAIEGBL_CORE_EVTBRDCAST0_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST0_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST0_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST0_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST0(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST1		0x00034014
#define XAIEGBL_CORE_EVTBRDCAST1WID		32
#define XAIEGBL_CORE_EVTBRDCAST1_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST1_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST1_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST1_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST1(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST2		0x00034018
#define XAIEGBL_CORE_EVTBRDCAST2WID		32
#define XAIEGBL_CORE_EVTBRDCAST2_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST2_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST2_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST2_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST2(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST3		0x0003401C
#define XAIEGBL_CORE_EVTBRDCAST3WID		32
#define XAIEGBL_CORE_EVTBRDCAST3_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST3_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST3_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST3_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST3(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST4		0x00034020
#define XAIEGBL_CORE_EVTBRDCAST4WID		32
#define XAIEGBL_CORE_EVTBRDCAST4_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST4_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST4_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST4_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST4(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST5		0x00034024
#define XAIEGBL_CORE_EVTBRDCAST5WID		32
#define XAIEGBL_CORE_EVTBRDCAST5_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST5_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST5_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST5_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST5(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST6		0x00034028
#define XAIEGBL_CORE_EVTBRDCAST6WID		32
#define XAIEGBL_CORE_EVTBRDCAST6_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST6_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST6_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST6_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST6(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST7		0x0003402C
#define XAIEGBL_CORE_EVTBRDCAST7WID		32
#define XAIEGBL_CORE_EVTBRDCAST7_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST7_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST7_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST7_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST7(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST8		0x00034030
#define XAIEGBL_CORE_EVTBRDCAST8WID		32
#define XAIEGBL_CORE_EVTBRDCAST8_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST8_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST8_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST8_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST8(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST9		0x00034034
#define XAIEGBL_CORE_EVTBRDCAST9WID		32
#define XAIEGBL_CORE_EVTBRDCAST9_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST9_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST9_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST9_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST9(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST10		0x00034038
#define XAIEGBL_CORE_EVTBRDCAST10WID		32
#define XAIEGBL_CORE_EVTBRDCAST10_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST10_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST10_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST10_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST10(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST11		0x0003403C
#define XAIEGBL_CORE_EVTBRDCAST11WID		32
#define XAIEGBL_CORE_EVTBRDCAST11_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST11_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST11_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST11_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST11(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST12		0x00034040
#define XAIEGBL_CORE_EVTBRDCAST12WID		32
#define XAIEGBL_CORE_EVTBRDCAST12_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST12_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST12_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST12_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST12(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST13		0x00034044
#define XAIEGBL_CORE_EVTBRDCAST13WID		32
#define XAIEGBL_CORE_EVTBRDCAST13_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST13_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST13_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST13_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST13(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST14		0x00034048
#define XAIEGBL_CORE_EVTBRDCAST14WID		32
#define XAIEGBL_CORE_EVTBRDCAST14_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST14_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST14_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST14_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST14(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCAST15		0x0003404C
#define XAIEGBL_CORE_EVTBRDCAST15WID		32
#define XAIEGBL_CORE_EVTBRDCAST15_EVT_LSB		0
#define XAIEGBL_CORE_EVTBRDCAST15_EVT_WIDTH		7
#define XAIEGBL_CORE_EVTBRDCAST15_EVT_MASK		0x0000007F
#define XAIEGBL_CORE_EVTBRDCAST15_EVT_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCAST15(Event)		((Event&0x0000007f))

#define XAIEGBL_CORE_EVTBRDCASTBLKSOUSET		0x00034050
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUSETWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUSET_SET_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUSET_SET_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUSET_SET_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUSET_SET_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKSOUSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKSOUCLR		0x00034054
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUCLRWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUCLR_CLR_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUCLR_CLR_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUCLR_CLR_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKSOUCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKSOUVAL		0x00034058
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUVALWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUVAL_VAL_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUVAL_VAL_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKSOUVAL_VAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKSOUVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKWESSET		0x00034060
#define XAIEGBL_CORE_EVTBRDCASTBLKWESSETWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKWESSET_SET_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKWESSET_SET_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKWESSET_SET_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKWESSET_SET_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKWESSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKWESCLR		0x00034064
#define XAIEGBL_CORE_EVTBRDCASTBLKWESCLRWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKWESCLR_CLR_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKWESCLR_CLR_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKWESCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKWESCLR_CLR_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKWESCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKWESVAL		0x00034068
#define XAIEGBL_CORE_EVTBRDCASTBLKWESVALWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKWESVAL_VAL_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKWESVAL_VAL_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKWESVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKWESVAL_VAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKWESVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKNORSET		0x00034070
#define XAIEGBL_CORE_EVTBRDCASTBLKNORSETWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKNORSET_SET_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKNORSET_SET_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKNORSET_SET_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKNORSET_SET_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKNORSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKNORCLR		0x00034074
#define XAIEGBL_CORE_EVTBRDCASTBLKNORCLRWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKNORCLR_CLR_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKNORCLR_CLR_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKNORCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKNORCLR_CLR_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKNORCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKNORVAL		0x00034078
#define XAIEGBL_CORE_EVTBRDCASTBLKNORVALWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKNORVAL_VAL_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKNORVAL_VAL_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKNORVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKNORVAL_VAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKNORVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKEASSET		0x00034080
#define XAIEGBL_CORE_EVTBRDCASTBLKEASSETWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKEASSET_SET_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKEASSET_SET_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKEASSET_SET_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKEASSET_SET_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKEASSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKEASCLR		0x00034084
#define XAIEGBL_CORE_EVTBRDCASTBLKEASCLRWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKEASCLR_CLR_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKEASCLR_CLR_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKEASCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKEASCLR_CLR_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKEASCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_CORE_EVTBRDCASTBLKEASVAL		0x00034088
#define XAIEGBL_CORE_EVTBRDCASTBLKEASVALWID		32
#define XAIEGBL_CORE_EVTBRDCASTBLKEASVAL_VAL_LSB		0
#define XAIEGBL_CORE_EVTBRDCASTBLKEASVAL_VAL_WIDTH		16
#define XAIEGBL_CORE_EVTBRDCASTBLKEASVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_CORE_EVTBRDCASTBLKEASVAL_VAL_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTBRDCASTBLKEASVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_CORE_TRACTRL0		0x000340D0
#define XAIEGBL_CORE_TRACTRL0WID		32
#define XAIEGBL_CORE_TRACTRL0_TRASTOPEVT_LSB		24
#define XAIEGBL_CORE_TRACTRL0_TRASTOPEVT_WIDTH		7
#define XAIEGBL_CORE_TRACTRL0_TRASTOPEVT_MASK		0x7F000000
#define XAIEGBL_CORE_TRACTRL0_TRASTOPEVT_DEFVAL		0x0
#define XAIEGBL_CORE_TRACTRL0_TRASTAEVT_LSB		16
#define XAIEGBL_CORE_TRACTRL0_TRASTAEVT_WIDTH		7
#define XAIEGBL_CORE_TRACTRL0_TRASTAEVT_MASK		0x007F0000
#define XAIEGBL_CORE_TRACTRL0_TRASTAEVT_DEFVAL		0x0
#define XAIEGBL_CORE_TRACTRL0_MOD_LSB		0
#define XAIEGBL_CORE_TRACTRL0_MOD_WIDTH		3
#define XAIEGBL_CORE_TRACTRL0_MOD_MASK		0x00000007
#define XAIEGBL_CORE_TRACTRL0_MOD_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TRACTRL0(Trace_Stop_Event,Trace_Start_Event,Mode)		(((Trace_Stop_Event&0x0000007f)<<24)+((Trace_Start_Event&0x0000007f)<<16)+(Mode&0x00000007))

#define XAIEGBL_CORE_TRACTRL1		0x000340D4
#define XAIEGBL_CORE_TRACTRL1WID		32
#define XAIEGBL_CORE_TRACTRL1_PKTTYP_LSB		12
#define XAIEGBL_CORE_TRACTRL1_PKTTYP_WIDTH		3
#define XAIEGBL_CORE_TRACTRL1_PKTTYP_MASK		0x00007000
#define XAIEGBL_CORE_TRACTRL1_PKTTYP_DEFVAL		0x0
#define XAIEGBL_CORE_TRACTRL1_ID_LSB		0
#define XAIEGBL_CORE_TRACTRL1_ID_WIDTH		5
#define XAIEGBL_CORE_TRACTRL1_ID_MASK		0x0000001F
#define XAIEGBL_CORE_TRACTRL1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TRACTRL1(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_CORE_TRASTA		0x000340D8
#define XAIEGBL_CORE_TRASTAWID		32
#define XAIEGBL_CORE_TRASTA_STA_LSB		8
#define XAIEGBL_CORE_TRASTA_STA_WIDTH		2
#define XAIEGBL_CORE_TRASTA_STA_MASK		0x00000300
#define XAIEGBL_CORE_TRASTA_STA_DEFVAL		0x0
#define XAIEGBL_CORE_TRASTA_MOD_LSB		0
#define XAIEGBL_CORE_TRASTA_MOD_WIDTH		3
#define XAIEGBL_CORE_TRASTA_MOD_MASK		0x00000007
#define XAIEGBL_CORE_TRASTA_MOD_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TRASTA(State,Mode)		(((State&0x00000003)<<8)+(Mode&0x00000007))

#define XAIEGBL_CORE_TRAEVT0		0x000340E0
#define XAIEGBL_CORE_TRAEVT0WID		32
#define XAIEGBL_CORE_TRAEVT0_TRAEVT3_LSB		24
#define XAIEGBL_CORE_TRAEVT0_TRAEVT3_WIDTH		7
#define XAIEGBL_CORE_TRAEVT0_TRAEVT3_MASK		0x7F000000
#define XAIEGBL_CORE_TRAEVT0_TRAEVT3_DEFVAL		0x0
#define XAIEGBL_CORE_TRAEVT0_TRAEVT2_LSB		16
#define XAIEGBL_CORE_TRAEVT0_TRAEVT2_WIDTH		7
#define XAIEGBL_CORE_TRAEVT0_TRAEVT2_MASK		0x007F0000
#define XAIEGBL_CORE_TRAEVT0_TRAEVT2_DEFVAL		0x0
#define XAIEGBL_CORE_TRAEVT0_TRAEVT1_LSB		8
#define XAIEGBL_CORE_TRAEVT0_TRAEVT1_WIDTH		7
#define XAIEGBL_CORE_TRAEVT0_TRAEVT1_MASK		0x00007F00
#define XAIEGBL_CORE_TRAEVT0_TRAEVT1_DEFVAL		0x0
#define XAIEGBL_CORE_TRAEVT0_TRAEVT0_LSB		0
#define XAIEGBL_CORE_TRAEVT0_TRAEVT0_WIDTH		7
#define XAIEGBL_CORE_TRAEVT0_TRAEVT0_MASK		0x0000007F
#define XAIEGBL_CORE_TRAEVT0_TRAEVT0_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TRAEVT0(Trace_Event3,Trace_Event2,Trace_Event1,Trace_Event0)		(((Trace_Event3&0x0000007f)<<24)+((Trace_Event2&0x0000007f)<<16)+((Trace_Event1&0x0000007f)<<8)+(Trace_Event0&0x0000007f))

#define XAIEGBL_CORE_TRAEVT1		0x000340E4
#define XAIEGBL_CORE_TRAEVT1WID		32
#define XAIEGBL_CORE_TRAEVT1_TRAEVT7_LSB		24
#define XAIEGBL_CORE_TRAEVT1_TRAEVT7_WIDTH		7
#define XAIEGBL_CORE_TRAEVT1_TRAEVT7_MASK		0x7F000000
#define XAIEGBL_CORE_TRAEVT1_TRAEVT7_DEFVAL		0x0
#define XAIEGBL_CORE_TRAEVT1_TRAEVT6_LSB		16
#define XAIEGBL_CORE_TRAEVT1_TRAEVT6_WIDTH		7
#define XAIEGBL_CORE_TRAEVT1_TRAEVT6_MASK		0x007F0000
#define XAIEGBL_CORE_TRAEVT1_TRAEVT6_DEFVAL		0x0
#define XAIEGBL_CORE_TRAEVT1_TRAEVT5_LSB		8
#define XAIEGBL_CORE_TRAEVT1_TRAEVT5_WIDTH		7
#define XAIEGBL_CORE_TRAEVT1_TRAEVT5_MASK		0x00007F00
#define XAIEGBL_CORE_TRAEVT1_TRAEVT5_DEFVAL		0x0
#define XAIEGBL_CORE_TRAEVT1_TRAEVT4_LSB		0
#define XAIEGBL_CORE_TRAEVT1_TRAEVT4_WIDTH		7
#define XAIEGBL_CORE_TRAEVT1_TRAEVT4_MASK		0x0000007F
#define XAIEGBL_CORE_TRAEVT1_TRAEVT4_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TRAEVT1(Trace_Event7,Trace_Event6,Trace_Event5,Trace_Event4)		(((Trace_Event7&0x0000007f)<<24)+((Trace_Event6&0x0000007f)<<16)+((Trace_Event5&0x0000007f)<<8)+(Trace_Event4&0x0000007f))

#define XAIEGBL_CORE_TIMTRIEVTLOWVAL		0x000340F0
#define XAIEGBL_CORE_TIMTRIEVTLOWVALWID		32
#define XAIEGBL_CORE_TIMTRIEVTLOWVAL_TIM_LSB		0
#define XAIEGBL_CORE_TIMTRIEVTLOWVAL_TIM_WIDTH		32
#define XAIEGBL_CORE_TIMTRIEVTLOWVAL_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_TIMTRIEVTLOWVAL_TIM_DEFVAL		0xFFFFFFFF
#define XAIEGBL_CORE_VALUE_TIMTRIEVTLOWVAL(TimerTrigLow)		((TimerTrigLow&0xffffffff))

#define XAIEGBL_CORE_TIMTRIEVTHIGVAL		0x000340F4
#define XAIEGBL_CORE_TIMTRIEVTHIGVALWID		32
#define XAIEGBL_CORE_TIMTRIEVTHIGVAL_TIM_LSB		0
#define XAIEGBL_CORE_TIMTRIEVTHIGVAL_TIM_WIDTH		32
#define XAIEGBL_CORE_TIMTRIEVTHIGVAL_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_TIMTRIEVTHIGVAL_TIM_DEFVAL		0xFFFFFFFF
#define XAIEGBL_CORE_VALUE_TIMTRIEVTHIGVAL(TimerTrigHigh)		((TimerTrigHigh&0xffffffff))

#define XAIEGBL_CORE_TIMLOW		0x000340F8
#define XAIEGBL_CORE_TIMLOWWID		32
#define XAIEGBL_CORE_TIMLOW_TIM_LSB		0
#define XAIEGBL_CORE_TIMLOW_TIM_WIDTH		32
#define XAIEGBL_CORE_TIMLOW_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_TIMLOW_TIM_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TIMLOW(TimerLow)		((TimerLow&0xffffffff))

#define XAIEGBL_CORE_TIMHIG		0x000340FC
#define XAIEGBL_CORE_TIMHIGWID		32
#define XAIEGBL_CORE_TIMHIG_TIM_LSB		0
#define XAIEGBL_CORE_TIMHIG_TIM_WIDTH		32
#define XAIEGBL_CORE_TIMHIG_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_TIMHIG_TIM_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TIMHIG(TimerHigh)		((TimerHigh&0xffffffff))

#define XAIEGBL_CORE_EVTSTA0		0x00034200
#define XAIEGBL_CORE_EVTSTA0WID		32
#define XAIEGBL_CORE_EVTSTA0_EVT310STA_LSB		0
#define XAIEGBL_CORE_EVTSTA0_EVT310STA_WIDTH		32
#define XAIEGBL_CORE_EVTSTA0_EVT310STA_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_EVTSTA0_EVT310STA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTSTA0(Event_31_0_Status)		((Event_31_0_Status&0xffffffff))

#define XAIEGBL_CORE_EVTSTA1		0x00034204
#define XAIEGBL_CORE_EVTSTA1WID		32
#define XAIEGBL_CORE_EVTSTA1_EVT6332STA_LSB		0
#define XAIEGBL_CORE_EVTSTA1_EVT6332STA_WIDTH		32
#define XAIEGBL_CORE_EVTSTA1_EVT6332STA_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_EVTSTA1_EVT6332STA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTSTA1(Event_63_32_Status)		((Event_63_32_Status&0xffffffff))

#define XAIEGBL_CORE_EVTSTA2		0x00034208
#define XAIEGBL_CORE_EVTSTA2WID		32
#define XAIEGBL_CORE_EVTSTA2_EVT9564STA_LSB		0
#define XAIEGBL_CORE_EVTSTA2_EVT9564STA_WIDTH		32
#define XAIEGBL_CORE_EVTSTA2_EVT9564STA_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_EVTSTA2_EVT9564STA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTSTA2(Event_95_64_Status)		((Event_95_64_Status&0xffffffff))

#define XAIEGBL_CORE_EVTSTA3		0x0003420C
#define XAIEGBL_CORE_EVTSTA3WID		32
#define XAIEGBL_CORE_EVTSTA3_EVT12796STA_LSB		0
#define XAIEGBL_CORE_EVTSTA3_EVT12796STA_WIDTH		32
#define XAIEGBL_CORE_EVTSTA3_EVT12796STA_MASK		0xFFFFFFFF
#define XAIEGBL_CORE_EVTSTA3_EVT12796STA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_EVTSTA3(Event_127_96_Status)		((Event_127_96_Status&0xffffffff))

#define XAIEGBL_CORE_COMEVTINP		0x00034400
#define XAIEGBL_CORE_COMEVTINPWID		32
#define XAIEGBL_CORE_COMEVTINP_EVTD_LSB		24
#define XAIEGBL_CORE_COMEVTINP_EVTD_WIDTH		7
#define XAIEGBL_CORE_COMEVTINP_EVTD_MASK		0x7F000000
#define XAIEGBL_CORE_COMEVTINP_EVTD_DEFVAL		0x0
#define XAIEGBL_CORE_COMEVTINP_EVTC_LSB		16
#define XAIEGBL_CORE_COMEVTINP_EVTC_WIDTH		7
#define XAIEGBL_CORE_COMEVTINP_EVTC_MASK		0x007F0000
#define XAIEGBL_CORE_COMEVTINP_EVTC_DEFVAL		0x0
#define XAIEGBL_CORE_COMEVTINP_EVTB_LSB		8
#define XAIEGBL_CORE_COMEVTINP_EVTB_WIDTH		7
#define XAIEGBL_CORE_COMEVTINP_EVTB_MASK		0x00007F00
#define XAIEGBL_CORE_COMEVTINP_EVTB_DEFVAL		0x0
#define XAIEGBL_CORE_COMEVTINP_EVTA_LSB		0
#define XAIEGBL_CORE_COMEVTINP_EVTA_WIDTH		7
#define XAIEGBL_CORE_COMEVTINP_EVTA_MASK		0x0000007F
#define XAIEGBL_CORE_COMEVTINP_EVTA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COMEVTINP(eventD,eventC,eventB,eventA)		(((eventD&0x0000007f)<<24)+((eventC&0x0000007f)<<16)+((eventB&0x0000007f)<<8)+(eventA&0x0000007f))

#define XAIEGBL_CORE_COMEVTCTRL		0x00034404
#define XAIEGBL_CORE_COMEVTCTRLWID		32
#define XAIEGBL_CORE_COMEVTCTRL_COM2_LSB		16
#define XAIEGBL_CORE_COMEVTCTRL_COM2_WIDTH		2
#define XAIEGBL_CORE_COMEVTCTRL_COM2_MASK		0x00030000
#define XAIEGBL_CORE_COMEVTCTRL_COM2_DEFVAL		0x0
#define XAIEGBL_CORE_COMEVTCTRL_COM1_LSB		8
#define XAIEGBL_CORE_COMEVTCTRL_COM1_WIDTH		2
#define XAIEGBL_CORE_COMEVTCTRL_COM1_MASK		0x00000300
#define XAIEGBL_CORE_COMEVTCTRL_COM1_DEFVAL		0x0
#define XAIEGBL_CORE_COMEVTCTRL_COM0_LSB		0
#define XAIEGBL_CORE_COMEVTCTRL_COM0_WIDTH		2
#define XAIEGBL_CORE_COMEVTCTRL_COM0_MASK		0x00000003
#define XAIEGBL_CORE_COMEVTCTRL_COM0_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_COMEVTCTRL(combo2,combo1,combo0)		(((combo2&0x00000003)<<16)+((combo1&0x00000003)<<8)+(combo0&0x00000003))

#define XAIEGBL_CORE_EVTGRP0ENA		0x00034500
#define XAIEGBL_CORE_EVTGRP0ENAWID		32
#define XAIEGBL_CORE_EVTGRP0ENAMSK		0x0000003FF
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT3_LSB		9
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT3_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT3_MASK		0x00000200
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT2_LSB		8
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT2_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT2_MASK		0x00000100
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT1_LSB		7
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT1_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT1_MASK		0x00000080
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT0_LSB		6
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT0_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT0_MASK		0x00000040
#define XAIEGBL_CORE_EVTGRP0ENA_COMEVT0_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT3_LSB		5
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT3_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT3_MASK		0x00000020
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT2_LSB		4
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT2_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT2_MASK		0x00000010
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT1_LSB		3
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT1_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT1_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT0_LSB		2
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT0_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT0_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRP0ENA_PERCNT0_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_TIMVALREA_LSB		1
#define XAIEGBL_CORE_EVTGRP0ENA_TIMVALREA_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_TIMVALREA_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRP0ENA_TIMVALREA_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRP0ENA_TIMSYN_LSB		0
#define XAIEGBL_CORE_EVTGRP0ENA_TIMSYN_WIDTH		1
#define XAIEGBL_CORE_EVTGRP0ENA_TIMSYN_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRP0ENA_TIMSYN_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRP0ENA(Combo_Event_3,Combo_Event_2,Combo_Event_1,Combo_Event_0,Perf_Cnt3,Perf_Cnt2,Perf_Cnt1,Perf_Cnt0,Timer_Value_Reached,Timer_Sync)		(((Combo_Event_3&0x00000001)<<9)+((Combo_Event_2&0x00000001)<<8)+((Combo_Event_1&0x00000001)<<7)+((Combo_Event_0&0x00000001)<<6)+((Perf_Cnt3&0x00000001)<<5)+((Perf_Cnt2&0x00000001)<<4)+((Perf_Cnt1&0x00000001)<<3)+((Perf_Cnt0&0x00000001)<<2)+((Timer_Value_Reached&0x00000001)<<1)+(Timer_Sync&0x00000001))

#define XAIEGBL_CORE_EVTGRPPCENA		0x00034504
#define XAIEGBL_CORE_EVTGRPPCENAWID		32
#define XAIEGBL_CORE_EVTGRPPCENAMSK		0x3F
#define XAIEGBL_CORE_EVTGRPPCENA_PCRAN23_LSB		5
#define XAIEGBL_CORE_EVTGRPPCENA_PCRAN23_WIDTH		1
#define XAIEGBL_CORE_EVTGRPPCENA_PCRAN23_MASK		0x00000020
#define XAIEGBL_CORE_EVTGRPPCENA_PCRAN23_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPPCENA_PCRAN01_LSB		4
#define XAIEGBL_CORE_EVTGRPPCENA_PCRAN01_WIDTH		1
#define XAIEGBL_CORE_EVTGRPPCENA_PCRAN01_MASK		0x00000010
#define XAIEGBL_CORE_EVTGRPPCENA_PCRAN01_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPPCENA_PC3_LSB		3
#define XAIEGBL_CORE_EVTGRPPCENA_PC3_WIDTH		1
#define XAIEGBL_CORE_EVTGRPPCENA_PC3_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRPPCENA_PC3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPPCENA_PC2_LSB		2
#define XAIEGBL_CORE_EVTGRPPCENA_PC2_WIDTH		1
#define XAIEGBL_CORE_EVTGRPPCENA_PC2_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRPPCENA_PC2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPPCENA_PC1_LSB		1
#define XAIEGBL_CORE_EVTGRPPCENA_PC1_WIDTH		1
#define XAIEGBL_CORE_EVTGRPPCENA_PC1_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRPPCENA_PC1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPPCENA_PC0_LSB		0
#define XAIEGBL_CORE_EVTGRPPCENA_PC0_WIDTH		1
#define XAIEGBL_CORE_EVTGRPPCENA_PC0_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRPPCENA_PC0_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRPPCENA(PC_Range_2_3,PC_Range_0_1,PC_3,PC_2,PC_1,PC_0)		(((PC_Range_2_3&0x00000001)<<5)+((PC_Range_0_1&0x00000001)<<4)+((PC_3&0x00000001)<<3)+((PC_2&0x00000001)<<2)+((PC_1&0x00000001)<<1)+(PC_0&0x00000001))

#define XAIEGBL_CORE_EVTGRPCORESTALENA		0x00034508
#define XAIEGBL_CORE_EVTGRPCORESTALENAWID		32
#define XAIEGBL_CORE_EVTGRPCORESTALENAMSK		0x1FF
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ECCERRSTAL_LSB		8
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ECCERRSTAL_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ECCERRSTAL_MASK		0x00000100
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ECCERRSTAL_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ECCSCRSTAL_LSB		7
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ECCSCRSTAL_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ECCSCRSTAL_MASK		0x00000080
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ECCSCRSTAL_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_DIS_LSB		6
#define XAIEGBL_CORE_EVTGRPCORESTALENA_DIS_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_DIS_MASK		0x00000040
#define XAIEGBL_CORE_EVTGRPCORESTALENA_DIS_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ACT_LSB		5
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ACT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ACT_MASK		0x00000020
#define XAIEGBL_CORE_EVTGRPCORESTALENA_ACT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_DBG_LSB		4
#define XAIEGBL_CORE_EVTGRPCORESTALENA_DBG_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_DBG_MASK		0x00000010
#define XAIEGBL_CORE_EVTGRPCORESTALENA_DBG_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_LOCKSTAL_LSB		3
#define XAIEGBL_CORE_EVTGRPCORESTALENA_LOCKSTAL_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_LOCKSTAL_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRPCORESTALENA_LOCKSTAL_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_CASSTAL_LSB		2
#define XAIEGBL_CORE_EVTGRPCORESTALENA_CASSTAL_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_CASSTAL_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRPCORESTALENA_CASSTAL_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_STRSTAL_LSB		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_STRSTAL_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_STRSTAL_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRPCORESTALENA_STRSTAL_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_MEMSTAL_LSB		0
#define XAIEGBL_CORE_EVTGRPCORESTALENA_MEMSTAL_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCORESTALENA_MEMSTAL_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRPCORESTALENA_MEMSTAL_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRPCORESTALENA(ECC_Error_Stall,ECC_Scrubbing_Stall,Disable,Active,Debug,Lock_Stall,Cascade_Stall,Stream_Stall,Memory_Stall)		(((ECC_Error_Stall&0x00000001)<<8)+((ECC_Scrubbing_Stall&0x00000001)<<7)+((Disable&0x00000001)<<6)+((Active&0x00000001)<<5)+((Debug&0x00000001)<<4)+((Lock_Stall&0x00000001)<<3)+((Cascade_Stall&0x00000001)<<2)+((Stream_Stall&0x00000001)<<1)+(Memory_Stall&0x00000001))

#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA		0x0003450C
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENAWID		32
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENAMSK		0x1FFF
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOCKRELREQ_LSB		12
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOCKRELREQ_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOCKRELREQ_MASK		0x00001000
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOCKRELREQ_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOCKACQREQ_LSB		11
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOCKACQREQ_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOCKACQREQ_MASK		0x00000800
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOCKACQREQ_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCASPUT_LSB		10
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCASPUT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCASPUT_MASK		0x00000400
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCASPUT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCASGET_LSB		9
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCASGET_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCASGET_MASK		0x00000200
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCASGET_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTRPUT_LSB		8
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTRPUT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTRPUT_MASK		0x00000100
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTRPUT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTRGET_LSB		7
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTRGET_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTRGET_MASK		0x00000080
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTRGET_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTO_LSB		6
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTO_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTO_MASK		0x00000040
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSSTO_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOA_LSB		5
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOA_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOA_MASK		0x00000020
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSLOA_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSVEC_LSB		4
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSVEC_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSVEC_MASK		0x00000010
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSVEC_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSRET_LSB		3
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSRET_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSRET_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSRET_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCAL_LSB		2
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCAL_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCAL_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSCAL_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSEVT1_LSB		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSEVT1_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSEVT1_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSEVT1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSEVT0_LSB		0
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSEVT0_WIDTH		1
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSEVT0_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRPCOREPRGFLOENA_INSEVT0_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRPCOREPRGFLOENA(Instr_Lock_Release_req,Instr_Lock_Acquire_req,Instr_Cascade_Put,Instr_Cascade_Get,Instr_Stream_Put,Instr_Stream_Get,Instr_Store,Instr_Load,Instr_Vector,Instr_Return,Instr_Call,Instr_Event_1,Instr_Event_0)		(((Instr_Lock_Release_req&0x00000001)<<12)+((Instr_Lock_Acquire_req&0x00000001)<<11)+((Instr_Cascade_Put&0x00000001)<<10)+((Instr_Cascade_Get&0x00000001)<<9)+((Instr_Stream_Put&0x00000001)<<8)+((Instr_Stream_Get&0x00000001)<<7)+((Instr_Store&0x00000001)<<6)+((Instr_Load&0x00000001)<<5)+((Instr_Vector&0x00000001)<<4)+((Instr_Return&0x00000001)<<3)+((Instr_Call&0x00000001)<<2)+((Instr_Event_1&0x00000001)<<1)+(Instr_Event_0&0x00000001))

#define XAIEGBL_CORE_EVTGRPERR0ENA		0x00034510
#define XAIEGBL_CORE_EVTGRPERR0ENAWID		32
#define XAIEGBL_CORE_EVTGRPERR0ENAMSK		0x3FFFFF
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSERR_LSB		21
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSERR_MASK		0x00200000
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSWAR_LSB		20
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSWAR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSWAR_MASK		0x00100000
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSWAR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_LOCKACCTOUNA_LSB		19
#define XAIEGBL_CORE_EVTGRPERR0ENA_LOCKACCTOUNA_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_LOCKACCTOUNA_MASK		0x00080000
#define XAIEGBL_CORE_EVTGRPERR0ENA_LOCKACCTOUNA_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_DMACCTOUNA_LSB		18
#define XAIEGBL_CORE_EVTGRPERR0ENA_DMACCTOUNA_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_DMACCTOUNA_MASK		0x00040000
#define XAIEGBL_CORE_EVTGRPERR0ENA_DMACCTOUNA_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMADDOUTOFRAN_LSB		17
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMADDOUTOFRAN_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMADDOUTOFRAN_MASK		0x00020000
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMADDOUTOFRAN_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERR2BIT_LSB		16
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERR2BIT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERR2BIT_MASK		0x00010000
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERR2BIT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERR1BIT_LSB		15
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERR1BIT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERR1BIT_MASK		0x00008000
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERR1BIT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERRSCR2BIT_LSB		14
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERRSCR2BIT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERRSCR2BIT_MASK		0x00004000
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERRSCR2BIT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERRSCRCOR_LSB		13
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERRSCRCOR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERRSCRCOR_MASK		0x00002000
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMECCERRSCRCOR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_DMADDOUTOFRAN_LSB		12
#define XAIEGBL_CORE_EVTGRPERR0ENA_DMADDOUTOFRAN_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_DMADDOUTOFRAN_MASK		0x00001000
#define XAIEGBL_CORE_EVTGRPERR0ENA_DMADDOUTOFRAN_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSDECERR_LSB		11
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSDECERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSDECERR_MASK		0x00000800
#define XAIEGBL_CORE_EVTGRPERR0ENA_INSDECERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_AXIMMSLVERR_LSB		10
#define XAIEGBL_CORE_EVTGRPERR0ENA_AXIMMSLVERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_AXIMMSLVERR_MASK		0x00000400
#define XAIEGBL_CORE_EVTGRPERR0ENA_AXIMMSLVERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_CTRLPKTERR_LSB		9
#define XAIEGBL_CORE_EVTGRPERR0ENA_CTRLPKTERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_CTRLPKTERR_MASK		0x00000200
#define XAIEGBL_CORE_EVTGRPERR0ENA_CTRLPKTERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_STRPKTPARERR_LSB		8
#define XAIEGBL_CORE_EVTGRPERR0ENA_STRPKTPARERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_STRPKTPARERR_MASK		0x00000100
#define XAIEGBL_CORE_EVTGRPERR0ENA_STRPKTPARERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMREGACCFAI_LSB		7
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMREGACCFAI_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMREGACCFAI_MASK		0x00000080
#define XAIEGBL_CORE_EVTGRPERR0ENA_PMREGACCFAI_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_TLAINWSSWOR02_LSB		6
#define XAIEGBL_CORE_EVTGRPERR0ENA_TLAINWSSWOR02_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_TLAINWSSWOR02_MASK		0x00000040
#define XAIEGBL_CORE_EVTGRPERR0ENA_TLAINWSSWOR02_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPDIVBYZER_LSB		5
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPDIVBYZER_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPDIVBYZER_MASK		0x00000020
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPDIVBYZER_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPINV_LSB		4
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPINV_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPINV_MASK		0x00000010
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPINV_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPUND_LSB		3
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPUND_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPUND_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPUND_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPOVE_LSB		2
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPOVE_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPOVE_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRPERR0ENA_FPOVE_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_UPSSAT_LSB		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_UPSSAT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_UPSSAT_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRPERR0ENA_UPSSAT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR0ENA_SRSSAT_LSB		0
#define XAIEGBL_CORE_EVTGRPERR0ENA_SRSSAT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR0ENA_SRSSAT_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRPERR0ENA_SRSSAT_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRPERR0ENA(Instr_Error,Instr_Warning,Lock_Access_to_Unavailable,DM_access_to_Unavailable,PM_address_out_of_range,PM_ECC_Error_2bit,PM_ECC_Error_1bit,PM_ECC_Error_Scrub_2bit,PM_ECC_Error_Scrub_Corrected,DM_address_out_of_range,Instruction_Decompression_Error,AXI_MM_Slave_Error,Control_Pkt_Error,Stream_Pkt_Parity_Error,PM_Reg_Access_Failure,TLAST_in_WSS_words_0_2,FP_Div_by_Zero,FP_Invalid,FP_Underflow,FP_Overflow,UPS_Saturate,SRS_Saturate)		(((Instr_Error&0x00000001)<<21)+((Instr_Warning&0x00000001)<<20)+((Lock_Access_to_Unavailable&0x00000001)<<19)+((DM_access_to_Unavailable&0x00000001)<<18)+((PM_address_out_of_range&0x00000001)<<17)+((PM_ECC_Error_2bit&0x00000001)<<16)+((PM_ECC_Error_1bit&0x00000001)<<15)+((PM_ECC_Error_Scrub_2bit&0x00000001)<<14)+((PM_ECC_Error_Scrub_Corrected&0x00000001)<<13)+((DM_address_out_of_range&0x00000001)<<12)+((Instruction_Decompression_Error&0x00000001)<<11)+((AXI_MM_Slave_Error&0x00000001)<<10)+((Control_Pkt_Error&0x00000001)<<9)+((Stream_Pkt_Parity_Error&0x00000001)<<8)+((PM_Reg_Access_Failure&0x00000001)<<7)+((TLAST_in_WSS_words_0_2&0x00000001)<<6)+((FP_Div_by_Zero&0x00000001)<<5)+((FP_Invalid&0x00000001)<<4)+((FP_Underflow&0x00000001)<<3)+((FP_Overflow&0x00000001)<<2)+((UPS_Saturate&0x00000001)<<1)+(SRS_Saturate&0x00000001))

#define XAIEGBL_CORE_EVTGRPERR1ENA		0x00034514
#define XAIEGBL_CORE_EVTGRPERR1ENAWID		32
#define XAIEGBL_CORE_EVTGRPERR1ENAMSK		0x3FFFFF
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSERR_LSB		21
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSERR_MASK		0x00200000
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSWAR_LSB		20
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSWAR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSWAR_MASK		0x00100000
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSWAR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_LOCKACCTOUNA_LSB		19
#define XAIEGBL_CORE_EVTGRPERR1ENA_LOCKACCTOUNA_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_LOCKACCTOUNA_MASK		0x00080000
#define XAIEGBL_CORE_EVTGRPERR1ENA_LOCKACCTOUNA_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_DMACCTOUNA_LSB		18
#define XAIEGBL_CORE_EVTGRPERR1ENA_DMACCTOUNA_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_DMACCTOUNA_MASK		0x00040000
#define XAIEGBL_CORE_EVTGRPERR1ENA_DMACCTOUNA_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMADDOUTOFRAN_LSB		17
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMADDOUTOFRAN_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMADDOUTOFRAN_MASK		0x00020000
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMADDOUTOFRAN_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERR2BIT_LSB		16
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERR2BIT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERR2BIT_MASK		0x00010000
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERR2BIT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERR1BIT_LSB		15
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERR1BIT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERR1BIT_MASK		0x00008000
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERR1BIT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERRSCR2BIT_LSB		14
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERRSCR2BIT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERRSCR2BIT_MASK		0x00004000
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERRSCR2BIT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERRSCRCOR_LSB		13
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERRSCRCOR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERRSCRCOR_MASK		0x00002000
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMECCERRSCRCOR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_DMADDOUTOFRAN_LSB		12
#define XAIEGBL_CORE_EVTGRPERR1ENA_DMADDOUTOFRAN_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_DMADDOUTOFRAN_MASK		0x00001000
#define XAIEGBL_CORE_EVTGRPERR1ENA_DMADDOUTOFRAN_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSDECERR_LSB		11
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSDECERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSDECERR_MASK		0x00000800
#define XAIEGBL_CORE_EVTGRPERR1ENA_INSDECERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_AXIMMSLVERR_LSB		10
#define XAIEGBL_CORE_EVTGRPERR1ENA_AXIMMSLVERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_AXIMMSLVERR_MASK		0x00000400
#define XAIEGBL_CORE_EVTGRPERR1ENA_AXIMMSLVERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_CTRLPKTERR_LSB		9
#define XAIEGBL_CORE_EVTGRPERR1ENA_CTRLPKTERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_CTRLPKTERR_MASK		0x00000200
#define XAIEGBL_CORE_EVTGRPERR1ENA_CTRLPKTERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_STRPKTPARERR_LSB		8
#define XAIEGBL_CORE_EVTGRPERR1ENA_STRPKTPARERR_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_STRPKTPARERR_MASK		0x00000100
#define XAIEGBL_CORE_EVTGRPERR1ENA_STRPKTPARERR_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMREGACCFAI_LSB		7
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMREGACCFAI_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMREGACCFAI_MASK		0x00000080
#define XAIEGBL_CORE_EVTGRPERR1ENA_PMREGACCFAI_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_TLAINWSSWOR02_LSB		6
#define XAIEGBL_CORE_EVTGRPERR1ENA_TLAINWSSWOR02_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_TLAINWSSWOR02_MASK		0x00000040
#define XAIEGBL_CORE_EVTGRPERR1ENA_TLAINWSSWOR02_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPDIVBYZER_LSB		5
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPDIVBYZER_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPDIVBYZER_MASK		0x00000020
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPDIVBYZER_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPINV_LSB		4
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPINV_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPINV_MASK		0x00000010
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPINV_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPUND_LSB		3
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPUND_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPUND_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPUND_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPOVE_LSB		2
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPOVE_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPOVE_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRPERR1ENA_FPOVE_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_UPSSAT_LSB		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_UPSSAT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_UPSSAT_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRPERR1ENA_UPSSAT_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPERR1ENA_SRSSAT_LSB		0
#define XAIEGBL_CORE_EVTGRPERR1ENA_SRSSAT_WIDTH		1
#define XAIEGBL_CORE_EVTGRPERR1ENA_SRSSAT_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRPERR1ENA_SRSSAT_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRPERR1ENA(Instr_Error,Instr_Warning,Lock_Access_to_Unavailable,DM_access_to_Unavailable,PM_address_out_of_range,PM_ECC_Error_2bit,PM_ECC_Error_1bit,PM_ECC_Error_Scrub_2bit,PM_ECC_Error_Scrub_Corrected,DM_address_out_of_range,Instruction_Decompression_Error,AXI_MM_Slave_Error,Control_Pkt_Error,Stream_Pkt_Parity_Error,PM_Reg_Access_Failure,TLAST_in_WSS_words_0_2,FP_Div_by_Zero,FP_Invalid,FP_Underflow,FP_Overflow,UPS_Saturate,SRS_Saturate)		(((Instr_Error&0x00000001)<<21)+((Instr_Warning&0x00000001)<<20)+((Lock_Access_to_Unavailable&0x00000001)<<19)+((DM_access_to_Unavailable&0x00000001)<<18)+((PM_address_out_of_range&0x00000001)<<17)+((PM_ECC_Error_2bit&0x00000001)<<16)+((PM_ECC_Error_1bit&0x00000001)<<15)+((PM_ECC_Error_Scrub_2bit&0x00000001)<<14)+((PM_ECC_Error_Scrub_Corrected&0x00000001)<<13)+((DM_address_out_of_range&0x00000001)<<12)+((Instruction_Decompression_Error&0x00000001)<<11)+((AXI_MM_Slave_Error&0x00000001)<<10)+((Control_Pkt_Error&0x00000001)<<9)+((Stream_Pkt_Parity_Error&0x00000001)<<8)+((PM_Reg_Access_Failure&0x00000001)<<7)+((TLAST_in_WSS_words_0_2&0x00000001)<<6)+((FP_Div_by_Zero&0x00000001)<<5)+((FP_Invalid&0x00000001)<<4)+((FP_Underflow&0x00000001)<<3)+((FP_Overflow&0x00000001)<<2)+((UPS_Saturate&0x00000001)<<1)+(SRS_Saturate&0x00000001))

#define XAIEGBL_CORE_EVTGRPSTRSWIENA		0x00034518
#define XAIEGBL_CORE_EVTGRPSTRSWIENAWID		32
#define XAIEGBL_CORE_EVTGRPSTRSWIENAMSK		0xFFFFFFFF
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA7_LSB		31
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA7_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA7_MASK		0x80000000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA7_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL7_LSB		30
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL7_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL7_MASK		0x40000000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL7_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN7_LSB		29
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN7_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN7_MASK		0x20000000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN7_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL7_LSB		28
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL7_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL7_MASK		0x10000000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL7_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA6_LSB		27
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA6_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA6_MASK		0x08000000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA6_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL6_LSB		26
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL6_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL6_MASK		0x04000000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL6_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN6_LSB		25
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN6_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN6_MASK		0x02000000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN6_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL6_LSB		24
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL6_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL6_MASK		0x01000000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL6_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA5_LSB		23
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA5_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA5_MASK		0x00800000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA5_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL5_LSB		22
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL5_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL5_MASK		0x00400000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL5_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN5_LSB		21
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN5_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN5_MASK		0x00200000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN5_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL5_LSB		20
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL5_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL5_MASK		0x00100000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL5_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA4_LSB		19
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA4_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA4_MASK		0x00080000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA4_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL4_LSB		18
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL4_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL4_MASK		0x00040000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL4_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN4_LSB		17
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN4_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN4_MASK		0x00020000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN4_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL4_LSB		16
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL4_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL4_MASK		0x00010000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL4_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA3_LSB		15
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA3_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA3_MASK		0x00008000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL3_LSB		14
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL3_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL3_MASK		0x00004000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN3_LSB		13
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN3_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN3_MASK		0x00002000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL3_LSB		12
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL3_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL3_MASK		0x00001000
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA2_LSB		11
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA2_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA2_MASK		0x00000800
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL2_LSB		10
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL2_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL2_MASK		0x00000400
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN2_LSB		9
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN2_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN2_MASK		0x00000200
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL2_LSB		8
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL2_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL2_MASK		0x00000100
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA1_LSB		7
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA1_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA1_MASK		0x00000080
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL1_LSB		6
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL1_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL1_MASK		0x00000040
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN1_LSB		5
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN1_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN1_MASK		0x00000020
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL1_LSB		4
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL1_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL1_MASK		0x00000010
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA0_LSB		3
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA0_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA0_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTTLA0_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL0_LSB		2
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL0_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL0_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTSTAL0_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN0_LSB		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN0_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN0_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTRUN0_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL0_LSB		0
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL0_WIDTH		1
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL0_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRPSTRSWIENA_PORTIDL0_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRPSTRSWIENA(Port_TLAST_7,Port_Stalled_7,Port_Running_7,Port_Idle_7,Port_TLAST_6,Port_Stalled_6,Port_Running_6,Port_Idle_6,Port_TLAST_5,Port_Stalled_5,Port_Running_5,Port_Idle_5,Port_TLAST_4,Port_Stalled_4,Port_Running_4,Port_Idle_4,Port_TLAST_3,Port_Stalled_3,Port_Running_3,Port_Idle_3,Port_TLAST_2,Port_Stalled_2,Port_Running_2,Port_Idle_2,Port_TLAST_1,Port_Stalled_1,Port_Running_1,Port_Idle_1,Port_TLAST_0,Port_Stalled_0,Port_Running_0,Port_Idle_0)		(((Port_TLAST_7&0x00000001)<<31)+((Port_Stalled_7&0x00000001)<<30)+((Port_Running_7&0x00000001)<<29)+((Port_Idle_7&0x00000001)<<28)+((Port_TLAST_6&0x00000001)<<27)+((Port_Stalled_6&0x00000001)<<26)+((Port_Running_6&0x00000001)<<25)+((Port_Idle_6&0x00000001)<<24)+((Port_TLAST_5&0x00000001)<<23)+((Port_Stalled_5&0x00000001)<<22)+((Port_Running_5&0x00000001)<<21)+((Port_Idle_5&0x00000001)<<20)+((Port_TLAST_4&0x00000001)<<19)+((Port_Stalled_4&0x00000001)<<18)+((Port_Running_4&0x00000001)<<17)+((Port_Idle_4&0x00000001)<<16)+((Port_TLAST_3&0x00000001)<<15)+((Port_Stalled_3&0x00000001)<<14)+((Port_Running_3&0x00000001)<<13)+((Port_Idle_3&0x00000001)<<12)+((Port_TLAST_2&0x00000001)<<11)+((Port_Stalled_2&0x00000001)<<10)+((Port_Running_2&0x00000001)<<9)+((Port_Idle_2&0x00000001)<<8)+((Port_TLAST_1&0x00000001)<<7)+((Port_Stalled_1&0x00000001)<<6)+((Port_Running_1&0x00000001)<<5)+((Port_Idle_1&0x00000001)<<4)+((Port_TLAST_0&0x00000001)<<3)+((Port_Stalled_0&0x00000001)<<2)+((Port_Running_0&0x00000001)<<1)+(Port_Idle_0&0x00000001))

#define XAIEGBL_CORE_EVTGRPBRDCASTENA		0x0003451C
#define XAIEGBL_CORE_EVTGRPBRDCASTENAWID		32
#define XAIEGBL_CORE_EVTGRPBRDCASTENAMSK		0xFFFF
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST15_LSB		15
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST15_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST15_MASK		0x00008000
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST15_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST14_LSB		14
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST14_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST14_MASK		0x00004000
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST14_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST13_LSB		13
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST13_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST13_MASK		0x00002000
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST13_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST12_LSB		12
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST12_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST12_MASK		0x00001000
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST12_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST11_LSB		11
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST11_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST11_MASK		0x00000800
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST11_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST10_LSB		10
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST10_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST10_MASK		0x00000400
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST10_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST9_LSB		9
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST9_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST9_MASK		0x00000200
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST9_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST8_LSB		8
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST8_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST8_MASK		0x00000100
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST8_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST7_LSB		7
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST7_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST7_MASK		0x00000080
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST7_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST6_LSB		6
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST6_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST6_MASK		0x00000040
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST6_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST5_LSB		5
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST5_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST5_MASK		0x00000020
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST5_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST4_LSB		4
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST4_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST4_MASK		0x00000010
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST4_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST3_LSB		3
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST3_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST3_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST2_LSB		2
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST2_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST2_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST1_LSB		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST1_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST1_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST0_LSB		0
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST0_WIDTH		1
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST0_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRPBRDCASTENA_BRDCAST0_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRPBRDCASTENA(Broadcast_15,Broadcast_14,Broadcast_13,Broadcast_12,Broadcast_11,Broadcast_10,Broadcast_9,Broadcast_8,Broadcast_7,Broadcast_6,Broadcast_5,Broadcast_4,Broadcast_3,Broadcast_2,Broadcast_1,Broadcast_0)		(((Broadcast_15&0x00000001)<<15)+((Broadcast_14&0x00000001)<<14)+((Broadcast_13&0x00000001)<<13)+((Broadcast_12&0x00000001)<<12)+((Broadcast_11&0x00000001)<<11)+((Broadcast_10&0x00000001)<<10)+((Broadcast_9&0x00000001)<<9)+((Broadcast_8&0x00000001)<<8)+((Broadcast_7&0x00000001)<<7)+((Broadcast_6&0x00000001)<<6)+((Broadcast_5&0x00000001)<<5)+((Broadcast_4&0x00000001)<<4)+((Broadcast_3&0x00000001)<<3)+((Broadcast_2&0x00000001)<<2)+((Broadcast_1&0x00000001)<<1)+(Broadcast_0&0x00000001))

#define XAIEGBL_CORE_EVTGRPUSREVTENA		0x00034520
#define XAIEGBL_CORE_EVTGRPUSREVTENAWID		32
#define XAIEGBL_CORE_EVTGRPUSREVTENAMSK		0xF
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT3_LSB		3
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT3_WIDTH		1
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT3_MASK		0x00000008
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT3_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT2_LSB		2
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT2_WIDTH		1
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT2_MASK		0x00000004
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT2_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT1_LSB		1
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT1_WIDTH		1
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT1_MASK		0x00000002
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT1_DEFVAL		0x1
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT0_LSB		0
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT0_WIDTH		1
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT0_MASK		0x00000001
#define XAIEGBL_CORE_EVTGRPUSREVTENA_USREVT0_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_EVTGRPUSREVTENA(User_Event_3,User_Event_2,User_Event_1,User_Event_0)		(((User_Event_3&0x00000001)<<3)+((User_Event_2&0x00000001)<<2)+((User_Event_1&0x00000001)<<1)+(User_Event_0&0x00000001))

#define XAIEGBL_CORE_TILCTRL		0x00036030
#define XAIEGBL_CORE_TILCTRLWID		32
#define XAIEGBL_CORE_TILCTRL_ISOFROEAS_LSB		3
#define XAIEGBL_CORE_TILCTRL_ISOFROEAS_WIDTH		1
#define XAIEGBL_CORE_TILCTRL_ISOFROEAS_MASK		0x00000008
#define XAIEGBL_CORE_TILCTRL_ISOFROEAS_DEFVAL		0x0
#define XAIEGBL_CORE_TILCTRL_ISOFRONOR_LSB		2
#define XAIEGBL_CORE_TILCTRL_ISOFRONOR_WIDTH		1
#define XAIEGBL_CORE_TILCTRL_ISOFRONOR_MASK		0x00000004
#define XAIEGBL_CORE_TILCTRL_ISOFRONOR_DEFVAL		0x0
#define XAIEGBL_CORE_TILCTRL_ISOFROWES_LSB		1
#define XAIEGBL_CORE_TILCTRL_ISOFROWES_WIDTH		1
#define XAIEGBL_CORE_TILCTRL_ISOFROWES_MASK		0x00000002
#define XAIEGBL_CORE_TILCTRL_ISOFROWES_DEFVAL		0x0
#define XAIEGBL_CORE_TILCTRL_ISOFROSOU_LSB		0
#define XAIEGBL_CORE_TILCTRL_ISOFROSOU_WIDTH		1
#define XAIEGBL_CORE_TILCTRL_ISOFROSOU_MASK		0x00000001
#define XAIEGBL_CORE_TILCTRL_ISOFROSOU_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TILCTRL(Isolate_From_East,Isolate_From_North,Isolate_From_West,Isolate_From_South)		(((Isolate_From_East&0x00000001)<<3)+((Isolate_From_North&0x00000001)<<2)+((Isolate_From_West&0x00000001)<<1)+(Isolate_From_South&0x00000001))

#define XAIEGBL_CORE_TILCTRLPKTHANSTA		0x00036034
#define XAIEGBL_CORE_TILCTRLPKTHANSTAWID		32
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_TLAERR_LSB		3
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_TLAERR_WIDTH		1
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_TLAERR_MASK		0x00000008
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_TLAERR_DEFVAL		0x0
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_SLVONACC_LSB		2
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_SLVONACC_WIDTH		1
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_SLVONACC_MASK		0x00000004
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_SLVONACC_DEFVAL		0x0
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_SECHEAPARERR_LSB		1
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_SECHEAPARERR_WIDTH		1
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_SECHEAPARERR_MASK		0x00000002
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_SECHEAPARERR_DEFVAL		0x0
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_FIRHEAPARERR_LSB		0
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_FIRHEAPARERR_WIDTH		1
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_FIRHEAPARERR_MASK		0x00000001
#define XAIEGBL_CORE_TILCTRLPKTHANSTA_FIRHEAPARERR_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_TILCTRLPKTHANSTA(Tlast_Error,SLVERR_On_Access,Second_Header_Parity_Error,First_Header_Parity_Error)		(((Tlast_Error&0x00000001)<<3)+((SLVERR_On_Access&0x00000001)<<2)+((Second_Header_Parity_Error&0x00000001)<<1)+(First_Header_Parity_Error&0x00000001))

#define XAIEGBL_CORE_TILCLOCTRL		0x00036040
#define XAIEGBL_CORE_TILCLOCTRLWID		32
#define XAIEGBL_CORE_TILCLOCTRL_NEXTILCLOENA_LSB		1
#define XAIEGBL_CORE_TILCLOCTRL_NEXTILCLOENA_WIDTH		1
#define XAIEGBL_CORE_TILCLOCTRL_NEXTILCLOENA_MASK		0x00000002
#define XAIEGBL_CORE_TILCLOCTRL_NEXTILCLOENA_DEFVAL		0x1
#define XAIEGBL_CORE_TILCLOCTRL_CLOBUFENA_LSB		0
#define XAIEGBL_CORE_TILCLOCTRL_CLOBUFENA_WIDTH		1
#define XAIEGBL_CORE_TILCLOCTRL_CLOBUFENA_MASK		0x00000001
#define XAIEGBL_CORE_TILCLOCTRL_CLOBUFENA_DEFVAL		0x1
#define XAIEGBL_CORE_VALUE_TILCLOCTRL(Next_Tile_Clock_Enable,Clock_Buffer_Enable)		(((Next_Tile_Clock_Enable&0x00000001)<<1)+(Clock_Buffer_Enable&0x00000001))

#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0		0x0003F000
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE0_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGMECORE0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1		0x0003F004
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGMECORE1_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGMECORE1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0		0x0003F008
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA0_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGDMA0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1		0x0003F00C
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGDMA1_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGDMA1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR		0x0003F010
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTRWID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGTILCTR_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGTILCTR(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0		0x0003F014
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF0_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGFIF0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1		0x0003F018
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGFIF1_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGFIF1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0		0x0003F01C
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU0_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGSOU0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1		0x0003F020
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU1_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGSOU1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2		0x0003F024
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU2_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGSOU2(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3		0x0003F028
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGSOU3_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGSOU3(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGWES0		0x0003F02C
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGWES0_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGWES0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGWES1		0x0003F030
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGWES1_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGWES1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGWES2		0x0003F034
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGWES2_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGWES2(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGWES3		0x0003F038
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGWES3_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGWES3(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0		0x0003F03C
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR0_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGNOR0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1		0x0003F040
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR1_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGNOR1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2		0x0003F044
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR2_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGNOR2(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3		0x0003F048
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR3_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGNOR3(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4		0x0003F04C
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR4_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGNOR4(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5		0x0003F050
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGNOR5_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGNOR5(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0		0x0003F054
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS0_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGEAS0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1		0x0003F058
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS1_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGEAS1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2		0x0003F05C
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS2_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGEAS2(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3		0x0003F060
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3WID		32
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_MSTRENA_LSB		31
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_MSTRENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_MSTRENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_MSTRENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_DROHEA_LSB		7
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_DROHEA_WIDTH		1
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_DROHEA_MASK		0x00000080
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_DROHEA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_CON_LSB		0
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_CON_WIDTH		7
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_CON_MASK		0x0000007F
#define XAIEGBL_CORE_STRSWIMSTRCFGEAS3_CON_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIMSTRCFGEAS3(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_CORE_STRSWISLVMECORE0CFG		0x0003F100
#define XAIEGBL_CORE_STRSWISLVMECORE0CFGWID		32
#define XAIEGBL_CORE_STRSWISLVMECORE0CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVMECORE0CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVMECORE0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVMECORE0CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVMECORE0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVMECORE1CFG		0x0003F104
#define XAIEGBL_CORE_STRSWISLVMECORE1CFGWID		32
#define XAIEGBL_CORE_STRSWISLVMECORE1CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVMECORE1CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVMECORE1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVMECORE1CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVMECORE1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVDMA0CFG		0x0003F108
#define XAIEGBL_CORE_STRSWISLVDMA0CFGWID		32
#define XAIEGBL_CORE_STRSWISLVDMA0CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVDMA0CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVDMA0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVDMA0CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVDMA0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVDMA1CFG		0x0003F10C
#define XAIEGBL_CORE_STRSWISLVDMA1CFGWID		32
#define XAIEGBL_CORE_STRSWISLVDMA1CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVDMA1CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVDMA1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVDMA1CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVDMA1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVTILCTRCFG		0x0003F110
#define XAIEGBL_CORE_STRSWISLVTILCTRCFGWID		32
#define XAIEGBL_CORE_STRSWISLVTILCTRCFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVTILCTRCFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVTILCTRCFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVTILCTRCFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRCFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVTILCTRCFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVTILCTRCFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVTILCTRCFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVTILCTRCFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVFIF0CFG		0x0003F114
#define XAIEGBL_CORE_STRSWISLVFIF0CFGWID		32
#define XAIEGBL_CORE_STRSWISLVFIF0CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVFIF0CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVFIF0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVFIF0CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVFIF0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVFIF1CFG		0x0003F118
#define XAIEGBL_CORE_STRSWISLVFIF1CFGWID		32
#define XAIEGBL_CORE_STRSWISLVFIF1CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVFIF1CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVFIF1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVFIF1CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVFIF1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVSOU0CFG		0x0003F11C
#define XAIEGBL_CORE_STRSWISLVSOU0CFGWID		32
#define XAIEGBL_CORE_STRSWISLVSOU0CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVSOU0CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVSOU0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVSOU0CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVSOU0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVSOU1CFG		0x0003F120
#define XAIEGBL_CORE_STRSWISLVSOU1CFGWID		32
#define XAIEGBL_CORE_STRSWISLVSOU1CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVSOU1CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVSOU1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVSOU1CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVSOU1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVSOU2CFG		0x0003F124
#define XAIEGBL_CORE_STRSWISLVSOU2CFGWID		32
#define XAIEGBL_CORE_STRSWISLVSOU2CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVSOU2CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU2CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVSOU2CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVSOU2CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU2CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVSOU2CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU2CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVSOU3CFG		0x0003F128
#define XAIEGBL_CORE_STRSWISLVSOU3CFGWID		32
#define XAIEGBL_CORE_STRSWISLVSOU3CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVSOU3CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU3CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVSOU3CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVSOU3CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU3CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVSOU3CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU3CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVSOU4CFG		0x0003F12C
#define XAIEGBL_CORE_STRSWISLVSOU4CFGWID		32
#define XAIEGBL_CORE_STRSWISLVSOU4CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVSOU4CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU4CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVSOU4CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVSOU4CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU4CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVSOU4CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU4CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVSOU5CFG		0x0003F130
#define XAIEGBL_CORE_STRSWISLVSOU5CFGWID		32
#define XAIEGBL_CORE_STRSWISLVSOU5CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVSOU5CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU5CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVSOU5CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVSOU5CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU5CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVSOU5CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU5CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVWES0CFG		0x0003F134
#define XAIEGBL_CORE_STRSWISLVWES0CFGWID		32
#define XAIEGBL_CORE_STRSWISLVWES0CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVWES0CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVWES0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVWES0CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVWES0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVWES1CFG		0x0003F138
#define XAIEGBL_CORE_STRSWISLVWES1CFGWID		32
#define XAIEGBL_CORE_STRSWISLVWES1CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVWES1CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVWES1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVWES1CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVWES1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVWES2CFG		0x0003F13C
#define XAIEGBL_CORE_STRSWISLVWES2CFGWID		32
#define XAIEGBL_CORE_STRSWISLVWES2CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVWES2CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES2CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVWES2CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVWES2CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES2CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVWES2CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES2CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVWES3CFG		0x0003F140
#define XAIEGBL_CORE_STRSWISLVWES3CFGWID		32
#define XAIEGBL_CORE_STRSWISLVWES3CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVWES3CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES3CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVWES3CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVWES3CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES3CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVWES3CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES3CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVNOR0CFG		0x0003F144
#define XAIEGBL_CORE_STRSWISLVNOR0CFGWID		32
#define XAIEGBL_CORE_STRSWISLVNOR0CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVNOR0CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVNOR0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVNOR0CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVNOR0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVNOR1CFG		0x0003F148
#define XAIEGBL_CORE_STRSWISLVNOR1CFGWID		32
#define XAIEGBL_CORE_STRSWISLVNOR1CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVNOR1CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVNOR1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVNOR1CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVNOR1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVNOR2CFG		0x0003F14C
#define XAIEGBL_CORE_STRSWISLVNOR2CFGWID		32
#define XAIEGBL_CORE_STRSWISLVNOR2CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVNOR2CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR2CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVNOR2CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVNOR2CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR2CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVNOR2CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR2CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVNOR3CFG		0x0003F150
#define XAIEGBL_CORE_STRSWISLVNOR3CFGWID		32
#define XAIEGBL_CORE_STRSWISLVNOR3CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVNOR3CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR3CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVNOR3CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVNOR3CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR3CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVNOR3CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR3CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVEAS0CFG		0x0003F154
#define XAIEGBL_CORE_STRSWISLVEAS0CFGWID		32
#define XAIEGBL_CORE_STRSWISLVEAS0CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVEAS0CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVEAS0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVEAS0CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVEAS0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVEAS1CFG		0x0003F158
#define XAIEGBL_CORE_STRSWISLVEAS1CFGWID		32
#define XAIEGBL_CORE_STRSWISLVEAS1CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVEAS1CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVEAS1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVEAS1CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVEAS1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVEAS2CFG		0x0003F15C
#define XAIEGBL_CORE_STRSWISLVEAS2CFGWID		32
#define XAIEGBL_CORE_STRSWISLVEAS2CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVEAS2CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS2CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVEAS2CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVEAS2CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS2CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVEAS2CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS2CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVEAS3CFG		0x0003F160
#define XAIEGBL_CORE_STRSWISLVEAS3CFGWID		32
#define XAIEGBL_CORE_STRSWISLVEAS3CFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVEAS3CFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS3CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVEAS3CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3CFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVEAS3CFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS3CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVEAS3CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS3CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVMETRACFG		0x0003F164
#define XAIEGBL_CORE_STRSWISLVMETRACFGWID		32
#define XAIEGBL_CORE_STRSWISLVMETRACFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVMETRACFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMETRACFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVMETRACFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRACFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVMETRACFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMETRACFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVMETRACFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMETRACFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVMEMTRACFG		0x0003F168
#define XAIEGBL_CORE_STRSWISLVMEMTRACFGWID		32
#define XAIEGBL_CORE_STRSWISLVMEMTRACFG_SLVENA_LSB		31
#define XAIEGBL_CORE_STRSWISLVMEMTRACFG_SLVENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMEMTRACFG_SLVENA_MASK		0x80000000
#define XAIEGBL_CORE_STRSWISLVMEMTRACFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRACFG_PKTENA_LSB		30
#define XAIEGBL_CORE_STRSWISLVMEMTRACFG_PKTENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMEMTRACFG_PKTENA_MASK		0x40000000
#define XAIEGBL_CORE_STRSWISLVMEMTRACFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMEMTRACFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0		0x0003F200
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1		0x0003F204
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2		0x0003F208
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3		0x0003F20C
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMECORE0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0		0x0003F210
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1		0x0003F214
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2		0x0003F218
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3		0x0003F21C
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMECORE1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMECORE1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVDMA0SLO0		0x0003F220
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVDMA0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVDMA0SLO1		0x0003F224
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVDMA0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVDMA0SLO2		0x0003F228
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVDMA0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVDMA0SLO3		0x0003F22C
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVDMA0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVDMA1SLO0		0x0003F230
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVDMA1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVDMA1SLO1		0x0003F234
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVDMA1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVDMA1SLO2		0x0003F238
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVDMA1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVDMA1SLO3		0x0003F23C
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVDMA1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVDMA1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0		0x0003F240
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0WID		32
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVTILCTRSLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1		0x0003F244
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1WID		32
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVTILCTRSLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2		0x0003F248
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2WID		32
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVTILCTRSLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3		0x0003F24C
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3WID		32
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVTILCTRSLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVTILCTRSLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVFIF0SLO0		0x0003F250
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVFIF0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVFIF0SLO1		0x0003F254
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVFIF0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVFIF0SLO2		0x0003F258
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVFIF0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVFIF0SLO3		0x0003F25C
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVFIF0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVFIF1SLO0		0x0003F260
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVFIF1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVFIF1SLO1		0x0003F264
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVFIF1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVFIF1SLO2		0x0003F268
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVFIF1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVFIF1SLO3		0x0003F26C
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVFIF1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVFIF1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU0SLO0		0x0003F270
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU0SLO1		0x0003F274
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU0SLO2		0x0003F278
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU0SLO3		0x0003F27C
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU1SLO0		0x0003F280
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU1SLO1		0x0003F284
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU1SLO2		0x0003F288
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU1SLO3		0x0003F28C
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU2SLO0		0x0003F290
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU2SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU2SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU2SLO1		0x0003F294
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU2SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU2SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU2SLO2		0x0003F298
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU2SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU2SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU2SLO3		0x0003F29C
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU2SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU2SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU3SLO0		0x0003F2A0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU3SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU3SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU3SLO1		0x0003F2A4
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU3SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU3SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU3SLO2		0x0003F2A8
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU3SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU3SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU3SLO3		0x0003F2AC
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU3SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU3SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU4SLO0		0x0003F2B0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU4SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU4SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU4SLO1		0x0003F2B4
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU4SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU4SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU4SLO2		0x0003F2B8
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU4SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU4SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU4SLO3		0x0003F2BC
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU4SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU4SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU5SLO0		0x0003F2C0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU5SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU5SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU5SLO1		0x0003F2C4
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU5SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU5SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU5SLO2		0x0003F2C8
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU5SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU5SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVSOU5SLO3		0x0003F2CC
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVSOU5SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVSOU5SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES0SLO0		0x0003F2D0
#define XAIEGBL_CORE_STRSWISLVWES0SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES0SLO1		0x0003F2D4
#define XAIEGBL_CORE_STRSWISLVWES0SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES0SLO2		0x0003F2D8
#define XAIEGBL_CORE_STRSWISLVWES0SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES0SLO3		0x0003F2DC
#define XAIEGBL_CORE_STRSWISLVWES0SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES1SLO0		0x0003F2E0
#define XAIEGBL_CORE_STRSWISLVWES1SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES1SLO1		0x0003F2E4
#define XAIEGBL_CORE_STRSWISLVWES1SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES1SLO2		0x0003F2E8
#define XAIEGBL_CORE_STRSWISLVWES1SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES1SLO3		0x0003F2EC
#define XAIEGBL_CORE_STRSWISLVWES1SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES2SLO0		0x0003F2F0
#define XAIEGBL_CORE_STRSWISLVWES2SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES2SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES2SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES2SLO1		0x0003F2F4
#define XAIEGBL_CORE_STRSWISLVWES2SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES2SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES2SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES2SLO2		0x0003F2F8
#define XAIEGBL_CORE_STRSWISLVWES2SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES2SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES2SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES2SLO3		0x0003F2FC
#define XAIEGBL_CORE_STRSWISLVWES2SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES2SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES2SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES3SLO0		0x0003F300
#define XAIEGBL_CORE_STRSWISLVWES3SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES3SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES3SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES3SLO1		0x0003F304
#define XAIEGBL_CORE_STRSWISLVWES3SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES3SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES3SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES3SLO2		0x0003F308
#define XAIEGBL_CORE_STRSWISLVWES3SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES3SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES3SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVWES3SLO3		0x0003F30C
#define XAIEGBL_CORE_STRSWISLVWES3SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVWES3SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVWES3SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR0SLO0		0x0003F310
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR0SLO1		0x0003F314
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR0SLO2		0x0003F318
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR0SLO3		0x0003F31C
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR1SLO0		0x0003F320
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR1SLO1		0x0003F324
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR1SLO2		0x0003F328
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR1SLO3		0x0003F32C
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR2SLO0		0x0003F330
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR2SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR2SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR2SLO1		0x0003F334
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR2SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR2SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR2SLO2		0x0003F338
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR2SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR2SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR2SLO3		0x0003F33C
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR2SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR2SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR3SLO0		0x0003F340
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR3SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR3SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR3SLO1		0x0003F344
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR3SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR3SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR3SLO2		0x0003F348
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR3SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR3SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVNOR3SLO3		0x0003F34C
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVNOR3SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVNOR3SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS0SLO0		0x0003F350
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS0SLO1		0x0003F354
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS0SLO2		0x0003F358
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS0SLO3		0x0003F35C
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS1SLO0		0x0003F360
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS1SLO1		0x0003F364
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS1SLO2		0x0003F368
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS1SLO3		0x0003F36C
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS2SLO0		0x0003F370
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS2SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS2SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS2SLO1		0x0003F374
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS2SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS2SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS2SLO2		0x0003F378
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS2SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS2SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS2SLO3		0x0003F37C
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS2SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS2SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS3SLO0		0x0003F380
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0WID		32
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS3SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS3SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS3SLO1		0x0003F384
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1WID		32
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS3SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS3SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS3SLO2		0x0003F388
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2WID		32
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS3SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS3SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVEAS3SLO3		0x0003F38C
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3WID		32
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVEAS3SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVEAS3SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMETRASLO0		0x0003F390
#define XAIEGBL_CORE_STRSWISLVMETRASLO0WID		32
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMETRASLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMETRASLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMETRASLO1		0x0003F394
#define XAIEGBL_CORE_STRSWISLVMETRASLO1WID		32
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMETRASLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMETRASLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMETRASLO2		0x0003F398
#define XAIEGBL_CORE_STRSWISLVMETRASLO2WID		32
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMETRASLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMETRASLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMETRASLO3		0x0003F39C
#define XAIEGBL_CORE_STRSWISLVMETRASLO3WID		32
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMETRASLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMETRASLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0		0x0003F3A0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0WID		32
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO0_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMEMTRASLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1		0x0003F3A4
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1WID		32
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO1_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMEMTRASLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2		0x0003F3A8
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2WID		32
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO2_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMEMTRASLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3		0x0003F3AC
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3WID		32
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ID_LSB		24
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ID_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSK_LSB		16
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSK_WIDTH		5
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSK_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSK_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ENA_LSB		8
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ENA_WIDTH		1
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ENA_MASK		0x00000100
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ENA_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSE_LSB		4
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSE_WIDTH		2
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSE_MASK		0x00000030
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_MSE_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ARB_LSB		0
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ARB_WIDTH		3
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ARB_MASK		0x00000007
#define XAIEGBL_CORE_STRSWISLVMEMTRASLO3_ARB_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWISLVMEMTRASLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_CORE_STRSWIEVTPORTSEL0		0x0003FF00
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0WID		32
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3MSTRSLV_LSB		29
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3MSTRSLV_WIDTH		1
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3MSTRSLV_MASK		0x20000000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3MSTRSLV_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3ID_LSB		24
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3ID_WIDTH		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT3ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2MSTRSLV_LSB		21
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2MSTRSLV_WIDTH		1
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2MSTRSLV_MASK		0x00200000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2MSTRSLV_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2ID_LSB		16
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2ID_WIDTH		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2ID_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT2ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1MSTRSLV_LSB		13
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1MSTRSLV_WIDTH		1
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1MSTRSLV_MASK		0x00002000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1MSTRSLV_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1ID_LSB		8
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1ID_WIDTH		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1ID_MASK		0x00001F00
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT1ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0MSTRSLV_LSB		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0MSTRSLV_WIDTH		1
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0MSTRSLV_MASK		0x00000020
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0MSTRSLV_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0ID_LSB		0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0ID_WIDTH		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0ID_MASK		0x0000001F
#define XAIEGBL_CORE_STRSWIEVTPORTSEL0_PORT0ID_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIEVTPORTSEL0(Port_3_Master_Slave,Port_3_ID,Port_2_Master_Slave,Port_2_ID,Port_1_Master_Slave,Port_1_ID,Port_0_Master_Slave,Port_0_ID)		(((Port_3_Master_Slave&0x00000001)<<29)+((Port_3_ID&0x0000001f)<<24)+((Port_2_Master_Slave&0x00000001)<<21)+((Port_2_ID&0x0000001f)<<16)+((Port_1_Master_Slave&0x00000001)<<13)+((Port_1_ID&0x0000001f)<<8)+((Port_0_Master_Slave&0x00000001)<<5)+(Port_0_ID&0x0000001f))

#define XAIEGBL_CORE_STRSWIEVTPORTSEL1		0x0003FF04
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1WID		32
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7MSTRSLV_LSB		29
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7MSTRSLV_WIDTH		1
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7MSTRSLV_MASK		0x20000000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7MSTRSLV_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7ID_LSB		24
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7ID_WIDTH		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7ID_MASK		0x1F000000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT7ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6MSTRSLV_LSB		21
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6MSTRSLV_WIDTH		1
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6MSTRSLV_MASK		0x00200000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6MSTRSLV_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6ID_LSB		16
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6ID_WIDTH		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6ID_MASK		0x001F0000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT6ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5MSTRSLV_LSB		13
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5MSTRSLV_WIDTH		1
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5MSTRSLV_MASK		0x00002000
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5MSTRSLV_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5ID_LSB		8
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5ID_WIDTH		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5ID_MASK		0x00001F00
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT5ID_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4MSTRSLV_LSB		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4MSTRSLV_WIDTH		1
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4MSTRSLV_MASK		0x00000020
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4MSTRSLV_DEFVAL		0x0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4ID_LSB		0
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4ID_WIDTH		5
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4ID_MASK		0x0000001F
#define XAIEGBL_CORE_STRSWIEVTPORTSEL1_PORT4ID_DEFVAL		0x0
#define XAIEGBL_CORE_VALUE_STRSWIEVTPORTSEL1(Port_7_Master_Slave,Port_7_ID,Port_6_Master_Slave,Port_6_ID,Port_5_Master_Slave,Port_5_ID,Port_4_Master_Slave,Port_4_ID)		(((Port_7_Master_Slave&0x00000001)<<29)+((Port_7_ID&0x0000001f)<<24)+((Port_6_Master_Slave&0x00000001)<<21)+((Port_6_ID&0x0000001f)<<16)+((Port_5_Master_Slave&0x00000001)<<13)+((Port_5_ID&0x0000001f)<<8)+((Port_4_Master_Slave&0x00000001)<<5)+(Port_4_ID&0x0000001f))

#define XAIEGBL_CORE_MODULE_ERROR_HALT_EVENT                           0x00032034
#define XAIEGBL_CORE_MODULE_ERROR_HALT_EVENT_WIDTH                     32
#define XAIEGBL_CORE_MODULE_ERROR_HALT_EVENT_MASK                      0x0000007F
#define XAIEGBL_CORE_MODULE_ERROR_HALT_EVENT_ERROR_HALT_CORE_EVENT_LSB 0
#define XAIEGBL_CORE_MODULE_ERROR_HALT_EVENT_ERROR_HALT_CORE_EVENT_WIDTH 7
#define XAIEGBL_CORE_MODULE_ERROR_HALT_EVENT_ERROR_HALT_CORE_EVENT_MASK 0x0000007F
#define XAIEGBL_CORE_MODULE_ERROR_HALT_EVENT_ERROR_HALT_CORE_EVENT_DEFVAL 0x0
/** @} */

/* Append new macros here */

/**
 * @name Pl Module register definitions
 * This registers contains pl module information
 * @{
 */
/**
 * Register:XAIEMLGBL_PL_MODULE
 */
#define XAIEGBL_PL_PERCTR0		0x00031000
#define XAIEGBL_PL_PERCTR0WID		32
#define XAIEGBL_PL_PERCTR0MSK		0x7F7F7F7F
#define XAIEGBL_PL_PERCTR0_CNT1STOPEVT_LSB		24
#define XAIEGBL_PL_PERCTR0_CNT1STOPEVT_WIDTH		7
#define XAIEGBL_PL_PERCTR0_CNT1STOPEVT_MASK		0x7F000000
#define XAIEGBL_PL_PERCTR0_CNT1STOPEVT_DEFVAL		0x0
#define XAIEGBL_PL_PERCTR0_CNT1STAEVT_LSB		16
#define XAIEGBL_PL_PERCTR0_CNT1STAEVT_WIDTH		7
#define XAIEGBL_PL_PERCTR0_CNT1STAEVT_MASK		0x007F0000
#define XAIEGBL_PL_PERCTR0_CNT1STAEVT_DEFVAL		0x0
#define XAIEGBL_PL_PERCTR0_CNT0STOPEVT_LSB		8
#define XAIEGBL_PL_PERCTR0_CNT0STOPEVT_WIDTH		7
#define XAIEGBL_PL_PERCTR0_CNT0STOPEVT_MASK		0x00007F00
#define XAIEGBL_PL_PERCTR0_CNT0STOPEVT_DEFVAL		0x0
#define XAIEGBL_PL_PERCTR0_CNT0STAEVT_LSB		0
#define XAIEGBL_PL_PERCTR0_CNT0STAEVT_WIDTH		7
#define XAIEGBL_PL_PERCTR0_CNT0STAEVT_MASK		0x0000007F
#define XAIEGBL_PL_PERCTR0_CNT0STAEVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_PERCTR0(Cnt1_Stop_Event,Cnt1_Start_Event,Cnt0_Stop_Event,Cnt0_Start_Event)		(((Cnt1_Stop_Event&0x0000007f)<<24)+((Cnt1_Start_Event&0x0000007f)<<16)+((Cnt0_Stop_Event&0x0000007f)<<8)+(Cnt0_Start_Event&0x0000007f))

#define XAIEGBL_PL_PERCTR1		0x00031008
#define XAIEGBL_PL_PERCTR1WID		32
#define XAIEGBL_PL_PERCTR1MSK		0x00007F7F
#define XAIEGBL_PL_PERCTR1_CNT1RSTEVT_LSB		8
#define XAIEGBL_PL_PERCTR1_CNT1RSTEVT_WIDTH		7
#define XAIEGBL_PL_PERCTR1_CNT1RSTEVT_MASK		0x00007F00
#define XAIEGBL_PL_PERCTR1_CNT1RSTEVT_DEFVAL		0x0
#define XAIEGBL_PL_PERCTR1_CNT0RSTEVT_LSB		0
#define XAIEGBL_PL_PERCTR1_CNT0RSTEVT_WIDTH		7
#define XAIEGBL_PL_PERCTR1_CNT0RSTEVT_MASK		0x0000007F
#define XAIEGBL_PL_PERCTR1_CNT0RSTEVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_PERCTR1(Cnt1_Reset_Event,Cnt0_Reset_Event)		(((Cnt1_Reset_Event&0x0000007f)<<8)+(Cnt0_Reset_Event&0x0000007f))

#define XAIEGBL_PL_PERCOU0		0x00031020
#define XAIEGBL_PL_PERCOU0WID		32
#define XAIEGBL_PL_PERCOU0MSK		0xFFFFFFFF
#define XAIEGBL_PL_PERCOU0_COU0VAL_LSB		0
#define XAIEGBL_PL_PERCOU0_COU0VAL_WIDTH		32
#define XAIEGBL_PL_PERCOU0_COU0VAL_MASK		0xFFFFFFFF
#define XAIEGBL_PL_PERCOU0_COU0VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_PERCOU0(Counter0_Value)		((Counter0_Value&0xffffffff))

#define XAIEGBL_PL_PERCOU1		0x00031024
#define XAIEGBL_PL_PERCOU1WID		32
#define XAIEGBL_PL_PERCOU1MSK		0xFFFFFFFF
#define XAIEGBL_PL_PERCOU1_COU0VAL_LSB		0
#define XAIEGBL_PL_PERCOU1_COU0VAL_WIDTH		32
#define XAIEGBL_PL_PERCOU1_COU0VAL_MASK		0xFFFFFFFF
#define XAIEGBL_PL_PERCOU1_COU0VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_PERCOU1(Counter0_Value)		((Counter0_Value&0xffffffff))

#define XAIEGBL_PL_PERCOU0EVTVAL		0x00031080
#define XAIEGBL_PL_PERCOU0EVTVALWID		32
#define XAIEGBL_PL_PERCOU0EVTVALMSK		0xFFFFFFFF
#define XAIEGBL_PL_PERCOU0EVTVAL_COUEVTVAL_LSB		0
#define XAIEGBL_PL_PERCOU0EVTVAL_COUEVTVAL_WIDTH		32
#define XAIEGBL_PL_PERCOU0EVTVAL_COUEVTVAL_MASK		0xFFFFFFFF
#define XAIEGBL_PL_PERCOU0EVTVAL_COUEVTVAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_PERCOU0EVTVAL(Counter_Event_Value)		((Counter_Event_Value&0xffffffff))

#define XAIEGBL_PL_PERCOU1EVTVAL		0x00031084
#define XAIEGBL_PL_PERCOU1EVTVALWID		32
#define XAIEGBL_PL_PERCOU1EVTVALMSK		0xFFFFFFFF
#define XAIEGBL_PL_PERCOU1EVTVAL_COUEVTVAL_LSB		0
#define XAIEGBL_PL_PERCOU1EVTVAL_COUEVTVAL_WIDTH		32
#define XAIEGBL_PL_PERCOU1EVTVAL_COUEVTVAL_MASK		0xFFFFFFFF
#define XAIEGBL_PL_PERCOU1EVTVAL_COUEVTVAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_PERCOU1EVTVAL(Counter_Event_Value)		((Counter_Event_Value&0xffffffff))

#define XAIEGBL_PL_PLINTUPSCFG		0x00033000
#define XAIEGBL_PL_PLINTUPSCFGWID		32
#define XAIEGBL_PL_PLINTUPSCFGMSK		0x000001FF
#define XAIEGBL_PL_PLINTUPSCFG_SOU4SOU5128COM_LSB		8
#define XAIEGBL_PL_PLINTUPSCFG_SOU4SOU5128COM_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU4SOU5128COM_MASK		0x00000100
#define XAIEGBL_PL_PLINTUPSCFG_SOU4SOU5128COM_DEFVAL		0x0
#define XAIEGBL_PL_PLINTUPSCFG_SOU5_LSB		7
#define XAIEGBL_PL_PLINTUPSCFG_SOU5_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU5_MASK		0x00000080
#define XAIEGBL_PL_PLINTUPSCFG_SOU5_DEFVAL		0x1
#define XAIEGBL_PL_PLINTUPSCFG_SOU4_LSB		6
#define XAIEGBL_PL_PLINTUPSCFG_SOU4_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU4_MASK		0x00000040
#define XAIEGBL_PL_PLINTUPSCFG_SOU4_DEFVAL		0x1
#define XAIEGBL_PL_PLINTUPSCFG_SOU2SOU3128COM_LSB		5
#define XAIEGBL_PL_PLINTUPSCFG_SOU2SOU3128COM_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU2SOU3128COM_MASK		0x00000020
#define XAIEGBL_PL_PLINTUPSCFG_SOU2SOU3128COM_DEFVAL		0x0
#define XAIEGBL_PL_PLINTUPSCFG_SOU3_LSB		4
#define XAIEGBL_PL_PLINTUPSCFG_SOU3_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU3_MASK		0x00000010
#define XAIEGBL_PL_PLINTUPSCFG_SOU3_DEFVAL		0x1
#define XAIEGBL_PL_PLINTUPSCFG_SOU2_LSB		3
#define XAIEGBL_PL_PLINTUPSCFG_SOU2_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU2_MASK		0x00000008
#define XAIEGBL_PL_PLINTUPSCFG_SOU2_DEFVAL		0x1
#define XAIEGBL_PL_PLINTUPSCFG_SOU0SOU1128COM_LSB		2
#define XAIEGBL_PL_PLINTUPSCFG_SOU0SOU1128COM_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU0SOU1128COM_MASK		0x00000004
#define XAIEGBL_PL_PLINTUPSCFG_SOU0SOU1128COM_DEFVAL		0x0
#define XAIEGBL_PL_PLINTUPSCFG_SOU1_LSB		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU1_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU1_MASK		0x00000002
#define XAIEGBL_PL_PLINTUPSCFG_SOU1_DEFVAL		0x1
#define XAIEGBL_PL_PLINTUPSCFG_SOU0_LSB		0
#define XAIEGBL_PL_PLINTUPSCFG_SOU0_WIDTH		1
#define XAIEGBL_PL_PLINTUPSCFG_SOU0_MASK		0x00000001
#define XAIEGBL_PL_PLINTUPSCFG_SOU0_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_PLINTUPSCFG(South4_South5_128_combine,South5,South4,South2_South3_128_combine,South3,South2,South0_South1_128_combine,South1,South0)		(((South4_South5_128_combine&0x00000001)<<8)+((South5&0x00000001)<<7)+((South4&0x00000001)<<6)+((South2_South3_128_combine&0x00000001)<<5)+((South3&0x00000001)<<4)+((South2&0x00000001)<<3)+((South0_South1_128_combine&0x00000001)<<2)+((South1&0x00000001)<<1)+(South0&0x00000001))

#define XAIEGBL_PL_PLINTDOWCFG		0x00033004
#define XAIEGBL_PL_PLINTDOWCFGWID		32
#define XAIEGBL_PL_PLINTDOWCFGMSK		0x00000FFF
#define XAIEGBL_PL_PLINTDOWCFG_SOU6SOU7128COM_LSB		11
#define XAIEGBL_PL_PLINTDOWCFG_SOU6SOU7128COM_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU6SOU7128COM_MASK		0x00000800
#define XAIEGBL_PL_PLINTDOWCFG_SOU6SOU7128COM_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWCFG_SOU7_LSB		10
#define XAIEGBL_PL_PLINTDOWCFG_SOU7_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU7_MASK		0x00000400
#define XAIEGBL_PL_PLINTDOWCFG_SOU7_DEFVAL		0x1
#define XAIEGBL_PL_PLINTDOWCFG_SOU6_LSB		9
#define XAIEGBL_PL_PLINTDOWCFG_SOU6_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU6_MASK		0x00000200
#define XAIEGBL_PL_PLINTDOWCFG_SOU6_DEFVAL		0x1
#define XAIEGBL_PL_PLINTDOWCFG_SOU4SOU5128COM_LSB		8
#define XAIEGBL_PL_PLINTDOWCFG_SOU4SOU5128COM_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU4SOU5128COM_MASK		0x00000100
#define XAIEGBL_PL_PLINTDOWCFG_SOU4SOU5128COM_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWCFG_SOU5_LSB		7
#define XAIEGBL_PL_PLINTDOWCFG_SOU5_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU5_MASK		0x00000080
#define XAIEGBL_PL_PLINTDOWCFG_SOU5_DEFVAL		0x1
#define XAIEGBL_PL_PLINTDOWCFG_SOU4_LSB		6
#define XAIEGBL_PL_PLINTDOWCFG_SOU4_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU4_MASK		0x00000040
#define XAIEGBL_PL_PLINTDOWCFG_SOU4_DEFVAL		0x1
#define XAIEGBL_PL_PLINTDOWCFG_SOU2SOU3128COM_LSB		5
#define XAIEGBL_PL_PLINTDOWCFG_SOU2SOU3128COM_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU2SOU3128COM_MASK		0x00000020
#define XAIEGBL_PL_PLINTDOWCFG_SOU2SOU3128COM_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWCFG_SOU3_LSB		4
#define XAIEGBL_PL_PLINTDOWCFG_SOU3_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU3_MASK		0x00000010
#define XAIEGBL_PL_PLINTDOWCFG_SOU3_DEFVAL		0x1
#define XAIEGBL_PL_PLINTDOWCFG_SOU2_LSB		3
#define XAIEGBL_PL_PLINTDOWCFG_SOU2_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU2_MASK		0x00000008
#define XAIEGBL_PL_PLINTDOWCFG_SOU2_DEFVAL		0x1
#define XAIEGBL_PL_PLINTDOWCFG_SOU0SOU1128COM_LSB		2
#define XAIEGBL_PL_PLINTDOWCFG_SOU0SOU1128COM_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU0SOU1128COM_MASK		0x00000004
#define XAIEGBL_PL_PLINTDOWCFG_SOU0SOU1128COM_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWCFG_SOU1_LSB		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU1_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU1_MASK		0x00000002
#define XAIEGBL_PL_PLINTDOWCFG_SOU1_DEFVAL		0x1
#define XAIEGBL_PL_PLINTDOWCFG_SOU0_LSB		0
#define XAIEGBL_PL_PLINTDOWCFG_SOU0_WIDTH		1
#define XAIEGBL_PL_PLINTDOWCFG_SOU0_MASK		0x00000001
#define XAIEGBL_PL_PLINTDOWCFG_SOU0_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_PLINTDOWCFG(South6_South7_128_combine,South7,South6,South4_South5_128_combine,South5,South4,South2_South3_128_combine,South3,South2,South0_South1_128_combine,South1,South0)		(((South6_South7_128_combine&0x00000001)<<11)+((South7&0x00000001)<<10)+((South6&0x00000001)<<9)+((South4_South5_128_combine&0x00000001)<<8)+((South5&0x00000001)<<7)+((South4&0x00000001)<<6)+((South2_South3_128_combine&0x00000001)<<5)+((South3&0x00000001)<<4)+((South2&0x00000001)<<3)+((South0_South1_128_combine&0x00000001)<<2)+((South1&0x00000001)<<1)+(South0&0x00000001))

#define XAIEGBL_PL_PLINTDOWENA		0x00033008
#define XAIEGBL_PL_PLINTDOWENAWID		32
#define XAIEGBL_PL_PLINTDOWENAMSK		0x000000FF
#define XAIEGBL_PL_PLINTDOWENA_SOU7_LSB		7
#define XAIEGBL_PL_PLINTDOWENA_SOU7_WIDTH		1
#define XAIEGBL_PL_PLINTDOWENA_SOU7_MASK		0x00000080
#define XAIEGBL_PL_PLINTDOWENA_SOU7_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWENA_SOU6_LSB		6
#define XAIEGBL_PL_PLINTDOWENA_SOU6_WIDTH		1
#define XAIEGBL_PL_PLINTDOWENA_SOU6_MASK		0x00000040
#define XAIEGBL_PL_PLINTDOWENA_SOU6_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWENA_SOU5_LSB		5
#define XAIEGBL_PL_PLINTDOWENA_SOU5_WIDTH		1
#define XAIEGBL_PL_PLINTDOWENA_SOU5_MASK		0x00000020
#define XAIEGBL_PL_PLINTDOWENA_SOU5_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWENA_SOU4_LSB		4
#define XAIEGBL_PL_PLINTDOWENA_SOU4_WIDTH		1
#define XAIEGBL_PL_PLINTDOWENA_SOU4_MASK		0x00000010
#define XAIEGBL_PL_PLINTDOWENA_SOU4_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWENA_SOU3_LSB		3
#define XAIEGBL_PL_PLINTDOWENA_SOU3_WIDTH		1
#define XAIEGBL_PL_PLINTDOWENA_SOU3_MASK		0x00000008
#define XAIEGBL_PL_PLINTDOWENA_SOU3_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWENA_SOU2_LSB		2
#define XAIEGBL_PL_PLINTDOWENA_SOU2_WIDTH		1
#define XAIEGBL_PL_PLINTDOWENA_SOU2_MASK		0x00000004
#define XAIEGBL_PL_PLINTDOWENA_SOU2_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWENA_SOU1_LSB		1
#define XAIEGBL_PL_PLINTDOWENA_SOU1_WIDTH		1
#define XAIEGBL_PL_PLINTDOWENA_SOU1_MASK		0x00000002
#define XAIEGBL_PL_PLINTDOWENA_SOU1_DEFVAL		0x0
#define XAIEGBL_PL_PLINTDOWENA_SOU0_LSB		0
#define XAIEGBL_PL_PLINTDOWENA_SOU0_WIDTH		1
#define XAIEGBL_PL_PLINTDOWENA_SOU0_MASK		0x00000001
#define XAIEGBL_PL_PLINTDOWENA_SOU0_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_PLINTDOWENA(South7,South6,South5,South4,South3,South2,South1,South0)		(((South7&0x00000001)<<7)+((South6&0x00000001)<<6)+((South5&0x00000001)<<5)+((South4&0x00000001)<<4)+((South3&0x00000001)<<3)+((South2&0x00000001)<<2)+((South1&0x00000001)<<1)+(South0&0x00000001))

#define XAIEGBL_PL_PLINTDOWBYPASS		0x0003300C
#define XAIEGBL_PL_PLINTDOWBYPASSWID		32
#define XAIEGBL_PL_PLINTDOWBYPASSMSK		0x0000003F
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU6_LSB	5
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU6_WIDTH	1
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU6_MASK	0x00000020
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU6_DEFVAL	0x0
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU5_LSB	4
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU5_WIDTH	1
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU5_MASK	0x00000010
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU5_DEFVAL	0x0
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU4_LSB	3
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU4_WIDTH	1
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU4_MASK	0x00000008
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU4_DEFVAL	0x0
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU2_LSB	2
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU2_WIDTH	1
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU2_MASK	0x00000004
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU2_DEFVAL	0x0
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU1_LSB	1
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU1_WIDTH	1
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU1_MASK	0x00000002
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU1_DEFVAL	0x0
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU0_LSB	0
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU0_WIDTH	1
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU0_MASK	0x00000001
#define XAIEGBL_PL_PLINTDOWBYPASS_SOU0_DEFVAL	0x0
#define XAIEGBL_PL_VALUE_PLINTDOWBYPASS(South6,South5,South4,South2,South1,South0)		(((South6&0x00000001)<<5)+((South5&0x00000001)<<4)+((South4&0x00000001)<<3)+((South2&0x00000001)<<2)+((South1&0x00000001)<<1)+((South0&0x00000001)<<0))

#define XAIEGBL_PL_TIMCTRL		0x00034000
#define XAIEGBL_PL_TIMCTRLWID		32
#define XAIEGBL_PL_TIMCTRLMSK		0x80007F00
#define XAIEGBL_PL_TIMCTRL_RST_LSB		31
#define XAIEGBL_PL_TIMCTRL_RST_WIDTH		1
#define XAIEGBL_PL_TIMCTRL_RST_MASK		0x80000000
#define XAIEGBL_PL_TIMCTRL_RST_DEFVAL		0x0
#define XAIEGBL_PL_TIMCTRL_RSTEVT_LSB		8
#define XAIEGBL_PL_TIMCTRL_RSTEVT_WIDTH		7
#define XAIEGBL_PL_TIMCTRL_RSTEVT_MASK		0x00007F00
#define XAIEGBL_PL_TIMCTRL_RSTEVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TIMCTRL(Reset,Reset_Event)		(((Reset&0x00000001)<<31)+((Reset_Event&0x0000007f)<<8))

#define XAIEGBL_PL_EVTGEN		0x00034008
#define XAIEGBL_PL_EVTGENWID		32
#define XAIEGBL_PL_EVTGENMSK		0x0000007F
#define XAIEGBL_PL_EVTGEN_EVT_LSB		0
#define XAIEGBL_PL_EVTGEN_EVT_WIDTH		7
#define XAIEGBL_PL_EVTGEN_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTGEN_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTGEN(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST0A		0x00034010
#define XAIEGBL_PL_EVTBRDCAST0AWID		32
#define XAIEGBL_PL_EVTBRDCAST0AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST0A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST0A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST0A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST0A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST0A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST1A		0x00034014
#define XAIEGBL_PL_EVTBRDCAST1AWID		32
#define XAIEGBL_PL_EVTBRDCAST1AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST1A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST1A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST1A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST1A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST1A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST2A		0x00034018
#define XAIEGBL_PL_EVTBRDCAST2AWID		32
#define XAIEGBL_PL_EVTBRDCAST2AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST2A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST2A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST2A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST2A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST2A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST3A		0x0003401C
#define XAIEGBL_PL_EVTBRDCAST3AWID		32
#define XAIEGBL_PL_EVTBRDCAST3AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST3A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST3A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST3A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST3A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST3A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST4A		0x00034020
#define XAIEGBL_PL_EVTBRDCAST4AWID		32
#define XAIEGBL_PL_EVTBRDCAST4AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST4A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST4A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST4A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST4A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST4A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST5A		0x00034024
#define XAIEGBL_PL_EVTBRDCAST5AWID		32
#define XAIEGBL_PL_EVTBRDCAST5AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST5A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST5A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST5A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST5A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST5A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST6A		0x00034028
#define XAIEGBL_PL_EVTBRDCAST6AWID		32
#define XAIEGBL_PL_EVTBRDCAST6AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST6A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST6A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST6A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST6A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST6A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST7A		0x0003402C
#define XAIEGBL_PL_EVTBRDCAST7AWID		32
#define XAIEGBL_PL_EVTBRDCAST7AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST7A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST7A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST7A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST7A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST7A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST8A		0x00034030
#define XAIEGBL_PL_EVTBRDCAST8AWID		32
#define XAIEGBL_PL_EVTBRDCAST8AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST8A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST8A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST8A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST8A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST8A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST9A		0x00034034
#define XAIEGBL_PL_EVTBRDCAST9AWID		32
#define XAIEGBL_PL_EVTBRDCAST9AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST9A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST9A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST9A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST9A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST9A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST10A		0x00034038
#define XAIEGBL_PL_EVTBRDCAST10AWID		32
#define XAIEGBL_PL_EVTBRDCAST10AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST10A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST10A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST10A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST10A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST10A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST11A		0x0003403C
#define XAIEGBL_PL_EVTBRDCAST11AWID		32
#define XAIEGBL_PL_EVTBRDCAST11AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST11A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST11A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST11A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST11A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST11A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST12A		0x00034040
#define XAIEGBL_PL_EVTBRDCAST12AWID		32
#define XAIEGBL_PL_EVTBRDCAST12AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST12A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST12A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST12A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST12A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST12A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST13A		0x00034044
#define XAIEGBL_PL_EVTBRDCAST13AWID		32
#define XAIEGBL_PL_EVTBRDCAST13AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST13A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST13A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST13A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST13A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST13A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST14A		0x00034048
#define XAIEGBL_PL_EVTBRDCAST14AWID		32
#define XAIEGBL_PL_EVTBRDCAST14AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST14A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST14A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST14A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST14A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST14A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCAST15A		0x0003404C
#define XAIEGBL_PL_EVTBRDCAST15AWID		32
#define XAIEGBL_PL_EVTBRDCAST15AMSK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST15A_EVT_LSB		0
#define XAIEGBL_PL_EVTBRDCAST15A_EVT_WIDTH		7
#define XAIEGBL_PL_EVTBRDCAST15A_EVT_MASK		0x0000007F
#define XAIEGBL_PL_EVTBRDCAST15A_EVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCAST15A(Event)		((Event&0x0000007f))

#define XAIEGBL_PL_EVTBRDCASTABLKSOUSET		0x00034050
#define XAIEGBL_PL_EVTBRDCASTABLKSOUSETWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKSOUSETMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKSOUSET_SET_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKSOUSET_SET_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKSOUSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKSOUSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKSOUSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKSOUCLR		0x00034054
#define XAIEGBL_PL_EVTBRDCASTABLKSOUCLRWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKSOUCLRMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKSOUCLR_CLR_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKSOUCLR_CLR_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKSOUCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKSOUCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKSOUCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKSOUVAL		0x00034058
#define XAIEGBL_PL_EVTBRDCASTABLKSOUVALWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKSOUVALMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKSOUVAL_VAL_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKSOUVAL_VAL_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKSOUVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKSOUVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKSOUVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKWESSET		0x00034060
#define XAIEGBL_PL_EVTBRDCASTABLKWESSETWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKWESSETMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKWESSET_SET_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKWESSET_SET_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKWESSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKWESSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKWESSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKWESCLR		0x00034064
#define XAIEGBL_PL_EVTBRDCASTABLKWESCLRWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKWESCLRMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKWESCLR_CLR_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKWESCLR_CLR_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKWESCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKWESCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKWESCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKWESVAL		0x00034068
#define XAIEGBL_PL_EVTBRDCASTABLKWESVALWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKWESVALMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKWESVAL_VAL_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKWESVAL_VAL_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKWESVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKWESVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKWESVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKNORSET		0x00034070
#define XAIEGBL_PL_EVTBRDCASTABLKNORSETWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKNORSETMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKNORSET_SET_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKNORSET_SET_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKNORSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKNORSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKNORSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKNORCLR		0x00034074
#define XAIEGBL_PL_EVTBRDCASTABLKNORCLRWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKNORCLRMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKNORCLR_CLR_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKNORCLR_CLR_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKNORCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKNORCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKNORCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKNORVAL		0x00034078
#define XAIEGBL_PL_EVTBRDCASTABLKNORVALWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKNORVALMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKNORVAL_VAL_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKNORVAL_VAL_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKNORVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKNORVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKNORVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKEASSET		0x00034080
#define XAIEGBL_PL_EVTBRDCASTABLKEASSETWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKEASSETMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKEASSET_SET_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKEASSET_SET_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKEASSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKEASSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKEASSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKEASCLR		0x00034084
#define XAIEGBL_PL_EVTBRDCASTABLKEASCLRWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKEASCLRMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKEASCLR_CLR_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKEASCLR_CLR_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKEASCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKEASCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKEASCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTABLKEASVAL		0x00034088
#define XAIEGBL_PL_EVTBRDCASTABLKEASVALWID		32
#define XAIEGBL_PL_EVTBRDCASTABLKEASVALMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKEASVAL_VAL_LSB		0
#define XAIEGBL_PL_EVTBRDCASTABLKEASVAL_VAL_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTABLKEASVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTABLKEASVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTABLKEASVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKSOUSET		0x00034090
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUSETWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUSETMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUSET_SET_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUSET_SET_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKSOUSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKSOUCLR		0x00034094
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUCLRWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUCLRMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUCLR_CLR_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUCLR_CLR_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKSOUCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKSOUVAL		0x00034098
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUVALWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUVALMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUVAL_VAL_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUVAL_VAL_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKSOUVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKSOUVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKWESSET		0x000340A0
#define XAIEGBL_PL_EVTBRDCASTBBLKWESSETWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKWESSETMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKWESSET_SET_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKWESSET_SET_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKWESSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKWESSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKWESSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKWESCLR		0x000340A4
#define XAIEGBL_PL_EVTBRDCASTBBLKWESCLRWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKWESCLRMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKWESCLR_CLR_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKWESCLR_CLR_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKWESCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKWESCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKWESCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKWESVAL		0x000340A8
#define XAIEGBL_PL_EVTBRDCASTBBLKWESVALWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKWESVALMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKWESVAL_VAL_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKWESVAL_VAL_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKWESVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKWESVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKWESVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKNORSET		0x000340B0
#define XAIEGBL_PL_EVTBRDCASTBBLKNORSETWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKNORSETMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKNORSET_SET_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKNORSET_SET_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKNORSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKNORSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKNORSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKNORCLR		0x000340B4
#define XAIEGBL_PL_EVTBRDCASTBBLKNORCLRWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKNORCLRMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKNORCLR_CLR_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKNORCLR_CLR_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKNORCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKNORCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKNORCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKNORVAL		0x000340B8
#define XAIEGBL_PL_EVTBRDCASTBBLKNORVALWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKNORVALMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKNORVAL_VAL_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKNORVAL_VAL_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKNORVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKNORVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKNORVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKEASSET		0x000340C0
#define XAIEGBL_PL_EVTBRDCASTBBLKEASSETWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKEASSETMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKEASSET_SET_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKEASSET_SET_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKEASSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKEASSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKEASSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKEASCLR		0x000340C4
#define XAIEGBL_PL_EVTBRDCASTBBLKEASCLRWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKEASCLRMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKEASCLR_CLR_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKEASCLR_CLR_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKEASCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKEASCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKEASCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_EVTBRDCASTBBLKEASVAL		0x000340C8
#define XAIEGBL_PL_EVTBRDCASTBBLKEASVALWID		32
#define XAIEGBL_PL_EVTBRDCASTBBLKEASVALMSK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKEASVAL_VAL_LSB		0
#define XAIEGBL_PL_EVTBRDCASTBBLKEASVAL_VAL_WIDTH		16
#define XAIEGBL_PL_EVTBRDCASTBBLKEASVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_EVTBRDCASTBBLKEASVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTBRDCASTBBLKEASVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_TILCTRL		0x00036030
#define XAIEGBL_PL_TILCTRLWID		32
#define XAIEGBL_PL_TILCTRL_ISOFROEAS_LSB		3
#define XAIEGBL_PL_TILCTRL_ISOFROEAS_WIDTH		1
#define XAIEGBL_PL_TILCTRL_ISOFROEAS_MASK		0x00000008
#define XAIEGBL_PL_TILCTRL_ISOFROEAS_DEFVAL		0x0
#define XAIEGBL_PL_TILCTRL_ISOFRONOR_LSB		2
#define XAIEGBL_PL_TILCTRL_ISOFRONOR_WIDTH		1
#define XAIEGBL_PL_TILCTRL_ISOFRONOR_MASK		0x00000004
#define XAIEGBL_PL_TILCTRL_ISOFRONOR_DEFVAL		0x0
#define XAIEGBL_PL_TILCTRL_ISOFROWES_LSB		1
#define XAIEGBL_PL_TILCTRL_ISOFROWES_WIDTH		1
#define XAIEGBL_PL_TILCTRL_ISOFROWES_MASK		0x00000002
#define XAIEGBL_PL_TILCTRL_ISOFROWES_DEFVAL		0x0
#define XAIEGBL_PL_TILCTRL_ISOFROSOU_LSB		0
#define XAIEGBL_PL_TILCTRL_ISOFROSOU_WIDTH		1
#define XAIEGBL_PL_TILCTRL_ISOFROSOU_MASK		0x00000001
#define XAIEGBL_PL_TILCTRL_ISOFROSOU_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TILCTRL(Isolate_From_East,Isolate_From_North,Isolate_From_West,Isolate_From_South)		(((Isolate_From_East&0x00000001)<<3)+((Isolate_From_North&0x00000001)<<2)+((Isolate_From_West&0x00000001)<<1)+(Isolate_From_South&0x00000001))

#define XAIEGBL_PL_TRACTRL0		0x000340D0
#define XAIEGBL_PL_TRACTRL0WID		32
#define XAIEGBL_PL_TRACTRL0MSK		0xFFFF0000
#define XAIEGBL_PL_TRACTRL0_TRASTOPEVT_LSB		24
#define XAIEGBL_PL_TRACTRL0_TRASTOPEVT_WIDTH		8
#define XAIEGBL_PL_TRACTRL0_TRASTOPEVT_MASK		0xFF000000
#define XAIEGBL_PL_TRACTRL0_TRASTOPEVT_DEFVAL		0x0
#define XAIEGBL_PL_TRACTRL0_TRASTAEVT_LSB		16
#define XAIEGBL_PL_TRACTRL0_TRASTAEVT_WIDTH		8
#define XAIEGBL_PL_TRACTRL0_TRASTAEVT_MASK		0x00FF0000
#define XAIEGBL_PL_TRACTRL0_TRASTAEVT_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TRACTRL0(Trace_Stop_Event,Trace_Start_Event)		(((Trace_Stop_Event&0x000000ff)<<24)+((Trace_Start_Event&0x000000ff)<<16))

#define XAIEGBL_PL_TRACTRL1		0x000340D4
#define XAIEGBL_PL_TRACTRL1WID		32
#define XAIEGBL_PL_TRACTRL1MSK		0x0000701F
#define XAIEGBL_PL_TRACTRL1_PKTTYP_LSB		12
#define XAIEGBL_PL_TRACTRL1_PKTTYP_WIDTH		3
#define XAIEGBL_PL_TRACTRL1_PKTTYP_MASK		0x00007000
#define XAIEGBL_PL_TRACTRL1_PKTTYP_DEFVAL		0x0
#define XAIEGBL_PL_TRACTRL1_ID_LSB		0
#define XAIEGBL_PL_TRACTRL1_ID_WIDTH		5
#define XAIEGBL_PL_TRACTRL1_ID_MASK		0x0000001F
#define XAIEGBL_PL_TRACTRL1_ID_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TRACTRL1(Packet_Type,ID)		(((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_PL_TRASTA		0x000340D8
#define XAIEGBL_PL_TRASTAWID		32
#define XAIEGBL_PL_TRASTAMSK		0x00000307
#define XAIEGBL_PL_TRASTA_STA_LSB		8
#define XAIEGBL_PL_TRASTA_STA_WIDTH		2
#define XAIEGBL_PL_TRASTA_STA_MASK		0x00000300
#define XAIEGBL_PL_TRASTA_STA_DEFVAL		0x0
#define XAIEGBL_PL_TRASTA_MOD_LSB		0
#define XAIEGBL_PL_TRASTA_MOD_WIDTH		3
#define XAIEGBL_PL_TRASTA_MOD_MASK		0x00000007
#define XAIEGBL_PL_TRASTA_MOD_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TRASTA(State,Mode)		(((State&0x00000003)<<8)+(Mode&0x00000007))

#define XAIEGBL_PL_TRAEVT0		0x000340E0
#define XAIEGBL_PL_TRAEVT0WID		32
#define XAIEGBL_PL_TRAEVT0MSK		0x7F7F7F7F
#define XAIEGBL_PL_TRAEVT0_TRAEVT3_LSB		24
#define XAIEGBL_PL_TRAEVT0_TRAEVT3_WIDTH		7
#define XAIEGBL_PL_TRAEVT0_TRAEVT3_MASK		0x7F000000
#define XAIEGBL_PL_TRAEVT0_TRAEVT3_DEFVAL		0x0
#define XAIEGBL_PL_TRAEVT0_TRAEVT2_LSB		16
#define XAIEGBL_PL_TRAEVT0_TRAEVT2_WIDTH		7
#define XAIEGBL_PL_TRAEVT0_TRAEVT2_MASK		0x007F0000
#define XAIEGBL_PL_TRAEVT0_TRAEVT2_DEFVAL		0x0
#define XAIEGBL_PL_TRAEVT0_TRAEVT1_LSB		8
#define XAIEGBL_PL_TRAEVT0_TRAEVT1_WIDTH		7
#define XAIEGBL_PL_TRAEVT0_TRAEVT1_MASK		0x00007F00
#define XAIEGBL_PL_TRAEVT0_TRAEVT1_DEFVAL		0x0
#define XAIEGBL_PL_TRAEVT0_TRAEVT0_LSB		0
#define XAIEGBL_PL_TRAEVT0_TRAEVT0_WIDTH		7
#define XAIEGBL_PL_TRAEVT0_TRAEVT0_MASK		0x0000007F
#define XAIEGBL_PL_TRAEVT0_TRAEVT0_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TRAEVT0(Trace_Event3,Trace_Event2,Trace_Event1,Trace_Event0)		(((Trace_Event3&0x0000007f)<<24)+((Trace_Event2&0x0000007f)<<16)+((Trace_Event1&0x0000007f)<<8)+(Trace_Event0&0x0000007f))

#define XAIEGBL_PL_TRAEVT1		0x000340E4
#define XAIEGBL_PL_TRAEVT1WID		32
#define XAIEGBL_PL_TRAEVT1MSK		0x7F7F7F7F
#define XAIEGBL_PL_TRAEVT1_TRAEVT7_LSB		24
#define XAIEGBL_PL_TRAEVT1_TRAEVT7_WIDTH		7
#define XAIEGBL_PL_TRAEVT1_TRAEVT7_MASK		0x7F000000
#define XAIEGBL_PL_TRAEVT1_TRAEVT7_DEFVAL		0x0
#define XAIEGBL_PL_TRAEVT1_TRAEVT6_LSB		16
#define XAIEGBL_PL_TRAEVT1_TRAEVT6_WIDTH		7
#define XAIEGBL_PL_TRAEVT1_TRAEVT6_MASK		0x007F0000
#define XAIEGBL_PL_TRAEVT1_TRAEVT6_DEFVAL		0x0
#define XAIEGBL_PL_TRAEVT1_TRAEVT5_LSB		8
#define XAIEGBL_PL_TRAEVT1_TRAEVT5_WIDTH		7
#define XAIEGBL_PL_TRAEVT1_TRAEVT5_MASK		0x00007F00
#define XAIEGBL_PL_TRAEVT1_TRAEVT5_DEFVAL		0x0
#define XAIEGBL_PL_TRAEVT1_TRAEVT4_LSB		0
#define XAIEGBL_PL_TRAEVT1_TRAEVT4_WIDTH		7
#define XAIEGBL_PL_TRAEVT1_TRAEVT4_MASK		0x0000007F
#define XAIEGBL_PL_TRAEVT1_TRAEVT4_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TRAEVT1(Trace_Event7,Trace_Event6,Trace_Event5,Trace_Event4)		(((Trace_Event7&0x0000007f)<<24)+((Trace_Event6&0x0000007f)<<16)+((Trace_Event5&0x0000007f)<<8)+(Trace_Event4&0x0000007f))

#define XAIEGBL_PL_TIMTRIEVTLOWVAL		0x000340F0
#define XAIEGBL_PL_TIMTRIEVTLOWVALWID		32
#define XAIEGBL_PL_TIMTRIEVTLOWVALMSK		0xFFFFFFFF
#define XAIEGBL_PL_TIMTRIEVTLOWVAL_TIM_LSB		0
#define XAIEGBL_PL_TIMTRIEVTLOWVAL_TIM_WIDTH		32
#define XAIEGBL_PL_TIMTRIEVTLOWVAL_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_PL_TIMTRIEVTLOWVAL_TIM_DEFVAL		0xFFFFFFFF
#define XAIEGBL_PL_VALUE_TIMTRIEVTLOWVAL(TimerTrigLow)		((TimerTrigLow&0xffffffff))

#define XAIEGBL_PL_TIMTRIEVTHIGVAL		0x000340F4
#define XAIEGBL_PL_TIMTRIEVTHIGVALWID		32
#define XAIEGBL_PL_TIMTRIEVTHIGVALMSK		0xFFFFFFFF
#define XAIEGBL_PL_TIMTRIEVTHIGVAL_TIM_LSB		0
#define XAIEGBL_PL_TIMTRIEVTHIGVAL_TIM_WIDTH		32
#define XAIEGBL_PL_TIMTRIEVTHIGVAL_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_PL_TIMTRIEVTHIGVAL_TIM_DEFVAL		0xFFFFFFFF
#define XAIEGBL_PL_VALUE_TIMTRIEVTHIGVAL(TimerTrigHigh)		((TimerTrigHigh&0xffffffff))

#define XAIEGBL_PL_TIMLOW		0x000340F8
#define XAIEGBL_PL_TIMLOWWID		32
#define XAIEGBL_PL_TIMLOWMSK		0xFFFFFFFF
#define XAIEGBL_PL_TIMLOW_TIM_LSB		0
#define XAIEGBL_PL_TIMLOW_TIM_WIDTH		32
#define XAIEGBL_PL_TIMLOW_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_PL_TIMLOW_TIM_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TIMLOW(TimerLow)		((TimerLow&0xffffffff))

#define XAIEGBL_PL_TIMHIG		0x000340FC
#define XAIEGBL_PL_TIMHIGWID		32
#define XAIEGBL_PL_TIMHIGMSK		0xFFFFFFFF
#define XAIEGBL_PL_TIMHIG_TIM_LSB		0
#define XAIEGBL_PL_TIMHIG_TIM_WIDTH		32
#define XAIEGBL_PL_TIMHIG_TIM_MASK		0xFFFFFFFF
#define XAIEGBL_PL_TIMHIG_TIM_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_TIMHIG(TimerHigh)		((TimerHigh&0xffffffff))

#define XAIEGBL_PL_EVTSTA0		0x00034200
#define XAIEGBL_PL_EVTSTA0WID		32
#define XAIEGBL_PL_EVTSTA0MSK		0xFFFFFFFF
#define XAIEGBL_PL_EVTSTA0_EVT310STA_LSB		0
#define XAIEGBL_PL_EVTSTA0_EVT310STA_WIDTH		32
#define XAIEGBL_PL_EVTSTA0_EVT310STA_MASK		0xFFFFFFFF
#define XAIEGBL_PL_EVTSTA0_EVT310STA_DEFVAL		0x2
#define XAIEGBL_PL_VALUE_EVTSTA0(Event_31_0_Status)		((Event_31_0_Status&0xffffffff))

#define XAIEGBL_PL_EVTSTA1		0x00034204
#define XAIEGBL_PL_EVTSTA1WID		32
#define XAIEGBL_PL_EVTSTA1MSK		0xFFFFFFFF
#define XAIEGBL_PL_EVTSTA1_EVT6332STA_LSB		0
#define XAIEGBL_PL_EVTSTA1_EVT6332STA_WIDTH		32
#define XAIEGBL_PL_EVTSTA1_EVT6332STA_MASK		0xFFFFFFFF
#define XAIEGBL_PL_EVTSTA1_EVT6332STA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTSTA1(Event_63_32_Status)		((Event_63_32_Status&0xffffffff))

#define XAIEGBL_PL_EVTSTA2		0x00034208
#define XAIEGBL_PL_EVTSTA2WID		32
#define XAIEGBL_PL_EVTSTA2MSK		0xFFFFFFFF
#define XAIEGBL_PL_EVTSTA2_EVT9564STA_LSB		0
#define XAIEGBL_PL_EVTSTA2_EVT9564STA_WIDTH		32
#define XAIEGBL_PL_EVTSTA2_EVT9564STA_MASK		0xFFFFFFFF
#define XAIEGBL_PL_EVTSTA2_EVT9564STA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTSTA2(Event_95_64_Status)		((Event_95_64_Status&0xffffffff))

#define XAIEGBL_PL_EVTSTA3		0x0003420C
#define XAIEGBL_PL_EVTSTA3WID		32
#define XAIEGBL_PL_EVTSTA3MSK		0xFFFFFFFF
#define XAIEGBL_PL_EVTSTA3_EVT12796STA_LSB		0
#define XAIEGBL_PL_EVTSTA3_EVT12796STA_WIDTH		32
#define XAIEGBL_PL_EVTSTA3_EVT12796STA_MASK		0xFFFFFFFF
#define XAIEGBL_PL_EVTSTA3_EVT12796STA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_EVTSTA3(Event_127_96_Status)		((Event_127_96_Status&0xffffffff))

#define XAIEGBL_PL_COMEVTINP		0x00034400
#define XAIEGBL_PL_COMEVTINPWID		32
#define XAIEGBL_PL_COMEVTINPMSK		0x7F7F7F7F
#define XAIEGBL_PL_COMEVTINP_EVTD_LSB		24
#define XAIEGBL_PL_COMEVTINP_EVTD_WIDTH		7
#define XAIEGBL_PL_COMEVTINP_EVTD_MASK		0x7F000000
#define XAIEGBL_PL_COMEVTINP_EVTD_DEFVAL		0x0
#define XAIEGBL_PL_COMEVTINP_EVTC_LSB		16
#define XAIEGBL_PL_COMEVTINP_EVTC_WIDTH		7
#define XAIEGBL_PL_COMEVTINP_EVTC_MASK		0x007F0000
#define XAIEGBL_PL_COMEVTINP_EVTC_DEFVAL		0x0
#define XAIEGBL_PL_COMEVTINP_EVTB_LSB		8
#define XAIEGBL_PL_COMEVTINP_EVTB_WIDTH		7
#define XAIEGBL_PL_COMEVTINP_EVTB_MASK		0x00007F00
#define XAIEGBL_PL_COMEVTINP_EVTB_DEFVAL		0x0
#define XAIEGBL_PL_COMEVTINP_EVTA_LSB		0
#define XAIEGBL_PL_COMEVTINP_EVTA_WIDTH		7
#define XAIEGBL_PL_COMEVTINP_EVTA_MASK		0x0000007F
#define XAIEGBL_PL_COMEVTINP_EVTA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_COMEVTINP(eventD,eventC,eventB,eventA)		(((eventD&0x0000007f)<<24)+((eventC&0x0000007f)<<16)+((eventB&0x0000007f)<<8)+(eventA&0x0000007f))

#define XAIEGBL_PL_COMEVTCTRL		0x00034404
#define XAIEGBL_PL_COMEVTCTRLWID		32
#define XAIEGBL_PL_COMEVTCTRLMSK		0x00030303
#define XAIEGBL_PL_COMEVTCTRL_COM2_LSB		16
#define XAIEGBL_PL_COMEVTCTRL_COM2_WIDTH		2
#define XAIEGBL_PL_COMEVTCTRL_COM2_MASK		0x00030000
#define XAIEGBL_PL_COMEVTCTRL_COM2_DEFVAL		0x0
#define XAIEGBL_PL_COMEVTCTRL_COM1_LSB		8
#define XAIEGBL_PL_COMEVTCTRL_COM1_WIDTH		2
#define XAIEGBL_PL_COMEVTCTRL_COM1_MASK		0x00000300
#define XAIEGBL_PL_COMEVTCTRL_COM1_DEFVAL		0x0
#define XAIEGBL_PL_COMEVTCTRL_COM0_LSB		0
#define XAIEGBL_PL_COMEVTCTRL_COM0_WIDTH		2
#define XAIEGBL_PL_COMEVTCTRL_COM0_MASK		0x00000003
#define XAIEGBL_PL_COMEVTCTRL_COM0_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_COMEVTCTRL(combo2,combo1,combo0)		(((combo2&0x00000003)<<16)+((combo1&0x00000003)<<8)+(combo0&0x00000003))

#define XAIEGBL_PL_EVTGRP0ENA		0x00034500
#define XAIEGBL_PL_EVTGRP0ENAWID		32
#define XAIEGBL_PL_EVTGRP0ENAMSK		0x000000FF
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT3_LSB		7
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT3_WIDTH		1
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT3_MASK		0x00000080
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT3_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT2_LSB		6
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT2_WIDTH		1
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT2_MASK		0x00000040
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT2_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT1_LSB		5
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT1_WIDTH		1
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT1_MASK		0x00000020
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT1_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT0_LSB		4
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT0_WIDTH		1
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT0_MASK		0x00000010
#define XAIEGBL_PL_EVTGRP0ENA_COMEVT0_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRP0ENA_PERCNT1_LSB		3
#define XAIEGBL_PL_EVTGRP0ENA_PERCNT1_WIDTH		1
#define XAIEGBL_PL_EVTGRP0ENA_PERCNT1_MASK		0x00000008
#define XAIEGBL_PL_EVTGRP0ENA_PERCNT1_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRP0ENA_PERCNT0_LSB		2
#define XAIEGBL_PL_EVTGRP0ENA_PERCNT0_WIDTH		1
#define XAIEGBL_PL_EVTGRP0ENA_PERCNT0_MASK		0x00000004
#define XAIEGBL_PL_EVTGRP0ENA_PERCNT0_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRP0ENA_TIMVALREA_LSB		1
#define XAIEGBL_PL_EVTGRP0ENA_TIMVALREA_WIDTH		1
#define XAIEGBL_PL_EVTGRP0ENA_TIMVALREA_MASK		0x00000002
#define XAIEGBL_PL_EVTGRP0ENA_TIMVALREA_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRP0ENA_TIMSYN_LSB		0
#define XAIEGBL_PL_EVTGRP0ENA_TIMSYN_WIDTH		1
#define XAIEGBL_PL_EVTGRP0ENA_TIMSYN_MASK		0x00000001
#define XAIEGBL_PL_EVTGRP0ENA_TIMSYN_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_EVTGRP0ENA(Combo_Event_3,Combo_Event_2,Combo_Event_1,Combo_Event_0,Perf_Cnt1,Perf_Cnt0,Timer_Value_Reached,Timer_Sync)		(((Combo_Event_3&0x00000001)<<7)+((Combo_Event_2&0x00000001)<<6)+((Combo_Event_1&0x00000001)<<5)+((Combo_Event_0&0x00000001)<<4)+((Perf_Cnt1&0x00000001)<<3)+((Perf_Cnt0&0x00000001)<<2)+((Timer_Value_Reached&0x00000001)<<1)+(Timer_Sync&0x00000001))

#define XAIEGBL_PL_EVTGRPDMAACTENA		0x00034504
#define XAIEGBL_PL_EVTGRPDMAACTENAWID		32
#define XAIEGBL_PL_EVTGRPDMAACTENAMSK		0x0000FFFF
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1STALLOCKACQ_LSB		15
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1STALLOCKACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1STALLOCKACQ_MASK		0x00008000
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1STALLOCKACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0STALLOCKACQ_LSB		14
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0STALLOCKACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0STALLOCKACQ_MASK		0x00004000
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0STALLOCKACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1STALLOCKACQ_LSB		13
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1STALLOCKACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1STALLOCKACQ_MASK		0x00002000
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1STALLOCKACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0STALLOCKACQ_LSB		12
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0STALLOCKACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0STALLOCKACQ_MASK		0x00001000
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0STALLOCKACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1GOTOIDL_LSB		11
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1GOTOIDL_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1GOTOIDL_MASK		0x00000800
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1GOTOIDL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0GOTOIDL_LSB		10
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0GOTOIDL_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0GOTOIDL_MASK		0x00000400
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0GOTOIDL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1GOTOIDL_LSB		9
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1GOTOIDL_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1GOTOIDL_MASK		0x00000200
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1GOTOIDL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0GOTOIDL_LSB		8
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0GOTOIDL_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0GOTOIDL_MASK		0x00000100
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0GOTOIDL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1FINBD_LSB		7
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1FINBD_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1FINBD_MASK		0x00000080
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1FINBD_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0FINBD_LSB		6
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0FINBD_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0FINBD_MASK		0x00000040
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0FINBD_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1FINBD_LSB		5
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1FINBD_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1FINBD_MASK		0x00000020
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1FINBD_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0FINBD_LSB		4
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0FINBD_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0FINBD_MASK		0x00000010
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0FINBD_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1STABD_LSB		3
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1STABD_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1STABD_MASK		0x00000008
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S1STABD_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0STABD_LSB		2
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0STABD_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0STABD_MASK		0x00000004
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAMM2S0STABD_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1STABD_LSB		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1STABD_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1STABD_MASK		0x00000002
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM1STABD_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0STABD_LSB		0
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0STABD_WIDTH		1
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0STABD_MASK		0x00000001
#define XAIEGBL_PL_EVTGRPDMAACTENA_DMAS2MM0STABD_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_EVTGRPDMAACTENA(DMA_MM2S_1_stalled_lock_acquire,DMA_MM2S_0_stalled_lock_acquire,DMA_S2MM_1_stalled_lock_acquire,DMA_S2MM_0_stalled_lock_acquire,DMA_MM2S_1_go_to_idle,DMA_MM2S_0_go_to_idle,DMA_S2MM_1_go_to_idle,DMA_S2MM_0_go_to_idle,DMA_MM2S_1_finished_BD,DMA_MM2S_0_finished_BD,DMA_S2MM_1_finished_BD,DMA_S2MM_0_finished_BD,DMA_MM2S_1_start_BD,DMA_MM2S_0_start_BD,DMA_S2MM_1_start_BD,DMA_S2MM_0_start_BD)		(((DMA_MM2S_1_stalled_lock_acquire&0x00000001)<<15)+((DMA_MM2S_0_stalled_lock_acquire&0x00000001)<<14)+((DMA_S2MM_1_stalled_lock_acquire&0x00000001)<<13)+((DMA_S2MM_0_stalled_lock_acquire&0x00000001)<<12)+((DMA_MM2S_1_go_to_idle&0x00000001)<<11)+((DMA_MM2S_0_go_to_idle&0x00000001)<<10)+((DMA_S2MM_1_go_to_idle&0x00000001)<<9)+((DMA_S2MM_0_go_to_idle&0x00000001)<<8)+((DMA_MM2S_1_finished_BD&0x00000001)<<7)+((DMA_MM2S_0_finished_BD&0x00000001)<<6)+((DMA_S2MM_1_finished_BD&0x00000001)<<5)+((DMA_S2MM_0_finished_BD&0x00000001)<<4)+((DMA_MM2S_1_start_BD&0x00000001)<<3)+((DMA_MM2S_0_start_BD&0x00000001)<<2)+((DMA_S2MM_1_start_BD&0x00000001)<<1)+(DMA_S2MM_0_start_BD&0x00000001))

#define XAIEGBL_PL_EVTGRPLOCKENA		0x00034508
#define XAIEGBL_PL_EVTGRPLOCKENAWID		32
#define XAIEGBL_PL_EVTGRPLOCKENAMSK		0xFFFFFFFF
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK15REL_LSB		31
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK15REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK15REL_MASK		0x80000000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK15REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK15ACQ_LSB		30
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK15ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK15ACQ_MASK		0x40000000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK15ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK14REL_LSB		29
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK14REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK14REL_MASK		0x20000000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK14REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK14ACQ_LSB		28
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK14ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK14ACQ_MASK		0x10000000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK14ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK13REL_LSB		27
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK13REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK13REL_MASK		0x08000000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK13REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK13ACQ_LSB		26
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK13ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK13ACQ_MASK		0x04000000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK13ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK12REL_LSB		25
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK12REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK12REL_MASK		0x02000000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK12REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK12ACQ_LSB		24
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK12ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK12ACQ_MASK		0x01000000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK12ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK11REL_LSB		23
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK11REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK11REL_MASK		0x00800000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK11REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK11ACQ_LSB		22
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK11ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK11ACQ_MASK		0x00400000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK11ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK10REL_LSB		21
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK10REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK10REL_MASK		0x00200000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK10REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK10ACQ_LSB		20
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK10ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK10ACQ_MASK		0x00100000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK10ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK9REL_LSB		19
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK9REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK9REL_MASK		0x00080000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK9REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK9ACQ_LSB		18
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK9ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK9ACQ_MASK		0x00040000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK9ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK8REL_LSB		17
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK8REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK8REL_MASK		0x00020000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK8REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK8ACQ_LSB		16
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK8ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK8ACQ_MASK		0x00010000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK8ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK7REL_LSB		15
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK7REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK7REL_MASK		0x00008000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK7REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK7ACQ_LSB		14
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK7ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK7ACQ_MASK		0x00004000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK7ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK6REL_LSB		13
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK6REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK6REL_MASK		0x00002000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK6REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK6ACQ_LSB		12
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK6ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK6ACQ_MASK		0x00001000
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK6ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK5REL_LSB		11
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK5REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK5REL_MASK		0x00000800
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK5REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK5ACQ_LSB		10
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK5ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK5ACQ_MASK		0x00000400
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK5ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK4REL_LSB		9
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK4REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK4REL_MASK		0x00000200
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK4REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK4ACQ_LSB		8
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK4ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK4ACQ_MASK		0x00000100
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK4ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK3REL_LSB		7
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK3REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK3REL_MASK		0x00000080
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK3REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK3ACQ_LSB		6
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK3ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK3ACQ_MASK		0x00000040
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK3ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK2REL_LSB		5
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK2REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK2REL_MASK		0x00000020
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK2REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK2ACQ_LSB		4
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK2ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK2ACQ_MASK		0x00000010
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK2ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK1REL_LSB		3
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK1REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK1REL_MASK		0x00000008
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK1REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK1ACQ_LSB		2
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK1ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK1ACQ_MASK		0x00000004
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK1ACQ_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK0REL_LSB		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK0REL_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK0REL_MASK		0x00000002
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK0REL_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK0ACQ_LSB		0
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK0ACQ_WIDTH		1
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK0ACQ_MASK		0x00000001
#define XAIEGBL_PL_EVTGRPLOCKENA_LOCK0ACQ_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_EVTGRPLOCKENA(Lock_15_Release,Lock_15_Acquired,Lock_14_Release,Lock_14_Acquired,Lock_13_Release,Lock_13_Acquired,Lock_12_Release,Lock_12_Acquired,Lock_11_Release,Lock_11_Acquired,Lock_10_Release,Lock_10_Acquired,Lock_9_Release,Lock_9_Acquired,Lock_8_Release,Lock_8_Acquired,Lock_7_Release,Lock_7_Acquired,Lock_6_Release,Lock_6_Acquired,Lock_5_Release,Lock_5_Acquired,Lock_4_Release,Lock_4_Acquired,Lock_3_Release,Lock_3_Acquired,Lock_2_Release,Lock_2_Acquired,Lock_1_Release,Lock_1_Acquired,Lock_0_Release,Lock_0_Acquired)		(((Lock_15_Release&0x00000001)<<31)+((Lock_15_Acquired&0x00000001)<<30)+((Lock_14_Release&0x00000001)<<29)+((Lock_14_Acquired&0x00000001)<<28)+((Lock_13_Release&0x00000001)<<27)+((Lock_13_Acquired&0x00000001)<<26)+((Lock_12_Release&0x00000001)<<25)+((Lock_12_Acquired&0x00000001)<<24)+((Lock_11_Release&0x00000001)<<23)+((Lock_11_Acquired&0x00000001)<<22)+((Lock_10_Release&0x00000001)<<21)+((Lock_10_Acquired&0x00000001)<<20)+((Lock_9_Release&0x00000001)<<19)+((Lock_9_Acquired&0x00000001)<<18)+((Lock_8_Release&0x00000001)<<17)+((Lock_8_Acquired&0x00000001)<<16)+((Lock_7_Release&0x00000001)<<15)+((Lock_7_Acquired&0x00000001)<<14)+((Lock_6_Release&0x00000001)<<13)+((Lock_6_Acquired&0x00000001)<<12)+((Lock_5_Release&0x00000001)<<11)+((Lock_5_Acquired&0x00000001)<<10)+((Lock_4_Release&0x00000001)<<9)+((Lock_4_Acquired&0x00000001)<<8)+((Lock_3_Release&0x00000001)<<7)+((Lock_3_Acquired&0x00000001)<<6)+((Lock_2_Release&0x00000001)<<5)+((Lock_2_Acquired&0x00000001)<<4)+((Lock_1_Release&0x00000001)<<3)+((Lock_1_Acquired&0x00000001)<<2)+((Lock_0_Release&0x00000001)<<1)+(Lock_0_Acquired&0x00000001))

#define XAIEGBL_PL_EVTGRPERRENA		0x0003450C
#define XAIEGBL_PL_EVTGRPERRENAWID		32
#define XAIEGBL_PL_EVTGRPERRENAMSK		0x000007FF
#define XAIEGBL_PL_EVTGRPERRENA_DMAMM2S1ERR_LSB		10
#define XAIEGBL_PL_EVTGRPERRENA_DMAMM2S1ERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_DMAMM2S1ERR_MASK		0x00000400
#define XAIEGBL_PL_EVTGRPERRENA_DMAMM2S1ERR_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_DMAMM2S0ERR_LSB		9
#define XAIEGBL_PL_EVTGRPERRENA_DMAMM2S0ERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_DMAMM2S0ERR_MASK		0x00000200
#define XAIEGBL_PL_EVTGRPERRENA_DMAMM2S0ERR_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_DMAS2MM1ERR_LSB		8
#define XAIEGBL_PL_EVTGRPERRENA_DMAS2MM1ERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_DMAS2MM1ERR_MASK		0x00000100
#define XAIEGBL_PL_EVTGRPERRENA_DMAS2MM1ERR_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_DMAS2MM0ERR_LSB		7
#define XAIEGBL_PL_EVTGRPERRENA_DMAS2MM0ERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_DMAS2MM0ERR_MASK		0x00000080
#define XAIEGBL_PL_EVTGRPERRENA_DMAS2MM0ERR_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMBYTSTRERR_LSB		6
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMBYTSTRERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMBYTSTRERR_MASK		0x00000040
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMBYTSTRERR_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMUNSACCINSECMOD_LSB		5
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMUNSACCINSECMOD_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMUNSACCINSECMOD_MASK		0x00000020
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMUNSACCINSECMOD_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMUNSTRA_LSB		4
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMUNSTRA_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMUNSTRA_MASK		0x00000010
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMUNSTRA_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMSLVNSUERR_LSB		3
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMSLVNSUERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMSLVNSUERR_MASK		0x00000008
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMSLVNSUERR_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMDECNSUERR_LSB		2
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMDECNSUERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMDECNSUERR_MASK		0x00000004
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMDECNSUERR_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_CTRLPKTERR_LSB		1
#define XAIEGBL_PL_EVTGRPERRENA_CTRLPKTERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_CTRLPKTERR_MASK		0x00000002
#define XAIEGBL_PL_EVTGRPERRENA_CTRLPKTERR_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMSLVTILERR_LSB		0
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMSLVTILERR_WIDTH		1
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMSLVTILERR_MASK		0x00000001
#define XAIEGBL_PL_EVTGRPERRENA_AXIMMSLVTILERR_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_EVTGRPERRENA(DMA_MM2S_1_Error,DMA_MM2S_0_Error,DMA_S2MM_1_Error,DMA_S2MM_0_Error,AXI_MM_Byte_Strobe_Error,AXI_MM_Unsecure_Access_in_Secure_Mode,AXI_MM_Unsupported_Traffic,AXI_MM_Slave_NSU_Error,AXI_MM_Decode_NSU_Error,Control_Pkt_Error,AXI_MM_Slave_Tile_Error)		(((DMA_MM2S_1_Error&0x00000001)<<10)+((DMA_MM2S_0_Error&0x00000001)<<9)+((DMA_S2MM_1_Error&0x00000001)<<8)+((DMA_S2MM_0_Error&0x00000001)<<7)+((AXI_MM_Byte_Strobe_Error&0x00000001)<<6)+((AXI_MM_Unsecure_Access_in_Secure_Mode&0x00000001)<<5)+((AXI_MM_Unsupported_Traffic&0x00000001)<<4)+((AXI_MM_Slave_NSU_Error&0x00000001)<<3)+((AXI_MM_Decode_NSU_Error&0x00000001)<<2)+((Control_Pkt_Error&0x00000001)<<1)+(AXI_MM_Slave_Tile_Error&0x00000001))

#define XAIEGBL_PL_EVTGRPSTRSWIENA		0x00034510
#define XAIEGBL_PL_EVTGRPSTRSWIENAWID		32
#define XAIEGBL_PL_EVTGRPSTRSWIENAMSK		0xFFFFFFFF
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA7_LSB		31
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA7_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA7_MASK		0x80000000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA7_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL7_LSB		30
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL7_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL7_MASK		0x40000000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL7_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN7_LSB		29
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN7_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN7_MASK		0x20000000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN7_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL7_LSB		28
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL7_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL7_MASK		0x10000000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL7_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA6_LSB		27
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA6_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA6_MASK		0x08000000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA6_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL6_LSB		26
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL6_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL6_MASK		0x04000000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL6_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN6_LSB		25
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN6_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN6_MASK		0x02000000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN6_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL6_LSB		24
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL6_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL6_MASK		0x01000000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL6_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA5_LSB		23
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA5_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA5_MASK		0x00800000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA5_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL5_LSB		22
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL5_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL5_MASK		0x00400000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL5_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN5_LSB		21
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN5_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN5_MASK		0x00200000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN5_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL5_LSB		20
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL5_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL5_MASK		0x00100000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL5_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA4_LSB		19
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA4_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA4_MASK		0x00080000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA4_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL4_LSB		18
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL4_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL4_MASK		0x00040000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL4_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN4_LSB		17
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN4_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN4_MASK		0x00020000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN4_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL4_LSB		16
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL4_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL4_MASK		0x00010000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL4_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA3_LSB		15
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA3_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA3_MASK		0x00008000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA3_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL3_LSB		14
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL3_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL3_MASK		0x00004000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL3_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN3_LSB		13
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN3_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN3_MASK		0x00002000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN3_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL3_LSB		12
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL3_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL3_MASK		0x00001000
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL3_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA2_LSB		11
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA2_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA2_MASK		0x00000800
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA2_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL2_LSB		10
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL2_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL2_MASK		0x00000400
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL2_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN2_LSB		9
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN2_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN2_MASK		0x00000200
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN2_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL2_LSB		8
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL2_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL2_MASK		0x00000100
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL2_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA1_LSB		7
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA1_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA1_MASK		0x00000080
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA1_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL1_LSB		6
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL1_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL1_MASK		0x00000040
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL1_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN1_LSB		5
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN1_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN1_MASK		0x00000020
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN1_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL1_LSB		4
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL1_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL1_MASK		0x00000010
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL1_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA0_LSB		3
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA0_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA0_MASK		0x00000008
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTTLA0_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL0_LSB		2
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL0_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL0_MASK		0x00000004
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTSTAL0_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN0_LSB		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN0_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN0_MASK		0x00000002
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTRUN0_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL0_LSB		0
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL0_WIDTH		1
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL0_MASK		0x00000001
#define XAIEGBL_PL_EVTGRPSTRSWIENA_PORTIDL0_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_EVTGRPSTRSWIENA(Port_TLAST_7,Port_Stalled_7,Port_Running_7,Port_Idle_7,Port_TLAST_6,Port_Stalled_6,Port_Running_6,Port_Idle_6,Port_TLAST_5,Port_Stalled_5,Port_Running_5,Port_Idle_5,Port_TLAST_4,Port_Stalled_4,Port_Running_4,Port_Idle_4,Port_TLAST_3,Port_Stalled_3,Port_Running_3,Port_Idle_3,Port_TLAST_2,Port_Stalled_2,Port_Running_2,Port_Idle_2,Port_TLAST_1,Port_Stalled_1,Port_Running_1,Port_Idle_1,Port_TLAST_0,Port_Stalled_0,Port_Running_0,Port_Idle_0)		(((Port_TLAST_7&0x00000001)<<31)+((Port_Stalled_7&0x00000001)<<30)+((Port_Running_7&0x00000001)<<29)+((Port_Idle_7&0x00000001)<<28)+((Port_TLAST_6&0x00000001)<<27)+((Port_Stalled_6&0x00000001)<<26)+((Port_Running_6&0x00000001)<<25)+((Port_Idle_6&0x00000001)<<24)+((Port_TLAST_5&0x00000001)<<23)+((Port_Stalled_5&0x00000001)<<22)+((Port_Running_5&0x00000001)<<21)+((Port_Idle_5&0x00000001)<<20)+((Port_TLAST_4&0x00000001)<<19)+((Port_Stalled_4&0x00000001)<<18)+((Port_Running_4&0x00000001)<<17)+((Port_Idle_4&0x00000001)<<16)+((Port_TLAST_3&0x00000001)<<15)+((Port_Stalled_3&0x00000001)<<14)+((Port_Running_3&0x00000001)<<13)+((Port_Idle_3&0x00000001)<<12)+((Port_TLAST_2&0x00000001)<<11)+((Port_Stalled_2&0x00000001)<<10)+((Port_Running_2&0x00000001)<<9)+((Port_Idle_2&0x00000001)<<8)+((Port_TLAST_1&0x00000001)<<7)+((Port_Stalled_1&0x00000001)<<6)+((Port_Running_1&0x00000001)<<5)+((Port_Idle_1&0x00000001)<<4)+((Port_TLAST_0&0x00000001)<<3)+((Port_Stalled_0&0x00000001)<<2)+((Port_Running_0&0x00000001)<<1)+(Port_Idle_0&0x00000001))

#define XAIEGBL_PL_EVTGRPBRDCASTAENA		0x00034514
#define XAIEGBL_PL_EVTGRPBRDCASTAENAWID		32
#define XAIEGBL_PL_EVTGRPBRDCASTAENAMSK		0x0000FFFF
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA15_LSB		15
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA15_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA15_MASK		0x00008000
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA15_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA14_LSB		14
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA14_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA14_MASK		0x00004000
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA14_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA13_LSB		13
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA13_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA13_MASK		0x00002000
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA13_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA12_LSB		12
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA12_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA12_MASK		0x00001000
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA12_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA11_LSB		11
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA11_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA11_MASK		0x00000800
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA11_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA10_LSB		10
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA10_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA10_MASK		0x00000400
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA10_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA9_LSB		9
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA9_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA9_MASK		0x00000200
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA9_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA8_LSB		8
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA8_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA8_MASK		0x00000100
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA8_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA7_LSB		7
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA7_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA7_MASK		0x00000080
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA7_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA6_LSB		6
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA6_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA6_MASK		0x00000040
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA6_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA5_LSB		5
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA5_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA5_MASK		0x00000020
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA5_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA4_LSB		4
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA4_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA4_MASK		0x00000010
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA4_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA3_LSB		3
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA3_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA3_MASK		0x00000008
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA3_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA2_LSB		2
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA2_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA2_MASK		0x00000004
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA2_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA1_LSB		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA1_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA1_MASK		0x00000002
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA1_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA0_LSB		0
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA0_WIDTH		1
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA0_MASK		0x00000001
#define XAIEGBL_PL_EVTGRPBRDCASTAENA_BRDCASTA0_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_EVTGRPBRDCASTAENA(Broadcast_A_15,Broadcast_A_14,Broadcast_A_13,Broadcast_A_12,Broadcast_A_11,Broadcast_A_10,Broadcast_A_9,Broadcast_A_8,Broadcast_A_7,Broadcast_A_6,Broadcast_A_5,Broadcast_A_4,Broadcast_A_3,Broadcast_A_2,Broadcast_A_1,Broadcast_A_0)		(((Broadcast_A_15&0x00000001)<<15)+((Broadcast_A_14&0x00000001)<<14)+((Broadcast_A_13&0x00000001)<<13)+((Broadcast_A_12&0x00000001)<<12)+((Broadcast_A_11&0x00000001)<<11)+((Broadcast_A_10&0x00000001)<<10)+((Broadcast_A_9&0x00000001)<<9)+((Broadcast_A_8&0x00000001)<<8)+((Broadcast_A_7&0x00000001)<<7)+((Broadcast_A_6&0x00000001)<<6)+((Broadcast_A_5&0x00000001)<<5)+((Broadcast_A_4&0x00000001)<<4)+((Broadcast_A_3&0x00000001)<<3)+((Broadcast_A_2&0x00000001)<<2)+((Broadcast_A_1&0x00000001)<<1)+(Broadcast_A_0&0x00000001))

#define XAIEGBL_PL_EVTGRPUSRENA		0x00034518
#define XAIEGBL_PL_EVTGRPUSRENAWID		32
#define XAIEGBL_PL_EVTGRPUSRENAMSK		0x0000000F
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT3_LSB		3
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT3_WIDTH		1
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT3_MASK		0x00000008
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT3_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT2_LSB		2
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT2_WIDTH		1
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT2_MASK		0x00000004
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT2_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT1_LSB		1
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT1_WIDTH		1
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT1_MASK		0x00000002
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT1_DEFVAL		0x1
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT0_LSB		0
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT0_WIDTH		1
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT0_MASK		0x00000001
#define XAIEGBL_PL_EVTGRPUSRENA_USREVT0_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_EVTGRPUSRENA(User_Event_3,User_Event_2,User_Event_1,User_Event_0)		(((User_Event_3&0x00000001)<<3)+((User_Event_2&0x00000001)<<2)+((User_Event_1&0x00000001)<<1)+(User_Event_0&0x00000001))

#define XAIEGBL_PL_INTCON1STLEVMSKA		0x00035000
#define XAIEGBL_PL_INTCON1STLEVMSKAWID		32
#define XAIEGBL_PL_INTCON1STLEVMSKAMSK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVMSKA_IRQMSKA_LSB		0
#define XAIEGBL_PL_INTCON1STLEVMSKA_IRQMSKA_WIDTH		20
#define XAIEGBL_PL_INTCON1STLEVMSKA_IRQMSKA_MASK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVMSKA_IRQMSKA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVMSKA(IRQ_Mask_A)		((IRQ_Mask_A&0x000fffff))

#define XAIEGBL_PL_INTCON1STLEVENAA		0x00035004
#define XAIEGBL_PL_INTCON1STLEVENAAWID		32
#define XAIEGBL_PL_INTCON1STLEVENAAMSK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVENAA_ENAA_LSB		0
#define XAIEGBL_PL_INTCON1STLEVENAA_ENAA_WIDTH		20
#define XAIEGBL_PL_INTCON1STLEVENAA_ENAA_MASK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVENAA_ENAA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVENAA(Enable_A)		((Enable_A&0x000fffff))

#define XAIEGBL_PL_INTCON1STLEVDISA		0x00035008
#define XAIEGBL_PL_INTCON1STLEVDISAWID		32
#define XAIEGBL_PL_INTCON1STLEVDISAMSK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVDISA_DISA_LSB		0
#define XAIEGBL_PL_INTCON1STLEVDISA_DISA_WIDTH		20
#define XAIEGBL_PL_INTCON1STLEVDISA_DISA_MASK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVDISA_DISA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVDISA(Disable_A)		((Disable_A&0x000fffff))

#define XAIEGBL_PL_INTCON1STLEVSTAA		0x0003500C
#define XAIEGBL_PL_INTCON1STLEVSTAAWID		32
#define XAIEGBL_PL_INTCON1STLEVSTAAMSK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVSTAA_STAA_LSB		0
#define XAIEGBL_PL_INTCON1STLEVSTAA_STAA_WIDTH		20
#define XAIEGBL_PL_INTCON1STLEVSTAA_STAA_MASK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVSTAA_STAA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVSTAA(Status_A)		((Status_A&0x000fffff))

#define XAIEGBL_PL_INTCON1STLEVIRQNOA		0x00035010
#define XAIEGBL_PL_INTCON1STLEVIRQNOAWID		32
#define XAIEGBL_PL_INTCON1STLEVIRQNOAMSK		0x0000000F
#define XAIEGBL_PL_INTCON1STLEVIRQNOA_STAA_LSB		0
#define XAIEGBL_PL_INTCON1STLEVIRQNOA_STAA_WIDTH		4
#define XAIEGBL_PL_INTCON1STLEVIRQNOA_STAA_MASK		0x0000000F
#define XAIEGBL_PL_INTCON1STLEVIRQNOA_STAA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVIRQNOA(Status_A)		((Status_A&0x0000000f))

#define XAIEGBL_PL_INTCON1STLEVIRQEVTA		0x00035014
#define XAIEGBL_PL_INTCON1STLEVIRQEVTAWID		32
#define XAIEGBL_PL_INTCON1STLEVIRQEVTAMSK		0x7F7F7F7F
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT3_LSB		24
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT3_WIDTH		7
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT3_MASK		0x7F000000
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT3_DEFVAL		0x0
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT2_LSB		16
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT2_WIDTH		7
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT2_MASK		0x007F0000
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT2_DEFVAL		0x0
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT1_LSB		8
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT1_WIDTH		7
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT1_MASK		0x00007F00
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT1_DEFVAL		0x0
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT0_LSB		0
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT0_WIDTH		7
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT0_MASK		0x0000007F
#define XAIEGBL_PL_INTCON1STLEVIRQEVTA_IRQEVT0_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVIRQEVTA(IRQ_Event3,IRQ_Event2,IRQ_Event1,IRQ_Event0)		(((IRQ_Event3&0x0000007f)<<24)+((IRQ_Event2&0x0000007f)<<16)+((IRQ_Event1&0x0000007f)<<8)+(IRQ_Event0&0x0000007f))

#define XAIEGBL_PL_INTCON1STLEVBLKNORINASET		0x00035018
#define XAIEGBL_PL_INTCON1STLEVBLKNORINASETWID		32
#define XAIEGBL_PL_INTCON1STLEVBLKNORINASETMSK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINASET_SET_LSB		0
#define XAIEGBL_PL_INTCON1STLEVBLKNORINASET_SET_WIDTH		16
#define XAIEGBL_PL_INTCON1STLEVBLKNORINASET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINASET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVBLKNORINASET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_INTCON1STLEVBLKNORINACLR		0x0003501C
#define XAIEGBL_PL_INTCON1STLEVBLKNORINACLRWID		32
#define XAIEGBL_PL_INTCON1STLEVBLKNORINACLRMSK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINACLR_CLR_LSB		0
#define XAIEGBL_PL_INTCON1STLEVBLKNORINACLR_CLR_WIDTH		16
#define XAIEGBL_PL_INTCON1STLEVBLKNORINACLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINACLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVBLKNORINACLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_INTCON1STLEVBLKNORINAVAL		0x00035020
#define XAIEGBL_PL_INTCON1STLEVBLKNORINAVALWID		32
#define XAIEGBL_PL_INTCON1STLEVBLKNORINAVALMSK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINAVAL_VAL_LSB		0
#define XAIEGBL_PL_INTCON1STLEVBLKNORINAVAL_VAL_WIDTH		16
#define XAIEGBL_PL_INTCON1STLEVBLKNORINAVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINAVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVBLKNORINAVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_INTCON1STLEVMSKB		0x00035030
#define XAIEGBL_PL_INTCON1STLEVMSKBWID		32
#define XAIEGBL_PL_INTCON1STLEVMSKBMSK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVMSKB_IRQMSKB_LSB		0
#define XAIEGBL_PL_INTCON1STLEVMSKB_IRQMSKB_WIDTH		20
#define XAIEGBL_PL_INTCON1STLEVMSKB_IRQMSKB_MASK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVMSKB_IRQMSKB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVMSKB(IRQ_Mask_B)		((IRQ_Mask_B&0x000fffff))

#define XAIEGBL_PL_INTCON1STLEVENAB		0x00035034
#define XAIEGBL_PL_INTCON1STLEVENABWID		32
#define XAIEGBL_PL_INTCON1STLEVENABMSK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVENAB_ENAB_LSB		0
#define XAIEGBL_PL_INTCON1STLEVENAB_ENAB_WIDTH		20
#define XAIEGBL_PL_INTCON1STLEVENAB_ENAB_MASK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVENAB_ENAB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVENAB(Enable_B)		((Enable_B&0x000fffff))

#define XAIEGBL_PL_INTCON1STLEVDISB		0x00035038
#define XAIEGBL_PL_INTCON1STLEVDISBWID		32
#define XAIEGBL_PL_INTCON1STLEVDISBMSK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVDISB_DISB_LSB		0
#define XAIEGBL_PL_INTCON1STLEVDISB_DISB_WIDTH		20
#define XAIEGBL_PL_INTCON1STLEVDISB_DISB_MASK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVDISB_DISB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVDISB(Disable_B)		((Disable_B&0x000fffff))

#define XAIEGBL_PL_INTCON1STLEVSTAB		0x0003503C
#define XAIEGBL_PL_INTCON1STLEVSTABWID		32
#define XAIEGBL_PL_INTCON1STLEVSTABMSK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVSTAB_STAB_LSB		0
#define XAIEGBL_PL_INTCON1STLEVSTAB_STAB_WIDTH		20
#define XAIEGBL_PL_INTCON1STLEVSTAB_STAB_MASK		0x000FFFFF
#define XAIEGBL_PL_INTCON1STLEVSTAB_STAB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVSTAB(Status_B)		((Status_B&0x000fffff))

#define XAIEGBL_PL_INTCON1STLEVIRQNOB		0x00035040
#define XAIEGBL_PL_INTCON1STLEVIRQNOBWID		32
#define XAIEGBL_PL_INTCON1STLEVIRQNOBMSK		0x0000000F
#define XAIEGBL_PL_INTCON1STLEVIRQNOB_STAB_LSB		0
#define XAIEGBL_PL_INTCON1STLEVIRQNOB_STAB_WIDTH		4
#define XAIEGBL_PL_INTCON1STLEVIRQNOB_STAB_MASK		0x0000000F
#define XAIEGBL_PL_INTCON1STLEVIRQNOB_STAB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVIRQNOB(Status_B)		((Status_B&0x0000000f))

#define XAIEGBL_PL_INTCON1STLEVIRQEVTB		0x00035044
#define XAIEGBL_PL_INTCON1STLEVIRQEVTBWID		32
#define XAIEGBL_PL_INTCON1STLEVIRQEVTBMSK		0x7F7F7F7F
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT3_LSB		24
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT3_WIDTH		7
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT3_MASK		0x7F000000
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT3_DEFVAL		0x0
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT2_LSB		16
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT2_WIDTH		7
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT2_MASK		0x007F0000
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT2_DEFVAL		0x0
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT1_LSB		8
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT1_WIDTH		7
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT1_MASK		0x00007F00
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT1_DEFVAL		0x0
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT0_LSB		0
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT0_WIDTH		7
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT0_MASK		0x0000007F
#define XAIEGBL_PL_INTCON1STLEVIRQEVTB_IRQEVT0_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVIRQEVTB(IRQ_Event3,IRQ_Event2,IRQ_Event1,IRQ_Event0)		(((IRQ_Event3&0x0000007f)<<24)+((IRQ_Event2&0x0000007f)<<16)+((IRQ_Event1&0x0000007f)<<8)+(IRQ_Event0&0x0000007f))

#define XAIEGBL_PL_INTCON1STLEVBLKNORINBSET		0x00035048
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBSETWID		32
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBSETMSK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBSET_SET_LSB		0
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBSET_SET_WIDTH		16
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBSET_SET_MASK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBSET_SET_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVBLKNORINBSET(Set)		((Set&0x0000ffff))

#define XAIEGBL_PL_INTCON1STLEVBLKNORINBCLR		0x0003504C
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBCLRWID		32
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBCLRMSK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBCLR_CLR_LSB		0
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBCLR_CLR_WIDTH		16
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBCLR_CLR_MASK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBCLR_CLR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVBLKNORINBCLR(Clear)		((Clear&0x0000ffff))

#define XAIEGBL_PL_INTCON1STLEVBLKNORINBVAL		0x00035050
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBVALWID		32
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBVALMSK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBVAL_VAL_LSB		0
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBVAL_VAL_WIDTH		16
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBVAL_VAL_MASK		0x0000FFFF
#define XAIEGBL_PL_INTCON1STLEVBLKNORINBVAL_VAL_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_INTCON1STLEVBLKNORINBVAL(Value)		((Value&0x0000ffff))

#define XAIEGBL_PL_CTRLPKTHANSTA		0x00036034
#define XAIEGBL_PL_CTRLPKTHANSTAWID		32
#define XAIEGBL_PL_CTRLPKTHANSTAMSK		0x0000000F
#define XAIEGBL_PL_CTRLPKTHANSTA_TLAERR_LSB		3
#define XAIEGBL_PL_CTRLPKTHANSTA_TLAERR_WIDTH		1
#define XAIEGBL_PL_CTRLPKTHANSTA_TLAERR_MASK		0x00000008
#define XAIEGBL_PL_CTRLPKTHANSTA_TLAERR_DEFVAL		0x0
#define XAIEGBL_PL_CTRLPKTHANSTA_SLVONACC_LSB		2
#define XAIEGBL_PL_CTRLPKTHANSTA_SLVONACC_WIDTH		1
#define XAIEGBL_PL_CTRLPKTHANSTA_SLVONACC_MASK		0x00000004
#define XAIEGBL_PL_CTRLPKTHANSTA_SLVONACC_DEFVAL		0x0
#define XAIEGBL_PL_CTRLPKTHANSTA_SECHEAPARERR_LSB		1
#define XAIEGBL_PL_CTRLPKTHANSTA_SECHEAPARERR_WIDTH		1
#define XAIEGBL_PL_CTRLPKTHANSTA_SECHEAPARERR_MASK		0x00000002
#define XAIEGBL_PL_CTRLPKTHANSTA_SECHEAPARERR_DEFVAL		0x0
#define XAIEGBL_PL_CTRLPKTHANSTA_FIRHEAPARERR_LSB		0
#define XAIEGBL_PL_CTRLPKTHANSTA_FIRHEAPARERR_WIDTH		1
#define XAIEGBL_PL_CTRLPKTHANSTA_FIRHEAPARERR_MASK		0x00000001
#define XAIEGBL_PL_CTRLPKTHANSTA_FIRHEAPARERR_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_CTRLPKTHANSTA(Tlast_Error,SLVERR_On_Access,Second_Header_Parity_Error,First_Header_Parity_Error)		(((Tlast_Error&0x00000001)<<3)+((SLVERR_On_Access&0x00000001)<<2)+((Second_Header_Parity_Error&0x00000001)<<1)+(First_Header_Parity_Error&0x00000001))

#define XAIEGBL_PL_TILCLOCTRL		0x00036040
#define XAIEGBL_PL_TILCLOCTRLWID		32
#define XAIEGBL_PL_TILCLOCTRLMSK		0x00000003
#define XAIEGBL_PL_TILCLOCTRL_NEXTILCLOENA_LSB		1
#define XAIEGBL_PL_TILCLOCTRL_NEXTILCLOENA_WIDTH		1
#define XAIEGBL_PL_TILCLOCTRL_NEXTILCLOENA_MASK		0x00000002
#define XAIEGBL_PL_TILCLOCTRL_NEXTILCLOENA_DEFVAL		0x1
#define XAIEGBL_PL_TILCLOCTRL_CLOBUFENA_LSB		0
#define XAIEGBL_PL_TILCLOCTRL_CLOBUFENA_WIDTH		1
#define XAIEGBL_PL_TILCLOCTRL_CLOBUFENA_MASK		0x00000001
#define XAIEGBL_PL_TILCLOCTRL_CLOBUFENA_DEFVAL		0x1
#define XAIEGBL_PL_VALUE_TILCLOCTRL(Next_Tile_Clock_Enable,Clock_Buffer_Enable)		(((Next_Tile_Clock_Enable&0x00000001)<<1)+(Clock_Buffer_Enable&0x00000001))

#define XAIEGBL_PL_CSSTRI		0x00036044
#define XAIEGBL_PL_CSSTRIWID		32
#define XAIEGBL_PL_CSSTRIMSK		0x00000001
#define XAIEGBL_PL_CSSTRI_TRI_LSB		0
#define XAIEGBL_PL_CSSTRI_TRI_WIDTH		1
#define XAIEGBL_PL_CSSTRI_TRI_MASK		0x00000001
#define XAIEGBL_PL_CSSTRI_TRI_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_CSSTRI(Trigger)		((Trigger&0x00000001))

#define XAIEGBL_PL_AIETILCOLRST		0x00036048
#define XAIEGBL_PL_AIETILCOLRSTWID		32
#define XAIEGBL_PL_AIETILCOLRSTMSK		0x00000001
#define XAIEGBL_PL_AIETILCOLRST_RST_LSB		0
#define XAIEGBL_PL_AIETILCOLRST_RST_WIDTH		1
#define XAIEGBL_PL_AIETILCOLRST_RST_MASK		0x00000001
#define XAIEGBL_PL_AIETILCOLRST_RST_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_AIETILCOLRST(Reset)		((Reset&0x00000001))

#define XAIEGBL_PL_AIESHIRSTENA		0x0003604C
#define XAIEGBL_PL_AIESHIRSTENAWID		32
#define XAIEGBL_PL_AIESHIRSTENAMSK		0x00000001
#define XAIEGBL_PL_AIESHIRSTENA_RST_LSB		0
#define XAIEGBL_PL_AIESHIRSTENA_RST_WIDTH		1
#define XAIEGBL_PL_AIESHIRSTENA_RST_MASK		0x00000001
#define XAIEGBL_PL_AIESHIRSTENA_RST_DEFVAL		0x00000001

#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR		0x0003F000
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTRWID		32
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTRMSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGTILCTR_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGTILCTR(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGFIF0		0x0003F004
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGFIF0_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGFIF0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGFIF1		0x0003F008
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGFIF1_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGFIF1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGSOU0		0x0003F00C
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGSOU0_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGSOU0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGSOU1		0x0003F010
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGSOU1_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGSOU1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGSOU2		0x0003F014
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGSOU2_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGSOU2(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGSOU3		0x0003F018
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGSOU3_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGSOU3(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGSOU4		0x0003F01C
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGSOU4_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGSOU4(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGSOU5		0x0003F020
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGSOU5_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGSOU5(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGWES0		0x0003F024
#define XAIEGBL_PL_STRSWIMSTRCFGWES0WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGWES0MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGWES0_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGWES0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGWES1		0x0003F028
#define XAIEGBL_PL_STRSWIMSTRCFGWES1WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGWES1MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGWES1_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGWES1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGWES2		0x0003F02C
#define XAIEGBL_PL_STRSWIMSTRCFGWES2WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGWES2MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGWES2_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGWES2(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGWES3		0x0003F030
#define XAIEGBL_PL_STRSWIMSTRCFGWES3WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGWES3MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGWES3_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGWES3(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGNOR0		0x0003F034
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGNOR0_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGNOR0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGNOR1		0x0003F038
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGNOR1_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGNOR1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGNOR2		0x0003F03C
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGNOR2_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGNOR2(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGNOR3		0x0003F040
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGNOR3_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGNOR3(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGNOR4		0x0003F044
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGNOR4_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGNOR4(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGNOR5		0x0003F048
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGNOR5_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGNOR5(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGEAS0		0x0003F04C
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGEAS0_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGEAS0(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGEAS1		0x0003F050
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGEAS1_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGEAS1(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGEAS2		0x0003F054
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGEAS2_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGEAS2(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWIMSTRCFGEAS3		0x0003F058
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3WID		32
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3MSK		0xC00000FF
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_MSTRENA_LSB		31
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_MSTRENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_MSTRENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_MSTRENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_DROHEA_LSB		7
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_DROHEA_WIDTH		1
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_DROHEA_MASK		0x00000080
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_DROHEA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_CON_LSB		0
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_CON_WIDTH		7
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_CON_MASK		0x0000007F
#define XAIEGBL_PL_STRSWIMSTRCFGEAS3_CON_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIMSTRCFGEAS3(Master_Enable,Packet_Enable,Drop_Header,Configuration)		(((Master_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30)+((Drop_Header&0x00000001)<<7)+(Configuration&0x0000007f))

#define XAIEGBL_PL_STRSWISLVTILCTRCFG		0x0003F100
#define XAIEGBL_PL_STRSWISLVTILCTRCFGWID		32
#define XAIEGBL_PL_STRSWISLVTILCTRCFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVTILCTRCFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVTILCTRCFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTILCTRCFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVTILCTRCFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRCFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVTILCTRCFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTILCTRCFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVTILCTRCFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTILCTRCFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVFIF0CFG		0x0003F104
#define XAIEGBL_PL_STRSWISLVFIF0CFGWID		32
#define XAIEGBL_PL_STRSWISLVFIF0CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVFIF0CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVFIF0CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVFIF0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVFIF0CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVFIF0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVFIF1CFG		0x0003F108
#define XAIEGBL_PL_STRSWISLVFIF1CFGWID		32
#define XAIEGBL_PL_STRSWISLVFIF1CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVFIF1CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVFIF1CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVFIF1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVFIF1CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVFIF1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVSOU0CFG		0x0003F10C
#define XAIEGBL_PL_STRSWISLVSOU0CFGWID		32
#define XAIEGBL_PL_STRSWISLVSOU0CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVSOU0CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVSOU0CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVSOU0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVSOU0CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVSOU0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVSOU1CFG		0x0003F110
#define XAIEGBL_PL_STRSWISLVSOU1CFGWID		32
#define XAIEGBL_PL_STRSWISLVSOU1CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVSOU1CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVSOU1CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVSOU1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVSOU1CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVSOU1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVSOU2CFG		0x0003F114
#define XAIEGBL_PL_STRSWISLVSOU2CFGWID		32
#define XAIEGBL_PL_STRSWISLVSOU2CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVSOU2CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVSOU2CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU2CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVSOU2CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVSOU2CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU2CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVSOU2CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU2CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVSOU3CFG		0x0003F118
#define XAIEGBL_PL_STRSWISLVSOU3CFGWID		32
#define XAIEGBL_PL_STRSWISLVSOU3CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVSOU3CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVSOU3CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU3CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVSOU3CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVSOU3CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU3CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVSOU3CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU3CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVSOU4CFG		0x0003F11C
#define XAIEGBL_PL_STRSWISLVSOU4CFGWID		32
#define XAIEGBL_PL_STRSWISLVSOU4CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVSOU4CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVSOU4CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU4CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVSOU4CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVSOU4CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU4CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVSOU4CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU4CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVSOU5CFG		0x0003F120
#define XAIEGBL_PL_STRSWISLVSOU5CFGWID		32
#define XAIEGBL_PL_STRSWISLVSOU5CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVSOU5CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVSOU5CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU5CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVSOU5CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVSOU5CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU5CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVSOU5CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU5CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVSOU6CFG		0x0003F124
#define XAIEGBL_PL_STRSWISLVSOU6CFGWID		32
#define XAIEGBL_PL_STRSWISLVSOU6CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVSOU6CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVSOU6CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU6CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVSOU6CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVSOU6CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU6CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVSOU6CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU6CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVSOU7CFG		0x0003F128
#define XAIEGBL_PL_STRSWISLVSOU7CFGWID		32
#define XAIEGBL_PL_STRSWISLVSOU7CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVSOU7CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVSOU7CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU7CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVSOU7CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVSOU7CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU7CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVSOU7CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU7CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVWES0CFG		0x0003F12C
#define XAIEGBL_PL_STRSWISLVWES0CFGWID		32
#define XAIEGBL_PL_STRSWISLVWES0CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVWES0CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVWES0CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVWES0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVWES0CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVWES0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVWES1CFG		0x0003F130
#define XAIEGBL_PL_STRSWISLVWES1CFGWID		32
#define XAIEGBL_PL_STRSWISLVWES1CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVWES1CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVWES1CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVWES1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVWES1CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVWES1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVWES2CFG		0x0003F134
#define XAIEGBL_PL_STRSWISLVWES2CFGWID		32
#define XAIEGBL_PL_STRSWISLVWES2CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVWES2CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVWES2CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES2CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVWES2CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVWES2CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES2CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVWES2CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES2CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVWES3CFG		0x0003F138
#define XAIEGBL_PL_STRSWISLVWES3CFGWID		32
#define XAIEGBL_PL_STRSWISLVWES3CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVWES3CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVWES3CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES3CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVWES3CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVWES3CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES3CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVWES3CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES3CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVNOR0CFG		0x0003F13C
#define XAIEGBL_PL_STRSWISLVNOR0CFGWID		32
#define XAIEGBL_PL_STRSWISLVNOR0CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVNOR0CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVNOR0CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVNOR0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVNOR0CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVNOR0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVNOR1CFG		0x0003F140
#define XAIEGBL_PL_STRSWISLVNOR1CFGWID		32
#define XAIEGBL_PL_STRSWISLVNOR1CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVNOR1CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVNOR1CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVNOR1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVNOR1CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVNOR1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVNOR2CFG		0x0003F144
#define XAIEGBL_PL_STRSWISLVNOR2CFGWID		32
#define XAIEGBL_PL_STRSWISLVNOR2CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVNOR2CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVNOR2CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR2CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVNOR2CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVNOR2CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR2CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVNOR2CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR2CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVNOR3CFG		0x0003F148
#define XAIEGBL_PL_STRSWISLVNOR3CFGWID		32
#define XAIEGBL_PL_STRSWISLVNOR3CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVNOR3CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVNOR3CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR3CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVNOR3CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVNOR3CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR3CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVNOR3CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR3CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVEAS0CFG		0x0003F14C
#define XAIEGBL_PL_STRSWISLVEAS0CFGWID		32
#define XAIEGBL_PL_STRSWISLVEAS0CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVEAS0CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVEAS0CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS0CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVEAS0CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVEAS0CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS0CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVEAS0CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS0CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVEAS1CFG		0x0003F150
#define XAIEGBL_PL_STRSWISLVEAS1CFGWID		32
#define XAIEGBL_PL_STRSWISLVEAS1CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVEAS1CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVEAS1CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS1CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVEAS1CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVEAS1CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS1CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVEAS1CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS1CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVEAS2CFG		0x0003F154
#define XAIEGBL_PL_STRSWISLVEAS2CFGWID		32
#define XAIEGBL_PL_STRSWISLVEAS2CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVEAS2CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVEAS2CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS2CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVEAS2CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVEAS2CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS2CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVEAS2CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS2CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVEAS3CFG		0x0003F158
#define XAIEGBL_PL_STRSWISLVEAS3CFGWID		32
#define XAIEGBL_PL_STRSWISLVEAS3CFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVEAS3CFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVEAS3CFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS3CFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVEAS3CFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3CFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVEAS3CFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS3CFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVEAS3CFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS3CFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVTRACFG		0x0003F15C
#define XAIEGBL_PL_STRSWISLVTRACFGWID		32
#define XAIEGBL_PL_STRSWISLVTRACFGMSK		0xC0000000
#define XAIEGBL_PL_STRSWISLVTRACFG_SLVENA_LSB		31
#define XAIEGBL_PL_STRSWISLVTRACFG_SLVENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTRACFG_SLVENA_MASK		0x80000000
#define XAIEGBL_PL_STRSWISLVTRACFG_SLVENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRACFG_PKTENA_LSB		30
#define XAIEGBL_PL_STRSWISLVTRACFG_PKTENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTRACFG_PKTENA_MASK		0x40000000
#define XAIEGBL_PL_STRSWISLVTRACFG_PKTENA_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTRACFG(Slave_Enable,Packet_Enable)		(((Slave_Enable&0x00000001)<<31)+((Packet_Enable&0x00000001)<<30))

#define XAIEGBL_PL_STRSWISLVTILCTRSLO0		0x0003F200
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0WID		32
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVTILCTRSLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTILCTRSLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVTILCTRSLO1		0x0003F204
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1WID		32
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVTILCTRSLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTILCTRSLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVTILCTRSLO2		0x0003F208
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2WID		32
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVTILCTRSLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTILCTRSLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVTILCTRSLO3		0x0003F20C
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3WID		32
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVTILCTRSLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTILCTRSLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVFIF0SLO0		0x0003F210
#define XAIEGBL_PL_STRSWISLVFIF0SLO0WID		32
#define XAIEGBL_PL_STRSWISLVFIF0SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVFIF0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVFIF0SLO1		0x0003F214
#define XAIEGBL_PL_STRSWISLVFIF0SLO1WID		32
#define XAIEGBL_PL_STRSWISLVFIF0SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVFIF0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVFIF0SLO2		0x0003F218
#define XAIEGBL_PL_STRSWISLVFIF0SLO2WID		32
#define XAIEGBL_PL_STRSWISLVFIF0SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVFIF0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVFIF0SLO3		0x0003F21C
#define XAIEGBL_PL_STRSWISLVFIF0SLO3WID		32
#define XAIEGBL_PL_STRSWISLVFIF0SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVFIF0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVFIF1SLO0		0x0003F220
#define XAIEGBL_PL_STRSWISLVFIF1SLO0WID		32
#define XAIEGBL_PL_STRSWISLVFIF1SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVFIF1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVFIF1SLO1		0x0003F224
#define XAIEGBL_PL_STRSWISLVFIF1SLO1WID		32
#define XAIEGBL_PL_STRSWISLVFIF1SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVFIF1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVFIF1SLO2		0x0003F228
#define XAIEGBL_PL_STRSWISLVFIF1SLO2WID		32
#define XAIEGBL_PL_STRSWISLVFIF1SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVFIF1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVFIF1SLO3		0x0003F22C
#define XAIEGBL_PL_STRSWISLVFIF1SLO3WID		32
#define XAIEGBL_PL_STRSWISLVFIF1SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVFIF1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVFIF1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU0SLO0		0x0003F230
#define XAIEGBL_PL_STRSWISLVSOU0SLO0WID		32
#define XAIEGBL_PL_STRSWISLVSOU0SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU0SLO1		0x0003F234
#define XAIEGBL_PL_STRSWISLVSOU0SLO1WID		32
#define XAIEGBL_PL_STRSWISLVSOU0SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU0SLO2		0x0003F238
#define XAIEGBL_PL_STRSWISLVSOU0SLO2WID		32
#define XAIEGBL_PL_STRSWISLVSOU0SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU0SLO3		0x0003F23C
#define XAIEGBL_PL_STRSWISLVSOU0SLO3WID		32
#define XAIEGBL_PL_STRSWISLVSOU0SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU1SLO0		0x0003F240
#define XAIEGBL_PL_STRSWISLVSOU1SLO0WID		32
#define XAIEGBL_PL_STRSWISLVSOU1SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU1SLO1		0x0003F244
#define XAIEGBL_PL_STRSWISLVSOU1SLO1WID		32
#define XAIEGBL_PL_STRSWISLVSOU1SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU1SLO2		0x0003F248
#define XAIEGBL_PL_STRSWISLVSOU1SLO2WID		32
#define XAIEGBL_PL_STRSWISLVSOU1SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU1SLO3		0x0003F24C
#define XAIEGBL_PL_STRSWISLVSOU1SLO3WID		32
#define XAIEGBL_PL_STRSWISLVSOU1SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU2SLO0		0x0003F250
#define XAIEGBL_PL_STRSWISLVSOU2SLO0WID		32
#define XAIEGBL_PL_STRSWISLVSOU2SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU2SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU2SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU2SLO1		0x0003F254
#define XAIEGBL_PL_STRSWISLVSOU2SLO1WID		32
#define XAIEGBL_PL_STRSWISLVSOU2SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU2SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU2SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU2SLO2		0x0003F258
#define XAIEGBL_PL_STRSWISLVSOU2SLO2WID		32
#define XAIEGBL_PL_STRSWISLVSOU2SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU2SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU2SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU2SLO3		0x0003F25C
#define XAIEGBL_PL_STRSWISLVSOU2SLO3WID		32
#define XAIEGBL_PL_STRSWISLVSOU2SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU2SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU2SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU3SLO0		0x0003F260
#define XAIEGBL_PL_STRSWISLVSOU3SLO0WID		32
#define XAIEGBL_PL_STRSWISLVSOU3SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU3SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU3SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU3SLO1		0x0003F264
#define XAIEGBL_PL_STRSWISLVSOU3SLO1WID		32
#define XAIEGBL_PL_STRSWISLVSOU3SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU3SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU3SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU3SLO2		0x0003F268
#define XAIEGBL_PL_STRSWISLVSOU3SLO2WID		32
#define XAIEGBL_PL_STRSWISLVSOU3SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU3SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU3SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU3SLO3		0x0003F26C
#define XAIEGBL_PL_STRSWISLVSOU3SLO3WID		32
#define XAIEGBL_PL_STRSWISLVSOU3SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU3SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU3SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU4SLO0		0x0003F270
#define XAIEGBL_PL_STRSWISLVSOU4SLO0WID		32
#define XAIEGBL_PL_STRSWISLVSOU4SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU4SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU4SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU4SLO1		0x0003F274
#define XAIEGBL_PL_STRSWISLVSOU4SLO1WID		32
#define XAIEGBL_PL_STRSWISLVSOU4SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU4SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU4SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU4SLO2		0x0003F278
#define XAIEGBL_PL_STRSWISLVSOU4SLO2WID		32
#define XAIEGBL_PL_STRSWISLVSOU4SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU4SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU4SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU4SLO3		0x0003F27C
#define XAIEGBL_PL_STRSWISLVSOU4SLO3WID		32
#define XAIEGBL_PL_STRSWISLVSOU4SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU4SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU4SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU5SLO0		0x0003F280
#define XAIEGBL_PL_STRSWISLVSOU5SLO0WID		32
#define XAIEGBL_PL_STRSWISLVSOU5SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU5SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU5SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU5SLO1		0x0003F284
#define XAIEGBL_PL_STRSWISLVSOU5SLO1WID		32
#define XAIEGBL_PL_STRSWISLVSOU5SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU5SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU5SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU5SLO2		0x0003F288
#define XAIEGBL_PL_STRSWISLVSOU5SLO2WID		32
#define XAIEGBL_PL_STRSWISLVSOU5SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU5SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU5SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU5SLO3		0x0003F28C
#define XAIEGBL_PL_STRSWISLVSOU5SLO3WID		32
#define XAIEGBL_PL_STRSWISLVSOU5SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU5SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU5SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU6SLO0		0x0003F290
#define XAIEGBL_PL_STRSWISLVSOU6SLO0WID		32
#define XAIEGBL_PL_STRSWISLVSOU6SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU6SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU6SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU6SLO1		0x0003F294
#define XAIEGBL_PL_STRSWISLVSOU6SLO1WID		32
#define XAIEGBL_PL_STRSWISLVSOU6SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU6SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU6SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU6SLO2		0x0003F298
#define XAIEGBL_PL_STRSWISLVSOU6SLO2WID		32
#define XAIEGBL_PL_STRSWISLVSOU6SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU6SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU6SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU6SLO3		0x0003F29C
#define XAIEGBL_PL_STRSWISLVSOU6SLO3WID		32
#define XAIEGBL_PL_STRSWISLVSOU6SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU6SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU6SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU7SLO0		0x0003F2A0
#define XAIEGBL_PL_STRSWISLVSOU7SLO0WID		32
#define XAIEGBL_PL_STRSWISLVSOU7SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU7SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU7SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU7SLO1		0x0003F2A4
#define XAIEGBL_PL_STRSWISLVSOU7SLO1WID		32
#define XAIEGBL_PL_STRSWISLVSOU7SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU7SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU7SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU7SLO2		0x0003F2A8
#define XAIEGBL_PL_STRSWISLVSOU7SLO2WID		32
#define XAIEGBL_PL_STRSWISLVSOU7SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU7SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU7SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVSOU7SLO3		0x0003F2AC
#define XAIEGBL_PL_STRSWISLVSOU7SLO3WID		32
#define XAIEGBL_PL_STRSWISLVSOU7SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVSOU7SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVSOU7SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES0SLO0		0x0003F2B0
#define XAIEGBL_PL_STRSWISLVWES0SLO0WID		32
#define XAIEGBL_PL_STRSWISLVWES0SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES0SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES0SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES0SLO1		0x0003F2B4
#define XAIEGBL_PL_STRSWISLVWES0SLO1WID		32
#define XAIEGBL_PL_STRSWISLVWES0SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES0SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES0SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES0SLO2		0x0003F2B8
#define XAIEGBL_PL_STRSWISLVWES0SLO2WID		32
#define XAIEGBL_PL_STRSWISLVWES0SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES0SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES0SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES0SLO3		0x0003F2BC
#define XAIEGBL_PL_STRSWISLVWES0SLO3WID		32
#define XAIEGBL_PL_STRSWISLVWES0SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES0SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES0SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES1SLO0		0x0003F2C0
#define XAIEGBL_PL_STRSWISLVWES1SLO0WID		32
#define XAIEGBL_PL_STRSWISLVWES1SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES1SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES1SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES1SLO1		0x0003F2C4
#define XAIEGBL_PL_STRSWISLVWES1SLO1WID		32
#define XAIEGBL_PL_STRSWISLVWES1SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES1SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES1SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES1SLO2		0x0003F2C8
#define XAIEGBL_PL_STRSWISLVWES1SLO2WID		32
#define XAIEGBL_PL_STRSWISLVWES1SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES1SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES1SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES1SLO3		0x0003F2CC
#define XAIEGBL_PL_STRSWISLVWES1SLO3WID		32
#define XAIEGBL_PL_STRSWISLVWES1SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES1SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES1SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES2SLO0		0x0003F2D0
#define XAIEGBL_PL_STRSWISLVWES2SLO0WID		32
#define XAIEGBL_PL_STRSWISLVWES2SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES2SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES2SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES2SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES2SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES2SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES2SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES2SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES2SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES2SLO1		0x0003F2D4
#define XAIEGBL_PL_STRSWISLVWES2SLO1WID		32
#define XAIEGBL_PL_STRSWISLVWES2SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES2SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES2SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES2SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES2SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES2SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES2SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES2SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES2SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES2SLO2		0x0003F2D8
#define XAIEGBL_PL_STRSWISLVWES2SLO2WID		32
#define XAIEGBL_PL_STRSWISLVWES2SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES2SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES2SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES2SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES2SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES2SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES2SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES2SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES2SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES2SLO3		0x0003F2DC
#define XAIEGBL_PL_STRSWISLVWES2SLO3WID		32
#define XAIEGBL_PL_STRSWISLVWES2SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES2SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES2SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES2SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES2SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES2SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES2SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES2SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES2SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES3SLO0		0x0003F2E0
#define XAIEGBL_PL_STRSWISLVWES3SLO0WID		32
#define XAIEGBL_PL_STRSWISLVWES3SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES3SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES3SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES3SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES3SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES3SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES3SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES3SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES3SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES3SLO1		0x0003F2E4
#define XAIEGBL_PL_STRSWISLVWES3SLO1WID		32
#define XAIEGBL_PL_STRSWISLVWES3SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES3SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES3SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES3SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES3SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES3SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES3SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES3SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES3SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES3SLO2		0x0003F2E8
#define XAIEGBL_PL_STRSWISLVWES3SLO2WID		32
#define XAIEGBL_PL_STRSWISLVWES3SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES3SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES3SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES3SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES3SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES3SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES3SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES3SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES3SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVWES3SLO3		0x0003F2EC
#define XAIEGBL_PL_STRSWISLVWES3SLO3WID		32
#define XAIEGBL_PL_STRSWISLVWES3SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVWES3SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVWES3SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVWES3SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVWES3SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVWES3SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVWES3SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVWES3SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVWES3SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR0SLO0		0x0003F2F0
#define XAIEGBL_PL_STRSWISLVNOR0SLO0WID		32
#define XAIEGBL_PL_STRSWISLVNOR0SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR0SLO1		0x0003F2F4
#define XAIEGBL_PL_STRSWISLVNOR0SLO1WID		32
#define XAIEGBL_PL_STRSWISLVNOR0SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR0SLO2		0x0003F2F8
#define XAIEGBL_PL_STRSWISLVNOR0SLO2WID		32
#define XAIEGBL_PL_STRSWISLVNOR0SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR0SLO3		0x0003F2FC
#define XAIEGBL_PL_STRSWISLVNOR0SLO3WID		32
#define XAIEGBL_PL_STRSWISLVNOR0SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR1SLO0		0x0003F300
#define XAIEGBL_PL_STRSWISLVNOR1SLO0WID		32
#define XAIEGBL_PL_STRSWISLVNOR1SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR1SLO1		0x0003F304
#define XAIEGBL_PL_STRSWISLVNOR1SLO1WID		32
#define XAIEGBL_PL_STRSWISLVNOR1SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR1SLO2		0x0003F308
#define XAIEGBL_PL_STRSWISLVNOR1SLO2WID		32
#define XAIEGBL_PL_STRSWISLVNOR1SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR1SLO3		0x0003F30C
#define XAIEGBL_PL_STRSWISLVNOR1SLO3WID		32
#define XAIEGBL_PL_STRSWISLVNOR1SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR2SLO0		0x0003F310
#define XAIEGBL_PL_STRSWISLVNOR2SLO0WID		32
#define XAIEGBL_PL_STRSWISLVNOR2SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR2SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR2SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR2SLO1		0x0003F314
#define XAIEGBL_PL_STRSWISLVNOR2SLO1WID		32
#define XAIEGBL_PL_STRSWISLVNOR2SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR2SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR2SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR2SLO2		0x0003F318
#define XAIEGBL_PL_STRSWISLVNOR2SLO2WID		32
#define XAIEGBL_PL_STRSWISLVNOR2SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR2SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR2SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR2SLO3		0x0003F31C
#define XAIEGBL_PL_STRSWISLVNOR2SLO3WID		32
#define XAIEGBL_PL_STRSWISLVNOR2SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR2SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR2SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR3SLO0		0x0003F320
#define XAIEGBL_PL_STRSWISLVNOR3SLO0WID		32
#define XAIEGBL_PL_STRSWISLVNOR3SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR3SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR3SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR3SLO1		0x0003F324
#define XAIEGBL_PL_STRSWISLVNOR3SLO1WID		32
#define XAIEGBL_PL_STRSWISLVNOR3SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR3SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR3SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR3SLO2		0x0003F328
#define XAIEGBL_PL_STRSWISLVNOR3SLO2WID		32
#define XAIEGBL_PL_STRSWISLVNOR3SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR3SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR3SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVNOR3SLO3		0x0003F32C
#define XAIEGBL_PL_STRSWISLVNOR3SLO3WID		32
#define XAIEGBL_PL_STRSWISLVNOR3SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVNOR3SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVNOR3SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS0SLO0		0x0003F330
#define XAIEGBL_PL_STRSWISLVEAS0SLO0WID		32
#define XAIEGBL_PL_STRSWISLVEAS0SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS0SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS0SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS0SLO1		0x0003F334
#define XAIEGBL_PL_STRSWISLVEAS0SLO1WID		32
#define XAIEGBL_PL_STRSWISLVEAS0SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS0SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS0SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS0SLO2		0x0003F338
#define XAIEGBL_PL_STRSWISLVEAS0SLO2WID		32
#define XAIEGBL_PL_STRSWISLVEAS0SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS0SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS0SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS0SLO3		0x0003F33C
#define XAIEGBL_PL_STRSWISLVEAS0SLO3WID		32
#define XAIEGBL_PL_STRSWISLVEAS0SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS0SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS0SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS1SLO0		0x0003F340
#define XAIEGBL_PL_STRSWISLVEAS1SLO0WID		32
#define XAIEGBL_PL_STRSWISLVEAS1SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS1SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS1SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS1SLO1		0x0003F344
#define XAIEGBL_PL_STRSWISLVEAS1SLO1WID		32
#define XAIEGBL_PL_STRSWISLVEAS1SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS1SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS1SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS1SLO2		0x0003F348
#define XAIEGBL_PL_STRSWISLVEAS1SLO2WID		32
#define XAIEGBL_PL_STRSWISLVEAS1SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS1SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS1SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS1SLO3		0x0003F34C
#define XAIEGBL_PL_STRSWISLVEAS1SLO3WID		32
#define XAIEGBL_PL_STRSWISLVEAS1SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS1SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS1SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS2SLO0		0x0003F350
#define XAIEGBL_PL_STRSWISLVEAS2SLO0WID		32
#define XAIEGBL_PL_STRSWISLVEAS2SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS2SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS2SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS2SLO1		0x0003F354
#define XAIEGBL_PL_STRSWISLVEAS2SLO1WID		32
#define XAIEGBL_PL_STRSWISLVEAS2SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS2SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS2SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS2SLO2		0x0003F358
#define XAIEGBL_PL_STRSWISLVEAS2SLO2WID		32
#define XAIEGBL_PL_STRSWISLVEAS2SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS2SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS2SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS2SLO3		0x0003F35C
#define XAIEGBL_PL_STRSWISLVEAS2SLO3WID		32
#define XAIEGBL_PL_STRSWISLVEAS2SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS2SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS2SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS3SLO0		0x0003F360
#define XAIEGBL_PL_STRSWISLVEAS3SLO0WID		32
#define XAIEGBL_PL_STRSWISLVEAS3SLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS3SLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS3SLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS3SLO1		0x0003F364
#define XAIEGBL_PL_STRSWISLVEAS3SLO1WID		32
#define XAIEGBL_PL_STRSWISLVEAS3SLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS3SLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS3SLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS3SLO2		0x0003F368
#define XAIEGBL_PL_STRSWISLVEAS3SLO2WID		32
#define XAIEGBL_PL_STRSWISLVEAS3SLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS3SLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS3SLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVEAS3SLO3		0x0003F36C
#define XAIEGBL_PL_STRSWISLVEAS3SLO3WID		32
#define XAIEGBL_PL_STRSWISLVEAS3SLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVEAS3SLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVEAS3SLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVTRASLO0		0x0003F370
#define XAIEGBL_PL_STRSWISLVTRASLO0WID		32
#define XAIEGBL_PL_STRSWISLVTRASLO0MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVTRASLO0_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVTRASLO0_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTRASLO0_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVTRASLO0_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO0_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVTRASLO0_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTRASLO0_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVTRASLO0_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO0_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVTRASLO0_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTRASLO0_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVTRASLO0_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO0_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVTRASLO0_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVTRASLO0_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVTRASLO0_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO0_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVTRASLO0_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVTRASLO0_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVTRASLO0_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTRASLO0(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVTRASLO1		0x0003F374
#define XAIEGBL_PL_STRSWISLVTRASLO1WID		32
#define XAIEGBL_PL_STRSWISLVTRASLO1MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVTRASLO1_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVTRASLO1_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTRASLO1_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVTRASLO1_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO1_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVTRASLO1_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTRASLO1_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVTRASLO1_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO1_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVTRASLO1_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTRASLO1_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVTRASLO1_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO1_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVTRASLO1_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVTRASLO1_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVTRASLO1_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO1_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVTRASLO1_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVTRASLO1_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVTRASLO1_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTRASLO1(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVTRASLO2		0x0003F378
#define XAIEGBL_PL_STRSWISLVTRASLO2WID		32
#define XAIEGBL_PL_STRSWISLVTRASLO2MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVTRASLO2_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVTRASLO2_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTRASLO2_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVTRASLO2_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO2_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVTRASLO2_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTRASLO2_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVTRASLO2_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO2_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVTRASLO2_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTRASLO2_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVTRASLO2_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO2_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVTRASLO2_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVTRASLO2_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVTRASLO2_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO2_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVTRASLO2_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVTRASLO2_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVTRASLO2_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTRASLO2(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWISLVTRASLO3		0x0003F37C
#define XAIEGBL_PL_STRSWISLVTRASLO3WID		32
#define XAIEGBL_PL_STRSWISLVTRASLO3MSK		0x1F1F0137
#define XAIEGBL_PL_STRSWISLVTRASLO3_ID_LSB		24
#define XAIEGBL_PL_STRSWISLVTRASLO3_ID_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTRASLO3_ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWISLVTRASLO3_ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO3_MSK_LSB		16
#define XAIEGBL_PL_STRSWISLVTRASLO3_MSK_WIDTH		5
#define XAIEGBL_PL_STRSWISLVTRASLO3_MSK_MASK		0x001F0000
#define XAIEGBL_PL_STRSWISLVTRASLO3_MSK_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO3_ENA_LSB		8
#define XAIEGBL_PL_STRSWISLVTRASLO3_ENA_WIDTH		1
#define XAIEGBL_PL_STRSWISLVTRASLO3_ENA_MASK		0x00000100
#define XAIEGBL_PL_STRSWISLVTRASLO3_ENA_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO3_MSE_LSB		4
#define XAIEGBL_PL_STRSWISLVTRASLO3_MSE_WIDTH		2
#define XAIEGBL_PL_STRSWISLVTRASLO3_MSE_MASK		0x00000030
#define XAIEGBL_PL_STRSWISLVTRASLO3_MSE_DEFVAL		0x0
#define XAIEGBL_PL_STRSWISLVTRASLO3_ARB_LSB		0
#define XAIEGBL_PL_STRSWISLVTRASLO3_ARB_WIDTH		3
#define XAIEGBL_PL_STRSWISLVTRASLO3_ARB_MASK		0x00000007
#define XAIEGBL_PL_STRSWISLVTRASLO3_ARB_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWISLVTRASLO3(id,mask,enable,msel,arbit)		(((id&0x0000001f)<<24)+((mask&0x0000001f)<<16)+((enable&0x00000001)<<8)+((msel&0x00000003)<<4)+(arbit&0x00000007))

#define XAIEGBL_PL_STRSWIEVTPORTSEL0		0x0003FF00
#define XAIEGBL_PL_STRSWIEVTPORTSEL0WID		32
#define XAIEGBL_PL_STRSWIEVTPORTSEL0MSK		0x3F3F3F3F
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3MSTRSLV_LSB		29
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3MSTRSLV_WIDTH		1
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3MSTRSLV_MASK		0x20000000
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3MSTRSLV_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3ID_LSB		24
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3ID_WIDTH		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT3ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2MSTRSLV_LSB		21
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2MSTRSLV_WIDTH		1
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2MSTRSLV_MASK		0x00200000
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2MSTRSLV_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2ID_LSB		16
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2ID_WIDTH		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2ID_MASK		0x001F0000
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT2ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1MSTRSLV_LSB		13
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1MSTRSLV_WIDTH		1
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1MSTRSLV_MASK		0x00002000
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1MSTRSLV_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1ID_LSB		8
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1ID_WIDTH		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1ID_MASK		0x00001F00
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT1ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0MSTRSLV_LSB		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0MSTRSLV_WIDTH		1
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0MSTRSLV_MASK		0x00000020
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0MSTRSLV_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0ID_LSB		0
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0ID_WIDTH		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0ID_MASK		0x0000001F
#define XAIEGBL_PL_STRSWIEVTPORTSEL0_PORT0ID_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIEVTPORTSEL0(Port_3_Master_Slave,Port_3_ID,Port_2_Master_Slave,Port_2_ID,Port_1_Master_Slave,Port_1_ID,Port_0_Master_Slave,Port_0_ID)		(((Port_3_Master_Slave&0x00000001)<<29)+((Port_3_ID&0x0000001f)<<24)+((Port_2_Master_Slave&0x00000001)<<21)+((Port_2_ID&0x0000001f)<<16)+((Port_1_Master_Slave&0x00000001)<<13)+((Port_1_ID&0x0000001f)<<8)+((Port_0_Master_Slave&0x00000001)<<5)+(Port_0_ID&0x0000001f))

#define XAIEGBL_PL_STRSWIEVTPORTSEL1		0x0003FF04
#define XAIEGBL_PL_STRSWIEVTPORTSEL1WID		32
#define XAIEGBL_PL_STRSWIEVTPORTSEL1MSK		0x3F3F3F3F
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7MSTRSLV_LSB		29
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7MSTRSLV_WIDTH		1
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7MSTRSLV_MASK		0x20000000
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7MSTRSLV_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7ID_LSB		24
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7ID_WIDTH		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7ID_MASK		0x1F000000
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT7ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6MSTRSLV_LSB		21
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6MSTRSLV_WIDTH		1
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6MSTRSLV_MASK		0x00200000
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6MSTRSLV_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6ID_LSB		16
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6ID_WIDTH		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6ID_MASK		0x001F0000
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT6ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5MSTRSLV_LSB		13
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5MSTRSLV_WIDTH		1
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5MSTRSLV_MASK		0x00002000
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5MSTRSLV_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5ID_LSB		8
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5ID_WIDTH		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5ID_MASK		0x00001F00
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT5ID_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4MSTRSLV_LSB		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4MSTRSLV_WIDTH		1
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4MSTRSLV_MASK		0x00000020
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4MSTRSLV_DEFVAL		0x0
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4ID_LSB		0
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4ID_WIDTH		5
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4ID_MASK		0x0000001F
#define XAIEGBL_PL_STRSWIEVTPORTSEL1_PORT4ID_DEFVAL		0x0
#define XAIEGBL_PL_VALUE_STRSWIEVTPORTSEL1(Port_7_Master_Slave,Port_7_ID,Port_6_Master_Slave,Port_6_ID,Port_5_Master_Slave,Port_5_ID,Port_4_Master_Slave,Port_4_ID)		(((Port_7_Master_Slave&0x00000001)<<29)+((Port_7_ID&0x0000001f)<<24)+((Port_6_Master_Slave&0x00000001)<<21)+((Port_6_ID&0x0000001f)<<16)+((Port_5_Master_Slave&0x00000001)<<13)+((Port_5_ID&0x0000001f)<<8)+((Port_4_Master_Slave&0x00000001)<<5)+(Port_4_ID&0x0000001f))
/** @} */

/* Append new macros here */

/**
 * @name Noc Module register definitions
 * This registers contains noc module information
 * @{
 */
/**
 * Register:XAIEMLGBL_NOC_MODULE
 */
#define XAIEGBL_NOC_LOCK0RELNV		0x00014000
#define XAIEGBL_NOC_LOCK0RELNVWID		32
#define XAIEGBL_NOC_LOCK0RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK0RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK0RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK0RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK0RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK0RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK0RELV0		0x00014020
#define XAIEGBL_NOC_LOCK0RELV0WID		32
#define XAIEGBL_NOC_LOCK0RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK0RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK0RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK0RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK0RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK0RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK0RELV1		0x00014030
#define XAIEGBL_NOC_LOCK0RELV1WID		32
#define XAIEGBL_NOC_LOCK0RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK0RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK0RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK0RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK0RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK0RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK0ACQNV		0x00014040
#define XAIEGBL_NOC_LOCK0ACQNVWID		32
#define XAIEGBL_NOC_LOCK0ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK0ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK0ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK0ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK0ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK0ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK0ACQV0		0x00014060
#define XAIEGBL_NOC_LOCK0ACQV0WID		32
#define XAIEGBL_NOC_LOCK0ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK0ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK0ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK0ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK0ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK0ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK0ACQV1		0x00014070
#define XAIEGBL_NOC_LOCK0ACQV1WID		32
#define XAIEGBL_NOC_LOCK0ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK0ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK0ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK0ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK0ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK0ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK1RELNV		0x00014080
#define XAIEGBL_NOC_LOCK1RELNVWID		32
#define XAIEGBL_NOC_LOCK1RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK1RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK1RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK1RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK1RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK1RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK1RELV0		0x000140A0
#define XAIEGBL_NOC_LOCK1RELV0WID		32
#define XAIEGBL_NOC_LOCK1RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK1RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK1RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK1RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK1RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK1RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK1RELV1		0x000140B0
#define XAIEGBL_NOC_LOCK1RELV1WID		32
#define XAIEGBL_NOC_LOCK1RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK1RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK1RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK1RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK1RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK1RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK1ACQNV		0x000140C0
#define XAIEGBL_NOC_LOCK1ACQNVWID		32
#define XAIEGBL_NOC_LOCK1ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK1ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK1ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK1ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK1ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK1ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK1ACQV0		0x000140E0
#define XAIEGBL_NOC_LOCK1ACQV0WID		32
#define XAIEGBL_NOC_LOCK1ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK1ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK1ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK1ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK1ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK1ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK1ACQV1		0x000140F0
#define XAIEGBL_NOC_LOCK1ACQV1WID		32
#define XAIEGBL_NOC_LOCK1ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK1ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK1ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK1ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK1ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK1ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK2RELNV		0x00014100
#define XAIEGBL_NOC_LOCK2RELNVWID		32
#define XAIEGBL_NOC_LOCK2RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK2RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK2RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK2RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK2RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK2RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK2RELV0		0x00014120
#define XAIEGBL_NOC_LOCK2RELV0WID		32
#define XAIEGBL_NOC_LOCK2RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK2RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK2RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK2RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK2RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK2RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK2RELV1		0x00014130
#define XAIEGBL_NOC_LOCK2RELV1WID		32
#define XAIEGBL_NOC_LOCK2RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK2RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK2RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK2RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK2RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK2RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK2ACQNV		0x00014140
#define XAIEGBL_NOC_LOCK2ACQNVWID		32
#define XAIEGBL_NOC_LOCK2ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK2ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK2ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK2ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK2ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK2ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK2ACQV0		0x00014160
#define XAIEGBL_NOC_LOCK2ACQV0WID		32
#define XAIEGBL_NOC_LOCK2ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK2ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK2ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK2ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK2ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK2ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK2ACQV1		0x00014170
#define XAIEGBL_NOC_LOCK2ACQV1WID		32
#define XAIEGBL_NOC_LOCK2ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK2ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK2ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK2ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK2ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK2ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK3RELNV		0x00014180
#define XAIEGBL_NOC_LOCK3RELNVWID		32
#define XAIEGBL_NOC_LOCK3RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK3RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK3RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK3RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK3RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK3RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK3RELV0		0x000141A0
#define XAIEGBL_NOC_LOCK3RELV0WID		32
#define XAIEGBL_NOC_LOCK3RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK3RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK3RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK3RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK3RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK3RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK3RELV1		0x000141B0
#define XAIEGBL_NOC_LOCK3RELV1WID		32
#define XAIEGBL_NOC_LOCK3RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK3RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK3RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK3RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK3RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK3RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK3ACQNV		0x000141C0
#define XAIEGBL_NOC_LOCK3ACQNVWID		32
#define XAIEGBL_NOC_LOCK3ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK3ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK3ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK3ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK3ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK3ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK3ACQV0		0x000141E0
#define XAIEGBL_NOC_LOCK3ACQV0WID		32
#define XAIEGBL_NOC_LOCK3ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK3ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK3ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK3ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK3ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK3ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK3ACQV1		0x000141F0
#define XAIEGBL_NOC_LOCK3ACQV1WID		32
#define XAIEGBL_NOC_LOCK3ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK3ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK3ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK3ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK3ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK3ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK4RELNV		0x00014200
#define XAIEGBL_NOC_LOCK4RELNVWID		32
#define XAIEGBL_NOC_LOCK4RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK4RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK4RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK4RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK4RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK4RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK4RELV0		0x00014220
#define XAIEGBL_NOC_LOCK4RELV0WID		32
#define XAIEGBL_NOC_LOCK4RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK4RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK4RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK4RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK4RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK4RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK4RELV1		0x00014230
#define XAIEGBL_NOC_LOCK4RELV1WID		32
#define XAIEGBL_NOC_LOCK4RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK4RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK4RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK4RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK4RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK4RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK4ACQNV		0x00014240
#define XAIEGBL_NOC_LOCK4ACQNVWID		32
#define XAIEGBL_NOC_LOCK4ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK4ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK4ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK4ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK4ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK4ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK4ACQV0		0x00014260
#define XAIEGBL_NOC_LOCK4ACQV0WID		32
#define XAIEGBL_NOC_LOCK4ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK4ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK4ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK4ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK4ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK4ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK4ACQV1		0x00014270
#define XAIEGBL_NOC_LOCK4ACQV1WID		32
#define XAIEGBL_NOC_LOCK4ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK4ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK4ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK4ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK4ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK4ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK5RELNV		0x00014280
#define XAIEGBL_NOC_LOCK5RELNVWID		32
#define XAIEGBL_NOC_LOCK5RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK5RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK5RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK5RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK5RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK5RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK5RELV0		0x000142A0
#define XAIEGBL_NOC_LOCK5RELV0WID		32
#define XAIEGBL_NOC_LOCK5RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK5RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK5RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK5RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK5RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK5RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK5RELV1		0x000142B0
#define XAIEGBL_NOC_LOCK5RELV1WID		32
#define XAIEGBL_NOC_LOCK5RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK5RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK5RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK5RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK5RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK5RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK5ACQNV		0x000142C0
#define XAIEGBL_NOC_LOCK5ACQNVWID		32
#define XAIEGBL_NOC_LOCK5ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK5ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK5ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK5ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK5ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK5ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK5ACQV0		0x000142E0
#define XAIEGBL_NOC_LOCK5ACQV0WID		32
#define XAIEGBL_NOC_LOCK5ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK5ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK5ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK5ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK5ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK5ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK5ACQV1		0x000142F0
#define XAIEGBL_NOC_LOCK5ACQV1WID		32
#define XAIEGBL_NOC_LOCK5ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK5ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK5ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK5ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK5ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK5ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK6RELNV		0x00014300
#define XAIEGBL_NOC_LOCK6RELNVWID		32
#define XAIEGBL_NOC_LOCK6RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK6RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK6RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK6RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK6RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK6RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK6RELV0		0x00014320
#define XAIEGBL_NOC_LOCK6RELV0WID		32
#define XAIEGBL_NOC_LOCK6RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK6RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK6RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK6RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK6RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK6RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK6RELV1		0x00014330
#define XAIEGBL_NOC_LOCK6RELV1WID		32
#define XAIEGBL_NOC_LOCK6RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK6RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK6RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK6RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK6RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK6RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK6ACQNV		0x00014340
#define XAIEGBL_NOC_LOCK6ACQNVWID		32
#define XAIEGBL_NOC_LOCK6ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK6ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK6ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK6ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK6ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK6ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK6ACQV0		0x00014360
#define XAIEGBL_NOC_LOCK6ACQV0WID		32
#define XAIEGBL_NOC_LOCK6ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK6ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK6ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK6ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK6ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK6ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK6ACQV1		0x00014370
#define XAIEGBL_NOC_LOCK6ACQV1WID		32
#define XAIEGBL_NOC_LOCK6ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK6ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK6ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK6ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK6ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK6ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK7RELNV		0x00014380
#define XAIEGBL_NOC_LOCK7RELNVWID		32
#define XAIEGBL_NOC_LOCK7RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK7RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK7RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK7RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK7RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK7RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK7RELV0		0x000143A0
#define XAIEGBL_NOC_LOCK7RELV0WID		32
#define XAIEGBL_NOC_LOCK7RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK7RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK7RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK7RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK7RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK7RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK7RELV1		0x000143B0
#define XAIEGBL_NOC_LOCK7RELV1WID		32
#define XAIEGBL_NOC_LOCK7RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK7RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK7RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK7RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK7RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK7RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK7ACQNV		0x000143C0
#define XAIEGBL_NOC_LOCK7ACQNVWID		32
#define XAIEGBL_NOC_LOCK7ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK7ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK7ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK7ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK7ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK7ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK7ACQV0		0x000143E0
#define XAIEGBL_NOC_LOCK7ACQV0WID		32
#define XAIEGBL_NOC_LOCK7ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK7ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK7ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK7ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK7ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK7ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK7ACQV1		0x000143F0
#define XAIEGBL_NOC_LOCK7ACQV1WID		32
#define XAIEGBL_NOC_LOCK7ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK7ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK7ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK7ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK7ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK7ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK8RELNV		0x00014400
#define XAIEGBL_NOC_LOCK8RELNVWID		32
#define XAIEGBL_NOC_LOCK8RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK8RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK8RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK8RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK8RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK8RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK8RELV0		0x00014420
#define XAIEGBL_NOC_LOCK8RELV0WID		32
#define XAIEGBL_NOC_LOCK8RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK8RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK8RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK8RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK8RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK8RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK8RELV1		0x00014430
#define XAIEGBL_NOC_LOCK8RELV1WID		32
#define XAIEGBL_NOC_LOCK8RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK8RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK8RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK8RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK8RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK8RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK8ACQNV		0x00014440
#define XAIEGBL_NOC_LOCK8ACQNVWID		32
#define XAIEGBL_NOC_LOCK8ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK8ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK8ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK8ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK8ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK8ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK8ACQV0		0x00014460
#define XAIEGBL_NOC_LOCK8ACQV0WID		32
#define XAIEGBL_NOC_LOCK8ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK8ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK8ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK8ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK8ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK8ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK8ACQV1		0x00014470
#define XAIEGBL_NOC_LOCK8ACQV1WID		32
#define XAIEGBL_NOC_LOCK8ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK8ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK8ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK8ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK8ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK8ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK9RELNV		0x00014480
#define XAIEGBL_NOC_LOCK9RELNVWID		32
#define XAIEGBL_NOC_LOCK9RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK9RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK9RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK9RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK9RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK9RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK9RELV0		0x000144A0
#define XAIEGBL_NOC_LOCK9RELV0WID		32
#define XAIEGBL_NOC_LOCK9RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK9RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK9RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK9RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK9RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK9RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK9RELV1		0x000144B0
#define XAIEGBL_NOC_LOCK9RELV1WID		32
#define XAIEGBL_NOC_LOCK9RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK9RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK9RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK9RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK9RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK9RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK9ACQNV		0x000144C0
#define XAIEGBL_NOC_LOCK9ACQNVWID		32
#define XAIEGBL_NOC_LOCK9ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK9ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK9ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK9ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK9ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK9ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK9ACQV0		0x000144E0
#define XAIEGBL_NOC_LOCK9ACQV0WID		32
#define XAIEGBL_NOC_LOCK9ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK9ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK9ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK9ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK9ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK9ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK9ACQV1		0x000144F0
#define XAIEGBL_NOC_LOCK9ACQV1WID		32
#define XAIEGBL_NOC_LOCK9ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK9ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK9ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK9ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK9ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK9ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK10RELNV		0x00014500
#define XAIEGBL_NOC_LOCK10RELNVWID		32
#define XAIEGBL_NOC_LOCK10RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK10RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK10RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK10RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK10RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK10RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK10RELV0		0x00014520
#define XAIEGBL_NOC_LOCK10RELV0WID		32
#define XAIEGBL_NOC_LOCK10RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK10RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK10RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK10RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK10RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK10RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK10RELV1		0x00014530
#define XAIEGBL_NOC_LOCK10RELV1WID		32
#define XAIEGBL_NOC_LOCK10RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK10RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK10RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK10RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK10RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK10RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK10ACQNV		0x00014540
#define XAIEGBL_NOC_LOCK10ACQNVWID		32
#define XAIEGBL_NOC_LOCK10ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK10ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK10ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK10ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK10ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK10ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK10ACQV0		0x00014560
#define XAIEGBL_NOC_LOCK10ACQV0WID		32
#define XAIEGBL_NOC_LOCK10ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK10ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK10ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK10ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK10ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK10ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK10ACQV1		0x00014570
#define XAIEGBL_NOC_LOCK10ACQV1WID		32
#define XAIEGBL_NOC_LOCK10ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK10ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK10ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK10ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK10ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK10ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK11RELNV		0x00014580
#define XAIEGBL_NOC_LOCK11RELNVWID		32
#define XAIEGBL_NOC_LOCK11RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK11RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK11RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK11RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK11RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK11RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK11RELV0		0x000145A0
#define XAIEGBL_NOC_LOCK11RELV0WID		32
#define XAIEGBL_NOC_LOCK11RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK11RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK11RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK11RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK11RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK11RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK11RELV1		0x000145B0
#define XAIEGBL_NOC_LOCK11RELV1WID		32
#define XAIEGBL_NOC_LOCK11RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK11RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK11RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK11RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK11RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK11RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK11ACQNV		0x000145C0
#define XAIEGBL_NOC_LOCK11ACQNVWID		32
#define XAIEGBL_NOC_LOCK11ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK11ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK11ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK11ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK11ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK11ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK11ACQV0		0x000145E0
#define XAIEGBL_NOC_LOCK11ACQV0WID		32
#define XAIEGBL_NOC_LOCK11ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK11ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK11ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK11ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK11ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK11ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK11ACQV1		0x000145F0
#define XAIEGBL_NOC_LOCK11ACQV1WID		32
#define XAIEGBL_NOC_LOCK11ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK11ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK11ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK11ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK11ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK11ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK12RELNV		0x00014600
#define XAIEGBL_NOC_LOCK12RELNVWID		32
#define XAIEGBL_NOC_LOCK12RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK12RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK12RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK12RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK12RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK12RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK12RELV0		0x00014620
#define XAIEGBL_NOC_LOCK12RELV0WID		32
#define XAIEGBL_NOC_LOCK12RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK12RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK12RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK12RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK12RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK12RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK12RELV1		0x00014630
#define XAIEGBL_NOC_LOCK12RELV1WID		32
#define XAIEGBL_NOC_LOCK12RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK12RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK12RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK12RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK12RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK12RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK12ACQNV		0x00014640
#define XAIEGBL_NOC_LOCK12ACQNVWID		32
#define XAIEGBL_NOC_LOCK12ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK12ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK12ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK12ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK12ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK12ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK12ACQV0		0x00014660
#define XAIEGBL_NOC_LOCK12ACQV0WID		32
#define XAIEGBL_NOC_LOCK12ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK12ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK12ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK12ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK12ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK12ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK12ACQV1		0x00014670
#define XAIEGBL_NOC_LOCK12ACQV1WID		32
#define XAIEGBL_NOC_LOCK12ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK12ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK12ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK12ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK12ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK12ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK13RELNV		0x00014680
#define XAIEGBL_NOC_LOCK13RELNVWID		32
#define XAIEGBL_NOC_LOCK13RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK13RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK13RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK13RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK13RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK13RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK13RELV0		0x000146A0
#define XAIEGBL_NOC_LOCK13RELV0WID		32
#define XAIEGBL_NOC_LOCK13RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK13RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK13RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK13RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK13RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK13RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK13RELV1		0x000146B0
#define XAIEGBL_NOC_LOCK13RELV1WID		32
#define XAIEGBL_NOC_LOCK13RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK13RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK13RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK13RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK13RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK13RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK13ACQNV		0x000146C0
#define XAIEGBL_NOC_LOCK13ACQNVWID		32
#define XAIEGBL_NOC_LOCK13ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK13ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK13ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK13ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK13ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK13ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK13ACQV0		0x000146E0
#define XAIEGBL_NOC_LOCK13ACQV0WID		32
#define XAIEGBL_NOC_LOCK13ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK13ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK13ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK13ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK13ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK13ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK13ACQV1		0x000146F0
#define XAIEGBL_NOC_LOCK13ACQV1WID		32
#define XAIEGBL_NOC_LOCK13ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK13ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK13ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK13ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK13ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK13ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK14RELNV		0x00014700
#define XAIEGBL_NOC_LOCK14RELNVWID		32
#define XAIEGBL_NOC_LOCK14RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK14RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK14RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK14RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK14RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK14RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK14RELV0		0x00014720
#define XAIEGBL_NOC_LOCK14RELV0WID		32
#define XAIEGBL_NOC_LOCK14RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK14RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK14RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK14RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK14RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK14RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK14RELV1		0x00014730
#define XAIEGBL_NOC_LOCK14RELV1WID		32
#define XAIEGBL_NOC_LOCK14RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK14RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK14RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK14RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK14RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK14RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK14ACQNV		0x00014740
#define XAIEGBL_NOC_LOCK14ACQNVWID		32
#define XAIEGBL_NOC_LOCK14ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK14ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK14ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK14ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK14ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK14ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK14ACQV0		0x00014760
#define XAIEGBL_NOC_LOCK14ACQV0WID		32
#define XAIEGBL_NOC_LOCK14ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK14ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK14ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK14ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK14ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK14ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK14ACQV1		0x00014770
#define XAIEGBL_NOC_LOCK14ACQV1WID		32
#define XAIEGBL_NOC_LOCK14ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK14ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK14ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK14ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK14ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK14ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK15RELNV		0x00014780
#define XAIEGBL_NOC_LOCK15RELNVWID		32
#define XAIEGBL_NOC_LOCK15RELNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK15RELNV_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK15RELNV_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK15RELNV_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK15RELNV_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK15RELNV(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK15RELV0		0x000147A0
#define XAIEGBL_NOC_LOCK15RELV0WID		32
#define XAIEGBL_NOC_LOCK15RELV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK15RELV0_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK15RELV0_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK15RELV0_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK15RELV0_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK15RELV0(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK15RELV1		0x000147B0
#define XAIEGBL_NOC_LOCK15RELV1WID		32
#define XAIEGBL_NOC_LOCK15RELV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK15RELV1_RELDON_LSB		0
#define XAIEGBL_NOC_LOCK15RELV1_RELDON_WIDTH		1
#define XAIEGBL_NOC_LOCK15RELV1_RELDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK15RELV1_RELDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK15RELV1(Release_Done)		((Release_Done&0x00000001))

#define XAIEGBL_NOC_LOCK15ACQNV		0x000147C0
#define XAIEGBL_NOC_LOCK15ACQNVWID		32
#define XAIEGBL_NOC_LOCK15ACQNVMSK		0x00000001
#define XAIEGBL_NOC_LOCK15ACQNV_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK15ACQNV_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK15ACQNV_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK15ACQNV_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK15ACQNV(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK15ACQV0		0x000147E0
#define XAIEGBL_NOC_LOCK15ACQV0WID		32
#define XAIEGBL_NOC_LOCK15ACQV0MSK		0x00000001
#define XAIEGBL_NOC_LOCK15ACQV0_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK15ACQV0_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK15ACQV0_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK15ACQV0_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK15ACQV0(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_LOCK15ACQV1		0x000147F0
#define XAIEGBL_NOC_LOCK15ACQV1WID		32
#define XAIEGBL_NOC_LOCK15ACQV1MSK		0x00000001
#define XAIEGBL_NOC_LOCK15ACQV1_ACQDON_LSB		0
#define XAIEGBL_NOC_LOCK15ACQV1_ACQDON_WIDTH		1
#define XAIEGBL_NOC_LOCK15ACQV1_ACQDON_MASK		0x00000001
#define XAIEGBL_NOC_LOCK15ACQV1_ACQDON_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCK15ACQV1(Acquire_Done)		((Acquire_Done&0x00000001))

#define XAIEGBL_NOC_ALLLOCKSTAVAL		0x00014F00
#define XAIEGBL_NOC_ALLLOCKSTAVALWID		32
#define XAIEGBL_NOC_ALLLOCKSTAVALMSK		0xFFFFFFFF
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK15VAL_LSB		31
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK15VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK15VAL_MASK		0x80000000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK15VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK15STA_LSB		30
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK15STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK15STA_MASK		0x40000000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK15STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK14VAL_LSB		29
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK14VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK14VAL_MASK		0x20000000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK14VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK14STA_LSB		28
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK14STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK14STA_MASK		0x10000000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK14STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK13VAL_LSB		27
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK13VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK13VAL_MASK		0x08000000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK13VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK13STA_LSB		26
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK13STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK13STA_MASK		0x04000000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK13STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK12VAL_LSB		25
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK12VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK12VAL_MASK		0x02000000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK12VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK12STA_LSB		24
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK12STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK12STA_MASK		0x01000000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK12STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK11VAL_LSB		23
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK11VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK11VAL_MASK		0x00800000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK11VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK11STA_LSB		22
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK11STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK11STA_MASK		0x00400000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK11STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK10VAL_LSB		21
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK10VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK10VAL_MASK		0x00200000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK10VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK10STA_LSB		20
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK10STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK10STA_MASK		0x00100000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK10STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK9VAL_LSB		19
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK9VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK9VAL_MASK		0x00080000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK9VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK9STA_LSB		18
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK9STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK9STA_MASK		0x00040000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK9STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK8VAL_LSB		17
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK8VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK8VAL_MASK		0x00020000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK8VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK8STA_LSB		16
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK8STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK8STA_MASK		0x00010000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK8STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK7VAL_LSB		15
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK7VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK7VAL_MASK		0x00008000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK7VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK7STA_LSB		14
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK7STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK7STA_MASK		0x00004000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK7STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK6VAL_LSB		13
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK6VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK6VAL_MASK		0x00002000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK6VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK6STA_LSB		12
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK6STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK6STA_MASK		0x00001000
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK6STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK5VAL_LSB		11
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK5VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK5VAL_MASK		0x00000800
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK5VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK5STA_LSB		10
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK5STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK5STA_MASK		0x00000400
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK5STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK4VAL_LSB		9
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK4VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK4VAL_MASK		0x00000200
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK4VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK4STA_LSB		8
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK4STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK4STA_MASK		0x00000100
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK4STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK3VAL_LSB		7
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK3VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK3VAL_MASK		0x00000080
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK3VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK3STA_LSB		6
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK3STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK3STA_MASK		0x00000040
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK3STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK2VAL_LSB		5
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK2VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK2VAL_MASK		0x00000020
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK2VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK2STA_LSB		4
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK2STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK2STA_MASK		0x00000010
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK2STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK1VAL_LSB		3
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK1VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK1VAL_MASK		0x00000008
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK1VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK1STA_LSB		2
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK1STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK1STA_MASK		0x00000004
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK1STA_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK0VAL_LSB		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK0VAL_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK0VAL_MASK		0x00000002
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK0VAL_DEFVAL		0x0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK0STA_LSB		0
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK0STA_WIDTH		1
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK0STA_MASK		0x00000001
#define XAIEGBL_NOC_ALLLOCKSTAVAL_LOCK0STA_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_ALLLOCKSTAVAL(Lock15_Value,Lock15_State,Lock14_Value,Lock14_State,Lock13_Value,Lock13_State,Lock12_Value,Lock12_State,Lock11_Value,Lock11_State,Lock10_Value,Lock10_State,Lock9_Value,Lock9_State,Lock8_Value,Lock8_State,Lock7_Value,Lock7_State,Lock6_Value,Lock6_State,Lock5_Value,Lock5_State,Lock4_Value,Lock4_State,Lock3_Value,Lock3_State,Lock2_Value,Lock2_State,Lock1_Value,Lock1_State,Lock0_Value,Lock0_State)		(((Lock15_Value&0x00000001)<<31)+((Lock15_State&0x00000001)<<30)+((Lock14_Value&0x00000001)<<29)+((Lock14_State&0x00000001)<<28)+((Lock13_Value&0x00000001)<<27)+((Lock13_State&0x00000001)<<26)+((Lock12_Value&0x00000001)<<25)+((Lock12_State&0x00000001)<<24)+((Lock11_Value&0x00000001)<<23)+((Lock11_State&0x00000001)<<22)+((Lock10_Value&0x00000001)<<21)+((Lock10_State&0x00000001)<<20)+((Lock9_Value&0x00000001)<<19)+((Lock9_State&0x00000001)<<18)+((Lock8_Value&0x00000001)<<17)+((Lock8_State&0x00000001)<<16)+((Lock7_Value&0x00000001)<<15)+((Lock7_State&0x00000001)<<14)+((Lock6_Value&0x00000001)<<13)+((Lock6_State&0x00000001)<<12)+((Lock5_Value&0x00000001)<<11)+((Lock5_State&0x00000001)<<10)+((Lock4_Value&0x00000001)<<9)+((Lock4_State&0x00000001)<<8)+((Lock3_Value&0x00000001)<<7)+((Lock3_State&0x00000001)<<6)+((Lock2_Value&0x00000001)<<5)+((Lock2_State&0x00000001)<<4)+((Lock1_Value&0x00000001)<<3)+((Lock1_State&0x00000001)<<2)+((Lock0_Value&0x00000001)<<1)+(Lock0_State&0x00000001))

#define XAIEGBL_NOC_LOCKEVTVALCTRL0		0x00014F20
#define XAIEGBL_NOC_LOCKEVTVALCTRL0WID		32
#define XAIEGBL_NOC_LOCKEVTVALCTRL0MSK		0xFFFFFFFF
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK7REL_LSB		30
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK7REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK7REL_MASK		0xC0000000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK7REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK7ACQ_LSB		28
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK7ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK7ACQ_MASK		0x30000000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK7ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK6REL_LSB		26
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK6REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK6REL_MASK		0x0C000000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK6REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK6ACQ_LSB		24
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK6ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK6ACQ_MASK		0x03000000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK6ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK5REL_LSB		22
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK5REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK5REL_MASK		0x00C00000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK5REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK5ACQ_LSB		20
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK5ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK5ACQ_MASK		0x00300000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK5ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK4REL_LSB		18
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK4REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK4REL_MASK		0x000C0000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK4REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK4ACQ_LSB		16
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK4ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK4ACQ_MASK		0x00030000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK4ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK3REL_LSB		14
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK3REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK3REL_MASK		0x0000C000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK3REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK3ACQ_LSB		12
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK3ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK3ACQ_MASK		0x00003000
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK3ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK2REL_LSB		10
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK2REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK2REL_MASK		0x00000C00
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK2REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK2ACQ_LSB		8
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK2ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK2ACQ_MASK		0x00000300
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK2ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK1REL_LSB		6
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK1REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK1REL_MASK		0x000000C0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK1REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK1ACQ_LSB		4
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK1ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK1ACQ_MASK		0x00000030
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK1ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK0REL_LSB		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK0REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK0REL_MASK		0x0000000C
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK0REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK0ACQ_LSB		0
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK0ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK0ACQ_MASK		0x00000003
#define XAIEGBL_NOC_LOCKEVTVALCTRL0_LOCK0ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCKEVTVALCTRL0(Lock_7_Release,Lock_7_Acquired,Lock_6_Release,Lock_6_Acquired,Lock_5_Release,Lock_5_Acquired,Lock_4_Release,Lock_4_Acquired,Lock_3_Release,Lock_3_Acquired,Lock_2_Release,Lock_2_Acquired,Lock_1_Release,Lock_1_Acquired,Lock_0_Release,Lock_0_Acquired)		(((Lock_7_Release&0x00000003)<<30)+((Lock_7_Acquired&0x00000003)<<28)+((Lock_6_Release&0x00000003)<<26)+((Lock_6_Acquired&0x00000003)<<24)+((Lock_5_Release&0x00000003)<<22)+((Lock_5_Acquired&0x00000003)<<20)+((Lock_4_Release&0x00000003)<<18)+((Lock_4_Acquired&0x00000003)<<16)+((Lock_3_Release&0x00000003)<<14)+((Lock_3_Acquired&0x00000003)<<12)+((Lock_2_Release&0x00000003)<<10)+((Lock_2_Acquired&0x00000003)<<8)+((Lock_1_Release&0x00000003)<<6)+((Lock_1_Acquired&0x00000003)<<4)+((Lock_0_Release&0x00000003)<<2)+(Lock_0_Acquired&0x00000003))

#define XAIEGBL_NOC_LOCKEVTVALCTRL1		0x00014F24
#define XAIEGBL_NOC_LOCKEVTVALCTRL1WID		32
#define XAIEGBL_NOC_LOCKEVTVALCTRL1MSK		0xFFFFFFFF
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK15REL_LSB		30
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK15REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK15REL_MASK		0xC0000000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK15REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK15ACQ_LSB		28
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK15ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK15ACQ_MASK		0x30000000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK15ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK14REL_LSB		26
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK14REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK14REL_MASK		0x0C000000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK14REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK14ACQ_LSB		24
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK14ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK14ACQ_MASK		0x03000000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK14ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK13REL_LSB		22
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK13REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK13REL_MASK		0x00C00000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK13REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK13ACQ_LSB		20
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK13ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK13ACQ_MASK		0x00300000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK13ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK12REL_LSB		18
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK12REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK12REL_MASK		0x000C0000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK12REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK12ACQ_LSB		16
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK12ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK12ACQ_MASK		0x00030000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK12ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK11REL_LSB		14
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK11REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK11REL_MASK		0x0000C000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK11REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK11ACQ_LSB		12
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK11ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK11ACQ_MASK		0x00003000
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK11ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK10REL_LSB		10
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK10REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK10REL_MASK		0x00000C00
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK10REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK10ACQ_LSB		8
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK10ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK10ACQ_MASK		0x00000300
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK10ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK9REL_LSB		6
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK9REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK9REL_MASK		0x000000C0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK9REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK9ACQ_LSB		4
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK9ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK9ACQ_MASK		0x00000030
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK9ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK8REL_LSB		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK8REL_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK8REL_MASK		0x0000000C
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK8REL_DEFVAL		0x0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK8ACQ_LSB		0
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK8ACQ_WIDTH		2
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK8ACQ_MASK		0x00000003
#define XAIEGBL_NOC_LOCKEVTVALCTRL1_LOCK8ACQ_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_LOCKEVTVALCTRL1(Lock_15_Release,Lock_15_Acquired,Lock_14_Release,Lock_14_Acquired,Lock_13_Release,Lock_13_Acquired,Lock_12_Release,Lock_12_Acquired,Lock_11_Release,Lock_11_Acquired,Lock_10_Release,Lock_10_Acquired,Lock_9_Release,Lock_9_Acquired,Lock_8_Release,Lock_8_Acquired)		(((Lock_15_Release&0x00000003)<<30)+((Lock_15_Acquired&0x00000003)<<28)+((Lock_14_Release&0x00000003)<<26)+((Lock_14_Acquired&0x00000003)<<24)+((Lock_13_Release&0x00000003)<<22)+((Lock_13_Acquired&0x00000003)<<20)+((Lock_12_Release&0x00000003)<<18)+((Lock_12_Acquired&0x00000003)<<16)+((Lock_11_Release&0x00000003)<<14)+((Lock_11_Acquired&0x00000003)<<12)+((Lock_10_Release&0x00000003)<<10)+((Lock_10_Acquired&0x00000003)<<8)+((Lock_9_Release&0x00000003)<<6)+((Lock_9_Acquired&0x00000003)<<4)+((Lock_8_Release&0x00000003)<<2)+(Lock_8_Acquired&0x00000003))

#define XAIEGBL_NOC_INTCON2NDLEVMSK		0x00015000
#define XAIEGBL_NOC_INTCON2NDLEVMSKWID		32
#define XAIEGBL_NOC_INTCON2NDLEVMSKMSK		0x0000FFFF
#define XAIEGBL_NOC_INTCON2NDLEVMSK_IRQMSKA_LSB		0
#define XAIEGBL_NOC_INTCON2NDLEVMSK_IRQMSKA_WIDTH		16
#define XAIEGBL_NOC_INTCON2NDLEVMSK_IRQMSKA_MASK		0x0000FFFF
#define XAIEGBL_NOC_INTCON2NDLEVMSK_IRQMSKA_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_INTCON2NDLEVMSK(IRQ_Mask_A)		((IRQ_Mask_A&0x0000ffff))

#define XAIEGBL_NOC_INTCON2NDLEVENA		0x00015004
#define XAIEGBL_NOC_INTCON2NDLEVENAWID		32
#define XAIEGBL_NOC_INTCON2NDLEVENAMSK		0x0000FFFF
#define XAIEGBL_NOC_INTCON2NDLEVENA_ENAA_LSB		0
#define XAIEGBL_NOC_INTCON2NDLEVENA_ENAA_WIDTH		16
#define XAIEGBL_NOC_INTCON2NDLEVENA_ENAA_MASK		0x0000FFFF
#define XAIEGBL_NOC_INTCON2NDLEVENA_ENAA_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_INTCON2NDLEVENA(Enable_A)		((Enable_A&0x0000ffff))

#define XAIEGBL_NOC_INTCON2NDLEVDIS		0x00015008
#define XAIEGBL_NOC_INTCON2NDLEVDISWID		32
#define XAIEGBL_NOC_INTCON2NDLEVDISMSK		0x0000FFFF
#define XAIEGBL_NOC_INTCON2NDLEVDIS_DISA_LSB		0
#define XAIEGBL_NOC_INTCON2NDLEVDIS_DISA_WIDTH		16
#define XAIEGBL_NOC_INTCON2NDLEVDIS_DISA_MASK		0x0000FFFF
#define XAIEGBL_NOC_INTCON2NDLEVDIS_DISA_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_INTCON2NDLEVDIS(Disable_A)		((Disable_A&0x0000ffff))

#define XAIEGBL_NOC_INTCON2NDLEVSTA		0x0001500C
#define XAIEGBL_NOC_INTCON2NDLEVSTAWID		32
#define XAIEGBL_NOC_INTCON2NDLEVSTAMSK		0x0000FFFF
#define XAIEGBL_NOC_INTCON2NDLEVSTA_STAA_LSB		0
#define XAIEGBL_NOC_INTCON2NDLEVSTA_STAA_WIDTH		16
#define XAIEGBL_NOC_INTCON2NDLEVSTA_STAA_MASK		0x0000FFFF
#define XAIEGBL_NOC_INTCON2NDLEVSTA_STAA_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_INTCON2NDLEVSTA(Status_A)		((Status_A&0x0000ffff))

#define XAIEGBL_NOC_INTCON2NDLEVINT		0x00015010
#define XAIEGBL_NOC_INTCON2NDLEVINTWID		32
#define XAIEGBL_NOC_INTCON2NDLEVINTMSK		0x00000003
#define XAIEGBL_NOC_INTCON2NDLEVINT_NOCINT_LSB		0
#define XAIEGBL_NOC_INTCON2NDLEVINT_NOCINT_WIDTH		2
#define XAIEGBL_NOC_INTCON2NDLEVINT_NOCINT_MASK		0x00000003
#define XAIEGBL_NOC_INTCON2NDLEVINT_NOCINT_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_INTCON2NDLEVINT(NoC_Interrupt)		((NoC_Interrupt&0x00000003))

#define XAIEGBL_NOC_DMABD0ADDLOW		0x0001D000
#define XAIEGBL_NOC_DMABD0ADDLOWWID		32
#define XAIEGBL_NOC_DMABD0ADDLOWMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD0ADDLOW_ADDLOW_LSB		0
#define XAIEGBL_NOC_DMABD0ADDLOW_ADDLOW_WIDTH		32
#define XAIEGBL_NOC_DMABD0ADDLOW_ADDLOW_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD0ADDLOW_ADDLOW_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD0ADDLOW(Addr_Low)		((Addr_Low&0xffffffff))

#define XAIEGBL_NOC_DMABD0BUFLEN		0x0001D004
#define XAIEGBL_NOC_DMABD0BUFLENWID		32
#define XAIEGBL_NOC_DMABD0BUFLENMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD0BUFLEN_BUFLEN_LSB		0
#define XAIEGBL_NOC_DMABD0BUFLEN_BUFLEN_WIDTH		32
#define XAIEGBL_NOC_DMABD0BUFLEN_BUFLEN_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD0BUFLEN_BUFLEN_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD0BUFLEN(Buffer_Length)		((Buffer_Length&0xffffffff))

#define XAIEGBL_NOC_DMABD0CTRL		0x0001D008
#define XAIEGBL_NOC_DMABD0CTRLWID		32
#define XAIEGBL_NOC_DMABD0CTRLMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD0CTRL_ADDHIG_LSB		16
#define XAIEGBL_NOC_DMABD0CTRL_ADDHIG_WIDTH		16
#define XAIEGBL_NOC_DMABD0CTRL_ADDHIG_MASK		0xFFFF0000
#define XAIEGBL_NOC_DMABD0CTRL_ADDHIG_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_USENEXBD_LSB		15
#define XAIEGBL_NOC_DMABD0CTRL_USENEXBD_WIDTH		1
#define XAIEGBL_NOC_DMABD0CTRL_USENEXBD_MASK		0x00008000
#define XAIEGBL_NOC_DMABD0CTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_NEXBD_LSB		11
#define XAIEGBL_NOC_DMABD0CTRL_NEXBD_WIDTH		4
#define XAIEGBL_NOC_DMABD0CTRL_NEXBD_MASK		0x00007800
#define XAIEGBL_NOC_DMABD0CTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_LOCKID_LSB		7
#define XAIEGBL_NOC_DMABD0CTRL_LOCKID_WIDTH		4
#define XAIEGBL_NOC_DMABD0CTRL_LOCKID_MASK		0x00000780
#define XAIEGBL_NOC_DMABD0CTRL_LOCKID_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_ENAREL_LSB		6
#define XAIEGBL_NOC_DMABD0CTRL_ENAREL_WIDTH		1
#define XAIEGBL_NOC_DMABD0CTRL_ENAREL_MASK		0x00000040
#define XAIEGBL_NOC_DMABD0CTRL_ENAREL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_RELVAL_LSB		5
#define XAIEGBL_NOC_DMABD0CTRL_RELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD0CTRL_RELVAL_MASK		0x00000020
#define XAIEGBL_NOC_DMABD0CTRL_RELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_USERELVAL_LSB		4
#define XAIEGBL_NOC_DMABD0CTRL_USERELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD0CTRL_USERELVAL_MASK		0x00000010
#define XAIEGBL_NOC_DMABD0CTRL_USERELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_ENAACQ_LSB		3
#define XAIEGBL_NOC_DMABD0CTRL_ENAACQ_WIDTH		1
#define XAIEGBL_NOC_DMABD0CTRL_ENAACQ_MASK		0x00000008
#define XAIEGBL_NOC_DMABD0CTRL_ENAACQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_ACQVAL_LSB		2
#define XAIEGBL_NOC_DMABD0CTRL_ACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD0CTRL_ACQVAL_MASK		0x00000004
#define XAIEGBL_NOC_DMABD0CTRL_ACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_USEACQVAL_LSB		1
#define XAIEGBL_NOC_DMABD0CTRL_USEACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD0CTRL_USEACQVAL_MASK		0x00000002
#define XAIEGBL_NOC_DMABD0CTRL_USEACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0CTRL_VALBD_LSB		0
#define XAIEGBL_NOC_DMABD0CTRL_VALBD_WIDTH		1
#define XAIEGBL_NOC_DMABD0CTRL_VALBD_MASK		0x00000001
#define XAIEGBL_NOC_DMABD0CTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD0CTRL(Addr_High,Use_Next_BD,Next_BD,Lock_ID,Enable_Release,Release_Value,Use_Release_Value,Enable_Acquire,Acquire_Value,Use_Acquire_Value,Valid_BD)		(((Addr_High&0x0000ffff)<<16)+((Use_Next_BD&0x00000001)<<15)+((Next_BD&0x0000000f)<<11)+((Lock_ID&0x0000000f)<<7)+((Enable_Release&0x00000001)<<6)+((Release_Value&0x00000001)<<5)+((Use_Release_Value&0x00000001)<<4)+((Enable_Acquire&0x00000001)<<3)+((Acquire_Value&0x00000001)<<2)+((Use_Acquire_Value&0x00000001)<<1)+(Valid_BD&0x00000001))

#define XAIEGBL_NOC_DMABD0AXICFG		0x0001D00C
#define XAIEGBL_NOC_DMABD0AXICFGWID		32
#define XAIEGBL_NOC_DMABD0AXICFGMSK		0xF00007FF
#define XAIEGBL_NOC_DMABD0AXICFG_SMI_LSB		28
#define XAIEGBL_NOC_DMABD0AXICFG_SMI_WIDTH		4
#define XAIEGBL_NOC_DMABD0AXICFG_SMI_MASK		0xF0000000
#define XAIEGBL_NOC_DMABD0AXICFG_SMI_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0AXICFG_BURLEN_LSB		9
#define XAIEGBL_NOC_DMABD0AXICFG_BURLEN_WIDTH		2
#define XAIEGBL_NOC_DMABD0AXICFG_BURLEN_MASK		0x00000600
#define XAIEGBL_NOC_DMABD0AXICFG_BURLEN_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0AXICFG_AXQ_LSB		5
#define XAIEGBL_NOC_DMABD0AXICFG_AXQ_WIDTH		4
#define XAIEGBL_NOC_DMABD0AXICFG_AXQ_MASK		0x000001E0
#define XAIEGBL_NOC_DMABD0AXICFG_AXQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0AXICFG_SECACC_LSB		4
#define XAIEGBL_NOC_DMABD0AXICFG_SECACC_WIDTH		1
#define XAIEGBL_NOC_DMABD0AXICFG_SECACC_MASK		0x00000010
#define XAIEGBL_NOC_DMABD0AXICFG_SECACC_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0AXICFG_AXC_LSB		0
#define XAIEGBL_NOC_DMABD0AXICFG_AXC_WIDTH		4
#define XAIEGBL_NOC_DMABD0AXICFG_AXC_MASK		0x0000000F
#define XAIEGBL_NOC_DMABD0AXICFG_AXC_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD0AXICFG(SMID,Burst_Length,AxQoS,Secure_Access,AxCache)		(((SMID&0x0000000f)<<28)+((Burst_Length&0x00000003)<<9)+((AxQoS&0x0000000f)<<5)+((Secure_Access&0x00000001)<<4)+(AxCache&0x0000000f))

#define XAIEGBL_NOC_DMABD0PKT		0x0001D010
#define XAIEGBL_NOC_DMABD0PKTWID		32
#define XAIEGBL_NOC_DMABD0PKTMSK		0x8000701F
#define XAIEGBL_NOC_DMABD0PKT_ENAPKT_LSB		31
#define XAIEGBL_NOC_DMABD0PKT_ENAPKT_WIDTH		1
#define XAIEGBL_NOC_DMABD0PKT_ENAPKT_MASK		0x80000000
#define XAIEGBL_NOC_DMABD0PKT_ENAPKT_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0PKT_PKTTYP_LSB		12
#define XAIEGBL_NOC_DMABD0PKT_PKTTYP_WIDTH		3
#define XAIEGBL_NOC_DMABD0PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_NOC_DMABD0PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD0PKT_ID_LSB		0
#define XAIEGBL_NOC_DMABD0PKT_ID_WIDTH		5
#define XAIEGBL_NOC_DMABD0PKT_ID_MASK		0x0000001F
#define XAIEGBL_NOC_DMABD0PKT_ID_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD0PKT(Enable_Packet,Packet_Type,ID)		(((Enable_Packet&0x00000001)<<31)+((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_NOC_DMABD1ADDLOW		0x0001D014
#define XAIEGBL_NOC_DMABD1ADDLOWWID		32
#define XAIEGBL_NOC_DMABD1ADDLOWMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD1ADDLOW_ADDLOW_LSB		0
#define XAIEGBL_NOC_DMABD1ADDLOW_ADDLOW_WIDTH		32
#define XAIEGBL_NOC_DMABD1ADDLOW_ADDLOW_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD1ADDLOW_ADDLOW_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD1ADDLOW(Addr_Low)		((Addr_Low&0xffffffff))

#define XAIEGBL_NOC_DMABD1BUFLEN		0x0001D018
#define XAIEGBL_NOC_DMABD1BUFLENWID		32
#define XAIEGBL_NOC_DMABD1BUFLENMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD1BUFLEN_BUFLEN_LSB		0
#define XAIEGBL_NOC_DMABD1BUFLEN_BUFLEN_WIDTH		32
#define XAIEGBL_NOC_DMABD1BUFLEN_BUFLEN_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD1BUFLEN_BUFLEN_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD1BUFLEN(Buffer_Length)		((Buffer_Length&0xffffffff))

#define XAIEGBL_NOC_DMABD1BUFCTRL		0x0001D01C
#define XAIEGBL_NOC_DMABD1BUFCTRLWID		32
#define XAIEGBL_NOC_DMABD1BUFCTRLMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD1BUFCTRL_ADDHIG_LSB		16
#define XAIEGBL_NOC_DMABD1BUFCTRL_ADDHIG_WIDTH		16
#define XAIEGBL_NOC_DMABD1BUFCTRL_ADDHIG_MASK		0xFFFF0000
#define XAIEGBL_NOC_DMABD1BUFCTRL_ADDHIG_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_USENEXBD_LSB		15
#define XAIEGBL_NOC_DMABD1BUFCTRL_USENEXBD_WIDTH		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_USENEXBD_MASK		0x00008000
#define XAIEGBL_NOC_DMABD1BUFCTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_NEXBD_LSB		11
#define XAIEGBL_NOC_DMABD1BUFCTRL_NEXBD_WIDTH		4
#define XAIEGBL_NOC_DMABD1BUFCTRL_NEXBD_MASK		0x00007800
#define XAIEGBL_NOC_DMABD1BUFCTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_LOCKID_LSB		7
#define XAIEGBL_NOC_DMABD1BUFCTRL_LOCKID_WIDTH		4
#define XAIEGBL_NOC_DMABD1BUFCTRL_LOCKID_MASK		0x00000780
#define XAIEGBL_NOC_DMABD1BUFCTRL_LOCKID_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_ENAREL_LSB		6
#define XAIEGBL_NOC_DMABD1BUFCTRL_ENAREL_WIDTH		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_ENAREL_MASK		0x00000040
#define XAIEGBL_NOC_DMABD1BUFCTRL_ENAREL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_RELVAL_LSB		5
#define XAIEGBL_NOC_DMABD1BUFCTRL_RELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_RELVAL_MASK		0x00000020
#define XAIEGBL_NOC_DMABD1BUFCTRL_RELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_USERELVAL_LSB		4
#define XAIEGBL_NOC_DMABD1BUFCTRL_USERELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_USERELVAL_MASK		0x00000010
#define XAIEGBL_NOC_DMABD1BUFCTRL_USERELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_ENAACQ_LSB		3
#define XAIEGBL_NOC_DMABD1BUFCTRL_ENAACQ_WIDTH		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_ENAACQ_MASK		0x00000008
#define XAIEGBL_NOC_DMABD1BUFCTRL_ENAACQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_ACQVAL_LSB		2
#define XAIEGBL_NOC_DMABD1BUFCTRL_ACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_ACQVAL_MASK		0x00000004
#define XAIEGBL_NOC_DMABD1BUFCTRL_ACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_USEACQVAL_LSB		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_USEACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_USEACQVAL_MASK		0x00000002
#define XAIEGBL_NOC_DMABD1BUFCTRL_USEACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1BUFCTRL_VALBD_LSB		0
#define XAIEGBL_NOC_DMABD1BUFCTRL_VALBD_WIDTH		1
#define XAIEGBL_NOC_DMABD1BUFCTRL_VALBD_MASK		0x00000001
#define XAIEGBL_NOC_DMABD1BUFCTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD1BUFCTRL(Addr_High,Use_Next_BD,Next_BD,Lock_ID,Enable_Release,Release_Value,Use_Release_Value,Enable_Acquire,Acquire_Value,Use_Acquire_Value,Valid_BD)		(((Addr_High&0x0000ffff)<<16)+((Use_Next_BD&0x00000001)<<15)+((Next_BD&0x0000000f)<<11)+((Lock_ID&0x0000000f)<<7)+((Enable_Release&0x00000001)<<6)+((Release_Value&0x00000001)<<5)+((Use_Release_Value&0x00000001)<<4)+((Enable_Acquire&0x00000001)<<3)+((Acquire_Value&0x00000001)<<2)+((Use_Acquire_Value&0x00000001)<<1)+(Valid_BD&0x00000001))

#define XAIEGBL_NOC_DMABD1AXICFG		0x0001D020
#define XAIEGBL_NOC_DMABD1AXICFGWID		32
#define XAIEGBL_NOC_DMABD1AXICFGMSK		0xF00007FF
#define XAIEGBL_NOC_DMABD1AXICFG_SMI_LSB		28
#define XAIEGBL_NOC_DMABD1AXICFG_SMI_WIDTH		4
#define XAIEGBL_NOC_DMABD1AXICFG_SMI_MASK		0xF0000000
#define XAIEGBL_NOC_DMABD1AXICFG_SMI_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1AXICFG_BURLEN_LSB		9
#define XAIEGBL_NOC_DMABD1AXICFG_BURLEN_WIDTH		2
#define XAIEGBL_NOC_DMABD1AXICFG_BURLEN_MASK		0x00000600
#define XAIEGBL_NOC_DMABD1AXICFG_BURLEN_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1AXICFG_AXQ_LSB		5
#define XAIEGBL_NOC_DMABD1AXICFG_AXQ_WIDTH		4
#define XAIEGBL_NOC_DMABD1AXICFG_AXQ_MASK		0x000001E0
#define XAIEGBL_NOC_DMABD1AXICFG_AXQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1AXICFG_SECACC_LSB		4
#define XAIEGBL_NOC_DMABD1AXICFG_SECACC_WIDTH		1
#define XAIEGBL_NOC_DMABD1AXICFG_SECACC_MASK		0x00000010
#define XAIEGBL_NOC_DMABD1AXICFG_SECACC_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1AXICFG_AXC_LSB		0
#define XAIEGBL_NOC_DMABD1AXICFG_AXC_WIDTH		4
#define XAIEGBL_NOC_DMABD1AXICFG_AXC_MASK		0x0000000F
#define XAIEGBL_NOC_DMABD1AXICFG_AXC_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD1AXICFG(SMID,Burst_Length,AxQoS,Secure_Access,AxCache)		(((SMID&0x0000000f)<<28)+((Burst_Length&0x00000003)<<9)+((AxQoS&0x0000000f)<<5)+((Secure_Access&0x00000001)<<4)+(AxCache&0x0000000f))

#define XAIEGBL_NOC_DMABD1PKT		0x0001D024
#define XAIEGBL_NOC_DMABD1PKTWID		32
#define XAIEGBL_NOC_DMABD1PKTMSK		0x8000701F
#define XAIEGBL_NOC_DMABD1PKT_ENAPKT_LSB		31
#define XAIEGBL_NOC_DMABD1PKT_ENAPKT_WIDTH		1
#define XAIEGBL_NOC_DMABD1PKT_ENAPKT_MASK		0x80000000
#define XAIEGBL_NOC_DMABD1PKT_ENAPKT_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1PKT_PKTTYP_LSB		12
#define XAIEGBL_NOC_DMABD1PKT_PKTTYP_WIDTH		3
#define XAIEGBL_NOC_DMABD1PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_NOC_DMABD1PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD1PKT_ID_LSB		0
#define XAIEGBL_NOC_DMABD1PKT_ID_WIDTH		5
#define XAIEGBL_NOC_DMABD1PKT_ID_MASK		0x0000001F
#define XAIEGBL_NOC_DMABD1PKT_ID_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD1PKT(Enable_Packet,Packet_Type,ID)		(((Enable_Packet&0x00000001)<<31)+((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_NOC_DMABD2ADDLOW		0x0001D028
#define XAIEGBL_NOC_DMABD2ADDLOWWID		32
#define XAIEGBL_NOC_DMABD2ADDLOWMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD2ADDLOW_ADDLOW_LSB		0
#define XAIEGBL_NOC_DMABD2ADDLOW_ADDLOW_WIDTH		32
#define XAIEGBL_NOC_DMABD2ADDLOW_ADDLOW_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD2ADDLOW_ADDLOW_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD2ADDLOW(Addr_Low)		((Addr_Low&0xffffffff))

#define XAIEGBL_NOC_DMABD2BUFLEN		0x0001D02C
#define XAIEGBL_NOC_DMABD2BUFLENWID		32
#define XAIEGBL_NOC_DMABD2BUFLENMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD2BUFLEN_BUFLEN_LSB		0
#define XAIEGBL_NOC_DMABD2BUFLEN_BUFLEN_WIDTH		32
#define XAIEGBL_NOC_DMABD2BUFLEN_BUFLEN_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD2BUFLEN_BUFLEN_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD2BUFLEN(Buffer_Length)		((Buffer_Length&0xffffffff))

#define XAIEGBL_NOC_DMABD2BUFCTRL		0x0001D030
#define XAIEGBL_NOC_DMABD2BUFCTRLWID		32
#define XAIEGBL_NOC_DMABD2BUFCTRLMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD2BUFCTRL_ADDHIG_LSB		16
#define XAIEGBL_NOC_DMABD2BUFCTRL_ADDHIG_WIDTH		16
#define XAIEGBL_NOC_DMABD2BUFCTRL_ADDHIG_MASK		0xFFFF0000
#define XAIEGBL_NOC_DMABD2BUFCTRL_ADDHIG_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_USENEXBD_LSB		15
#define XAIEGBL_NOC_DMABD2BUFCTRL_USENEXBD_WIDTH		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_USENEXBD_MASK		0x00008000
#define XAIEGBL_NOC_DMABD2BUFCTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_NEXBD_LSB		11
#define XAIEGBL_NOC_DMABD2BUFCTRL_NEXBD_WIDTH		4
#define XAIEGBL_NOC_DMABD2BUFCTRL_NEXBD_MASK		0x00007800
#define XAIEGBL_NOC_DMABD2BUFCTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_LOCKID_LSB		7
#define XAIEGBL_NOC_DMABD2BUFCTRL_LOCKID_WIDTH		4
#define XAIEGBL_NOC_DMABD2BUFCTRL_LOCKID_MASK		0x00000780
#define XAIEGBL_NOC_DMABD2BUFCTRL_LOCKID_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_ENAREL_LSB		6
#define XAIEGBL_NOC_DMABD2BUFCTRL_ENAREL_WIDTH		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_ENAREL_MASK		0x00000040
#define XAIEGBL_NOC_DMABD2BUFCTRL_ENAREL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_RELVAL_LSB		5
#define XAIEGBL_NOC_DMABD2BUFCTRL_RELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_RELVAL_MASK		0x00000020
#define XAIEGBL_NOC_DMABD2BUFCTRL_RELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_USERELVAL_LSB		4
#define XAIEGBL_NOC_DMABD2BUFCTRL_USERELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_USERELVAL_MASK		0x00000010
#define XAIEGBL_NOC_DMABD2BUFCTRL_USERELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_ENAACQ_LSB		3
#define XAIEGBL_NOC_DMABD2BUFCTRL_ENAACQ_WIDTH		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_ENAACQ_MASK		0x00000008
#define XAIEGBL_NOC_DMABD2BUFCTRL_ENAACQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_ACQVAL_LSB		2
#define XAIEGBL_NOC_DMABD2BUFCTRL_ACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_ACQVAL_MASK		0x00000004
#define XAIEGBL_NOC_DMABD2BUFCTRL_ACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_USEACQVAL_LSB		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_USEACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_USEACQVAL_MASK		0x00000002
#define XAIEGBL_NOC_DMABD2BUFCTRL_USEACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2BUFCTRL_VALBD_LSB		0
#define XAIEGBL_NOC_DMABD2BUFCTRL_VALBD_WIDTH		1
#define XAIEGBL_NOC_DMABD2BUFCTRL_VALBD_MASK		0x00000001
#define XAIEGBL_NOC_DMABD2BUFCTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD2BUFCTRL(Addr_High,Use_Next_BD,Next_BD,Lock_ID,Enable_Release,Release_Value,Use_Release_Value,Enable_Acquire,Acquire_Value,Use_Acquire_Value,Valid_BD)		(((Addr_High&0x0000ffff)<<16)+((Use_Next_BD&0x00000001)<<15)+((Next_BD&0x0000000f)<<11)+((Lock_ID&0x0000000f)<<7)+((Enable_Release&0x00000001)<<6)+((Release_Value&0x00000001)<<5)+((Use_Release_Value&0x00000001)<<4)+((Enable_Acquire&0x00000001)<<3)+((Acquire_Value&0x00000001)<<2)+((Use_Acquire_Value&0x00000001)<<1)+(Valid_BD&0x00000001))

#define XAIEGBL_NOC_DMABD2AXICFG		0x0001D034
#define XAIEGBL_NOC_DMABD2AXICFGWID		32
#define XAIEGBL_NOC_DMABD2AXICFGMSK		0xF00007FF
#define XAIEGBL_NOC_DMABD2AXICFG_SMI_LSB		28
#define XAIEGBL_NOC_DMABD2AXICFG_SMI_WIDTH		4
#define XAIEGBL_NOC_DMABD2AXICFG_SMI_MASK		0xF0000000
#define XAIEGBL_NOC_DMABD2AXICFG_SMI_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2AXICFG_BURLEN_LSB		9
#define XAIEGBL_NOC_DMABD2AXICFG_BURLEN_WIDTH		2
#define XAIEGBL_NOC_DMABD2AXICFG_BURLEN_MASK		0x00000600
#define XAIEGBL_NOC_DMABD2AXICFG_BURLEN_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2AXICFG_AXQ_LSB		5
#define XAIEGBL_NOC_DMABD2AXICFG_AXQ_WIDTH		4
#define XAIEGBL_NOC_DMABD2AXICFG_AXQ_MASK		0x000001E0
#define XAIEGBL_NOC_DMABD2AXICFG_AXQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2AXICFG_SECACC_LSB		4
#define XAIEGBL_NOC_DMABD2AXICFG_SECACC_WIDTH		1
#define XAIEGBL_NOC_DMABD2AXICFG_SECACC_MASK		0x00000010
#define XAIEGBL_NOC_DMABD2AXICFG_SECACC_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2AXICFG_AXC_LSB		0
#define XAIEGBL_NOC_DMABD2AXICFG_AXC_WIDTH		4
#define XAIEGBL_NOC_DMABD2AXICFG_AXC_MASK		0x0000000F
#define XAIEGBL_NOC_DMABD2AXICFG_AXC_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD2AXICFG(SMID,Burst_Length,AxQoS,Secure_Access,AxCache)		(((SMID&0x0000000f)<<28)+((Burst_Length&0x00000003)<<9)+((AxQoS&0x0000000f)<<5)+((Secure_Access&0x00000001)<<4)+(AxCache&0x0000000f))

#define XAIEGBL_NOC_DMABD2PKT		0x0001D038
#define XAIEGBL_NOC_DMABD2PKTWID		32
#define XAIEGBL_NOC_DMABD2PKTMSK		0x8000701F
#define XAIEGBL_NOC_DMABD2PKT_ENAPKT_LSB		31
#define XAIEGBL_NOC_DMABD2PKT_ENAPKT_WIDTH		1
#define XAIEGBL_NOC_DMABD2PKT_ENAPKT_MASK		0x80000000
#define XAIEGBL_NOC_DMABD2PKT_ENAPKT_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2PKT_PKTTYP_LSB		12
#define XAIEGBL_NOC_DMABD2PKT_PKTTYP_WIDTH		3
#define XAIEGBL_NOC_DMABD2PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_NOC_DMABD2PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD2PKT_ID_LSB		0
#define XAIEGBL_NOC_DMABD2PKT_ID_WIDTH		5
#define XAIEGBL_NOC_DMABD2PKT_ID_MASK		0x0000001F
#define XAIEGBL_NOC_DMABD2PKT_ID_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD2PKT(Enable_Packet,Packet_Type,ID)		(((Enable_Packet&0x00000001)<<31)+((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_NOC_DMABD3ADDLOW		0x0001D03C
#define XAIEGBL_NOC_DMABD3ADDLOWWID		32
#define XAIEGBL_NOC_DMABD3ADDLOWMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD3ADDLOW_ADDLOW_LSB		0
#define XAIEGBL_NOC_DMABD3ADDLOW_ADDLOW_WIDTH		32
#define XAIEGBL_NOC_DMABD3ADDLOW_ADDLOW_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD3ADDLOW_ADDLOW_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD3ADDLOW(Addr_Low)		((Addr_Low&0xffffffff))

#define XAIEGBL_NOC_DMABD3BUFLEN		0x0001D040
#define XAIEGBL_NOC_DMABD3BUFLENWID		32
#define XAIEGBL_NOC_DMABD3BUFLENMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD3BUFLEN_BUFLEN_LSB		0
#define XAIEGBL_NOC_DMABD3BUFLEN_BUFLEN_WIDTH		32
#define XAIEGBL_NOC_DMABD3BUFLEN_BUFLEN_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD3BUFLEN_BUFLEN_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD3BUFLEN(Buffer_Length)		((Buffer_Length&0xffffffff))

#define XAIEGBL_NOC_DMABD3BUFCTRL		0x0001D044
#define XAIEGBL_NOC_DMABD3BUFCTRLWID		32
#define XAIEGBL_NOC_DMABD3BUFCTRLMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD3BUFCTRL_ADDHIG_LSB		16
#define XAIEGBL_NOC_DMABD3BUFCTRL_ADDHIG_WIDTH		16
#define XAIEGBL_NOC_DMABD3BUFCTRL_ADDHIG_MASK		0xFFFF0000
#define XAIEGBL_NOC_DMABD3BUFCTRL_ADDHIG_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_USENEXBD_LSB		15
#define XAIEGBL_NOC_DMABD3BUFCTRL_USENEXBD_WIDTH		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_USENEXBD_MASK		0x00008000
#define XAIEGBL_NOC_DMABD3BUFCTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_NEXBD_LSB		11
#define XAIEGBL_NOC_DMABD3BUFCTRL_NEXBD_WIDTH		4
#define XAIEGBL_NOC_DMABD3BUFCTRL_NEXBD_MASK		0x00007800
#define XAIEGBL_NOC_DMABD3BUFCTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_LOCKID_LSB		7
#define XAIEGBL_NOC_DMABD3BUFCTRL_LOCKID_WIDTH		4
#define XAIEGBL_NOC_DMABD3BUFCTRL_LOCKID_MASK		0x00000780
#define XAIEGBL_NOC_DMABD3BUFCTRL_LOCKID_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_ENAREL_LSB		6
#define XAIEGBL_NOC_DMABD3BUFCTRL_ENAREL_WIDTH		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_ENAREL_MASK		0x00000040
#define XAIEGBL_NOC_DMABD3BUFCTRL_ENAREL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_RELVAL_LSB		5
#define XAIEGBL_NOC_DMABD3BUFCTRL_RELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_RELVAL_MASK		0x00000020
#define XAIEGBL_NOC_DMABD3BUFCTRL_RELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_USERELVAL_LSB		4
#define XAIEGBL_NOC_DMABD3BUFCTRL_USERELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_USERELVAL_MASK		0x00000010
#define XAIEGBL_NOC_DMABD3BUFCTRL_USERELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_ENAACQ_LSB		3
#define XAIEGBL_NOC_DMABD3BUFCTRL_ENAACQ_WIDTH		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_ENAACQ_MASK		0x00000008
#define XAIEGBL_NOC_DMABD3BUFCTRL_ENAACQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_ACQVAL_LSB		2
#define XAIEGBL_NOC_DMABD3BUFCTRL_ACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_ACQVAL_MASK		0x00000004
#define XAIEGBL_NOC_DMABD3BUFCTRL_ACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_USEACQVAL_LSB		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_USEACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_USEACQVAL_MASK		0x00000002
#define XAIEGBL_NOC_DMABD3BUFCTRL_USEACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3BUFCTRL_VALBD_LSB		0
#define XAIEGBL_NOC_DMABD3BUFCTRL_VALBD_WIDTH		1
#define XAIEGBL_NOC_DMABD3BUFCTRL_VALBD_MASK		0x00000001
#define XAIEGBL_NOC_DMABD3BUFCTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD3BUFCTRL(Addr_High,Use_Next_BD,Next_BD,Lock_ID,Enable_Release,Release_Value,Use_Release_Value,Enable_Acquire,Acquire_Value,Use_Acquire_Value,Valid_BD)		(((Addr_High&0x0000ffff)<<16)+((Use_Next_BD&0x00000001)<<15)+((Next_BD&0x0000000f)<<11)+((Lock_ID&0x0000000f)<<7)+((Enable_Release&0x00000001)<<6)+((Release_Value&0x00000001)<<5)+((Use_Release_Value&0x00000001)<<4)+((Enable_Acquire&0x00000001)<<3)+((Acquire_Value&0x00000001)<<2)+((Use_Acquire_Value&0x00000001)<<1)+(Valid_BD&0x00000001))

#define XAIEGBL_NOC_DMABD3AXICFG		0x0001D048
#define XAIEGBL_NOC_DMABD3AXICFGWID		32
#define XAIEGBL_NOC_DMABD3AXICFGMSK		0xF00007FF
#define XAIEGBL_NOC_DMABD3AXICFG_SMI_LSB		28
#define XAIEGBL_NOC_DMABD3AXICFG_SMI_WIDTH		4
#define XAIEGBL_NOC_DMABD3AXICFG_SMI_MASK		0xF0000000
#define XAIEGBL_NOC_DMABD3AXICFG_SMI_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3AXICFG_BURLEN_LSB		9
#define XAIEGBL_NOC_DMABD3AXICFG_BURLEN_WIDTH		2
#define XAIEGBL_NOC_DMABD3AXICFG_BURLEN_MASK		0x00000600
#define XAIEGBL_NOC_DMABD3AXICFG_BURLEN_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3AXICFG_AXQ_LSB		5
#define XAIEGBL_NOC_DMABD3AXICFG_AXQ_WIDTH		4
#define XAIEGBL_NOC_DMABD3AXICFG_AXQ_MASK		0x000001E0
#define XAIEGBL_NOC_DMABD3AXICFG_AXQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3AXICFG_SECACC_LSB		4
#define XAIEGBL_NOC_DMABD3AXICFG_SECACC_WIDTH		1
#define XAIEGBL_NOC_DMABD3AXICFG_SECACC_MASK		0x00000010
#define XAIEGBL_NOC_DMABD3AXICFG_SECACC_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3AXICFG_AXC_LSB		0
#define XAIEGBL_NOC_DMABD3AXICFG_AXC_WIDTH		4
#define XAIEGBL_NOC_DMABD3AXICFG_AXC_MASK		0x0000000F
#define XAIEGBL_NOC_DMABD3AXICFG_AXC_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD3AXICFG(SMID,Burst_Length,AxQoS,Secure_Access,AxCache)		(((SMID&0x0000000f)<<28)+((Burst_Length&0x00000003)<<9)+((AxQoS&0x0000000f)<<5)+((Secure_Access&0x00000001)<<4)+(AxCache&0x0000000f))

#define XAIEGBL_NOC_DMABD3PKT		0x0001D04C
#define XAIEGBL_NOC_DMABD3PKTWID		32
#define XAIEGBL_NOC_DMABD3PKTMSK		0x8000701F
#define XAIEGBL_NOC_DMABD3PKT_ENAPKT_LSB		31
#define XAIEGBL_NOC_DMABD3PKT_ENAPKT_WIDTH		1
#define XAIEGBL_NOC_DMABD3PKT_ENAPKT_MASK		0x80000000
#define XAIEGBL_NOC_DMABD3PKT_ENAPKT_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3PKT_PKTTYP_LSB		12
#define XAIEGBL_NOC_DMABD3PKT_PKTTYP_WIDTH		3
#define XAIEGBL_NOC_DMABD3PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_NOC_DMABD3PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD3PKT_ID_LSB		0
#define XAIEGBL_NOC_DMABD3PKT_ID_WIDTH		5
#define XAIEGBL_NOC_DMABD3PKT_ID_MASK		0x0000001F
#define XAIEGBL_NOC_DMABD3PKT_ID_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD3PKT(Enable_Packet,Packet_Type,ID)		(((Enable_Packet&0x00000001)<<31)+((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_NOC_DMABD4ADDLOW		0x0001D050
#define XAIEGBL_NOC_DMABD4ADDLOWWID		32
#define XAIEGBL_NOC_DMABD4ADDLOWMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD4ADDLOW_ADDLOW_LSB		0
#define XAIEGBL_NOC_DMABD4ADDLOW_ADDLOW_WIDTH		32
#define XAIEGBL_NOC_DMABD4ADDLOW_ADDLOW_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD4ADDLOW_ADDLOW_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD4ADDLOW(Addr_Low)		((Addr_Low&0xffffffff))

#define XAIEGBL_NOC_DMABD4BUFLEN		0x0001D054
#define XAIEGBL_NOC_DMABD4BUFLENWID		32
#define XAIEGBL_NOC_DMABD4BUFLENMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD4BUFLEN_BUFLEN_LSB		0
#define XAIEGBL_NOC_DMABD4BUFLEN_BUFLEN_WIDTH		32
#define XAIEGBL_NOC_DMABD4BUFLEN_BUFLEN_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD4BUFLEN_BUFLEN_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD4BUFLEN(Buffer_Length)		((Buffer_Length&0xffffffff))

#define XAIEGBL_NOC_DMABD4BUFCTRL		0x0001D058
#define XAIEGBL_NOC_DMABD4BUFCTRLWID		32
#define XAIEGBL_NOC_DMABD4BUFCTRLMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD4BUFCTRL_ADDHIG_LSB		16
#define XAIEGBL_NOC_DMABD4BUFCTRL_ADDHIG_WIDTH		16
#define XAIEGBL_NOC_DMABD4BUFCTRL_ADDHIG_MASK		0xFFFF0000
#define XAIEGBL_NOC_DMABD4BUFCTRL_ADDHIG_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_USENEXBD_LSB		15
#define XAIEGBL_NOC_DMABD4BUFCTRL_USENEXBD_WIDTH		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_USENEXBD_MASK		0x00008000
#define XAIEGBL_NOC_DMABD4BUFCTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_NEXBD_LSB		11
#define XAIEGBL_NOC_DMABD4BUFCTRL_NEXBD_WIDTH		4
#define XAIEGBL_NOC_DMABD4BUFCTRL_NEXBD_MASK		0x00007800
#define XAIEGBL_NOC_DMABD4BUFCTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_LOCKID_LSB		7
#define XAIEGBL_NOC_DMABD4BUFCTRL_LOCKID_WIDTH		4
#define XAIEGBL_NOC_DMABD4BUFCTRL_LOCKID_MASK		0x00000780
#define XAIEGBL_NOC_DMABD4BUFCTRL_LOCKID_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_ENAREL_LSB		6
#define XAIEGBL_NOC_DMABD4BUFCTRL_ENAREL_WIDTH		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_ENAREL_MASK		0x00000040
#define XAIEGBL_NOC_DMABD4BUFCTRL_ENAREL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_RELVAL_LSB		5
#define XAIEGBL_NOC_DMABD4BUFCTRL_RELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_RELVAL_MASK		0x00000020
#define XAIEGBL_NOC_DMABD4BUFCTRL_RELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_USERELVAL_LSB		4
#define XAIEGBL_NOC_DMABD4BUFCTRL_USERELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_USERELVAL_MASK		0x00000010
#define XAIEGBL_NOC_DMABD4BUFCTRL_USERELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_ENAACQ_LSB		3
#define XAIEGBL_NOC_DMABD4BUFCTRL_ENAACQ_WIDTH		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_ENAACQ_MASK		0x00000008
#define XAIEGBL_NOC_DMABD4BUFCTRL_ENAACQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_ACQVAL_LSB		2
#define XAIEGBL_NOC_DMABD4BUFCTRL_ACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_ACQVAL_MASK		0x00000004
#define XAIEGBL_NOC_DMABD4BUFCTRL_ACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_USEACQVAL_LSB		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_USEACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_USEACQVAL_MASK		0x00000002
#define XAIEGBL_NOC_DMABD4BUFCTRL_USEACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4BUFCTRL_VALBD_LSB		0
#define XAIEGBL_NOC_DMABD4BUFCTRL_VALBD_WIDTH		1
#define XAIEGBL_NOC_DMABD4BUFCTRL_VALBD_MASK		0x00000001
#define XAIEGBL_NOC_DMABD4BUFCTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD4BUFCTRL(Addr_High,Use_Next_BD,Next_BD,Lock_ID,Enable_Release,Release_Value,Use_Release_Value,Enable_Acquire,Acquire_Value,Use_Acquire_Value,Valid_BD)		(((Addr_High&0x0000ffff)<<16)+((Use_Next_BD&0x00000001)<<15)+((Next_BD&0x0000000f)<<11)+((Lock_ID&0x0000000f)<<7)+((Enable_Release&0x00000001)<<6)+((Release_Value&0x00000001)<<5)+((Use_Release_Value&0x00000001)<<4)+((Enable_Acquire&0x00000001)<<3)+((Acquire_Value&0x00000001)<<2)+((Use_Acquire_Value&0x00000001)<<1)+(Valid_BD&0x00000001))

#define XAIEGBL_NOC_DMABD4AXICFG		0x0001D05C
#define XAIEGBL_NOC_DMABD4AXICFGWID		32
#define XAIEGBL_NOC_DMABD4AXICFGMSK		0xF00007FF
#define XAIEGBL_NOC_DMABD4AXICFG_SMI_LSB		28
#define XAIEGBL_NOC_DMABD4AXICFG_SMI_WIDTH		4
#define XAIEGBL_NOC_DMABD4AXICFG_SMI_MASK		0xF0000000
#define XAIEGBL_NOC_DMABD4AXICFG_SMI_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4AXICFG_BURLEN_LSB		9
#define XAIEGBL_NOC_DMABD4AXICFG_BURLEN_WIDTH		2
#define XAIEGBL_NOC_DMABD4AXICFG_BURLEN_MASK		0x00000600
#define XAIEGBL_NOC_DMABD4AXICFG_BURLEN_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4AXICFG_AXQ_LSB		5
#define XAIEGBL_NOC_DMABD4AXICFG_AXQ_WIDTH		4
#define XAIEGBL_NOC_DMABD4AXICFG_AXQ_MASK		0x000001E0
#define XAIEGBL_NOC_DMABD4AXICFG_AXQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4AXICFG_SECACC_LSB		4
#define XAIEGBL_NOC_DMABD4AXICFG_SECACC_WIDTH		1
#define XAIEGBL_NOC_DMABD4AXICFG_SECACC_MASK		0x00000010
#define XAIEGBL_NOC_DMABD4AXICFG_SECACC_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4AXICFG_AXC_LSB		0
#define XAIEGBL_NOC_DMABD4AXICFG_AXC_WIDTH		4
#define XAIEGBL_NOC_DMABD4AXICFG_AXC_MASK		0x0000000F
#define XAIEGBL_NOC_DMABD4AXICFG_AXC_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD4AXICFG(SMID,Burst_Length,AxQoS,Secure_Access,AxCache)		(((SMID&0x0000000f)<<28)+((Burst_Length&0x00000003)<<9)+((AxQoS&0x0000000f)<<5)+((Secure_Access&0x00000001)<<4)+(AxCache&0x0000000f))

#define XAIEGBL_NOC_DMABD4PKT		0x0001D060
#define XAIEGBL_NOC_DMABD4PKTWID		32
#define XAIEGBL_NOC_DMABD4PKTMSK		0x8000701F
#define XAIEGBL_NOC_DMABD4PKT_ENAPKT_LSB		31
#define XAIEGBL_NOC_DMABD4PKT_ENAPKT_WIDTH		1
#define XAIEGBL_NOC_DMABD4PKT_ENAPKT_MASK		0x80000000
#define XAIEGBL_NOC_DMABD4PKT_ENAPKT_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4PKT_PKTTYP_LSB		12
#define XAIEGBL_NOC_DMABD4PKT_PKTTYP_WIDTH		3
#define XAIEGBL_NOC_DMABD4PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_NOC_DMABD4PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD4PKT_ID_LSB		0
#define XAIEGBL_NOC_DMABD4PKT_ID_WIDTH		5
#define XAIEGBL_NOC_DMABD4PKT_ID_MASK		0x0000001F
#define XAIEGBL_NOC_DMABD4PKT_ID_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD4PKT(Enable_Packet,Packet_Type,ID)		(((Enable_Packet&0x00000001)<<31)+((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_NOC_DMABD5ADDLOW		0x0001D064
#define XAIEGBL_NOC_DMABD5ADDLOWWID		32
#define XAIEGBL_NOC_DMABD5ADDLOWMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD5ADDLOW_ADDLOW_LSB		0
#define XAIEGBL_NOC_DMABD5ADDLOW_ADDLOW_WIDTH		32
#define XAIEGBL_NOC_DMABD5ADDLOW_ADDLOW_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD5ADDLOW_ADDLOW_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD5ADDLOW(Addr_Low)		((Addr_Low&0xffffffff))

#define XAIEGBL_NOC_DMABD5BUFLEN		0x0001D068
#define XAIEGBL_NOC_DMABD5BUFLENWID		32
#define XAIEGBL_NOC_DMABD5BUFLENMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD5BUFLEN_BUFLEN_LSB		0
#define XAIEGBL_NOC_DMABD5BUFLEN_BUFLEN_WIDTH		32
#define XAIEGBL_NOC_DMABD5BUFLEN_BUFLEN_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD5BUFLEN_BUFLEN_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD5BUFLEN(Buffer_Length)		((Buffer_Length&0xffffffff))

#define XAIEGBL_NOC_DMABD5BUFCTRL		0x0001D06C
#define XAIEGBL_NOC_DMABD5BUFCTRLWID		32
#define XAIEGBL_NOC_DMABD5BUFCTRLMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD5BUFCTRL_ADDHIG_LSB		16
#define XAIEGBL_NOC_DMABD5BUFCTRL_ADDHIG_WIDTH		16
#define XAIEGBL_NOC_DMABD5BUFCTRL_ADDHIG_MASK		0xFFFF0000
#define XAIEGBL_NOC_DMABD5BUFCTRL_ADDHIG_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_USENEXBD_LSB		15
#define XAIEGBL_NOC_DMABD5BUFCTRL_USENEXBD_WIDTH		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_USENEXBD_MASK		0x00008000
#define XAIEGBL_NOC_DMABD5BUFCTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_NEXBD_LSB		11
#define XAIEGBL_NOC_DMABD5BUFCTRL_NEXBD_WIDTH		4
#define XAIEGBL_NOC_DMABD5BUFCTRL_NEXBD_MASK		0x00007800
#define XAIEGBL_NOC_DMABD5BUFCTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_LOCKID_LSB		7
#define XAIEGBL_NOC_DMABD5BUFCTRL_LOCKID_WIDTH		4
#define XAIEGBL_NOC_DMABD5BUFCTRL_LOCKID_MASK		0x00000780
#define XAIEGBL_NOC_DMABD5BUFCTRL_LOCKID_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_ENAREL_LSB		6
#define XAIEGBL_NOC_DMABD5BUFCTRL_ENAREL_WIDTH		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_ENAREL_MASK		0x00000040
#define XAIEGBL_NOC_DMABD5BUFCTRL_ENAREL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_RELVAL_LSB		5
#define XAIEGBL_NOC_DMABD5BUFCTRL_RELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_RELVAL_MASK		0x00000020
#define XAIEGBL_NOC_DMABD5BUFCTRL_RELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_USERELVAL_LSB		4
#define XAIEGBL_NOC_DMABD5BUFCTRL_USERELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_USERELVAL_MASK		0x00000010
#define XAIEGBL_NOC_DMABD5BUFCTRL_USERELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_ENAACQ_LSB		3
#define XAIEGBL_NOC_DMABD5BUFCTRL_ENAACQ_WIDTH		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_ENAACQ_MASK		0x00000008
#define XAIEGBL_NOC_DMABD5BUFCTRL_ENAACQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_ACQVAL_LSB		2
#define XAIEGBL_NOC_DMABD5BUFCTRL_ACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_ACQVAL_MASK		0x00000004
#define XAIEGBL_NOC_DMABD5BUFCTRL_ACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_USEACQVAL_LSB		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_USEACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_USEACQVAL_MASK		0x00000002
#define XAIEGBL_NOC_DMABD5BUFCTRL_USEACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5BUFCTRL_VALBD_LSB		0
#define XAIEGBL_NOC_DMABD5BUFCTRL_VALBD_WIDTH		1
#define XAIEGBL_NOC_DMABD5BUFCTRL_VALBD_MASK		0x00000001
#define XAIEGBL_NOC_DMABD5BUFCTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD5BUFCTRL(Addr_High,Use_Next_BD,Next_BD,Lock_ID,Enable_Release,Release_Value,Use_Release_Value,Enable_Acquire,Acquire_Value,Use_Acquire_Value,Valid_BD)		(((Addr_High&0x0000ffff)<<16)+((Use_Next_BD&0x00000001)<<15)+((Next_BD&0x0000000f)<<11)+((Lock_ID&0x0000000f)<<7)+((Enable_Release&0x00000001)<<6)+((Release_Value&0x00000001)<<5)+((Use_Release_Value&0x00000001)<<4)+((Enable_Acquire&0x00000001)<<3)+((Acquire_Value&0x00000001)<<2)+((Use_Acquire_Value&0x00000001)<<1)+(Valid_BD&0x00000001))

#define XAIEGBL_NOC_DMABD5AXICFG		0x0001D070
#define XAIEGBL_NOC_DMABD5AXICFGWID		32
#define XAIEGBL_NOC_DMABD5AXICFGMSK		0xF00007FF
#define XAIEGBL_NOC_DMABD5AXICFG_SMI_LSB		28
#define XAIEGBL_NOC_DMABD5AXICFG_SMI_WIDTH		4
#define XAIEGBL_NOC_DMABD5AXICFG_SMI_MASK		0xF0000000
#define XAIEGBL_NOC_DMABD5AXICFG_SMI_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5AXICFG_BURLEN_LSB		9
#define XAIEGBL_NOC_DMABD5AXICFG_BURLEN_WIDTH		2
#define XAIEGBL_NOC_DMABD5AXICFG_BURLEN_MASK		0x00000600
#define XAIEGBL_NOC_DMABD5AXICFG_BURLEN_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5AXICFG_AXQ_LSB		5
#define XAIEGBL_NOC_DMABD5AXICFG_AXQ_WIDTH		4
#define XAIEGBL_NOC_DMABD5AXICFG_AXQ_MASK		0x000001E0
#define XAIEGBL_NOC_DMABD5AXICFG_AXQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5AXICFG_SECACC_LSB		4
#define XAIEGBL_NOC_DMABD5AXICFG_SECACC_WIDTH		1
#define XAIEGBL_NOC_DMABD5AXICFG_SECACC_MASK		0x00000010
#define XAIEGBL_NOC_DMABD5AXICFG_SECACC_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5AXICFG_AXC_LSB		0
#define XAIEGBL_NOC_DMABD5AXICFG_AXC_WIDTH		4
#define XAIEGBL_NOC_DMABD5AXICFG_AXC_MASK		0x0000000F
#define XAIEGBL_NOC_DMABD5AXICFG_AXC_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD5AXICFG(SMID,Burst_Length,AxQoS,Secure_Access,AxCache)		(((SMID&0x0000000f)<<28)+((Burst_Length&0x00000003)<<9)+((AxQoS&0x0000000f)<<5)+((Secure_Access&0x00000001)<<4)+(AxCache&0x0000000f))

#define XAIEGBL_NOC_DMABD5PKT		0x0001D074
#define XAIEGBL_NOC_DMABD5PKTWID		32
#define XAIEGBL_NOC_DMABD5PKTMSK		0x8000701F
#define XAIEGBL_NOC_DMABD5PKT_ENAPKT_LSB		31
#define XAIEGBL_NOC_DMABD5PKT_ENAPKT_WIDTH		1
#define XAIEGBL_NOC_DMABD5PKT_ENAPKT_MASK		0x80000000
#define XAIEGBL_NOC_DMABD5PKT_ENAPKT_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5PKT_PKTTYP_LSB		12
#define XAIEGBL_NOC_DMABD5PKT_PKTTYP_WIDTH		3
#define XAIEGBL_NOC_DMABD5PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_NOC_DMABD5PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD5PKT_ID_LSB		0
#define XAIEGBL_NOC_DMABD5PKT_ID_WIDTH		5
#define XAIEGBL_NOC_DMABD5PKT_ID_MASK		0x0000001F
#define XAIEGBL_NOC_DMABD5PKT_ID_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD5PKT(Enable_Packet,Packet_Type,ID)		(((Enable_Packet&0x00000001)<<31)+((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_NOC_DMABD6ADDLOW		0x0001D078
#define XAIEGBL_NOC_DMABD6ADDLOWWID		32
#define XAIEGBL_NOC_DMABD6ADDLOWMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD6ADDLOW_ADDLOW_LSB		0
#define XAIEGBL_NOC_DMABD6ADDLOW_ADDLOW_WIDTH		32
#define XAIEGBL_NOC_DMABD6ADDLOW_ADDLOW_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD6ADDLOW_ADDLOW_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD6ADDLOW(Addr_Low)		((Addr_Low&0xffffffff))

#define XAIEGBL_NOC_DMABD6BUFLEN		0x0001D07C
#define XAIEGBL_NOC_DMABD6BUFLENWID		32
#define XAIEGBL_NOC_DMABD6BUFLENMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD6BUFLEN_BUFLEN_LSB		0
#define XAIEGBL_NOC_DMABD6BUFLEN_BUFLEN_WIDTH		32
#define XAIEGBL_NOC_DMABD6BUFLEN_BUFLEN_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD6BUFLEN_BUFLEN_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD6BUFLEN(Buffer_Length)		((Buffer_Length&0xffffffff))

#define XAIEGBL_NOC_DMABD6BUFCTRL		0x0001D080
#define XAIEGBL_NOC_DMABD6BUFCTRLWID		32
#define XAIEGBL_NOC_DMABD6BUFCTRLMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD6BUFCTRL_ADDHIG_LSB		16
#define XAIEGBL_NOC_DMABD6BUFCTRL_ADDHIG_WIDTH		16
#define XAIEGBL_NOC_DMABD6BUFCTRL_ADDHIG_MASK		0xFFFF0000
#define XAIEGBL_NOC_DMABD6BUFCTRL_ADDHIG_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_USENEXBD_LSB		15
#define XAIEGBL_NOC_DMABD6BUFCTRL_USENEXBD_WIDTH		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_USENEXBD_MASK		0x00008000
#define XAIEGBL_NOC_DMABD6BUFCTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_NEXBD_LSB		11
#define XAIEGBL_NOC_DMABD6BUFCTRL_NEXBD_WIDTH		4
#define XAIEGBL_NOC_DMABD6BUFCTRL_NEXBD_MASK		0x00007800
#define XAIEGBL_NOC_DMABD6BUFCTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_LOCKID_LSB		7
#define XAIEGBL_NOC_DMABD6BUFCTRL_LOCKID_WIDTH		4
#define XAIEGBL_NOC_DMABD6BUFCTRL_LOCKID_MASK		0x00000780
#define XAIEGBL_NOC_DMABD6BUFCTRL_LOCKID_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_ENAREL_LSB		6
#define XAIEGBL_NOC_DMABD6BUFCTRL_ENAREL_WIDTH		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_ENAREL_MASK		0x00000040
#define XAIEGBL_NOC_DMABD6BUFCTRL_ENAREL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_RELVAL_LSB		5
#define XAIEGBL_NOC_DMABD6BUFCTRL_RELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_RELVAL_MASK		0x00000020
#define XAIEGBL_NOC_DMABD6BUFCTRL_RELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_USERELVAL_LSB		4
#define XAIEGBL_NOC_DMABD6BUFCTRL_USERELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_USERELVAL_MASK		0x00000010
#define XAIEGBL_NOC_DMABD6BUFCTRL_USERELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_ENAACQ_LSB		3
#define XAIEGBL_NOC_DMABD6BUFCTRL_ENAACQ_WIDTH		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_ENAACQ_MASK		0x00000008
#define XAIEGBL_NOC_DMABD6BUFCTRL_ENAACQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_ACQVAL_LSB		2
#define XAIEGBL_NOC_DMABD6BUFCTRL_ACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_ACQVAL_MASK		0x00000004
#define XAIEGBL_NOC_DMABD6BUFCTRL_ACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_USEACQVAL_LSB		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_USEACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_USEACQVAL_MASK		0x00000002
#define XAIEGBL_NOC_DMABD6BUFCTRL_USEACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6BUFCTRL_VALBD_LSB		0
#define XAIEGBL_NOC_DMABD6BUFCTRL_VALBD_WIDTH		1
#define XAIEGBL_NOC_DMABD6BUFCTRL_VALBD_MASK		0x00000001
#define XAIEGBL_NOC_DMABD6BUFCTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD6BUFCTRL(Addr_High,Use_Next_BD,Next_BD,Lock_ID,Enable_Release,Release_Value,Use_Release_Value,Enable_Acquire,Acquire_Value,Use_Acquire_Value,Valid_BD)		(((Addr_High&0x0000ffff)<<16)+((Use_Next_BD&0x00000001)<<15)+((Next_BD&0x0000000f)<<11)+((Lock_ID&0x0000000f)<<7)+((Enable_Release&0x00000001)<<6)+((Release_Value&0x00000001)<<5)+((Use_Release_Value&0x00000001)<<4)+((Enable_Acquire&0x00000001)<<3)+((Acquire_Value&0x00000001)<<2)+((Use_Acquire_Value&0x00000001)<<1)+(Valid_BD&0x00000001))

#define XAIEGBL_NOC_DMABD6AXICFG		0x0001D084
#define XAIEGBL_NOC_DMABD6AXICFGWID		32
#define XAIEGBL_NOC_DMABD6AXICFGMSK		0xF00007FF
#define XAIEGBL_NOC_DMABD6AXICFG_SMI_LSB		28
#define XAIEGBL_NOC_DMABD6AXICFG_SMI_WIDTH		4
#define XAIEGBL_NOC_DMABD6AXICFG_SMI_MASK		0xF0000000
#define XAIEGBL_NOC_DMABD6AXICFG_SMI_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6AXICFG_BURLEN_LSB		9
#define XAIEGBL_NOC_DMABD6AXICFG_BURLEN_WIDTH		2
#define XAIEGBL_NOC_DMABD6AXICFG_BURLEN_MASK		0x00000600
#define XAIEGBL_NOC_DMABD6AXICFG_BURLEN_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6AXICFG_AXQ_LSB		5
#define XAIEGBL_NOC_DMABD6AXICFG_AXQ_WIDTH		4
#define XAIEGBL_NOC_DMABD6AXICFG_AXQ_MASK		0x000001E0
#define XAIEGBL_NOC_DMABD6AXICFG_AXQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6AXICFG_SECACC_LSB		4
#define XAIEGBL_NOC_DMABD6AXICFG_SECACC_WIDTH		1
#define XAIEGBL_NOC_DMABD6AXICFG_SECACC_MASK		0x00000010
#define XAIEGBL_NOC_DMABD6AXICFG_SECACC_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6AXICFG_AXC_LSB		0
#define XAIEGBL_NOC_DMABD6AXICFG_AXC_WIDTH		4
#define XAIEGBL_NOC_DMABD6AXICFG_AXC_MASK		0x0000000F
#define XAIEGBL_NOC_DMABD6AXICFG_AXC_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD6AXICFG(SMID,Burst_Length,AxQoS,Secure_Access,AxCache)		(((SMID&0x0000000f)<<28)+((Burst_Length&0x00000003)<<9)+((AxQoS&0x0000000f)<<5)+((Secure_Access&0x00000001)<<4)+(AxCache&0x0000000f))

#define XAIEGBL_NOC_DMABD6PKT		0x0001D088
#define XAIEGBL_NOC_DMABD6PKTWID		32
#define XAIEGBL_NOC_DMABD6PKTMSK		0x8000701F
#define XAIEGBL_NOC_DMABD6PKT_ENAPKT_LSB		31
#define XAIEGBL_NOC_DMABD6PKT_ENAPKT_WIDTH		1
#define XAIEGBL_NOC_DMABD6PKT_ENAPKT_MASK		0x80000000
#define XAIEGBL_NOC_DMABD6PKT_ENAPKT_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6PKT_PKTTYP_LSB		12
#define XAIEGBL_NOC_DMABD6PKT_PKTTYP_WIDTH		3
#define XAIEGBL_NOC_DMABD6PKT_PKTTYP_MASK		0x00007000
#define XAIEGBL_NOC_DMABD6PKT_PKTTYP_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD6PKT_ID_LSB		0
#define XAIEGBL_NOC_DMABD6PKT_ID_WIDTH		5
#define XAIEGBL_NOC_DMABD6PKT_ID_MASK		0x0000001F
#define XAIEGBL_NOC_DMABD6PKT_ID_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD6PKT(Enable_Packet,Packet_Type,ID)		(((Enable_Packet&0x00000001)<<31)+((Packet_Type&0x00000007)<<12)+(ID&0x0000001f))

#define XAIEGBL_NOC_DMABD7ADDLOW		0x0001D08C
#define XAIEGBL_NOC_DMABD7ADDLOWWID		32
#define XAIEGBL_NOC_DMABD7ADDLOWMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD7ADDLOW_ADDLOW_LSB		0
#define XAIEGBL_NOC_DMABD7ADDLOW_ADDLOW_WIDTH		32
#define XAIEGBL_NOC_DMABD7ADDLOW_ADDLOW_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD7ADDLOW_ADDLOW_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD7ADDLOW(Addr_Low)		((Addr_Low&0xffffffff))

#define XAIEGBL_NOC_DMABD7BUFLEN		0x0001D090
#define XAIEGBL_NOC_DMABD7BUFLENWID		32
#define XAIEGBL_NOC_DMABD7BUFLENMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD7BUFLEN_BUFLEN_LSB		0
#define XAIEGBL_NOC_DMABD7BUFLEN_BUFLEN_WIDTH		32
#define XAIEGBL_NOC_DMABD7BUFLEN_BUFLEN_MASK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD7BUFLEN_BUFLEN_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD7BUFLEN(Buffer_Length)		((Buffer_Length&0xffffffff))

#define XAIEGBL_NOC_DMABD7BUFCTRL		0x0001D094
#define XAIEGBL_NOC_DMABD7BUFCTRLWID		32
#define XAIEGBL_NOC_DMABD7BUFCTRLMSK		0xFFFFFFFF
#define XAIEGBL_NOC_DMABD7BUFCTRL_ADDHIG_LSB		16
#define XAIEGBL_NOC_DMABD7BUFCTRL_ADDHIG_WIDTH		16
#define XAIEGBL_NOC_DMABD7BUFCTRL_ADDHIG_MASK		0xFFFF0000
#define XAIEGBL_NOC_DMABD7BUFCTRL_ADDHIG_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_USENEXBD_LSB		15
#define XAIEGBL_NOC_DMABD7BUFCTRL_USENEXBD_WIDTH		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_USENEXBD_MASK		0x00008000
#define XAIEGBL_NOC_DMABD7BUFCTRL_USENEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_NEXBD_LSB		11
#define XAIEGBL_NOC_DMABD7BUFCTRL_NEXBD_WIDTH		4
#define XAIEGBL_NOC_DMABD7BUFCTRL_NEXBD_MASK		0x00007800
#define XAIEGBL_NOC_DMABD7BUFCTRL_NEXBD_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_LOCKID_LSB		7
#define XAIEGBL_NOC_DMABD7BUFCTRL_LOCKID_WIDTH		4
#define XAIEGBL_NOC_DMABD7BUFCTRL_LOCKID_MASK		0x00000780
#define XAIEGBL_NOC_DMABD7BUFCTRL_LOCKID_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_ENAREL_LSB		6
#define XAIEGBL_NOC_DMABD7BUFCTRL_ENAREL_WIDTH		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_ENAREL_MASK		0x00000040
#define XAIEGBL_NOC_DMABD7BUFCTRL_ENAREL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_RELVAL_LSB		5
#define XAIEGBL_NOC_DMABD7BUFCTRL_RELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_RELVAL_MASK		0x00000020
#define XAIEGBL_NOC_DMABD7BUFCTRL_RELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_USERELVAL_LSB		4
#define XAIEGBL_NOC_DMABD7BUFCTRL_USERELVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_USERELVAL_MASK		0x00000010
#define XAIEGBL_NOC_DMABD7BUFCTRL_USERELVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_ENAACQ_LSB		3
#define XAIEGBL_NOC_DMABD7BUFCTRL_ENAACQ_WIDTH		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_ENAACQ_MASK		0x00000008
#define XAIEGBL_NOC_DMABD7BUFCTRL_ENAACQ_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_ACQVAL_LSB		2
#define XAIEGBL_NOC_DMABD7BUFCTRL_ACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_ACQVAL_MASK		0x00000004
#define XAIEGBL_NOC_DMABD7BUFCTRL_ACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_USEACQVAL_LSB		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_USEACQVAL_WIDTH		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_USEACQVAL_MASK		0x00000002
#define XAIEGBL_NOC_DMABD7BUFCTRL_USEACQVAL_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7BUFCTRL_VALBD_LSB		0
#define XAIEGBL_NOC_DMABD7BUFCTRL_VALBD_WIDTH		1
#define XAIEGBL_NOC_DMABD7BUFCTRL_VALBD_MASK		0x00000001
#define XAIEGBL_NOC_DMABD7BUFCTRL_VALBD_DEFVAL		0x0
#define XAIEGBL_NOC_VALUE_DMABD7BUFCTRL(Addr_High,Use_Next_BD,Next_BD,Lock_ID,Enable_Release,Release_Value,Use_Release_Value,Enable_Acquire,Acquire_Value,Use_Acquire_Value,Valid_BD)		(((Addr_High&0x0000ffff)<<16)+((Use_Next_BD&0x00000001)<<15)+((Next_BD&0x0000000f)<<11)+((Lock_ID&0x0000000f)<<7)+((Enable_Release&0x00000001)<<6)+((Release_Value&0x00000001)<<5)+((Use_Release_Value&0x00000001)<<4)+((Enable_Acquire&0x00000001)<<3)+((Acquire_Value&0x00000001)<<2)+((Use_Acquire_Value&0x00000001)<<1)+(Valid_BD&0x00000001))

#define XAIEGBL_NOC_DMABD7AXICFG		0x0001D098
#define XAIEGBL_NOC_DMABD7AXICFGWID		32
#define XAIEGBL_NOC_DMABD7AXICFGMSK		0xF00007FF
#define XAIEGBL_NOC_DMABD7AXICFG_SMI_LSB		28
#define XAIEGBL_NOC_DMABD7AXICFG_SMI_WIDTH		4
#define XAIEGBL_NOC_DMABD7AXICFG_SMI_MASK		0xF0000000
#define XAIEGBL_NOC_DMABD7AXICFG_SMI_DEFVAL		0x0
#define XAIEGBL_NOC_DMABD7AXICFG_BURLEN_LSB		9
#