% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_delim_chunked.R
\name{read_delim_chunked}
\alias{read_delim_chunked}
\alias{read_csv_chunked}
\alias{read_csv2_chunked}
\alias{read_tsv_chunked}
\title{Read a delimited file by chunks}
\usage{
read_delim_chunked(
  file,
  callback,
  delim = NULL,
  chunk_size = 10000,
  quote = "\\"",
  escape_backslash = FALSE,
  escape_double = TRUE,
  col_names = TRUE,
  col_types = NULL,
  locale = default_locale(),
  na = c("", "NA"),
  quoted_na = TRUE,
  comment = "",
  trim_ws = FALSE,
  skip = 0,
  guess_max = chunk_size,
  progress = show_progress(),
  show_col_types = should_show_types(),
  skip_empty_rows = TRUE
)

read_csv_chunked(
  file,
  callback,
  chunk_size = 10000,
  col_names = TRUE,
  col_types = NULL,
  locale = default_locale(),
  na = c("", "NA"),
  quoted_na = TRUE,
  quote = "\\"",
  comment = "",
  trim_ws = TRUE,
  skip = 0,
  guess_max = chunk_size,
  progress = show_progress(),
  show_col_types = should_show_types(),
  skip_empty_rows = TRUE
)

read_csv2_chunked(
  file,
  callback,
  chunk_size = 10000,
  col_names = TRUE,
  col_types = NULL,
  locale = default_locale(),
  na = c("", "NA"),
  quoted_na = TRUE,
  quote = "\\"",
  comment = "",
  trim_ws = TRUE,
  skip = 0,
  guess_max = chunk_size,
  progress = show_progress(),
  show_col_types = should_show_types(),
  skip_empty_rows = TRUE
)

read_tsv_chunked(
  file,
  callback,
  chunk_size = 10000,
  col_names = TRUE,
  col_types = NULL,
  locale = default_locale(),
  na = c("", "NA"),
  quoted_na = TRUE,
  quote = "\\"",
  comment = "",
  trim_ws = TRUE,
  skip = 0,
  guess_max = chunk_size,
  progress = show_progress(),
  show_col_types = should_show_types(),
  skip_empty_rows = TRUE
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote \code{.gz} files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, wrap the input with \code{I()}.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{callback}{A callback function to call on each chunk}

\item{delim}{Single character used to separate fields within a record.}

\item{chunk_size}{The number of rows to include in each chunk}

\item{quote}{Single character used to quote strings.}

\item{escape_backslash}{Does the file use backslashes to escape special
characters? This is more general than \code{escape_double} as backslashes
can be used to escape the delimiter character, the quote character, or
to add special characters like \verb{\\\\n}.}

\item{escape_double}{Does the file escape quotes by doubling them?
i.e. If this option is \code{TRUE}, the value \verb{""""} represents
a single quote, \verb{\\"}.}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
of column names.

If \code{TRUE}, the first row of the input will be used as the column
names, and will not be included in the data frame. If \code{FALSE}, column
names will be generated automatically: X1, X2, X3 etc.

If \code{col_names} is a character vector, the values will be used as the
names of the columns, and the first row of the input will be read into
the first row of the output data frame.

Missing (\code{NA}) column names will generate a warning, and be filled
in with dummy names \code{...1}, \code{...2} etc. Duplicate column names
will generate a warning and be made unique, see \code{name_repair} to control
how this is done.}

\item{col_types}{One of \code{NULL}, a \code{\link[=cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be inferred from \code{guess_max} rows of the
input, interspersed throughout the file. This is convenient (and fast),
but not robust. If the guessed types are wrong, you'll need to increase
\code{guess_max} or supply the correct types yourself.

Column specifications created by \code{\link[=list]{list()}} or \code{\link[=cols]{cols()}} must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[=cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
\itemize{
\item c = character
\item i = integer
\item n = number
\item d = double
\item l = logical
\item f = factor
\item D = date
\item T = date time
\item t = time
\item ? = guess
\item _ or - = skip
}

By default, reading a file without a column specification will print a
message showing what \code{readr} guessed they were. To remove this message,
set \code{show_col_types = FALSE} or set \code{options(readr.show_col_types = FALSE)}.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{quoted_na}{Should missing values inside quotes be treated as missing
values (the default) or strings.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data.}

\item{guess_max}{Maximum number of lines to use for guessing column types.
Will never use more than the number of lines read.
See \code{vignette("column-types", package = "readr")} for more details.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The automatic
progress bar can be disabled by setting option \code{readr.show_progress} to
\code{FALSE}.}

\item{show_col_types}{If \code{FALSE}, do not show the guessed column types. If
\code{TRUE} always show the column types, even if they are supplied. If \code{NULL}
(the default) only show the column types if they are not explicitly supplied
by the \code{col_types} argument.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}
}
\description{
Read a delimited file by chunks
}
\details{
The number of lines in \code{file} can exceed the maximum integer value in R (~2 billion).
}
\examples{
# Cars with 3 gears
f <- function(x, pos) subset(x, gear == 3)
read_csv_chunked(readr_example("mtcars.csv"), DataFrameCallback$new(f), chunk_size = 5)
}
\seealso{
Other chunked: 
\code{\link{callback}},
\code{\link{read_lines_chunked}()}
}
\concept{chunked}
\keyword{internal}
