% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{format_delim}
\alias{format_delim}
\alias{format_csv}
\alias{format_csv2}
\alias{format_tsv}
\title{Convert a data frame to a delimited string}
\usage{
format_delim(
  x,
  delim,
  na = "NA",
  append = FALSE,
  col_names = !append,
  quote = c("needed", "all", "none"),
  escape = c("double", "backslash", "none"),
  eol = "\\n"
)

format_csv(
  x,
  na = "NA",
  append = FALSE,
  col_names = !append,
  quote = c("needed", "all", "none"),
  escape = c("double", "backslash", "none"),
  eol = "\\n"
)

format_csv2(
  x,
  na = "NA",
  append = FALSE,
  col_names = !append,
  quote = c("needed", "all", "none"),
  escape = c("double", "backslash", "none"),
  eol = "\\n"
)

format_tsv(
  x,
  na = "NA",
  append = FALSE,
  col_names = !append,
  quote = c("needed", "all", "none"),
  escape = c("double", "backslash", "none"),
  eol = "\\n"
)
}
\arguments{
\item{x}{A data frame.}

\item{delim}{Delimiter used to separate values. Defaults to \code{" "} for \code{write_delim()}, \code{","} for \code{write_excel_csv()} and
\code{";"} for \code{write_excel_csv2()}. Must be a single character.}

\item{na}{String used for missing values. Defaults to NA. Missing values
will never be quoted; strings with the same value as \code{na} will
always be quoted.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if the file does not exist a new
file is created.}

\item{col_names}{If \code{FALSE}, column names will not be included at the top of the file. If \code{TRUE},
column names will be included. If not specified, \code{col_names} will take the opposite value given to \code{append}.}

\item{quote}{How to handle fields which contain characters that need to be
quoted.
\itemize{
\item \code{needed} - Values are only quoted if needed: if they contain a delimiter,
quote, or newline.
\item \code{all} - Quote all fields.
\item \code{none} - Never quote fields.
}}

\item{escape}{The type of escape to use when quotes are in the data.
\itemize{
\item \code{double} - quotes are escaped by doubling them.
\item \code{backslash} - quotes are escaped by a preceding backslash.
\item \code{none} - quotes are not escaped.
}}

\item{eol}{The end of line character to use. Most commonly either \code{"\\n"} for
Unix style newlines, or \code{"\\r\\n"} for Windows style newlines.}
}
\value{
A string.
}
\description{
These functions are equivalent to \code{\link[=write_csv]{write_csv()}} etc., but instead
of writing to disk, they return a string.
}
\section{Output}{

Factors are coerced to character. Doubles are formatted to a decimal string
using the grisu3 algorithm. \code{POSIXct} values are formatted as ISO8601 with a
UTC timezone \emph{Note: \code{POSIXct} objects in local or non-UTC timezones will be
converted to UTC time before writing.}

All columns are encoded as UTF-8. \code{write_excel_csv()} and \code{write_excel_csv2()} also include a
\href{https://en.wikipedia.org/wiki/Byte_order_mark}{UTF-8 Byte order mark}
which indicates to Excel the csv is UTF-8 encoded.

\code{write_excel_csv2()} and \code{write_csv2} were created to allow users with
different locale settings to save .csv files using their default settings
(e.g. \verb{;} as the column separator and \verb{,} as the decimal separator).
This is common in some European countries.

Values are only quoted if they contain a comma, quote or newline.

The \verb{write_*()} functions will automatically compress outputs if an appropriate extension is given.
Three extensions are currently supported: \code{.gz} for gzip compression, \code{.bz2} for bzip2 compression and
\code{.xz} for lzma compression.  See the examples for more information.
}

\examples{
# format_()* functions are useful for testing and reprexes
cat(format_csv(mtcars))
cat(format_tsv(mtcars))
cat(format_delim(mtcars, ";"))

# Specifying missing values
df <- data.frame(x = c(1, NA, 3))
format_csv(df, na = "missing")

# Quotes are automatically added as needed
df <- data.frame(x = c("a ", '"', ",", "\n"))
cat(format_csv(df))
}
\references{
Florian Loitsch, Printing Floating-Point Numbers Quickly and
Accurately with Integers, PLDI '10,
\url{http://www.cs.tufts.edu/~nr/cs257/archive/florian-loitsch/printf.pdf}
}
