% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-point.R
\name{seq.clock_time_point}
\alias{seq.clock_time_point}
\title{Sequences: time points}
\usage{
\method{seq}{clock_time_point}(from, to = NULL, by = NULL, length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from}{\verb{[clock_sys_time(1) / clock_naive_time(1)]}

A time point to start the sequence from.

\code{from} is always included in the result.}

\item{to}{\verb{[clock_sys_time(1) / clock_naive_time(1) / NULL]}

A time point to stop the sequence at.

\code{to} is cast to the type of \code{from}.

\code{to} is only included in the result if the resulting sequence divides
the distance between \code{from} and \code{to} exactly.}

\item{by}{\verb{[integer(1) / clock_duration(1) / NULL]}

The unit to increment the sequence by.

If \code{by} is an integer, it is transformed into a duration with the
precision of \code{from}.

If \code{by} is a duration, it is cast to the type of \code{from}.}

\item{length.out}{\verb{[positive integer(1) / NULL]}

The length of the resulting sequence.

If specified, \code{along.with} must be \code{NULL}.}

\item{along.with}{\verb{[vector / NULL]}

A vector who's length determines the length of the resulting sequence.

Equivalent to \code{length.out = vec_size(along.with)}.

If specified, \code{length.out} must be \code{NULL}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A sequence with the type of \code{from}.
}
\description{
This is a time point method for the \code{\link[=seq]{seq()}} generic. It works for sys-time
and naive-time vectors.

Sequences can be generated for all valid time point precisions (daily through
nanosecond).

When calling \code{seq()}, exactly two of the following must be specified:
\itemize{
\item \code{to}
\item \code{by}
\item Either \code{length.out} or \code{along.with}
}
}
\examples{
# Daily sequence
seq(
  as_naive_time(year_month_day(2019, 1, 1)),
  as_naive_time(year_month_day(2019, 2, 4)),
  by = 5
)

# Minutely sequence using minute precision naive-time
x <- as_naive_time(year_month_day(2019, 1, 2, 3, 3))
x

seq(x, by = 4, length.out = 10)

# You can use larger step sizes by using a duration-based `by`
seq(x, by = duration_days(1), length.out = 5)

# Nanosecond sequence
from <- as_naive_time(year_month_day(2019, 1, 1))
from <- time_point_cast(from, "nanosecond")
to <- from + 100
seq(from, to, by = 10)
}
