local binary_name = "eslint_d"
return {
  cmd = function()
    local local_binary = vim.fn.fnamemodify('./node_modules/.bin/' .. binary_name, ':p')
    return vim.loop.fs_stat(local_binary) and local_binary or binary_name
  end,
  args = {
    '--format',
    'json',
    '--stdin',
    '--stdin-filename',
    function() return vim.api.nvim_buf_get_name(0) end,
  },
  stdin = true,
  stream = 'stdout',
  ignore_exitcode = true,
  parser = function(output, bufnr)
    if string.find(output, "Error: Could not find config file") then
      return {}
    end
    local result = require("lint.linters.eslint").parser(output, bufnr)
    for _, d in ipairs(result) do
      d.source = binary_name
    end
    return result
  end
}
