function getRandomWithinPercent(value, percent)
{
  // Calculate the % range
  const range = value * percent;

  // Calculate min and max bounds
  const min = value - range;
  const max = value + range;

  // Generate random number within the range
  return Math.random() * (max - min) + min;
}


var seq_ed_wnd = progWnd.openSequence("/home/rusconi/devel/massxpert3/development/data/polSeqs/chicken-telokin.mxp");

polymer = seq_ed_wnd.getPolymer();
polymer.setLeftEndModifByName("Acetylation");

let phosphoserine_index = 12;
polymer.modifyMonomer(phosphoserine_index, "Phosphorylation", /*override*/ false);

calc_options = polymer.getCalcOptions();
ionizer = polymer.getIonizer();

seq_ed_wnd.setTraceColor("red");

mass_peak_shaper_dlg = seq_ed_wnd.configureMassPeakShaper();
mpscw = mass_peak_shaper_dlg.getConfigWidget();

let Mr = 17336;
let z_dict = {
  7: 0.125e6,
  8: 0.25e6,
  9: 0.375e6,
  10: 0.5e6,
  11: 0.675e6,
  12: 0.876e6,
  13: 0.9e6,
  14: 1e6,
  15: 1e6,
  16: 0.875e6,
  17: 0.75e6,
  18: 0.5e6,
  19: 0.375e6,
  20: 0.25e6,
  21: 0.125e6
};
// let z_dict = { 1: 1e7 }

let random_intensity = 0

let nterm_indices_list = [1, 2, 7];
// let nterm_indices_list = [0]

aborted = false;

for (const nterm_index of nterm_indices_list)
{
  // let removed_glu_start = 0
  // let removed_glu_stop = 1
  let removed_glu_start = 1;
  let removed_glu_stop = 7;

  for (let removed_glu = removed_glu_start; removed_glu < removed_glu_stop; removed_glu++)
  {

    let start_index = nterm_index;
    let end_index = polymer.size - 1 - removed_glu;

    range_as_string = `[${start_index}-${end_index}]`;

    seq_ed_wnd.setIndexRanges(range_as_string, libXpertMassCore.Enums.LocationType.INDEX);

    let mz = 1;

    for (let z in z_dict)
    {
      if(checkAbort())
      {
        aborted = true;
        break;
      }

      intensity = z_dict[z];

      if (z == 0)
      {
        mz = Mr;
      }
      else
      {
        mz = Mr / z;
      }

      ionizer.level = z;
      polymer.setIonizer(ionizer);

      mass_peak_shaper_dlg.setParameters(mz, 150, libXpertMassCore.Enums.MassPeakShapeType.GAUSSIAN, 40000, 0, 6);
      mpscw.checkParameters();

      // Now perform two calculations: without or with the polymer acetylation
      calc_options.setPolymerEntities(libXpertMassCore.Enums.ChemicalEntity.NONE);
      seq_ed_wnd.setCalcOptions(calc_options)
      random_intensity = getRandomWithinPercent(intensity, 0.10);
      seq_ed_wnd.setNormalizationIntensity(random_intensity);
      seq_ed_wnd.synthesizeMassSpectra();

      // Now perform the calculation with the Phosphorylation.
      calc_options.setMonomerEntities(libXpertMassCore.Enums.ChemicalEntity.MODIF);
      seq_ed_wnd.setCalcOptions(calc_options);
      random_intensity = getRandomWithinPercent(intensity, 0.10);
      seq_ed_wnd.setNormalizationIntensity(random_intensity);
      seq_ed_wnd.synthesizeMassSpectra();

      calc_options.setPolymerEntities(libXpertMassCore.Enums.ChemicalEntity.LEFT_END_MODIF | libXpertMassCore.Enums.ChemicalEntity.FORCE_LEFT_END_MODIF);
      seq_ed_wnd.setCalcOptions(calc_options);
      random_intensity = getRandomWithinPercent(intensity, 0.10);
      seq_ed_wnd.setNormalizationIntensity(random_intensity);
      seq_ed_wnd.synthesizeMassSpectra();

      // Now perform the calculation without the Phosphorylation.
      calc_options.setMonomerEntities(libXpertMassCore.Enums.ChemicalEntity.NONE);
      seq_ed_wnd.setCalcOptions(calc_options);
      random_intensity = getRandomWithinPercent(intensity, 0.10);
      seq_ed_wnd.setNormalizationIntensity(random_intensity);
      seq_ed_wnd.synthesizeMassSpectra();
    }

    if (aborted)
      break;
  }

  if (aborted)
    break;
}
