#pragma once
/*
 *  $Id: module-utils.h 28779 2025-11-04 17:00:29Z yeti-dn $
 *  Copyright (C) 2007-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_MODULE_UTILS_H__
#define __GWYAPP_MODULE_UTILS_H__

#include <stdio.h>
#include <gtk/gtk.h>
#include <libgwyddion/surface.h>
#include <libgwyddion/lawn.h>
#include <libgwyui/gwydataview.h>
#include <libgwyui/gwygraphmodel.h>
#include <libgwyui/inventory-store.h>
#include <libgwyapp/file.h>
#include <libgwyapp/data-chooser.h>
#include <libgwyapp/data-browser.h>
#include <libgwyapp/param-table.h>

G_BEGIN_DECLS

typedef enum {
    GWY_PREVIEW_SURFACE_DENSITY = 1 << 0,
    GWY_PREVIEW_SURFACE_FILL    = 1 << 1,
} GwyPreviewSurfaceFlags;

typedef gchar* (*GwySaveAuxiliaryCreate)(gpointer user_data,
                                         gssize *data_len);
typedef void (*GwySaveAuxiliaryDestroy)(gchar *data,
                                        gpointer user_data);

gboolean   gwy_save_auxiliary_data         (const gchar *title,
                                            GtkWindow *parent,
                                            const gchar *data,
                                            gssize data_len,
                                            gboolean binary);
gboolean   gwy_save_auxiliary_with_callback(const gchar *title,
                                            GtkWindow *parent,
                                            GwySaveAuxiliaryCreate create,
                                            GwySaveAuxiliaryDestroy destroy,
                                            gboolean binary,
                                            gpointer user_data);
gboolean   gwy_module_data_load            (const gchar *modname,
                                            const gchar *filename,
                                            gchar **contents,
                                            gsize *length,
                                            GError **error);
gboolean   gwy_module_data_save            (const gchar *modname,
                                            const gchar *filename,
                                            gchar *contents,
                                            gssize length,
                                            GError **error);
FILE*      gwy_module_data_fopen           (const gchar *modname,
                                            const gchar *filename,
                                            const gchar *mode,
                                            GError **error);
void       gwy_set_data_preview_size       (GwyDataView *data_view,
                                            gint max_size);
gboolean   gwy_require_image_same_units    (GwyField *field,
                                            GwyFile *data,
                                            gint id,
                                            const gchar *name);
gboolean   gwy_require_square_image        (GwyField *field,
                                            GwyFile *data,
                                            gint id,
                                            const gchar *name);
GtkWidget* gwy_create_preview              (GwyField *field,
                                            GwyField *mask,
                                            gint size);
void       gwy_setup_data_view             (GwyDataView *dataview,
                                            GwyFile *data,
                                            GwyDataKind data_kind,
                                            gint id,
                                            GwyFileItemFlags items);

GtkWidget*    gwy_create_dialog_preview_hbox            (GtkDialog *dialog,
                                                         GwyDataView *dataview,
                                                         gboolean pack_end);
GwySelection* gwy_create_preview_vector_layer           (GwyDataView *dataview,
                                                         GType type,
                                                         gint max_objects,
                                                         gboolean editable);
void          gwy_param_active_page_link_to_notebook    (GwyParams *params,
                                                         gint id,
                                                         GtkNotebook *notebook);
GtkWidget*    gwy_create_expander_with_param            (const gchar *label,
                                                         GwyParams *params,
                                                         gint id);
void          gwy_create_graph_xrange_with_params       (GwyParamTable *partable,
                                                         gint id_from,
                                                         gint id_to,
                                                         GwyGraph *graph,
                                                         GwyGraphModel *gmodel);
GtkTreeModel* gwy_create_inventory_model_without_default(GwyInventoryStore *store);
void          gwy_select_in_filtered_inventory_treeeview(GtkTreeView *treeview,
                                                         const gchar *name);
gint          gwy_app_add_graph_or_curves               (GwyGraphModel *gmodel,
                                                         GwyFile *data,
                                                         const GwyAppDataId *target_graph,
                                                         gint colorstep);
/* XXX: This seems to be a generally useful function, not really just for modules. Move it elsewhere and
 * stop including module-utils. */
void       gwy_preview_surface_to_field    (GwySurface *surface,
                                            GwyField *dfield,
                                            gint max_xres,
                                            gint max_yres,
                                            GwyPreviewSurfaceFlags flags);
GtkWidget* gwy_app_wait_preview_field      (GwyField *dfield,
                                            GwyFile *data,
                                            gint id);
void       gwy_set_gradient_for_residuals  (GwyGradient *gradient,
                                            gdouble fullmin,
                                            gdouble fullmax,
                                            gdouble *dispmin,
                                            gdouble *dispmax);
gint       gwy_run_subdialog               (GtkDialog *dialog);
gboolean   gwy_app_data_id_verify_channel  (GwyAppDataId *id);
gboolean   gwy_app_data_id_verify_graph    (GwyAppDataId *id);
gboolean   gwy_app_data_id_verify_volume   (GwyAppDataId *id);
gboolean   gwy_app_data_id_verify_xyz      (GwyAppDataId *id);
gboolean   gwy_app_data_id_verify_curve_map(GwyAppDataId *id);
gboolean   gwy_app_data_id_verify_spectra  (GwyAppDataId *id);

G_END_DECLS

#endif

/* vim: set cin et columns=120 tw=118 ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
