#!/bin/bash
# Script to generate a debian/changelog ready submodule manifest

TARGET_TAG=$1

if [ -z "$TARGET_TAG" ]; then
    echo "Usage: $0 <git-tag>"
    exit 1
fi

if ! git rev-parse "$TARGET_TAG" >/dev/null 2>&1; then
    echo "Error: Tag '$TARGET_TAG' not found."
    exit 1
fi

# Print the header for the specific version
# We strip the 'v' from the tag for the version number to match Debian style
VERSION_NUMBER=${TARGET_TAG#v}
echo "  * New upstream version $VERSION_NUMBER."

# Scan submodules
find . -mindepth 2 -maxdepth 2 -name "go.mod" | sort | while read -r modfile; do
    dir=$(dirname "$modfile")
    mod_name=${dir#./}

    # Get the submodule version
    version_tag=$(git describe --tags --match="${mod_name}/v*" --abbrev=0 "$TARGET_TAG" 2>/dev/null)

    if [ -n "$version_tag" ]; then
        clean_version=${version_tag#${mod_name}/}
        # Debian changelog style: 4 spaces indentation, hyphen bullet
        echo "    - $mod_name: $clean_version"
    fi
done
