"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyBaseTable = rectifyBaseTable;
const Ot = require("@ot-builder/ot");
const interface_1 = require("../../interface");
const shared_1 = require("../../shared");
function processGlyphRefAndCoord(rg, rc, lc) {
    const at = rc.coord(lc.at);
    if (!lc.pointAttachment) {
        return { ...lc, at };
    }
    const g1 = rg.glyphRef(lc.pointAttachment.glyph);
    if (!g1) {
        return { ...lc, at, pointAttachment: null };
    }
    else {
        return {
            ...lc,
            at,
            pointAttachment: { ...lc.pointAttachment, glyph: g1 }
        };
    }
}
function processPointAttach(rec, lc, horizontal) {
    if (!lc.pointAttachment)
        return lc;
    const desired = shared_1.RectifyImpl.getGlyphPoints(lc.pointAttachment.glyph)[lc.pointAttachment.pointIndex];
    if (!desired)
        return { ...lc, pointAttachment: null };
    const accept = horizontal
        ? rec.acceptOffset(desired, { x: desired.x, y: lc.at })
        : rec.acceptOffset(desired, { x: lc.at, y: desired.y });
    if (horizontal ? accept.y : accept.x)
        return lc;
    switch (rec.manner) {
        case interface_1.PointAttachmentRectifyManner.TrustAttachment:
            if (horizontal)
                return { ...lc, at: desired.y };
            else
                return { ...lc, at: desired.x };
        case interface_1.PointAttachmentRectifyManner.TrustCoordinate:
            return { ...lc, pointAttachment: null };
    }
}
function rectifyBaseCoord(fn, lc) {
    return fn.baseCoord(lc);
}
function rectifyMinMaxValue(fn, lc) {
    return {
        minCoord: shared_1.RectifyImpl.maybeT(fn, lc.minCoord, rectifyBaseCoord),
        maxCoord: shared_1.RectifyImpl.maybeT(fn, lc.maxCoord, rectifyBaseCoord)
    };
}
function rectifyMinMaxTable(fn, mm) {
    return new Ot.Base.MinMaxTable(rectifyMinMaxValue(fn, mm.defaultMinMax), shared_1.RectifyImpl.mapSomeT(fn, mm.featMinMax, shared_1.RectifyImpl.Id, rectifyMinMaxValue));
}
function rectifyBaseValues(fn, bv) {
    return new Ot.Base.BaseValues(bv.defaultBaselineIndex, shared_1.RectifyImpl.mapSomeT(fn, bv.baseValues, shared_1.RectifyImpl.Id, rectifyBaseCoord));
}
function rectifyScript(fn, sc) {
    const s2 = new Ot.Base.Script();
    if (sc.baseValues)
        s2.baseValues = rectifyBaseValues(fn, sc.baseValues);
    if (sc.defaultMinMax)
        s2.defaultMinMax = rectifyMinMaxTable(fn, sc.defaultMinMax);
    if (sc.baseLangSysRecords) {
        s2.baseLangSysRecords = shared_1.RectifyImpl.mapSomeT(fn, sc.baseLangSysRecords, shared_1.RectifyImpl.Id, rectifyMinMaxTable);
    }
    return s2;
}
function rectifyAxisTable(fn, at) {
    const ret = new Ot.Base.AxisTable();
    ret.baselineTags = at.baselineTags;
    ret.scripts = shared_1.RectifyImpl.mapSomeT(fn, at.scripts, shared_1.RectifyImpl.Id, rectifyScript);
    return ret;
}
function rectifyBaseTable(recGlyphRef, recCoord, recPA, at) {
    const ret = new Ot.Base.Table();
    const fnH = {
        baseCoord: c => processPointAttach(recPA, processGlyphRefAndCoord(recGlyphRef, recCoord, c), true)
    };
    const fnV = {
        baseCoord: c => processPointAttach(recPA, processGlyphRefAndCoord(recGlyphRef, recCoord, c), false)
    };
    if (at.horizontal)
        ret.horizontal = rectifyAxisTable(fnH, at.horizontal);
    if (at.vertical)
        ret.vertical = rectifyAxisTable(fnV, at.vertical);
    return ret;
}
//# sourceMappingURL=index.js.map