// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `BidiClass`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html) for more information.
 */


export class BidiClass {
    #value = undefined;

    static #values = new Map([
        ["LeftToRight", 0],
        ["RightToLeft", 1],
        ["EuropeanNumber", 2],
        ["EuropeanSeparator", 3],
        ["EuropeanTerminator", 4],
        ["ArabicNumber", 5],
        ["CommonSeparator", 6],
        ["ParagraphSeparator", 7],
        ["SegmentSeparator", 8],
        ["WhiteSpace", 9],
        ["OtherNeutral", 10],
        ["LeftToRightEmbedding", 11],
        ["LeftToRightOverride", 12],
        ["ArabicLetter", 13],
        ["RightToLeftEmbedding", 14],
        ["RightToLeftOverride", 15],
        ["PopDirectionalFormat", 16],
        ["NonspacingMark", 17],
        ["BoundaryNeutral", 18],
        ["FirstStrongIsolate", 19],
        ["LeftToRightIsolate", 20],
        ["RightToLeftIsolate", 21],
        ["PopDirectionalIsolate", 22]
    ]);

    static getAllEntries() {
        return BidiClass.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return BidiClass.#objectValues[arguments[1]];
        }

        if (value instanceof BidiClass) {
            return value;
        }

        let intVal = BidiClass.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return BidiClass.#objectValues[intVal];
        }

        throw TypeError(value + " is not a BidiClass and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new BidiClass(value);
    }

    get value(){
        return [...BidiClass.#values.keys()][this.#value];
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = [
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 6),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 7),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 8),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 9),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 10),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 11),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 12),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 13),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 14),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 15),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 16),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 17),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 18),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 19),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 20),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 21),
        new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 22),
    ];

    static LeftToRight = BidiClass.#objectValues[0];
    static RightToLeft = BidiClass.#objectValues[1];
    static EuropeanNumber = BidiClass.#objectValues[2];
    static EuropeanSeparator = BidiClass.#objectValues[3];
    static EuropeanTerminator = BidiClass.#objectValues[4];
    static ArabicNumber = BidiClass.#objectValues[5];
    static CommonSeparator = BidiClass.#objectValues[6];
    static ParagraphSeparator = BidiClass.#objectValues[7];
    static SegmentSeparator = BidiClass.#objectValues[8];
    static WhiteSpace = BidiClass.#objectValues[9];
    static OtherNeutral = BidiClass.#objectValues[10];
    static LeftToRightEmbedding = BidiClass.#objectValues[11];
    static LeftToRightOverride = BidiClass.#objectValues[12];
    static ArabicLetter = BidiClass.#objectValues[13];
    static RightToLeftEmbedding = BidiClass.#objectValues[14];
    static RightToLeftOverride = BidiClass.#objectValues[15];
    static PopDirectionalFormat = BidiClass.#objectValues[16];
    static NonspacingMark = BidiClass.#objectValues[17];
    static BoundaryNeutral = BidiClass.#objectValues[18];
    static FirstStrongIsolate = BidiClass.#objectValues[19];
    static LeftToRightIsolate = BidiClass.#objectValues[20];
    static RightToLeftIsolate = BidiClass.#objectValues[21];
    static PopDirectionalIsolate = BidiClass.#objectValues[22];


    /**
     * See the [Rust documentation for `for_char`](https://docs.rs/icu/latest/icu/properties/props/trait.EnumeratedProperty.html#tymethod.for_char) for more information.
     */
    static forChar(ch) {

        const result = wasm.icu4x_BidiClass_for_char_mv1(ch);

        try {
            return new BidiClass(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Get the "long" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesLongBorrowed.html#method.get) for more information.
     */
    longName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_BidiClass_long_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Get the "short" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesShortBorrowed.html#method.get) for more information.
     */
    shortName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_BidiClass_short_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Convert to an integer value usable with ICU4C and CodePointMapData
     *
     * See the [Rust documentation for `to_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html#method.to_icu4c_value) for more information.
     */
    toIntegerValue() {

        const result = wasm.icu4x_BidiClass_to_integer_value_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Convert from an integer value from ICU4C or CodePointMapData
     *
     * See the [Rust documentation for `from_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html#method.from_icu4c_value) for more information.
     */
    static fromIntegerValue(other) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_BidiClass_from_integer_value_mv1(diplomatReceive.buffer, other);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new BidiClass(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}