// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;
using System.Numerics;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.X86;
using Xunit;

// Generated by Fuzzlyn v2.2 on 2024-08-01 14:59:51
// Run on X64 Linux
// Seed: 1794865989474012381-vectort,vector128,vector256,vector512,x86aes,x86avx,x86avx2,x86avx512bw,x86avx512bwvl,x86avx512cd,x86avx512cdvl,x86avx512dq,x86avx512dqvl,x86avx512f,x86avx512fvl,x86avx512fx64,x86avx512vbmi,x86avx512vbmivl,x86bmi1,x86bmi1x64,x86bmi2,x86bmi2x64,x86fma,x86lzcnt,x86lzcntx64,x86pclmulqdq,x86popcnt,x86popcntx64,x86sse,x86ssex64,x86sse2,x86sse2x64,x86sse3,x86sse41,x86sse41x64,x86sse42,x86sse42x64,x86ssse3,x86x86base
// Reduced from 75.3 KiB to 0.7 KiB in 00:01:00
// Debug: Outputs <4294967295, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216>
// Release: Outputs <1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216>

public class C0
{
    public float F1;
}

public class Runtime_105822
{
    public static Vector512<float> s_2;

    [Fact]
    public static void TestEntryPoint()
    {
        if (Avx512F.IsSupported)
        {
            var vr6 = new C0();
            var vr8 = vr6.F1;
            var vr9 = Vector512.CreateScalar(vr8);
            var vr10 = Vector512.CreateScalar(107.15434f);
            var vr11 = Avx512F.CompareNotEqual(vr9, vr10);
            var vr12 = Avx512F.BlendVariable(vr11, Avx512F.ReciprocalSqrt14(s_2), s_2);
            s_2 = Avx512F.GetMantissa(vr12, 0);
            Vector512<uint> expected = Vector512.Create(4294967295, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216, 1065353216);
            Assert.Equal(expected, s_2.AsUInt32());
        }
    }
}
