//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragesync

import "time"

// APIError - Error type
type APIError struct {
	// Error code of the given entry.
	Code *string

	// Error details of the given entry.
	Details *ErrorDetails

	// Inner error details of the given entry.
	Innererror *InnerErrorDetails

	// Error message of the given entry.
	Message *string

	// Target of the given error entry.
	Target *string
}

// BackupRequest - Backup request
type BackupRequest struct {
	// Azure File Share.
	AzureFileShare *string
}

// CheckNameAvailabilityParameters - Parameters for a check name availability request.
type CheckNameAvailabilityParameters struct {
	// REQUIRED; The name to check for availability
	Name *string

	// CONSTANT; The resource type. Must be set to Microsoft.StorageSync/storageSyncServices
	// Field has constant value "Microsoft.StorageSync/storageSyncServices", any specified value is ignored.
	Type *string
}

// CheckNameAvailabilityResult - The CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	// READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string

	// READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or invalid and cannot be used.
	NameAvailable *bool

	// READ-ONLY; Gets the reason that a Storage Sync Service name could not be used. The Reason element is only returned if NameAvailable
	// is false.
	Reason *NameAvailabilityReason
}

// CloudEndpoint - Cloud Endpoint object.
type CloudEndpoint struct {
	// Cloud Endpoint properties.
	Properties *CloudEndpointProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CloudEndpointArray - Array of CloudEndpoint
type CloudEndpointArray struct {
	// Collection of CloudEndpoint.
	Value []*CloudEndpoint
}

// CloudEndpointChangeEnumerationActivity - Cloud endpoint change enumeration activity object
type CloudEndpointChangeEnumerationActivity struct {
	// READ-ONLY; Progress percentage for processing deletes. This is done separately from the rest of the enumeration run
	DeletesProgressPercent *int32

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time

	// READ-ONLY; Estimate of time remaining for the enumeration run
	MinutesRemaining *int32

	// READ-ONLY; Change enumeration operation state
	OperationState *CloudEndpointChangeEnumerationActivityState

	// READ-ONLY; Count of directories processed
	ProcessedDirectoriesCount *int64

	// READ-ONLY; Count of files processed
	ProcessedFilesCount *int64

	// READ-ONLY; Progress percentage for change enumeration run, excluding processing of deletes
	ProgressPercent *int32

	// READ-ONLY; Timestamp when change enumeration started
	StartedTimestamp *time.Time

	// READ-ONLY; When non-zero, indicates an issue that is delaying change enumeration
	StatusCode *int32

	// READ-ONLY; Change enumeration total counts state
	TotalCountsState *CloudEndpointChangeEnumerationTotalCountsState

	// READ-ONLY; Total count of directories enumerated
	TotalDirectoriesCount *int64

	// READ-ONLY; Total count of files enumerated
	TotalFilesCount *int64

	// READ-ONLY; Total enumerated size in bytes
	TotalSizeBytes *int64
}

// CloudEndpointChangeEnumerationStatus - Cloud endpoint change enumeration status object
type CloudEndpointChangeEnumerationStatus struct {
	// READ-ONLY; Change enumeration activity
	Activity *CloudEndpointChangeEnumerationActivity

	// READ-ONLY; Status of last completed change enumeration
	LastEnumerationStatus *CloudEndpointLastChangeEnumerationStatus

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time
}

// CloudEndpointCreateParameters - The parameters used when creating a cloud endpoint.
type CloudEndpointCreateParameters struct {
	// The parameters used to create the cloud endpoint.
	Properties *CloudEndpointCreateParametersProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CloudEndpointCreateParametersProperties - CloudEndpoint Properties object.
type CloudEndpointCreateParametersProperties struct {
	// Azure file share name
	AzureFileShareName *string

	// Friendly Name
	FriendlyName *string

	// Storage Account Resource Id
	StorageAccountResourceID *string

	// Storage Account Tenant Id
	StorageAccountTenantID *string
}

// CloudEndpointLastChangeEnumerationStatus - Cloud endpoint change enumeration status object
type CloudEndpointLastChangeEnumerationStatus struct {
	// READ-ONLY; Timestamp when change enumeration completed
	CompletedTimestamp *time.Time

	// READ-ONLY; Count of directories in the namespace
	NamespaceDirectoriesCount *int64

	// READ-ONLY; Count of files in the namespace
	NamespaceFilesCount *int64

	// READ-ONLY; Namespace size in bytes
	NamespaceSizeBytes *int64

	// READ-ONLY; Timestamp of when change enumeration is expected to run again
	NextRunTimestamp *time.Time

	// READ-ONLY; Timestamp when change enumeration started
	StartedTimestamp *time.Time
}

// CloudEndpointProperties - CloudEndpoint Properties object.
type CloudEndpointProperties struct {
	// Azure file share name
	AzureFileShareName *string

	// Friendly Name
	FriendlyName *string

	// Resource Last Operation Name
	LastOperationName *string

	// CloudEndpoint lastWorkflowId
	LastWorkflowID *string

	// Partnership Id
	PartnershipID *string

	// CloudEndpoint Provisioning State
	ProvisioningState *string

	// Storage Account Resource Id
	StorageAccountResourceID *string

	// Storage Account Tenant Id
	StorageAccountTenantID *string

	// READ-ONLY; Backup Enabled
	BackupEnabled *string

	// READ-ONLY; Cloud endpoint change enumeration status
	ChangeEnumerationStatus *CloudEndpointChangeEnumerationStatus
}

// CloudTieringCachePerformance - Server endpoint cloud tiering status object.
type CloudTieringCachePerformance struct {
	// READ-ONLY; Count of bytes that were served from the local server
	CacheHitBytes *int64

	// READ-ONLY; Percentage of total bytes (hit + miss) that were served from the local server
	CacheHitBytesPercent *int32

	// READ-ONLY; Count of bytes that were served from the cloud
	CacheMissBytes *int64

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time
}

// CloudTieringDatePolicyStatus - Status of the date policy
type CloudTieringDatePolicyStatus struct {
	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time

	// READ-ONLY; Most recent access time of tiered files
	TieredFilesMostRecentAccessTimestamp *time.Time
}

// CloudTieringFilesNotTiering - Server endpoint cloud tiering status object.
type CloudTieringFilesNotTiering struct {
	// READ-ONLY; Array of tiering errors
	Errors []*FilesNotTieringError

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time

	// READ-ONLY; Last cloud tiering result (HResult)
	TotalFileCount *int64
}

// CloudTieringSpaceSavings - Server endpoint cloud tiering status object.
type CloudTieringSpaceSavings struct {
	// READ-ONLY; Cached content size on the server
	CachedSizeBytes *int64

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time

	// READ-ONLY; Count of bytes saved on the server
	SpaceSavingsBytes *int64

	// READ-ONLY; Percentage of cached size over total size
	SpaceSavingsPercent *int32

	// READ-ONLY; Total size of content in the azure file share
	TotalSizeCloudBytes *int64

	// READ-ONLY; Volume size
	VolumeSizeBytes *int64
}

// CloudTieringVolumeFreeSpacePolicyStatus - Status of the volume free space policy
type CloudTieringVolumeFreeSpacePolicyStatus struct {
	// READ-ONLY; Current volume free space percentage.
	CurrentVolumeFreeSpacePercent *int32

	// READ-ONLY; In the case where multiple server endpoints are present in a volume, an effective free space policy is applied.
	EffectiveVolumeFreeSpacePolicy *int32

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time
}

// Error type
type Error struct {
	// Error details of the given entry.
	Error *APIError

	// Error details of the given entry.
	Innererror *APIError
}

// ErrorDetails - Error Details object.
type ErrorDetails struct {
	// Error code of the given entry.
	Code *string

	// Exception type of the given entry.
	ExceptionType *string

	// HTTP error code of the given entry.
	HTTPErrorCode *string

	// HTTP method of the given entry.
	HTTPMethod *string

	// Hashed message of the given entry.
	HashedMessage *string

	// Error message of the given entry.
	Message *string

	// Request URI of the given entry.
	RequestURI *string

	// Target of the given entry.
	Target *string
}

// FilesNotTieringError - Files not tiering error object
type FilesNotTieringError struct {
	// READ-ONLY; Error code (HResult)
	ErrorCode *int32

	// READ-ONLY; Count of files with this error
	FileCount *int64
}

// InnerErrorDetails - Error Details object.
type InnerErrorDetails struct {
	// Call stack of the error.
	CallStack *string

	// Exception of the inner error.
	InnerException *string

	// Call stack of the inner error.
	InnerExceptionCallStack *string

	// Error message of the error.
	Message *string
}

// LocationOperationStatus - Operation status object
type LocationOperationStatus struct {
	// READ-ONLY; End time of the operation
	EndTime *time.Time

	// READ-ONLY; Error details.
	Error *APIError

	// READ-ONLY; Operation resource Id
	ID *string

	// READ-ONLY; Operation Id
	Name *string

	// READ-ONLY; Percent complete.
	PercentComplete *int32

	// READ-ONLY; Start time of the operation
	StartTime *time.Time

	// READ-ONLY; Operation status
	Status *string
}

// OperationDisplayInfo - The operation supported by storage sync.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string

	// The action that users can perform, based on their permission level.
	Operation *string

	// Service provider: Microsoft StorageSync.
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// OperationDisplayResource - Operation Display Resource object.
type OperationDisplayResource struct {
	// Operation Display Resource Description.
	Description *string

	// Operation Display Resource Operation.
	Operation *string

	// Operation Display Resource Provider.
	Provider *string

	// Operation Display Resource.
	Resource *string
}

// OperationEntity - The operation supported by storage sync.
type OperationEntity struct {
	// The operation supported by storage sync.
	Display *OperationDisplayInfo

	// Operation name: {provider}/{resource}/{operation}.
	Name *string

	// The origin.
	Origin *string

	// Properties of the operations resource.
	Properties *OperationProperties
}

// OperationEntityListResult - The list of storage sync operations.
type OperationEntityListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of operations.
	Value []*OperationEntity
}

// OperationProperties - Properties of the operations resource.
type OperationProperties struct {
	// Service specification for the operations resource.
	ServiceSpecification *OperationResourceServiceSpecification
}

// OperationResourceMetricSpecification - Operation Display Resource object.
type OperationResourceMetricSpecification struct {
	// Aggregation type for the metric.
	AggregationType *string

	// Dimensions for the metric specification.
	Dimensions []*OperationResourceMetricSpecificationDimension

	// Display description for the metric.
	DisplayDescription *string

	// Display name for the metric.
	DisplayName *string

	// Fill gaps in the metric with zero.
	FillGapWithZero *bool

	// Name of the metric.
	Name *string

	// Supported aggregation types for the metric.
	SupportedAggregationTypes []*string

	// Unit for the metric.
	Unit *string
}

// OperationResourceMetricSpecificationDimension object.
type OperationResourceMetricSpecificationDimension struct {
	// Display name of the dimensions.
	DisplayName *string

	// Name of the dimension.
	Name *string

	// Indicates metric should be exported for Shoebox.
	ToBeExportedForShoebox *bool
}

// OperationResourceServiceSpecification - Service specification.
type OperationResourceServiceSpecification struct {
	// List of metric specifications.
	MetricSpecifications []*OperationResourceMetricSpecification
}

// OperationStatus - Operation status object
type OperationStatus struct {
	// READ-ONLY; End time of the operation
	EndTime *time.Time

	// READ-ONLY; Error details.
	Error *APIError

	// READ-ONLY; Operation Id
	Name *string

	// READ-ONLY; Start time of the operation
	StartTime *time.Time

	// READ-ONLY; Operation status
	Status *string
}

// PostBackupResponse - Post Backup Response
type PostBackupResponse struct {
	// Post Backup Response Properties
	BackupMetadata *PostBackupResponseProperties
}

// PostBackupResponseProperties - Post Backup Response Properties object.
type PostBackupResponseProperties struct {
	// READ-ONLY; cloud endpoint Name.
	CloudEndpointName *string
}

// PostRestoreRequest - Post Restore Request
type PostRestoreRequest struct {
	// Post Restore Azure file share uri.
	AzureFileShareURI *string

	// Post Restore Azure failed file list.
	FailedFileList *string

	// Post Restore partition.
	Partition *string

	// Post Restore replica group.
	ReplicaGroup *string

	// Post Restore request id.
	RequestID *string

	// Post Restore restore file spec array.
	RestoreFileSpec []*RestoreFileSpec

	// Post Restore Azure source azure file share uri.
	SourceAzureFileShareURI *string

	// Post Restore Azure status.
	Status *string
}

// PreRestoreRequest - Pre Restore request object.
type PreRestoreRequest struct {
	// Pre Restore Azure file share uri.
	AzureFileShareURI *string

	// Pre Restore backup metadata property bag.
	BackupMetadataPropertyBag *string

	// Pre Restore partition.
	Partition *string

	// Pre Restore pause wait for sync drain time period in seconds.
	PauseWaitForSyncDrainTimePeriodInSeconds *int32

	// Pre Restore replica group.
	ReplicaGroup *string

	// Pre Restore request id.
	RequestID *string

	// Pre Restore restore file spec array.
	RestoreFileSpec []*RestoreFileSpec

	// Pre Restore Azure source azure file share uri.
	SourceAzureFileShareURI *string

	// Pre Restore Azure status.
	Status *string
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RecallActionParameters - The parameters used when calling recall action on server endpoint.
type RecallActionParameters struct {
	// Pattern of the files.
	Pattern *string

	// Recall path.
	RecallPath *string
}

// RegisteredServer - Registered Server resource.
type RegisteredServer struct {
	// RegisteredServer properties.
	Properties *RegisteredServerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RegisteredServerArray - Array of RegisteredServer
type RegisteredServerArray struct {
	// Collection of Registered Server.
	Value []*RegisteredServer
}

// RegisteredServerCreateParameters - The parameters used when creating a registered server.
type RegisteredServerCreateParameters struct {
	// The parameters used to create the registered server.
	Properties *RegisteredServerCreateParametersProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RegisteredServerCreateParametersProperties - RegisteredServer Create Properties object.
type RegisteredServerCreateParametersProperties struct {
	// Registered Server Agent Version
	AgentVersion *string

	// Registered Server clusterId
	ClusterID *string

	// Registered Server clusterName
	ClusterName *string

	// Friendly Name
	FriendlyName *string

	// Registered Server last heart beat
	LastHeartBeat *string

	// Registered Server Certificate
	ServerCertificate *string

	// Registered Server serverId
	ServerID *string

	// Registered Server OS Version
	ServerOSVersion *string

	// Registered Server serverRole
	ServerRole *string
}

// RegisteredServerProperties - RegisteredServer Properties object.
type RegisteredServerProperties struct {
	// Registered Server Agent Version
	AgentVersion *string

	// Registered Server clusterId
	ClusterID *string

	// Registered Server clusterName
	ClusterName *string

	// Resource discoveryEndpointUri
	DiscoveryEndpointURI *string

	// Friendly Name
	FriendlyName *string

	// Registered Server last heart beat
	LastHeartBeat *string

	// Resource Last Operation Name
	LastOperationName *string

	// Registered Server lastWorkflowId
	LastWorkflowID *string

	// Management Endpoint Uri
	ManagementEndpointURI *string

	// Monitoring Configuration
	MonitoringConfiguration *string

	// Telemetry Endpoint Uri
	MonitoringEndpointURI *string

	// Registered Server Provisioning State
	ProvisioningState *string

	// Resource Location
	ResourceLocation *string

	// Registered Server Certificate
	ServerCertificate *string

	// Registered Server serverId
	ServerID *string

	// Registered Server Management Error Code
	ServerManagementErrorCode *int32

	// Registered Server OS Version
	ServerOSVersion *string

	// Registered Server serverRole
	ServerRole *string

	// Service Location
	ServiceLocation *string

	// Registered Server storageSyncServiceUid
	StorageSyncServiceUID *string

	// READ-ONLY; Registered Server Agent Version Expiration Date
	AgentVersionExpirationDate *time.Time

	// READ-ONLY; Registered Server Agent Version Status
	AgentVersionStatus *RegisteredServerAgentVersionStatus

	// READ-ONLY; Server name
	ServerName *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourcesMoveInfo - Resource Move Info.
type ResourcesMoveInfo struct {
	// Collection of Resources.
	Resources []*string

	// Target resource group.
	TargetResourceGroup *string
}

// RestoreFileSpec - Restore file spec.
type RestoreFileSpec struct {
	// Restore file spec isdir
	Isdir *bool

	// Restore file spec path
	Path *string
}

// ServerEndpoint - Server Endpoint object.
type ServerEndpoint struct {
	// Server Endpoint properties.
	Properties *ServerEndpointProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerEndpointArray - Array of ServerEndpoint
type ServerEndpointArray struct {
	// Collection of ServerEndpoint.
	Value []*ServerEndpoint
}

// ServerEndpointBackgroundDataDownloadActivity - Background data download activity object
type ServerEndpointBackgroundDataDownloadActivity struct {
	// READ-ONLY; Running count of bytes downloaded
	DownloadedBytes *int64

	// READ-ONLY; Progress percentage
	PercentProgress *int32

	// READ-ONLY; Timestamp when the operation started
	StartedTimestamp *time.Time

	// READ-ONLY; Timestamp when properties were updated
	Timestamp *time.Time
}

// ServerEndpointCloudTieringStatus - Server endpoint cloud tiering status object.
type ServerEndpointCloudTieringStatus struct {
	// READ-ONLY; Information regarding how well the local cache on the server is performing.
	CachePerformance *CloudTieringCachePerformance

	// READ-ONLY; Status of the date policy
	DatePolicyStatus *CloudTieringDatePolicyStatus

	// READ-ONLY; Information regarding files that failed to be tiered
	FilesNotTiering *CloudTieringFilesNotTiering

	// READ-ONLY; Cloud tiering health state.
	Health *ServerEndpointHealthState

	// READ-ONLY; The last updated timestamp of health state
	HealthLastUpdatedTimestamp *time.Time

	// READ-ONLY; Last cloud tiering result (HResult)
	LastCloudTieringResult *int32

	// READ-ONLY; Last cloud tiering success timestamp
	LastSuccessTimestamp *time.Time

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time

	// READ-ONLY; Information regarding how much local space cloud tiering is saving.
	SpaceSavings *CloudTieringSpaceSavings

	// READ-ONLY; Status of the volume free space policy
	VolumeFreeSpacePolicyStatus *CloudTieringVolumeFreeSpacePolicyStatus
}

// ServerEndpointCreateParameters - The parameters used when creating a server endpoint.
type ServerEndpointCreateParameters struct {
	// The parameters used to create the server endpoint.
	Properties *ServerEndpointCreateParametersProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerEndpointCreateParametersProperties - ServerEndpoint Properties object.
type ServerEndpointCreateParametersProperties struct {
	// Cloud Tiering.
	CloudTiering *FeatureStatus

	// Friendly Name
	FriendlyName *string

	// Policy for how namespace and files are recalled during FastDr.
	InitialDownloadPolicy *InitialDownloadPolicy

	// Policy for how the initial upload sync session is performed.
	InitialUploadPolicy *InitialUploadPolicy

	// Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
	LocalCacheMode *LocalCacheMode

	// Offline data transfer
	OfflineDataTransfer *FeatureStatus

	// Offline data transfer share name
	OfflineDataTransferShareName *string

	// Server Local path.
	ServerLocalPath *string

	// Server Resource Id.
	ServerResourceID *string

	// Tier files older than days.
	TierFilesOlderThanDays *int32

	// Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32
}

// ServerEndpointFilesNotSyncingError - Files not syncing error object
type ServerEndpointFilesNotSyncingError struct {
	// READ-ONLY; Error code (HResult)
	ErrorCode *int32

	// READ-ONLY; Count of persistent files not syncing with the specified error code
	PersistentCount *int64

	// READ-ONLY; Count of transient files not syncing with the specified error code
	TransientCount *int64
}

// ServerEndpointProperties - ServerEndpoint Properties object.
type ServerEndpointProperties struct {
	// Cloud Tiering.
	CloudTiering *FeatureStatus

	// Friendly Name
	FriendlyName *string

	// Policy for how namespace and files are recalled during FastDr.
	InitialDownloadPolicy *InitialDownloadPolicy

	// Policy for how the initial upload sync session is performed.
	InitialUploadPolicy *InitialUploadPolicy

	// Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
	LocalCacheMode *LocalCacheMode

	// Offline data transfer
	OfflineDataTransfer *FeatureStatus

	// Offline data transfer share name
	OfflineDataTransferShareName *string

	// Server Local path.
	ServerLocalPath *string

	// Server Resource Id.
	ServerResourceID *string

	// Tier files older than days.
	TierFilesOlderThanDays *int32

	// Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32

	// READ-ONLY; Cloud tiering status. Only populated if cloud tiering is enabled.
	CloudTieringStatus *ServerEndpointCloudTieringStatus

	// READ-ONLY; Resource Last Operation Name
	LastOperationName *string

	// READ-ONLY; ServerEndpoint lastWorkflowId
	LastWorkflowID *string

	// READ-ONLY; Offline data transfer storage account resource ID
	OfflineDataTransferStorageAccountResourceID *string

	// READ-ONLY; Offline data transfer storage account tenant ID
	OfflineDataTransferStorageAccountTenantID *string

	// READ-ONLY; ServerEndpoint Provisioning State
	ProvisioningState *string

	// READ-ONLY; Recall status. Only populated if cloud tiering is enabled.
	RecallStatus *ServerEndpointRecallStatus

	// READ-ONLY; Server name
	ServerName *string

	// READ-ONLY; Server Endpoint sync status
	SyncStatus *ServerEndpointSyncStatus
}

// ServerEndpointRecallError - Server endpoint recall error object
type ServerEndpointRecallError struct {
	// READ-ONLY; Count of occurences of the error
	Count *int64

	// READ-ONLY; Error code (HResult)
	ErrorCode *int32
}

// ServerEndpointRecallStatus - Server endpoint recall status object.
type ServerEndpointRecallStatus struct {
	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time

	// READ-ONLY; Array of recall errors
	RecallErrors []*ServerEndpointRecallError

	// READ-ONLY; Total count of recall errors.
	TotalRecallErrorsCount *int64
}

// ServerEndpointSyncActivityStatus - Sync Session status object.
type ServerEndpointSyncActivityStatus struct {
	// READ-ONLY; Applied bytes
	AppliedBytes *int64

	// READ-ONLY; Applied item count.
	AppliedItemCount *int64

	// READ-ONLY; Per item error count
	PerItemErrorCount *int64

	// READ-ONLY; Session minutes remaining (if available)
	SessionMinutesRemaining *int32

	// READ-ONLY; Sync mode
	SyncMode *ServerEndpointSyncMode

	// READ-ONLY; Timestamp when properties were updated
	Timestamp *time.Time

	// READ-ONLY; Total bytes (if available)
	TotalBytes *int64

	// READ-ONLY; Total item count (if available)
	TotalItemCount *int64
}

// ServerEndpointSyncSessionStatus - Sync Session status object.
type ServerEndpointSyncSessionStatus struct {
	// READ-ONLY; Array of per-item errors coming from the last sync session.
	FilesNotSyncingErrors []*ServerEndpointFilesNotSyncingError

	// READ-ONLY; Sync mode
	LastSyncMode *ServerEndpointSyncMode

	// READ-ONLY; Last sync per item error count.
	LastSyncPerItemErrorCount *int64

	// READ-ONLY; Last sync result (HResult)
	LastSyncResult *int32

	// READ-ONLY; Last sync success timestamp
	LastSyncSuccessTimestamp *time.Time

	// READ-ONLY; Last sync timestamp
	LastSyncTimestamp *time.Time

	// READ-ONLY; Count of persistent files not syncing.
	PersistentFilesNotSyncingCount *int64

	// READ-ONLY; Count of transient files not syncing.
	TransientFilesNotSyncingCount *int64
}

// ServerEndpointSyncStatus - Server Endpoint sync status
type ServerEndpointSyncStatus struct {
	// READ-ONLY; Background data download activity
	BackgroundDataDownloadActivity *ServerEndpointBackgroundDataDownloadActivity

	// READ-ONLY; Combined Health Status.
	CombinedHealth *ServerEndpointHealthState

	// READ-ONLY; Download sync activity
	DownloadActivity *ServerEndpointSyncActivityStatus

	// READ-ONLY; Download Health Status.
	DownloadHealth *ServerEndpointHealthState

	// READ-ONLY; Download Status
	DownloadStatus *ServerEndpointSyncSessionStatus

	// READ-ONLY; Last Updated Timestamp
	LastUpdatedTimestamp *time.Time

	// READ-ONLY; Offline Data Transfer State
	OfflineDataTransferStatus *ServerEndpointOfflineDataTransferState

	// READ-ONLY; Sync activity
	SyncActivity *ServerEndpointSyncActivityState

	// READ-ONLY; Total count of persistent files not syncing (combined upload + download).
	TotalPersistentFilesNotSyncingCount *int64

	// READ-ONLY; Upload sync activity
	UploadActivity *ServerEndpointSyncActivityStatus

	// READ-ONLY; Upload Health Status.
	UploadHealth *ServerEndpointHealthState

	// READ-ONLY; Upload Status
	UploadStatus *ServerEndpointSyncSessionStatus
}

// ServerEndpointUpdateParameters - Parameters for updating an Server Endpoint.
type ServerEndpointUpdateParameters struct {
	// The properties of the server endpoint.
	Properties *ServerEndpointUpdateProperties
}

// ServerEndpointUpdateProperties - ServerEndpoint Update Properties object.
type ServerEndpointUpdateProperties struct {
	// Cloud Tiering.
	CloudTiering *FeatureStatus

	// Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
	LocalCacheMode *LocalCacheMode

	// Offline data transfer
	OfflineDataTransfer *FeatureStatus

	// Offline data transfer share name
	OfflineDataTransferShareName *string

	// Tier files older than days.
	TierFilesOlderThanDays *int32

	// Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32
}

// Service - Storage Sync Service object.
type Service struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Storage Sync Service properties.
	Properties *ServiceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServiceArray - Array of StorageSyncServices
type ServiceArray struct {
	// Collection of StorageSyncServices.
	Value []*Service
}

// ServiceCreateParameters - The parameters used when creating a storage sync service.
type ServiceCreateParameters struct {
	// REQUIRED; Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo
	// Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource
	// cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string

	// The parameters used to create the storage sync service.
	Properties *ServiceCreateParametersProperties

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than
	// 256 characters.
	Tags map[string]*string
}

// ServiceCreateParametersProperties - StorageSyncService Properties object.
type ServiceCreateParametersProperties struct {
	// Incoming Traffic Policy
	IncomingTrafficPolicy *IncomingTrafficPolicy
}

// ServiceProperties - Storage Sync Service Properties object.
type ServiceProperties struct {
	// Incoming Traffic Policy
	IncomingTrafficPolicy *IncomingTrafficPolicy

	// READ-ONLY; Resource Last Operation Name
	LastOperationName *string

	// READ-ONLY; StorageSyncService lastWorkflowId
	LastWorkflowID *string

	// READ-ONLY; List of private endpoint connection associated with the specified storage sync service
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; StorageSyncService Provisioning State
	ProvisioningState *string

	// READ-ONLY; Storage Sync service status.
	StorageSyncServiceStatus *int32

	// READ-ONLY; Storage Sync service Uid
	StorageSyncServiceUID *string
}

// ServiceUpdateParameters - Parameters for updating an Storage sync service.
type ServiceUpdateParameters struct {
	// The properties of the server endpoint.
	Properties *ServiceUpdateProperties

	// The user-specified tags associated with the storage sync service.
	Tags map[string]*string
}

// ServiceUpdateProperties - StorageSyncService Properties object.
type ServiceUpdateProperties struct {
	// Incoming Traffic Policy
	IncomingTrafficPolicy *IncomingTrafficPolicy
}

// SubscriptionState - Subscription State object.
type SubscriptionState struct {
	// Subscription state properties.
	Properties any

	// State of Azure Subscription
	State *Reason

	// READ-ONLY; Is Transitioning
	Istransitioning *bool
}

// SyncGroup - Sync Group object.
type SyncGroup struct {
	// SyncGroup properties.
	Properties *SyncGroupProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SyncGroupArray - Array of SyncGroup
type SyncGroupArray struct {
	// Collection of SyncGroup.
	Value []*SyncGroup
}

// SyncGroupCreateParameters - The parameters used when creating a sync group.
type SyncGroupCreateParameters struct {
	// The parameters used to create the sync group
	Properties any

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SyncGroupProperties - SyncGroup Properties object.
type SyncGroupProperties struct {
	// READ-ONLY; Sync group status
	SyncGroupStatus *string

	// READ-ONLY; Unique Id
	UniqueID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TriggerChangeDetectionParameters - The parameters used when calling trigger change detection action on cloud endpoint.
type TriggerChangeDetectionParameters struct {
	// Change Detection Mode. Applies to a directory specified in directoryPath parameter.
	ChangeDetectionMode *ChangeDetectionMode

	// Relative path to a directory Azure File share for which change detection is to be performed.
	DirectoryPath *string

	// Array of relative paths on the Azure File share to be included in the change detection. Can be files and directories.
	Paths []*string
}

// TriggerRolloverRequest - Trigger Rollover Request.
type TriggerRolloverRequest struct {
	// Certificate Data
	ServerCertificate *string
}

// Workflow resource.
type Workflow struct {
	// Workflow properties.
	Properties *WorkflowProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkflowArray - Array of Workflow
type WorkflowArray struct {
	// Collection of workflow items.
	Value []*Workflow
}

// WorkflowProperties - Workflow Properties object.
type WorkflowProperties struct {
	// workflow last operation identifier.
	LastOperationID *string

	// last step name
	LastStepName *string

	// operation direction.
	Operation *OperationDirection

	// workflow status.
	Status *WorkflowStatus

	// workflow steps
	Steps *string

	// READ-ONLY; workflow command name.
	CommandName *string

	// READ-ONLY; workflow created timestamp.
	CreatedTimestamp *time.Time

	// READ-ONLY; workflow last status timestamp.
	LastStatusTimestamp *time.Time
}
