//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managementgroups/armmanagementgroups"
	"net/http"
	"net/url"
	"regexp"
)

// HierarchySettingsServer is a fake server for instances of the armmanagementgroups.HierarchySettingsClient type.
type HierarchySettingsServer struct {
	// CreateOrUpdate is the fake for method HierarchySettingsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, groupID string, createTenantSettingsRequest armmanagementgroups.CreateOrUpdateSettingsRequest, options *armmanagementgroups.HierarchySettingsClientCreateOrUpdateOptions) (resp azfake.Responder[armmanagementgroups.HierarchySettingsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method HierarchySettingsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, groupID string, options *armmanagementgroups.HierarchySettingsClientDeleteOptions) (resp azfake.Responder[armmanagementgroups.HierarchySettingsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method HierarchySettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, groupID string, options *armmanagementgroups.HierarchySettingsClientGetOptions) (resp azfake.Responder[armmanagementgroups.HierarchySettingsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method HierarchySettingsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, groupID string, options *armmanagementgroups.HierarchySettingsClientListOptions) (resp azfake.Responder[armmanagementgroups.HierarchySettingsClientListResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method HierarchySettingsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, groupID string, createTenantSettingsRequest armmanagementgroups.CreateOrUpdateSettingsRequest, options *armmanagementgroups.HierarchySettingsClientUpdateOptions) (resp azfake.Responder[armmanagementgroups.HierarchySettingsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewHierarchySettingsServerTransport creates a new instance of HierarchySettingsServerTransport with the provided implementation.
// The returned HierarchySettingsServerTransport instance is connected to an instance of armmanagementgroups.HierarchySettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewHierarchySettingsServerTransport(srv *HierarchySettingsServer) *HierarchySettingsServerTransport {
	return &HierarchySettingsServerTransport{srv: srv}
}

// HierarchySettingsServerTransport connects instances of armmanagementgroups.HierarchySettingsClient to instances of HierarchySettingsServer.
// Don't use this type directly, use NewHierarchySettingsServerTransport instead.
type HierarchySettingsServerTransport struct {
	srv *HierarchySettingsServer
}

// Do implements the policy.Transporter interface for HierarchySettingsServerTransport.
func (h *HierarchySettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "HierarchySettingsClient.CreateOrUpdate":
		resp, err = h.dispatchCreateOrUpdate(req)
	case "HierarchySettingsClient.Delete":
		resp, err = h.dispatchDelete(req)
	case "HierarchySettingsClient.Get":
		resp, err = h.dispatchGet(req)
	case "HierarchySettingsClient.List":
		resp, err = h.dispatchList(req)
	case "HierarchySettingsClient.Update":
		resp, err = h.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (h *HierarchySettingsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if h.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/settings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagementgroups.CreateOrUpdateSettingsRequest](req)
	if err != nil {
		return nil, err
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.CreateOrUpdate(req.Context(), groupIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HierarchySettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HierarchySettingsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if h.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/settings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Delete(req.Context(), groupIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HierarchySettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if h.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/settings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Get(req.Context(), groupIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HierarchySettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HierarchySettingsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if h.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/settings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.List(req.Context(), groupIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HierarchySettingsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HierarchySettingsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if h.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/settings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagementgroups.CreateOrUpdateSettingsRequest](req)
	if err != nil {
		return nil, err
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Update(req.Context(), groupIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HierarchySettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
