//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// CollectionPartitionServer is a fake server for instances of the armcosmos.CollectionPartitionClient type.
type CollectionPartitionServer struct {
	// NewListMetricsPager is the fake for method CollectionPartitionClient.NewListMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricsPager func(resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string, options *armcosmos.CollectionPartitionClientListMetricsOptions) (resp azfake.PagerResponder[armcosmos.CollectionPartitionClientListMetricsResponse])

	// NewListUsagesPager is the fake for method CollectionPartitionClient.NewListUsagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListUsagesPager func(resourceGroupName string, accountName string, databaseRid string, collectionRid string, options *armcosmos.CollectionPartitionClientListUsagesOptions) (resp azfake.PagerResponder[armcosmos.CollectionPartitionClientListUsagesResponse])
}

// NewCollectionPartitionServerTransport creates a new instance of CollectionPartitionServerTransport with the provided implementation.
// The returned CollectionPartitionServerTransport instance is connected to an instance of armcosmos.CollectionPartitionClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCollectionPartitionServerTransport(srv *CollectionPartitionServer) *CollectionPartitionServerTransport {
	return &CollectionPartitionServerTransport{
		srv:                 srv,
		newListMetricsPager: newTracker[azfake.PagerResponder[armcosmos.CollectionPartitionClientListMetricsResponse]](),
		newListUsagesPager:  newTracker[azfake.PagerResponder[armcosmos.CollectionPartitionClientListUsagesResponse]](),
	}
}

// CollectionPartitionServerTransport connects instances of armcosmos.CollectionPartitionClient to instances of CollectionPartitionServer.
// Don't use this type directly, use NewCollectionPartitionServerTransport instead.
type CollectionPartitionServerTransport struct {
	srv                 *CollectionPartitionServer
	newListMetricsPager *tracker[azfake.PagerResponder[armcosmos.CollectionPartitionClientListMetricsResponse]]
	newListUsagesPager  *tracker[azfake.PagerResponder[armcosmos.CollectionPartitionClientListUsagesResponse]]
}

// Do implements the policy.Transporter interface for CollectionPartitionServerTransport.
func (c *CollectionPartitionServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CollectionPartitionClient.NewListMetricsPager":
		resp, err = c.dispatchNewListMetricsPager(req)
	case "CollectionPartitionClient.NewListUsagesPager":
		resp, err = c.dispatchNewListUsagesPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CollectionPartitionServerTransport) dispatchNewListMetricsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricsPager not implemented")}
	}
	newListMetricsPager := c.newListMetricsPager.get(req)
	if newListMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseRid>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionRid>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/partitions/metrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseRidParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseRid")])
		if err != nil {
			return nil, err
		}
		collectionRidParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionRid")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListMetricsPager(resourceGroupNameParam, accountNameParam, databaseRidParam, collectionRidParam, filterParam, nil)
		newListMetricsPager = &resp
		c.newListMetricsPager.add(req, newListMetricsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricsPager) {
		c.newListMetricsPager.remove(req)
	}
	return resp, nil
}

func (c *CollectionPartitionServerTransport) dispatchNewListUsagesPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListUsagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListUsagesPager not implemented")}
	}
	newListUsagesPager := c.newListUsagesPager.get(req)
	if newListUsagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseRid>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionRid>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/partitions/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseRidParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseRid")])
		if err != nil {
			return nil, err
		}
		collectionRidParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionRid")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armcosmos.CollectionPartitionClientListUsagesOptions
		if filterParam != nil {
			options = &armcosmos.CollectionPartitionClientListUsagesOptions{
				Filter: filterParam,
			}
		}
		resp := c.srv.NewListUsagesPager(resourceGroupNameParam, accountNameParam, databaseRidParam, collectionRidParam, options)
		newListUsagesPager = &resp
		c.newListUsagesPager.add(req, newListUsagesPager)
	}
	resp, err := server.PagerResponderNext(newListUsagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListUsagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListUsagesPager) {
		c.newListUsagesPager.remove(req)
	}
	return resp, nil
}
