//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/applicationinsights/armapplicationinsights"
	"net/http"
	"net/url"
	"regexp"
)

// WebTestsServer is a fake server for instances of the armapplicationinsights.WebTestsClient type.
type WebTestsServer struct {
	// CreateOrUpdate is the fake for method WebTestsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, webTestName string, webTestDefinition armapplicationinsights.WebTest, options *armapplicationinsights.WebTestsClientCreateOrUpdateOptions) (resp azfake.Responder[armapplicationinsights.WebTestsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method WebTestsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, webTestName string, options *armapplicationinsights.WebTestsClientDeleteOptions) (resp azfake.Responder[armapplicationinsights.WebTestsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method WebTestsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, webTestName string, options *armapplicationinsights.WebTestsClientGetOptions) (resp azfake.Responder[armapplicationinsights.WebTestsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method WebTestsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armapplicationinsights.WebTestsClientListOptions) (resp azfake.PagerResponder[armapplicationinsights.WebTestsClientListResponse])

	// NewListByComponentPager is the fake for method WebTestsClient.NewListByComponentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByComponentPager func(componentName string, resourceGroupName string, options *armapplicationinsights.WebTestsClientListByComponentOptions) (resp azfake.PagerResponder[armapplicationinsights.WebTestsClientListByComponentResponse])

	// NewListByResourceGroupPager is the fake for method WebTestsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armapplicationinsights.WebTestsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armapplicationinsights.WebTestsClientListByResourceGroupResponse])

	// UpdateTags is the fake for method WebTestsClient.UpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	UpdateTags func(ctx context.Context, resourceGroupName string, webTestName string, webTestTags armapplicationinsights.TagsResource, options *armapplicationinsights.WebTestsClientUpdateTagsOptions) (resp azfake.Responder[armapplicationinsights.WebTestsClientUpdateTagsResponse], errResp azfake.ErrorResponder)
}

// NewWebTestsServerTransport creates a new instance of WebTestsServerTransport with the provided implementation.
// The returned WebTestsServerTransport instance is connected to an instance of armapplicationinsights.WebTestsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWebTestsServerTransport(srv *WebTestsServer) *WebTestsServerTransport {
	return &WebTestsServerTransport{
		srv:                         srv,
		newListPager:                newTracker[azfake.PagerResponder[armapplicationinsights.WebTestsClientListResponse]](),
		newListByComponentPager:     newTracker[azfake.PagerResponder[armapplicationinsights.WebTestsClientListByComponentResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armapplicationinsights.WebTestsClientListByResourceGroupResponse]](),
	}
}

// WebTestsServerTransport connects instances of armapplicationinsights.WebTestsClient to instances of WebTestsServer.
// Don't use this type directly, use NewWebTestsServerTransport instead.
type WebTestsServerTransport struct {
	srv                         *WebTestsServer
	newListPager                *tracker[azfake.PagerResponder[armapplicationinsights.WebTestsClientListResponse]]
	newListByComponentPager     *tracker[azfake.PagerResponder[armapplicationinsights.WebTestsClientListByComponentResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armapplicationinsights.WebTestsClientListByResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for WebTestsServerTransport.
func (w *WebTestsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WebTestsClient.CreateOrUpdate":
		resp, err = w.dispatchCreateOrUpdate(req)
	case "WebTestsClient.Delete":
		resp, err = w.dispatchDelete(req)
	case "WebTestsClient.Get":
		resp, err = w.dispatchGet(req)
	case "WebTestsClient.NewListPager":
		resp, err = w.dispatchNewListPager(req)
	case "WebTestsClient.NewListByComponentPager":
		resp, err = w.dispatchNewListByComponentPager(req)
	case "WebTestsClient.NewListByResourceGroupPager":
		resp, err = w.dispatchNewListByResourceGroupPager(req)
	case "WebTestsClient.UpdateTags":
		resp, err = w.dispatchUpdateTags(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WebTestsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/webtests/(?P<webTestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armapplicationinsights.WebTest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	webTestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webTestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, webTestNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WebTest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebTestsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if w.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/webtests/(?P<webTestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	webTestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webTestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Delete(req.Context(), resourceGroupNameParam, webTestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebTestsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/webtests/(?P<webTestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	webTestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webTestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), resourceGroupNameParam, webTestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WebTest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebTestsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := w.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/webtests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := w.srv.NewListPager(nil)
		newListPager = &resp
		w.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armapplicationinsights.WebTestsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		w.newListPager.remove(req)
	}
	return resp, nil
}

func (w *WebTestsServerTransport) dispatchNewListByComponentPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListByComponentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByComponentPager not implemented")}
	}
	newListByComponentPager := w.newListByComponentPager.get(req)
	if newListByComponentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/components/(?P<componentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/webtests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		componentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("componentName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListByComponentPager(componentNameParam, resourceGroupNameParam, nil)
		newListByComponentPager = &resp
		w.newListByComponentPager.add(req, newListByComponentPager)
		server.PagerResponderInjectNextLinks(newListByComponentPager, req, func(page *armapplicationinsights.WebTestsClientListByComponentResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByComponentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListByComponentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByComponentPager) {
		w.newListByComponentPager.remove(req)
	}
	return resp, nil
}

func (w *WebTestsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := w.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/webtests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		w.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armapplicationinsights.WebTestsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		w.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (w *WebTestsServerTransport) dispatchUpdateTags(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateTags not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/webtests/(?P<webTestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armapplicationinsights.TagsResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	webTestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("webTestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateTags(req.Context(), resourceGroupNameParam, webTestNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WebTest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
